/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrolChecker;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class PcaSystemStatusCtrolChecker
implements ISystemStatusCtrolChecker {
    private static final Logger logger = Logger.getLogger(PcaSystemStatusCtrolChecker.class);

    public void check(Context ctx, SystemStatusCtrolCollection objCol) throws PeriodException {
        try {
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            int count = objCol.size();
            for (int i = 0; i < count; ++i) {
                SystemStatusInfo systemStatusInfo;
                SystemStatusCtrolInfo newInfo = (SystemStatusCtrolInfo)objCol.getObject(i);
                if (newInfo.getId() == null || (systemStatusInfo = newInfo.getSystemStatus()) == null || systemStatusInfo.getName() == null || !systemStatusInfo.getName().equals((Object)SystemEnum.PROFIT_CENTER_ACCOUNTING) || newInfo.getProfitCenter() == null || newInfo.getProfitCenter().getId() == null) continue;
                String orgUnitId = newInfo.getProfitCenter().getId().toString();
                ObjectUuidPK sysPK = new ObjectUuidPK(newInfo.getId().toString());
                SystemStatusCtrolInfo oldInfo = (SystemStatusCtrolInfo)iSystemStatusCtrol.getValue((IObjectPK)sysPK);
                if (newInfo.getStartPeriod() != null && oldInfo.getStartPeriod() != null) {
                    if (oldInfo.getStartPeriod() != null && newInfo.getStartPeriod().getId().equals((Object)oldInfo.getStartPeriod().getId())) continue;
                    this.checkModifyStartPeriod(ctx, orgUnitId);
                    continue;
                }
                if (newInfo.getStartPeriod() == null && oldInfo.getStartPeriod() != null) {
                    this.checkModifyStartPeriod(ctx, orgUnitId);
                }
                if (newInfo.getStartPeriod() == null || oldInfo.getStartPeriod() != null) continue;
                this.checkModifyStartPeriod(ctx, orgUnitId);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private void checkModifyStartPeriod(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        String sql = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            sql = "select top 1 fprofitcenterid from t_pca_initpcaccountbalance where fprofitcenterid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new PcaException(PcaException.CANTMODIFYPERIOD);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 fprofitcenterid from t_pca_initpcassistbalance where fprofitcenterid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new PcaException(PcaException.CANTMODIFYPERIOD);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 fid from t_pca_pcvoucher where fprofitcenterid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new PcaException(PcaException.CANTMODIFYPERIOD);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
    }
}

