/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.eas.ma.pca.PcaGeneralFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;

public class ServerUtils {
    public static ProfitCenterOrgUnitInfo getDefaultProfitCenter(Context ctx, String profitCenterID, String permissionName) throws BOSException, EASBizException, PcaException {
        ProfitCenterOrgUnitInfo pco = null;
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (StringUtils.isEmpty((String)profitCenterID)) {
            pco = PcaGeneralFacadeFactory.getLocalInstance(ctx).getFirstProfitCenter(permissionName);
            if (pco == null) {
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permissionName);
                throw new PcaException(PcaException.NO_PERMISSION_OR_SYSTEM_NOT_INIT, new String[]{permItemInfo.getAlias()});
            }
        } else {
            String[] companyIds = profitCenterID.split(",");
            if (PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(companyIds[0]), permissionName)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("CU.id"));
                sic.add(new SelectorItemInfo("CU.name"));
                sic.add(new SelectorItemInfo("CU.number"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("isSealUp"));
                sic.add(new SelectorItemInfo("accountPeriodType.id"));
                sic.add(new SelectorItemInfo("baseCurrency.id"));
                sic.add(new SelectorItemInfo("reportCurrency.id"));
                sic.add(new SelectorItemInfo("baseExchangeTable.id"));
                sic.add(new SelectorItemInfo("reportExchangeTable.id"));
                sic.add(new SelectorItemInfo("reportConvertMode"));
                sic.add(new SelectorItemInfo("accountTable.id"));
                sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
                if (!BOSUuid.isValid((String)companyIds[0], (boolean)true)) {
                    throw new IllegalArgumentException("parameter is [" + companyIds[0] + "]");
                }
                pco = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyIds[0]), sic);
            } else {
                if (companyIds.length > 1) {
                    StringBuffer filterSql = new StringBuffer();
                    for (int i = 0; i < companyIds.length; ++i) {
                        if (StringUtils.isEmpty((String)companyIds[i])) continue;
                        if (!BOSUuid.isValid((String)companyIds[i], (boolean)true)) {
                            throw new IllegalArgumentException("parameter is [" + companyIds[i] + "]");
                        }
                        if (filterSql.length() > 0) {
                            filterSql.append(",");
                        }
                        filterSql.append("'").append(companyIds[i]).append("'");
                    }
                    pco = PcaGeneralFacadeFactory.getLocalInstance(ctx).getFirstProfitCenter(permissionName, " and cp.fid in (" + filterSql.toString() + ")");
                }
                if (pco == null && (pco = PcaGeneralFacadeFactory.getLocalInstance(ctx).getFirstProfitCenter(permissionName)) == null) {
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permissionName);
                    throw new PcaException(PcaException.NO_PERMISSION_OR_SYSTEM_NOT_INIT, new String[]{permItemInfo.getAlias()});
                }
            }
        }
        return pco;
    }
}

