/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.IVoucherTypeCtrlItem;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemType;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.validator.AssistCuSuStatusValidator;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.pca.ITemplatePcCashflowRecord;
import com.kingdee.eas.ma.pca.ITemplatePcVoucherAsstRecord;
import com.kingdee.eas.ma.pca.PcCashflowRecordCollection;
import com.kingdee.eas.ma.pca.PcCashflowRecordFactory;
import com.kingdee.eas.ma.pca.PcCashflowRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFacadeFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.TemplatePcCashflowRecordCollection;
import com.kingdee.eas.ma.pca.TemplatePcCashflowRecordFactory;
import com.kingdee.eas.ma.pca.TemplatePcCashflowRecordInfo;
import com.kingdee.eas.ma.pca.TemplatePcVoucherAsstRecordCollection;
import com.kingdee.eas.ma.pca.TemplatePcVoucherAsstRecordFactory;
import com.kingdee.eas.ma.pca.TemplatePcVoucherAsstRecordInfo;
import com.kingdee.eas.ma.pca.TemplatePcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.TemplatePcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.TemplatePcVoucherInfo;
import com.kingdee.eas.ma.pca.app.AbstractTemplatePcVoucherControllerBean;
import com.kingdee.eas.ma.pca.app.WebTemplatePcVoucherCreator;
import com.kingdee.eas.ma.pca.app.WebTemplatePcVoucherTransfer;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TemplatePcVoucherControllerBean
extends AbstractTemplatePcVoucherControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.TemplatePcVoucherControllerBean");

    @Override
    protected Object[] _fetchInitData(Context ctx, Object[] param) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TemplatePcVoucherInfo info = (TemplatePcVoucherInfo)model;
        this.checkVoucher(ctx, info);
        IObjectPK voucherPK = this.persistVoucher(ctx, info);
        return voucherPK;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._getValue(ctx, pk, TemplatePcVoucherInfo.getDefaultSelector());
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.addObjectCollection((IObjectCollection)selector);
        TemplatePcVoucherInfo vch = null;
        try {
            vch = (TemplatePcVoucherInfo)super._getValue(ctx, pk, sic);
            this.fillVoucherTypeDetail(ctx, vch);
        }
        catch (Exception ex) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST, (Throwable)ex);
        }
        return vch;
    }

    private void fillVoucherTypeDetail(Context ctx, TemplatePcVoucherInfo vch) throws BOSException, EASBizException {
        VoucherTypeInfo vt = vch.getVoucherType();
        if (vt != null) {
            String comId = vch.getCompany().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("voucherType.id", (Object)vt.getId().toString()));
            fic.add(new FilterItemInfo("company.id", (Object)comId));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("type"));
            sorters.add(new SorterItemInfo("account.number"));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("type"));
            sic.add(new SelectorItemInfo("account.number"));
            IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
            VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
            vt.put("items", (Object)ciCol);
            vch.setVoucherTypeDetail(TemplatePcVoucherControllerBean.reorganizeCtrlItems(ciCol));
        } else {
            Object[] vtDetail = new Object[7];
            vtDetail[0] = new VoucherTypeCtrlItemCollection();
            vch.setVoucherTypeDetail(vtDetail);
        }
    }

    private static Object[] reorganizeCtrlItems(VoucherTypeCtrlItemCollection ciCol) {
        Object[] result = new Object[7];
        HashMap debitMust = new HashMap();
        HashMap creditMust = new HashMap();
        HashMap debitOrCreditMust = new HashMap();
        HashMap debitNot = new HashMap();
        HashMap creditNot = new HashMap();
        HashMap debitAndCreditNot = new HashMap();
        for (VoucherTypeCtrlItemInfo ctrlItem : ciCol) {
            VoucherTypeCtrlItemType t = ctrlItem.getType();
            if (VoucherTypeCtrlItemType.DEBIT_MUST.equals((Object)t)) {
                debitMust.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.CREDIT_MUST.equals((Object)t)) {
                creditMust.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.DEBIT_OR_CREDIT_MUST.equals((Object)t)) {
                debitOrCreditMust.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.DEBIT_MUST_NOT.equals((Object)t)) {
                debitNot.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.CREDIT_MUST_NOT.equals((Object)t)) {
                creditNot.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (!VoucherTypeCtrlItemType.DEBIT_AND_CREDIT_MUST_NOT.equals((Object)t)) continue;
            debitAndCreditNot.put(ctrlItem.getAccount().getId().toString(), null);
        }
        if (debitMust.size() == 0) {
            debitMust = null;
        }
        if (creditMust.size() == 0) {
            creditMust = null;
        }
        if (debitOrCreditMust.size() == 0) {
            debitOrCreditMust = null;
        }
        if (debitNot.size() == 0) {
            debitNot = null;
        }
        if (creditNot.size() == 0) {
            creditNot = null;
        }
        if (debitAndCreditNot.size() == 0) {
            debitAndCreditNot = null;
        }
        result[0] = ciCol;
        result[1] = debitMust;
        result[2] = creditMust;
        result[3] = debitOrCreditMust;
        result[4] = debitNot;
        result[5] = creditNot;
        result[6] = debitAndCreditNot;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK persistVoucher(Context ctx, TemplatePcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        BOSUuid vchId = voucherInfo.getId();
        boolean isNew = true;
        boolean newByGL = true;
        if (vchId != null) {
            isNew = !this._exists(ctx, (IObjectPK)new ObjectUuidPK(vchId));
            newByGL = !isNew;
        }
        IObjectPK voucherPK = null;
        if (isNew) {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            voucherPK = super.addnew(ctx, (CoreBaseInfo)voucherInfo);
            voucherInfo.put("id", voucherPK.getKeyValue("id"));
        } else {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", (Object)vchId.toString()));
            fic.add(new FilterItemInfo("lastUpdateTime", (Object)voucherInfo.getLastUpdateTime()));
            if (!this._exists(ctx, filter)) {
                throw new VoucherException(VoucherException.EDIT_CONFLICT);
            }
            voucherPK = new ObjectUuidPK(vchId);
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            super.update(ctx, voucherPK, (CoreBaseInfo)voucherInfo);
        }
        TemplatePcVoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        Iterator iteratorEntry = voucherEntryCollection.iterator();
        Connection cn = null;
        try {
            TemplatePcCashflowRecordCollection cashflowRecordCollection;
            Vector vecEntries;
            TemplatePcCashflowRecordCollection cashflowRecordCollection2;
            cn = this.getConnection(ctx);
            ORMappingDAO iTemplateVoucherEntry = new ORMappingDAO(new TemplatePcVoucherEntryInfo().getBOSType(), ctx, cn);
            ORMappingDAO iTemplateVoucherAsstRecord = new ORMappingDAO(new TemplatePcVoucherAsstRecordInfo().getBOSType(), ctx, cn);
            TemplatePcVoucherEntryInfo voucherEntryInfo = null;
            TemplatePcVoucherAsstRecordCollection voucherAssistRecordCollection = null;
            while (iteratorEntry.hasNext()) {
                voucherEntryInfo = (TemplatePcVoucherEntryInfo)iteratorEntry.next();
                if (voucherEntryInfo.getCurrency().getId().equals((Object)voucherInfo.getCompany().getBaseCurrency().getId()) && voucherEntryInfo.getOriginalAmount().compareTo(voucherEntryInfo.getLocalAmount()) != 0) {
                    voucherEntryInfo.setOriginalAmount(voucherEntryInfo.getLocalAmount());
                }
                if (isNew) {
                    voucherEntryInfo.setOprStatus(1);
                }
                voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                TemplatePcVoucherAsstRecordInfo voucherAssistRecordInfo = null;
                int entryStatus = voucherEntryInfo.getOprStatus();
                if (entryStatus == 0) continue;
                voucherEntryInfo.setBill(voucherInfo);
                IObjectPK entryPK = null;
                if (entryStatus == 1) {
                    if (newByGL) {
                        voucherEntryInfo.setId(null);
                    }
                    entryPK = iTemplateVoucherEntry.addnew((IObjectValue)voucherEntryInfo);
                    voucherEntryInfo.put("id", entryPK.getKeyValue("id"));
                } else {
                    entryPK = new ObjectUuidPK(voucherEntryInfo.getId());
                    if (voucherEntryInfo.getQuantity() == null) {
                        voucherEntryInfo.setQuantity(PcaUtils.zero);
                        voucherEntryInfo.setStandardQuantity(PcaUtils.zero);
                    }
                    iTemplateVoucherEntry.update(entryPK, (IObjectValue)voucherEntryInfo);
                }
                while (iteratorAssist.hasNext()) {
                    int recordStatus;
                    voucherAssistRecordInfo = (TemplatePcVoucherAsstRecordInfo)iteratorAssist.next();
                    if (voucherEntryInfo.getCurrency().getId().equals((Object)voucherInfo.getCompany().getBaseCurrency()) && voucherAssistRecordInfo.getOriginalAmount().compareTo(voucherAssistRecordInfo.getLocalAmount()) != 0) {
                        voucherAssistRecordInfo.setOriginalAmount(voucherAssistRecordInfo.getLocalAmount());
                    }
                    if (isNew) {
                        voucherAssistRecordInfo.setOprStatus(1);
                    }
                    if ((recordStatus = voucherAssistRecordInfo.getOprStatus()) == 0) continue;
                    voucherAssistRecordInfo.setEntry(voucherEntryInfo);
                    voucherAssistRecordInfo.setBill(voucherInfo);
                    IObjectPK recordPK = null;
                    if (recordStatus == 1) {
                        if (newByGL) {
                            voucherAssistRecordInfo.setId(null);
                        }
                        recordPK = iTemplateVoucherAsstRecord.addnew((IObjectValue)voucherAssistRecordInfo);
                        voucherAssistRecordInfo.put("id", recordPK.getKeyValue("id"));
                        continue;
                    }
                    recordPK = new ObjectUuidPK(voucherAssistRecordInfo.getId());
                    iTemplateVoucherAsstRecord.update(recordPK, (IObjectValue)voucherAssistRecordInfo);
                }
            }
            Vector vecRecords = voucherInfo.getRemovedRecords();
            if (vecRecords != null && vecRecords.size() > 0) {
                int n = vecRecords.size();
                IObjectPK[] pks = new IObjectPK[n];
                for (int i = 0; i < n; ++i) {
                    pks[i] = new ObjectUuidPK((BOSUuid)vecRecords.get(i));
                }
                iTemplateVoucherAsstRecord.delete(pks);
            }
            if (vchId != null && (cashflowRecordCollection2 = voucherInfo.getCashflowRecords()) != null && cashflowRecordCollection2.size() > 0) {
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                String vchid = vchId.toString();
                filter.getFilterItems().add(new FilterItemInfo("voucher.ID", (Object)vchId));
                ITemplatePcCashflowRecord icash = TemplatePcCashflowRecordFactory.getLocalInstance(ctx);
                icash.delete(filter);
            }
            if ((vecEntries = voucherInfo.getRemovedEntries()) != null && vecEntries.size() > 0) {
                int n = vecEntries.size();
                IObjectPK[] pks = new IObjectPK[n];
                for (int i = 0; i < n; ++i) {
                    pks[i] = new ObjectUuidPK((BOSUuid)vecEntries.get(i));
                }
                iTemplateVoucherEntry.delete(pks);
            }
            if ((cashflowRecordCollection = voucherInfo.getCashflowRecords()) != null && cashflowRecordCollection.size() > 0) {
                ORMappingDAO iCashflowRecord = new ORMappingDAO(new TemplatePcCashflowRecordInfo().getBOSType(), ctx, cn);
                Iterator iteratorCF = cashflowRecordCollection.iterator();
                int seq = 0;
                while (iteratorCF.hasNext()) {
                    ++seq;
                    TemplatePcCashflowRecordInfo cashflowRecordInfo = (TemplatePcCashflowRecordInfo)iteratorCF.next();
                    CashFlowItemInfo pi = cashflowRecordInfo.getPrimaryItem();
                    if (pi != null && pi.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{pi.getNumber()});
                    }
                    CashFlowItemInfo si = cashflowRecordInfo.getSupplementaryItem();
                    if (si != null && si.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{si.getNumber()});
                    }
                    cashflowRecordInfo.setVoucher(voucherInfo);
                    UserInfo userInfo = voucherInfo.getCreator();
                    cashflowRecordInfo.setCU(voucherInfo.getCU());
                    cashflowRecordInfo.setCreator(userInfo);
                    Timestamp createtime = new Timestamp(new Date().getTime());
                    cashflowRecordInfo.setCreateTime(createtime);
                    cashflowRecordInfo.setLastUpdateUser(userInfo);
                    cashflowRecordInfo.setLastUpdateTime(createtime);
                    if (cashflowRecordInfo.getSeq() == 0) {
                        cashflowRecordInfo.setSeq(seq);
                    }
                    iCashflowRecord.addnew((IObjectValue)cashflowRecordInfo);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return voucherPK;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String voucherid = pk.toString();
        String sbSql = "delete from t_pca_templatepccashflowrecord where fvoucherid = ?";
        this.deleteBySql(ctx, sbSql, voucherid);
        sbSql = "delete from t_pca_templatepcvoucherasst where fbillid = ?";
        this.deleteBySql(ctx, sbSql, voucherid);
        sbSql = "delete from t_pca_templatepcvoucherentry where fbillid = ?";
        this.deleteBySql(ctx, sbSql, voucherid);
        super._delete(ctx, pk);
    }

    private void deleteBySql(Context ctx, String sbSql, String voucherid) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql);
            ps.setString(1, voucherid);
            sbSql = null;
            ps.executeUpdate();
        }
        catch (Exception se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    @Override
    protected Object[] _fetchAssColumnInfo(Context ctx, String acctId, String typeGroupId, String entryId) throws BOSException, EASBizException {
        Object[] result;
        VoucherInfo.DynamicColumnInfo[] itemCols = null;
        Locale[] locales = null;
        if (typeGroupId != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("asstActType.name"));
            sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
            sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
            sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
            sic.add(new SelectorItemInfo("asstActType.defaultF7UI"));
            sic.add(new SelectorItemInfo("asstActType.isForCompany"));
            sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            sorters.add(new SorterItemInfo("asstActType.number"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("asstAccount.id", (Object)typeGroupId));
            IAsstActGroupDetail relCtrl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
            AsstActGroupDetailCollection rels = relCtrl.getAsstActGroupDetailCollection(view);
            if (locales == null) {
                locales = this.getAllLocales(ctx);
            }
            itemCols = new VoucherInfo.DynamicColumnInfo[rels.size()];
            int count = 0;
            for (AsstActGroupDetailInfo r : rels) {
                AsstActTypeInfo t = r.getAsstActType();
                HashMap<Locale, String> hmMultiLangColName = new HashMap<Locale, String>();
                for (int i = 0; i < locales.length; ++i) {
                    hmMultiLangColName.put(locales[i], t.getName(locales[i]));
                }
                VoucherInfo.DynamicColumnInfo col = new VoucherInfo.DynamicColumnInfo(t.getName(), t.getAsstHGAttribute(), t.getDefaultQueryName(), t.getDefaultF7UI(), t.isIsForCompany(), hmMultiLangColName, t.getId());
                col.setGrp(t.getGlAsstActTypeGrp());
                col.setUseLongNumber(t.isUseLongNumber());
                itemCols[count++] = col;
            }
        } else {
            itemCols = new VoucherInfo.DynamicColumnInfo[]{};
        }
        VoucherInfo.DynamicColumnInfo[] cpCols = null;
        if (acctId != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("isNecessary"));
            sic.add(new SelectorItemInfo("customizedType.name"));
            sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
            sic.add(new SelectorItemInfo("customizedType.dataType"));
            sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
            sic.add(new SelectorItemInfo("customizedType.defaultF7UI"));
            sic.add(new SelectorItemInfo("customizedType.precision"));
            sic.add(new SelectorItemInfo("customizedType.isForCompany"));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("account.id", (Object)acctId));
            IAssistCustomizedProperty cpCtrl = AssistCustomizedPropertyFactory.getLocalInstance((Context)ctx);
            AssistCustomizedPropertyCollection props = cpCtrl.getAssistCustomizedPropertyCollection(view);
            if (locales == null) {
                locales = this.getAllLocales(ctx);
            }
            cpCols = new VoucherInfo.DynamicColumnInfo[props.size()];
            int count = 0;
            for (AssistCustomizedPropertyInfo prop : props) {
                AssistCustomizedTypeInfo t = prop.getCustomizedType();
                HashMap<Locale, String> hmMultiLangColName = new HashMap<Locale, String>();
                for (int i = 0; i < locales.length; ++i) {
                    hmMultiLangColName.put(locales[i], t.getName(locales[i]));
                }
                VoucherInfo.DynamicColumnInfo col = new VoucherInfo.DynamicColumnInfo(prop.isIsNecessary(), t.getName(), t.getDataType(), t.getMappingPropName(), t.getDefaultQueryName(), t.getDefaultF7UI(), t.getPrecision(), t.isIsForCompany(), hmMultiLangColName);
                cpCols[count++] = col;
            }
        } else {
            cpCols = new VoucherInfo.DynamicColumnInfo[]{};
        }
        result = new Object[]{itemCols, cpCols, entryId != null ? this._fetchAssData(ctx, entryId, result) : null};
        return result;
    }

    @Override
    protected IObjectCollection _fetchAssData(Context ctx, String entryId, Object[] info) throws BOSException, EASBizException {
        String propName;
        VoucherInfo.DynamicColumnInfo colInfo;
        int i;
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        VoucherInfo.DynamicColumnInfo[] propCols = (VoucherInfo.DynamicColumnInfo[])info[1];
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        SelectorItemCollection sic = view.getSelector();
        for (i = 0; i < propCols.length; ++i) {
            colInfo = propCols[i];
            propName = colInfo.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)colInfo.getDataType())) {
                sic.add(new SelectorItemInfo(propName + ".number"));
                sic.add(new SelectorItemInfo(propName + ".name"));
                continue;
            }
            sic.add(new SelectorItemInfo(propName));
        }
        for (i = 0; i < assItemCols.length; ++i) {
            colInfo = assItemCols[i];
            propName = colInfo.getMappingPropName();
            sic.add(new SelectorItemInfo("assGrp." + propName + ".number"));
            sic.add(new SelectorItemInfo("assGrp." + propName + ".name"));
            if (!colInfo.isUseLongNumber()) continue;
            sic.add(new SelectorItemInfo("assGrp." + propName + ".longNumber"));
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("entry.id", (Object)entryId));
        ITemplatePcVoucherAsstRecord recCtrl = TemplatePcVoucherAsstRecordFactory.getLocalInstance(ctx);
        TemplatePcVoucherAsstRecordCollection records = recCtrl.getTemplatePcVoucherAsstRecordCollection(view);
        return records;
    }

    protected Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    private void checkVoucher(Context ctx, TemplatePcVoucherInfo info) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1 and #2 ");
        } else {
            filterInfo.setMaskString("#0 and #1 ");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected Object[] _fetchAssColumn(Context ctx, String accid, String typegoupid, String entryid) throws EASBizException, BOSException {
        return this._fetchAssColumnInfo(ctx, accid, typegoupid, entryid);
    }

    @Override
    protected TemplatePcVoucherInfo _copyWebTemplateVoucherInfo(Context ctx, TemplatePcVoucherInfo templateVoucherInfo) throws BOSException, EASBizException {
        return new WebTemplatePcVoucherCreator().copy(ctx, templateVoucherInfo);
    }

    @Override
    protected TemplatePcVoucherInfo _createWebTemplateVoucherInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        return new WebTemplatePcVoucherCreator().create(ctx, companyId);
    }

    @Override
    protected TemplatePcVoucherInfo _toWebTemplateVoucherInfo(Context ctx, TemplatePcVoucherInfo templateVoucherInfo) throws BOSException, EASBizException {
        return new WebTemplatePcVoucherTransfer(ctx, templateVoucherInfo).transfer();
    }

    @Override
    protected PcVoucherInfo _templateToVoucher(Context ctx, String templateVoucherId) throws BOSException, EASBizException {
        Map diff;
        TemplatePcVoucherInfo templateVoucher = (TemplatePcVoucherInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(templateVoucherId));
        this.checkAssFreezed(ctx, templateVoucher);
        templateVoucher.put("isWeb", (Object)"isWeb");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)PcCashflowRecordInfo.getDefaultSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", (Object)templateVoucher.getId().toString()));
        TemplatePcCashflowRecordCollection cfCol = null;
        ITemplatePcCashflowRecord recCtrl = TemplatePcCashflowRecordFactory.getLocalInstance(ctx);
        cfCol = recCtrl.getTemplatePcCashflowRecordCollection(view);
        templateVoucher.setCashflowRecords(cfCol);
        ProfitCenterOrgUnitInfo pc = templateVoucher.getProfitCenter();
        String profitCenterID = pc.getId().toString();
        PeriodInfo period = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(1006, profitCenterID);
        UserSettingObject settingObj = UserSettingFactory.getLocalInstance((Context)ctx).getValue(null, "ma.pca.voucher.editSetting");
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        if (settingObj != null && settingObj.getBoolean("sysData") && (period == null || date.after(period.getEndDate()))) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)date, (Date)date, (CompanyOrgUnitInfo)templateVoucher.getCompany());
            if (!periodColl.isEmpty()) {
                period = periodColl.get(0);
            }
        } else {
            if (period != null) {
                if (date.before(period.getBeginDate())) {
                    date = period.getBeginDate();
                } else if (date.after(period.getEndDate())) {
                    date = period.getEndDate();
                }
            }
            date = DateTimeUtils.truncateDate((Date)date);
        }
        PcVoucherInfo voucher = templateVoucher.transfer();
        voucher.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucher.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucher.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucher.setBizDate(date);
        voucher.setBookedDate(date);
        voucher.setPeriod(period);
        if (voucher.getEntries() != null) {
            for (int i = 0; i < voucher.getEntries().size(); ++i) {
                PcVoucherEntryInfo entry = voucher.getEntries().get(i);
                if (entry.getId() == null) {
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                }
                entry.put("isTemplate", (Object)true);
                if (entry.getAssistRecords() == null) continue;
                for (int j = 0; j < entry.getAssistRecords().size(); ++j) {
                    PcVoucherAssistRecordInfo assist = entry.getAssistRecords().get(j);
                    if (assist.getId() != null) continue;
                    assist.setId(BOSUuid.create((BOSObjectType)assist.getBOSType()));
                    assist.setBizDate(date);
                    assist.setEndDate(date);
                }
            }
        }
        voucher = PcVoucherFacadeFactory.getLocalInstance((Context)ctx).toWebVoucherInfo(voucher);
        PcVoucherEntryCollection entries = voucher.getEntries();
        HashMap<String, PcVoucherEntryInfo> enMap = new HashMap<String, PcVoucherEntryInfo>();
        if (entries != null && entries.size() > 0) {
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                PcVoucherEntryInfo info = entries.get(i);
                enMap.put(String.valueOf(info.getSeq()), info);
            }
            voucher.setEntriesMap(enMap);
        }
        if (voucher.getCashflowRecords() != null && (diff = PcCashflowRecordFactory.getLocalInstance(ctx).getDifference(templateVoucher.getCompany().getId().toString())) != null) {
            HashMap diffMap = new HashMap();
            CashFlowKeepActivityCollection cfkaColl = (CashFlowKeepActivityCollection)diff.get("CashFlowKeepActivityCollection");
            if (cfkaColl != null && !cfkaColl.isEmpty()) {
                ArrayList<String> cfKeepActivities = new ArrayList<String>();
                for (int i = 0; i < cfkaColl.size(); ++i) {
                    cfKeepActivities.add(cfkaColl.get(i).getConCashFlowItem().getId().toString());
                }
                diffMap.put("cashflowKeepActivities", cfKeepActivities);
            }
            CashFlowAccountDiffCollection placColl = (CashFlowAccountDiffCollection)diff.get("CashFlowAccountDiffCollection");
            ArrayList<String> cfAccountDiffs = null;
            if (placColl != null && !placColl.isEmpty()) {
                cfAccountDiffs = new ArrayList<String>();
                for (int i = 0; i < placColl.size(); ++i) {
                    cfAccountDiffs.add(placColl.get(i).getDiffAccount().getId().toString());
                }
                diffMap.put("cashflowAccountDiffs", cfAccountDiffs);
            }
            List cashflowList = this.getCashflowList(voucher, cfAccountDiffs);
            CashflowFlag cashflowFlag = this.computeCashflowFlag(voucher);
            voucher.setCashflowRecords(null);
            voucher.put("cashflow", (Object)cashflowList);
            voucher.put("cashflowFlag", (Object)cashflowFlag);
        }
        this.setNumberAddNew(ctx, voucher);
        return voucher;
    }

    private void checkAssFreezed(Context ctx, TemplatePcVoucherInfo info) throws EASBizException, BOSException, UuidException {
        TemplatePcVoucherEntryCollection entryCollection = info.getEntries();
        int result = 0;
        int size = entryCollection.size();
        for (int i = 0; i < size && result != 1; ++i) {
            TemplatePcVoucherEntryInfo entry = entryCollection.get(i);
            TemplatePcVoucherAsstRecordCollection asstRecordCollection = entry.getAssistRecords();
            int asstSize = asstRecordCollection.size();
            for (int j = 0; j < asstSize; ++j) {
                TemplatePcVoucherAsstRecordInfo asstRecordInfo = asstRecordCollection.get(j);
                AssistantHGInfo assGrp = asstRecordInfo.getAssGrp();
                if (assGrp == null) continue;
                AssistCuSuStatusValidator cusuValidator = null;
                assGrp = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)assGrp.get("id").toString())));
                if (assGrp.get("customer") != null) {
                    ObjectBaseInfo customerDBInfo = (ObjectBaseInfo)assGrp.get("customer");
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(null);
                    }
                    if ((result = cusuValidator.validator(customerDBInfo.getString("id"), info.getCompany().getId().toString(), 0)) == 1) {
                        throw new PcaException(PcaException.ASST_FREEZED);
                    }
                }
                if (assGrp.get("provider") != null) {
                    ObjectBaseInfo prividerDBInfo = (ObjectBaseInfo)assGrp.get("provider");
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(null);
                    }
                    if ((result = cusuValidator.validator(prividerDBInfo.getString("id"), info.getCompany().getId().toString(), 1)) == 1) {
                        throw new PcaException(PcaException.ASST_FREEZED);
                    }
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)assGrp.getAsstAccount().getId().toString()));
                SelectorItemCollection select = new SelectorItemCollection();
                select.add("*");
                select.add("asstActType.*");
                AsstActGroupDetailCollection assColl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)select, null));
                for (int k = 0; k < assColl.size(); ++k) {
                    AsstActGroupDetailInfo aad = assColl.get(k);
                    AsstActTypeInfo aatInfo = aad.getAsstActType();
                    if (!"T_BD_GeneralAsstActType".equals(aatInfo.getRealtionDataObject()) || assGrp.get(aatInfo.getAsstHGAttribute()) == null) continue;
                    GeneralAsstActTypeInfo gInfo = (GeneralAsstActTypeInfo)assGrp.get(aatInfo.getAsstHGAttribute());
                    gInfo = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeInfo((IObjectPK)new ObjectUuidPK(gInfo.getId()));
                    if (gInfo.isIsEnabled()) continue;
                    throw new PcaException(PcaException.ASST_FREEZED);
                }
            }
        }
    }

    private List getCashflowList(PcVoucherInfo voucherInfo, List cfAccountDiffs) throws EASBizException, BOSException {
        ArrayList<HashMap> newCashflows = new ArrayList<HashMap>();
        PcCashflowRecordCollection cfColl = (PcCashflowRecordCollection)voucherInfo.getCashflowRecords();
        for (int i = 0; i < cfColl.size(); ++i) {
            HashMap cfMap = new HashMap();
            PcCashflowRecordInfo cfInfo = cfColl.get(i);
            cfMap.put("itemFlag", cfInfo.getItemFlag().getValue());
            if (cfInfo.getType() != null) {
                cfMap.put("type", CashflowTypeEnum.OUT);
            }
            List<PcVoucherEntryInfo> entrys = this.getVoucherEntrys(voucherInfo, String.valueOf(cfInfo.getEntry().getSeq()), null);
            for (int j = 0; j < entrys.size(); ++j) {
                PcVoucherEntryInfo entry = entrys.get(j);
                if (j > 0) {
                    cfMap = (HashMap)cfMap.clone();
                    cfMap.put("originalAmount", PcaUtils.zero);
                    cfMap.put("localAmount", PcaUtils.zero);
                    cfMap.put("reportingAmount", PcaUtils.zero);
                } else {
                    cfMap.put("originalAmount", cfInfo.getOriginalAmount());
                    cfMap.put("localAmount", cfInfo.getLocalAmount());
                    cfMap.put("reportingAmount", cfInfo.getReportingAmount());
                }
                cfMap.put("ownAccount", entry.getSeq());
                if (cfMap.get("itemFlag") != null && new BigDecimal(cfMap.get("itemFlag").toString()).intValue() == 5) {
                    cfMap.put("oppAccount", entry.getSeq());
                } else {
                    String assistRecordId = null;
                    if (cfInfo.getOppVoucherAssistRecord() != null) {
                        assistRecordId = cfInfo.getOppVoucherAssistRecord().getId().toString();
                    }
                    List<PcVoucherEntryInfo> oppEntrys = this.getVoucherEntrys(voucherInfo, String.valueOf(cfInfo.getOpposingAccountEntry().getSeq()), assistRecordId);
                    cfMap.put("oppAccount", oppEntrys.get(0).getSeq());
                }
                if (cfInfo.getPrimaryItem() != null) {
                    CashFlowItemInfo primaryItem = cfInfo.getPrimaryItem();
                    AssistantHGInfo hgInfo = cfInfo.getAssGrp();
                    if (hgInfo != null) {
                        String displayNameGroup = hgInfo.getDisplayNameGroup();
                        String[] displayNames = displayNameGroup.split(";");
                        StringBuffer displayName = new StringBuffer();
                        for (int n = 0; n < displayNames.length; ++n) {
                            String[] name = displayNames[n].split("_!", 2);
                            if ("".equals(name[1])) continue;
                            if (displayName.length() > 0) {
                                displayName.append("|");
                            }
                            displayName.append(name[1]);
                        }
                        hgInfo.put("displayname", (Object)displayName.toString());
                        primaryItem.put("assgrp", (Object)hgInfo);
                    }
                    cfMap.put("primaryItem", primaryItem);
                }
                if (cfInfo.getSupplementaryItem() != null) {
                    cfMap.put("supplementaryItem", cfInfo.getSupplementaryItem());
                }
                if (cfInfo.getFullInfoItem() != null) {
                    cfMap.put("fullInfoItem", cfInfo.getFullInfoItem());
                }
                newCashflows.add(cfMap);
            }
        }
        return newCashflows;
    }

    private List<PcVoucherEntryInfo> getVoucherEntrys(PcVoucherInfo voucherInfo, String entryId, String assistRecordId) {
        ArrayList<PcVoucherEntryInfo> entries = new ArrayList<PcVoucherEntryInfo>();
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            PcVoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (!entryId.equals(String.valueOf(entry.get("seq")))) continue;
            if (assistRecordId != null && entry.get("assistrecordid") != null) {
                if (!assistRecordId.equals(entry.get("assistrecordid"))) continue;
                entries.add(entry);
                continue;
            }
            entries.add(entry);
        }
        return entries;
    }

    private CashflowFlag computeCashflowFlag(PcVoucherInfo voucherInfo) {
        if (SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
            return CashflowFlag.NONE;
        }
        boolean cashAccExist = false;
        boolean pnlAccExist = false;
        boolean elseAccExist = false;
        PcVoucherEntryCollection entries = voucherInfo.getEntries();
        int count = entries.size();
        PcVoucherEntryInfo entry = null;
        for (int i = 0; i < count; ++i) {
            entry = entries.get(i);
            AccountViewInfo acc = entry.getAccount();
            if (acc == null) continue;
            if (acc.isIsCash() || acc.isIsBank() || acc.isIsCashEquivalent()) {
                cashAccExist = true;
                continue;
            }
            if (acc.getAccountTypeID() != null && AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty()) && this.isShowSI(voucherInfo, acc.getNumber())) {
                pnlAccExist = true;
                continue;
            }
            elseAccExist = true;
        }
        CashflowFlag flag = null;
        flag = !cashAccExist && pnlAccExist && elseAccExist ? CashflowFlag.ONLY_PNLACCOUNT : (cashAccExist && pnlAccExist && !elseAccExist || cashAccExist && !pnlAccExist && elseAccExist ? CashflowFlag.ONLY_CASHACCOUNT : (!cashAccExist && !pnlAccExist && elseAccExist ? CashflowFlag.BOTHNONE : (cashAccExist && pnlAccExist && elseAccExist ? CashflowFlag.BOTH_CASH_AND_PNL : CashflowFlag.NONE)));
        return flag;
    }

    private boolean isShowSI(PcVoucherInfo voucherInfo, String accountNumber) {
        CashFlowAccountDiffCollection actCol = voucherInfo.getCashFlowAccountDiffCollection();
        boolean isShowSI = true;
        if (actCol != null) {
            int size = actCol.size();
            for (int i = 0; i < size; ++i) {
                CashFlowAccountDiffInfo actitem = actCol.get(i);
                if (actitem.getDiffAccount() == null || !accountNumber.equals(actitem.getDiffAccount().getNumber())) continue;
                isShowSI = false;
                break;
            }
        }
        return isShowSI;
    }

    private void setNumberAddNew(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isNumberAddNew = iCodingRuleManager.isAddView((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (isNumberAddNew) {
                String number = iCodingRuleManager.readNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus", "");
                voucherInfo.setNumber(number);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"codingRule error!", (Throwable)ex);
        }
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
    }
}

