/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.pca.AmortizeOrgTypeEnum;
import com.kingdee.eas.ma.pca.AmortizeRuleAmountType;
import com.kingdee.eas.ma.pca.AmortizeRuleDestAssRecCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestAssRecInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcAssRecCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcAssRecInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryInfo;
import com.kingdee.eas.ma.pca.PcaGeneralFacadeFactory;
import com.kingdee.eas.ma.pca.app.PcaAmortizeRuleUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebAmortizeRuleTransfer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.WebAmortizeRuleTransfer");
    private Context ctx;
    private AmortizeRuleInfo amortizeRuleInfo;
    private Map exchangeRateCache = new HashMap();

    public WebAmortizeRuleTransfer(Context ctx, AmortizeRuleInfo amortizeRuleInfo) {
        this.ctx = ctx;
        this.amortizeRuleInfo = amortizeRuleInfo;
    }

    public AmortizeRuleInfo transfer() throws EASBizException, BOSException {
        VoucherTypeInfo voucherTypeInfo;
        Map paramMap = this.getSysParam(this.ctx);
        AmortizeRuleInfo amortRuleInfo = (AmortizeRuleInfo)this.amortizeRuleInfo.clone();
        CompanyOrgUnitInfo company = amortRuleInfo.getCompany();
        company.put("sysparam", (Object)paramMap);
        amortRuleInfo.put("currencies", this.getCurrencyComboList());
        List<Map> voucherTypeList = this.getVoucherTypeList(company);
        amortRuleInfo.put("vouchertypeenum", voucherTypeList);
        if (amortRuleInfo.get("vouchertypeid") == null && (voucherTypeInfo = this.getDefaultVoucherTypeInfo(voucherTypeList)) != null) {
            amortRuleInfo.put("vouchertypeid", voucherTypeInfo.getId().toString());
        }
        List<Map> amortizeStandList = this.getAmortizeStandList(company);
        amortRuleInfo.put("amortizestandenum", amortizeStandList);
        String profitcenterF7Filter = PcaGeneralFacadeFactory.getLocalInstance(this.ctx).getProfitCenterIDSQL("pca_voucher_add", null, true);
        amortRuleInfo.put("profitcenterf7filter", profitcenterF7Filter);
        AmortizeRuleSrcEntryCollection amorRuleSrcEntryColl = amortRuleInfo.getSrcEntries();
        AmortizeRuleSrcEntryCollection newSrcEntryColl = new AmortizeRuleSrcEntryCollection();
        int size = amorRuleSrcEntryColl.size();
        for (int i = 0; i < size; ++i) {
            this.toAmortizeRuleSrcEntryInfo(this.ctx, amortRuleInfo, amorRuleSrcEntryColl.get(i), newSrcEntryColl);
        }
        amortRuleInfo.getSrcEntries().clear();
        amortRuleInfo.getSrcEntries().addCollection(newSrcEntryColl);
        AmortizeRuleDestEntryCollection amorRuleDestEntryColl = amortRuleInfo.getDestEntries();
        AmortizeRuleDestEntryCollection newDestEntryColl = new AmortizeRuleDestEntryCollection();
        int size2 = amorRuleDestEntryColl.size();
        for (int i = 0; i < size2; ++i) {
            this.toAmortizeRuleDestEntryInfo(this.ctx, amortRuleInfo, amorRuleDestEntryColl.get(i), newDestEntryColl, i);
        }
        Iterator it = newDestEntryColl.iterator();
        while (it.hasNext()) {
            AmortizeRuleDestEntryInfo entryInfo = (AmortizeRuleDestEntryInfo)it.next();
            entryInfo.setId(null);
        }
        amortRuleInfo.getDestEntries().clear();
        amortRuleInfo.getDestEntries().addCollection(newDestEntryColl);
        return amortRuleInfo;
    }

    private void toAmortizeRuleSrcEntryInfo(Context ctx, AmortizeRuleInfo amortRuleInfo, AmortizeRuleSrcEntryInfo entryInfo, AmortizeRuleSrcEntryCollection newSrcEntryColl) throws BOSException {
        AccountViewInfo accountInfo;
        if (entryInfo == null || entryInfo.getId() == null) {
            return;
        }
        entryInfo.setId(null);
        AmortizeRuleSrcEntryInfo newEntryInfo = (AmortizeRuleSrcEntryInfo)entryInfo.clone();
        AmortizeOrgTypeEnum orgType = amortRuleInfo.getAmortizeOrgType();
        if (orgType == AmortizeOrgTypeEnum.ProfitCenterToProfitCenter) {
            newEntryInfo.setCompany(null);
        } else {
            newEntryInfo.setProfitCenter(null);
        }
        AmortizeRuleAmountType amountType = newEntryInfo.getAccountAmountType();
        if (amountType == AmortizeRuleAmountType.Amount) {
            newEntryInfo.setAmount(newEntryInfo.getAmount());
        } else {
            newEntryInfo.setAmount(newEntryInfo.getRatio());
        }
        HashMap<String, String> assgrpMap = new HashMap<String, String>();
        AssistantHGInfo hg = newEntryInfo.getCussentAssGrp();
        if (hg != null && hg.getId() != null) {
            this.toAssResMap(ctx, hg, assgrpMap);
            Iterator itor = assgrpMap.keySet().iterator();
            StringBuffer sb = new StringBuffer();
            while (itor.hasNext()) {
                String key = (String)itor.next();
                CoreBaseInfo info = (CoreBaseInfo)assgrpMap.get(key);
                if (sb.length() == 0) {
                    sb.append(info.get("name_" + ctx.getLocale()));
                    continue;
                }
                sb.append(" | ").append(info.get("name_" + ctx.getLocale()));
            }
            assgrpMap.put("name", sb.toString());
            AccountViewInfo cussentAccount = entryInfo.getCussentAccount();
            cussentAccount.put("assgrp", assgrpMap);
            newEntryInfo.setCussentAccount(cussentAccount);
        }
        if ((accountInfo = newEntryInfo.getAccount()) != null && accountInfo.getCAA() != null && accountInfo.getCAA().getId() != null) {
            AmortizeRuleSrcAssRecCollection assRecColl = newEntryInfo.getAssRec();
            ArrayList assRecList = new ArrayList();
            int size = assRecColl.size();
            for (int j = 0; j < size; ++j) {
                HashMap<String, Object> assResMap = new HashMap<String, Object>();
                AmortizeRuleSrcAssRecInfo assRecInfo = assRecColl.get(j);
                assResMap.put("assAmountType", (Object)newEntryInfo.getAssAmountType());
                AmortizeRuleAmountType asstAmountType = newEntryInfo.getAssAmountType();
                if (asstAmountType == AmortizeRuleAmountType.Amount) {
                    assResMap.put("amount", assRecInfo.getAmount());
                } else {
                    assResMap.put("amount", assRecInfo.getRatio());
                }
                assResMap.put("rowindex", "jqg" + (j + 1));
                this.toAssResMap(ctx, assRecInfo.getAssGrp(), assResMap);
                assRecList.add(assResMap);
            }
            accountInfo.put("asst", assRecList);
        }
        newSrcEntryColl.add(newEntryInfo);
    }

    private void toAssResMap(Context ctx, AssistantHGInfo hgInfo, Map assResMap) throws BOSException {
        if (hgInfo == null || hgInfo.getAsstAccount() == null || hgInfo.getAsstAccount().getId() == null) {
            return;
        }
        String asstAcctId = hgInfo.getAsstAccount().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FASSTHGATTRIBUTE, FMAPPINGFIELDNAME from T_BD_AsstActType ").append(" where FID in (").append("select FASSTACTTYPEID from T_BD_AsstActGroupDetail ").append(" where FAsstAccountID = ? )");
        Object[] param = new Object[]{asstAcctId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rs.next()) {
                String pk;
                String hgAttr = rs.getString("FASSTHGATTRIBUTE");
                String field = rs.getString("FMAPPINGFIELDNAME");
                String hgSql = "select " + field + " FID from T_BD_AssistantHG where fid = '" + hgInfo.getId() + "'";
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)hgSql);
                if (!rs1.next() || StringUtils.isEmpty((String)(pk = rs1.getString("FID")))) continue;
                BOSObjectType bosType = BOSUuid.read((String)pk).getType();
                ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
                CoreBaseInfo info = coreBase.getValue((IObjectPK)new ObjectUuidPK(pk));
                assResMap.put(hgAttr, info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void toAmortizeRuleDestEntryInfo(Context ctx, AmortizeRuleInfo amortRuleInfo, AmortizeRuleDestEntryInfo entryInfo, AmortizeRuleDestEntryCollection newDestEntryColl, int rowNum) throws BOSException {
        if (entryInfo == null || entryInfo.getId() == null) {
            return;
        }
        AmortizeRuleDestEntryInfo newEntryInfo = new AmortizeRuleDestEntryInfo();
        AmortizeOrgTypeEnum orgType = amortRuleInfo.getAmortizeOrgType();
        Iterator it = newDestEntryColl.iterator();
        boolean isExist = false;
        while (it.hasNext()) {
            String profitCenterId;
            AmortizeRuleDestEntryInfo existEntryInfo = (AmortizeRuleDestEntryInfo)it.next();
            if (orgType == AmortizeOrgTypeEnum.CompanyToCompany) {
                String companyId;
                String existCompanyId = existEntryInfo.getCompany() == null || existEntryInfo.getCompany().getId() == null ? "" : existEntryInfo.getCompany().getId().toString();
                if (!existCompanyId.equals(companyId = entryInfo.getCompany() == null || entryInfo.getCompany().getId() == null ? "" : entryInfo.getCompany().getId().toString())) continue;
                newEntryInfo = existEntryInfo;
                isExist = true;
                break;
            }
            String existProfitCenterId = existEntryInfo.getProfitCenter() == null || existEntryInfo.getProfitCenter().getId() == null ? "" : existEntryInfo.getProfitCenter().getId().toString();
            if (!existProfitCenterId.equals(profitCenterId = entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().getId() == null ? "" : entryInfo.getProfitCenter().getId().toString())) continue;
            newEntryInfo = existEntryInfo;
            isExist = true;
            break;
        }
        if (!isExist) {
            newEntryInfo.setId(entryInfo.getId());
            if (orgType == AmortizeOrgTypeEnum.CompanyToCompany) {
                newEntryInfo.setCompany(entryInfo.getCompany());
            } else {
                newEntryInfo.setProfitCenter(entryInfo.getProfitCenter());
            }
            newEntryInfo.setCussentAccount(entryInfo.getCussentAccount());
            HashMap<String, String> assgrpMap = new HashMap<String, String>();
            AssistantHGInfo hg = entryInfo.getCussentAssGrp();
            if (hg != null && hg.getId() != null) {
                this.toAssResMap(ctx, hg, assgrpMap);
                Iterator itor = assgrpMap.keySet().iterator();
                StringBuffer sb = new StringBuffer();
                while (itor.hasNext()) {
                    String key = (String)itor.next();
                    CoreBaseInfo info = (CoreBaseInfo)assgrpMap.get(key);
                    if (sb.length() == 0) {
                        sb.append(info.get("name_" + ctx.getLocale()));
                        continue;
                    }
                    sb.append(" | ").append(info.get("name_" + ctx.getLocale()));
                }
                assgrpMap.put("name", sb.toString());
                AccountViewInfo cussentAccount = entryInfo.getCussentAccount();
                cussentAccount.put("assgrp", assgrpMap);
                newEntryInfo.setCussentAccount(cussentAccount);
            }
            newEntryInfo.setCussentCurrency(entryInfo.getCussentCurrency());
            newEntryInfo.setVoucherType(entryInfo.getVoucherType());
            newEntryInfo.setOrgRatio(entryInfo.getOrgRatio());
        }
        List acctList = new ArrayList();
        acctList = orgType == AmortizeOrgTypeEnum.CompanyToCompany ? (entryInfo.getCompany() == null || entryInfo.getCompany().get("acct") == null ? new ArrayList() : (List)entryInfo.getCompany().get("acct")) : (entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().get("acct") == null ? new ArrayList() : (List)entryInfo.getProfitCenter().get("acct"));
        HashMap<String, Object> acctMap = new HashMap<String, Object>();
        acctMap.put("currency", entryInfo.getCurrency());
        acctMap.put("dc", entryInfo.getDc() == null ? 1 : entryInfo.getDc().getValue());
        acctMap.put("assActMode", entryInfo.getAssActMode() == null ? 1 : entryInfo.getAssActMode().getValue());
        acctMap.put("accountRatio", entryInfo.getAccountRatio());
        acctMap.put("rowindex", "jqg" + (rowNum + 1));
        AccountViewInfo accountInfo = entryInfo.getAccount();
        if (accountInfo != null && accountInfo.getCAA() != null && accountInfo.getCAA().getId() != null) {
            AmortizeRuleDestAssRecCollection assRecColl = entryInfo.getAssRec();
            ArrayList assRecList = new ArrayList();
            int size = assRecColl.size();
            for (int j = 0; j < size; ++j) {
                HashMap<String, Object> assResMap = new HashMap<String, Object>();
                AmortizeRuleDestAssRecInfo assRecInfo = assRecColl.get(j);
                assResMap.put("ratio", assRecInfo.getRatio());
                assResMap.put("rowindex", "jqg" + (j + 1));
                this.toAssResMap(ctx, assRecInfo.getAssGrp(), assResMap);
                assRecList.add(assResMap);
            }
            accountInfo.put("asst", assRecList);
        }
        acctMap.put("account", accountInfo);
        if (accountInfo != null) {
            acctList.add(acctMap);
        }
        if (orgType == AmortizeOrgTypeEnum.CompanyToCompany) {
            newEntryInfo.getCompany().put("acct", acctList);
        } else {
            newEntryInfo.getProfitCenter().put("acct", acctList);
        }
        if (isExist) {
            AmortizeRuleDestEntryCollection copyColl = new AmortizeRuleDestEntryCollection();
            Iterator itor = newDestEntryColl.iterator();
            while (itor.hasNext()) {
                AmortizeRuleDestEntryInfo destEntryInfo = (AmortizeRuleDestEntryInfo)itor.next();
                if (destEntryInfo.getId().equals((Object)newEntryInfo.getId())) {
                    copyColl.add(newEntryInfo);
                    continue;
                }
                copyColl.add(destEntryInfo);
            }
            newDestEntryColl.clear();
            newDestEntryColl.addCollection(copyColl);
        } else {
            newDestEntryColl.add(newEntryInfo);
        }
    }

    private List getCurrencyComboList() throws EASBizException, BOSException {
        CurrencyCollection currencyColl = this.getCurrencyCollection();
        ArrayList currencyComboList = new ArrayList();
        for (int i = 0; i < currencyColl.size(); ++i) {
            CurrencyInfo currency = currencyColl.get(i);
            HashMap<String, Object> currencyMap = new HashMap<String, Object>();
            currencyMap.put("value", currency.getId().toString());
            currencyMap.put("alias", currency.getName());
            currencyMap.put("precision", currency.getPrecision());
            currencyMap.put("invalid", currency.getDeletedStatus() == DeletedStatusEnum.DELETED);
            currencyComboList.add(currencyMap);
        }
        return currencyComboList;
    }

    private CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        view.getSelector().add(new SelectorItemInfo("deletedStatus"));
        return CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view, true);
    }

    private List<Map> getVoucherTypeList(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ArrayList<Map> voucherTypeList = new ArrayList<Map>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select vt.fid, vt.fname_").append(this.ctx.getLocale().toString()).append(" fname, vt.fpretermit, case when vtc.flevel is null then vt.flevel else vtc.flevel end flevel ");
        sql.append(" from t_bd_vouchertypes vt left outer join t_bd_vouchertypectrllevel vtc on vtc.fvouchertypeid = vt.fid and vtc.fcompanyid = ? ");
        sql.append(" where vt.fid IN (SELECT FDataBaseDID FROM t_bd_databasedassign WHERE FBOSObjectType = '7487D35D' AND FAssignCUID = ? ");
        sql.append(" union all (select fid from T_BD_VoucherTypes where fcontrolunitid = ?)) order by vt.fnumber ASC");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{company.getId().toString(), company.getCU().getId().toString(), company.getCU().getId().toString()});
        try {
            HashSet<String> keys = new HashSet<String>();
            while (rs.next()) {
                HashMap<String, Object> vt = new HashMap<String, Object>();
                String typeId = rs.getString("fid");
                if (keys.contains(typeId)) continue;
                vt.put("value", typeId);
                vt.put("alias", rs.getString("fname"));
                vt.put("isDefualt", rs.getInt("fpretermit") == 1);
                vt.put("level", rs.getInt("flevel"));
                voucherTypeList.add(vt);
                keys.add(typeId);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return voucherTypeList;
    }

    private VoucherTypeInfo getDefaultVoucherTypeInfo(List<Map> voucherTypeList) throws BOSException, EASBizException {
        Iterator<Map> it = voucherTypeList.iterator();
        Map defaultVoucherType = null;
        Map topLevelDefVType = null;
        while (it.hasNext()) {
            Map vt = it.next();
            if (topLevelDefVType == null || vt.get("level") != null && (Integer)vt.get("level") < (Integer)topLevelDefVType.get("level")) {
                topLevelDefVType = vt;
            }
            if (!Boolean.TRUE.equals(vt.get("isDefualt"))) continue;
            defaultVoucherType = vt;
            break;
        }
        if (defaultVoucherType == null) {
            if (topLevelDefVType != null) {
                defaultVoucherType = topLevelDefVType;
            } else if (!voucherTypeList.isEmpty()) {
                defaultVoucherType = voucherTypeList.get(0);
            }
        }
        if (defaultVoucherType != null) {
            VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
            voucherTypeInfo.setId(BOSUuid.read((String)((String)defaultVoucherType.get("value"))));
            voucherTypeInfo.setName((String)defaultVoucherType.get("alias"));
            return voucherTypeInfo;
        }
        return null;
    }

    private List<Map> getAmortizeStandList(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ArrayList<Map> amortizeStandList = new ArrayList<Map>();
        String[] companyParentIds = PcaAmortizeRuleUtils.getOrgAllParentIds(this.ctx, "company", company.getId().toString());
        StringBuffer sb = new StringBuffer();
        int size = companyParentIds.length;
        for (int i = 0; i < size; ++i) {
            sb.append("'").append(companyParentIds[i]).append("',");
        }
        String ids = sb.toString().substring(0, sb.toString().length() - 1);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ast.fid, ast.fname_").append(this.ctx.getLocale().toString()).append(" fname ");
        sql.append(" from T_PCA_AmortizeStand ast ");
        sql.append(" where ast.fcompanyid in (" + ids + ") ");
        sql.append(" order by ast.fnumber asc ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            HashSet<String> keys = new HashSet<String>();
            while (rs.next()) {
                HashMap<String, String> hm = new HashMap<String, String>();
                String astId = rs.getString("fid");
                if (keys.contains(astId)) continue;
                hm.put("value", astId);
                hm.put("alias", rs.getString("fname"));
                amortizeStandList.add(hm);
                keys.add(astId);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return amortizeStandList;
    }

    private Map getSysParam(Context ctx) throws GLException, EASBizException, BOSException {
        String companyId = this.amortizeRuleInfo.getCompany().getId().toString();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String[] groupParamNumbers = new String[]{"G001", "G010", "GL_VCH_POST_CONTROL", "G003"};
        HashMap paramMap = iParamControl.getParamHashMap(groupParamNumbers, null);
        String[] paramNumbers = new String[]{"GL_002", "GL_003", "GL_047", "GL_0151", "GL_069", "GL_043", "GL_0155", "GL_014", "GL_015", "GL_014_1", "GL_0151", "GL_102", "GL_031", "GL_099", "GL_067", "GL_012", "PCA_012", "GL_029", "GL_111"};
        paramMap.putAll(iParamControl.getParamHashMap(paramNumbers, companyId));
        for (String key : paramMap.keySet()) {
            Object value = paramMap.get(key);
            if (!"true".equals(value) && !"false".equals(value)) continue;
            paramMap.put(key, Boolean.valueOf((String)value));
        }
        return paramMap;
    }
}

