/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CussentStatusEnum;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.ServerUtils;
import com.kingdee.eas.ma.pca.app.WebPcVoucherTransfer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WebPcVoucherCreator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.WebPcVoucherCreator");

    public PcVoucherInfo create(Context ctx, String companyId) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = new PcVoucherInfo();
        voucherInfo.setPostedByUI(true);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        ProfitCenterOrgUnitInfo pco = ServerUtils.getDefaultProfitCenter(ctx, companyId, "pca_voucher_add");
        voucherInfo.setCompany(PcaUtils.getDelegateCompany(ctx, pco.getId().toString()));
        voucherInfo.put("defaultRelatedCompany", (Object)voucherInfo.getCompany());
        voucherInfo.setProfitCenter(pco);
        voucherInfo.setCU(pco.getCU());
        this.setPeriod(ctx, voucherInfo);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAttachments(0);
        voucherInfo.setSourceSys(SystemEnum.PROFIT_CENTER_ACCOUNTING);
        voucherInfo.setSourceType(SourceType.HANDCRAFT);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
        PcVoucherInfo webVoucherInfo = new WebPcVoucherTransfer(ctx, voucherInfo).transfer();
        this.setNumberAddNew(ctx, voucherInfo);
        return webVoucherInfo;
    }

    public PcVoucherInfo copy(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(voucherInfo.getProfitCenter().getId()), "pca_voucher_add")) {
            String addNewVoucher = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"addNewVoucher", (Locale)ctx.getLocale());
            throw new GLException(GLException.NO_PERMISSON, (Object[])new String[]{addNewVoucher});
        }
        voucherInfo.setId(null);
        voucherInfo.setNumber(null);
        this.setPeriod(ctx, voucherInfo);
        String periodTypeId = voucherInfo.getCompany().getAccountPeriodType().getId().toString();
        voucherInfo.put("periodenum", (Object)WebPcVoucherTransfer.getPeriodListByDate(ctx, periodTypeId, voucherInfo.getBookedDate()));
        voucherInfo.put("periodstr", (Object)WebPcVoucherTransfer.toPeriodString(voucherInfo.getPeriod()));
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setCashier(null);
        voucherInfo.setAuditor(null);
        voucherInfo.setPoster(null);
        voucherInfo.setCanceller(null);
        voucherInfo.setAttachments(0);
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
        voucherInfo.setSourceSys(SystemEnum.PROFIT_CENTER_ACCOUNTING);
        voucherInfo.setSourceType(SourceType.HANDCRAFT);
        voucherInfo.setIsCussent(false);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        voucherInfo.setSourceBillId(null);
        voucherInfo.setIsReverseVoucher(false);
        voucherInfo.setHasReversed(false);
        voucherInfo.setIsCheck(false);
        this.setNumberAddNew(ctx, voucherInfo);
        Iterator it = voucherInfo.getEntries().iterator();
        int index = 1;
        while (it.hasNext()) {
            PcVoucherEntryInfo entry = (PcVoucherEntryInfo)it.next();
            entry.put("entryid", null);
            entry.put("assistrecordid", null);
            entry.put("entry_assistrecord_id", (Object)index++);
            entry.setOprStatus(1);
            entry.setCussent(CussentStatusEnum.NONE);
            AccountViewInfo account = entry.getAccount();
            if (account == null || account.getCAA() == null && !account.isHasUserProperty()) continue;
            account.put("asstbizdate", (Object)voucherInfo.getBizDate());
            if (!account.isAC()) continue;
            Date asstEndDate = DateTimeUtils.truncateDate((Date)voucherInfo.getPeriod().getEndDate());
            account.put("asstenddate", (Object)asstEndDate);
        }
        return voucherInfo;
    }

    private void setPeriod(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        PeriodInfo period = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(1006, voucherInfo.getProfitCenter().getId().toString());
        UserSettingObject settingObj = UserSettingFactory.getLocalInstance((Context)ctx).getValue(null, "ma.pca.voucher.editSetting");
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        if (settingObj != null && settingObj.getBoolean("sysData") && (period == null || date.after(period.getEndDate()))) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)date, (Date)date, (CompanyOrgUnitInfo)company);
            if (!periodColl.isEmpty()) {
                period = periodColl.get(0);
            }
        } else {
            if (period != null) {
                if (date.before(period.getBeginDate())) {
                    date = period.getBeginDate();
                } else if (date.after(period.getEndDate())) {
                    date = period.getEndDate();
                }
            }
            date = DateTimeUtils.truncateDate((Date)date);
        }
        voucherInfo.setBizDate(date);
        voucherInfo.setBookedDate(date);
        voucherInfo.setPeriod(period);
    }

    private void setNumberAddNew(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isNumberAddNew = iCodingRuleManager.isAddView((IObjectValue)voucherInfo, voucherInfo.getProfitCenter().getId().toString(), "bizStatus");
            if (isNumberAddNew) {
                String number = iCodingRuleManager.readNumber((IObjectValue)voucherInfo, voucherInfo.getProfitCenter().getId().toString(), "bizStatus", "");
                voucherInfo.setNumber(number);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"codingRule error!", (Throwable)ex);
        }
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
    }
}

