/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.TemplatePcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.TemplatePcVoucherInfo;
import com.kingdee.eas.ma.pca.app.ServerUtils;
import com.kingdee.eas.ma.pca.app.WebTemplatePcVoucherTransfer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WebTemplatePcVoucherCreator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.WebTemplatePcVoucherCreator");

    public TemplatePcVoucherInfo create(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        TemplatePcVoucherInfo voucherInfo = new TemplatePcVoucherInfo();
        ProfitCenterOrgUnitInfo pco = ServerUtils.getDefaultProfitCenter(ctx, profitCenterId, "pca_templatevoucher_addnew");
        voucherInfo.setCompany(PcaUtils.getDelegateCompany(ctx, pco.getId().toString()));
        voucherInfo.setProfitCenter(pco);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAttachments(0);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        TemplatePcVoucherInfo webVoucherInfo = new WebTemplatePcVoucherTransfer(ctx, voucherInfo).transfer();
        return webVoucherInfo;
    }

    public TemplatePcVoucherInfo copy(Context ctx, TemplatePcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(voucherInfo.getProfitCenter().getId()), "pca_templatevoucher_addnew")) {
            String addNewVoucher = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"addNewTemplateVoucher", (Locale)ctx.getLocale());
            throw new GLException(GLException.NO_PERMISSON, (Object[])new String[]{addNewVoucher});
        }
        voucherInfo.setId(null);
        voucherInfo.setNumber(null);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAuditor(null);
        voucherInfo.setAttachments(0);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        voucherInfo.setSourceBillId(null);
        Iterator it = voucherInfo.getEntries().iterator();
        int index = 1;
        while (it.hasNext()) {
            TemplatePcVoucherEntryInfo entry = (TemplatePcVoucherEntryInfo)it.next();
            entry.put("entryid", null);
            entry.put("assistrecordid", null);
            entry.put("entry_assistrecord_id", (Object)index++);
            entry.setOprStatus(1);
            AccountViewInfo account = entry.getAccount();
            if (account == null || account.getCAA() == null && !account.isHasUserProperty()) continue;
            account.put("asstbizdate", (Object)voucherInfo.getBizDate());
        }
        return voucherInfo;
    }
}

