/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.dataImp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.pca.IPcaGeneralFacade;
import com.kingdee.eas.ma.pca.PcCashflowRecordCollection;
import com.kingdee.eas.ma.pca.PcCashflowRecordFactory;
import com.kingdee.eas.ma.pca.PcCashflowRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherImpFacadeFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcWSVoucherCollection;
import com.kingdee.eas.ma.pca.PcWSVoucherInfo;
import com.kingdee.eas.ma.pca.PcaGeneralFacadeFactory;
import com.kingdee.eas.ma.pca.app.dataImp.PcCashFlowRecordDataImport;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.RecordUtils;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PcVoucherDataImport
extends BlockDataTransmission {
    private static final SimpleDateFormat dateTime_Formater = new SimpleDateFormat("yyyy-MM-dd");
    private static final String RES_GLVOUCHERIMPRESOURCE = "com.kingdee.eas.fi.gl.GLVoucherImpResource";
    private int count = 0;
    private String FSerialNumber = "";
    protected static final String[] voucherField = new String[]{"FProfitCenterID", "FCompanyID", "FDate", "FTransDate", "FPeriod", "FGroup", "FNum", "FEntryID", "FExp", "FAcctID", "FCyID", "FExchRate", "FDC", "FFcyAmt", "FQty", "FAssistQty", "FPrice", "FDebit", "FCredit", "FPrepare", "FAttchment", "FSerialNO", "FUnitName", "FAssistUnit", "FReference", "FHasCashFlow", "FCashFlow", "FTransID", "FSettlCode", "FSettleNO", "FClsName1", "FObjID1", "FObjName1", "FClsName2", "FObjID2", "FObjName2", "FClsName3", "FObjId3", "FObjName3", "FClsName4", "FObjID4", "FObjName4", "FClsName5", "FObjID5", "FObjName5", "FClsName6", "FObjID6", "FObjName6", "FClsName7", "FObjID7", "FObjName7", "FClsName8", "FObjID8", "FObjName8", "FInvNum", "FTicketNum", "FCustomer", "FFeeType", "FHandler", "FMaterial", "FOrgUnit", "FSupplier", "FBizDate", "FEndDate"};
    private RecordCollection excelColl = new RecordCollection();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PcVoucherFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
    }

    public boolean isSkipMainProcess() {
        return true;
    }

    public boolean isAfterAllProcess() {
        Map paramMap = this.getContextMap();
        String hasCashFlow = (String)paramMap.get("hasCashFlow");
        return hasCashFlow != null && "false".equals(hasCashFlow);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            String FHandler;
            String FInvNum;
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            String FProfitCenterID = rs.getString("profitCenter.number");
            result.put("FProfitCenterID", FProfitCenterID);
            String FCompanyID = rs.getString("company.number");
            result.put("FCompanyID", FCompanyID);
            Object FDate = rs.getObject("bookedDate");
            result.put("FDate", FDate == null ? "" : FDate.toString());
            Object FTransDate = rs.getObject("bizDate");
            result.put("FTransDate", FTransDate == null ? "" : FTransDate.toString());
            String FPeriod = rs.getString("period.number");
            FPeriod = Integer.valueOf(FPeriod.substring(4)).toString();
            result.put("FPeriod", FPeriod == null ? "" : FPeriod);
            String FGroup = rs.getString("voucherType.name");
            result.put("FGroup", FGroup == null ? "" : FGroup);
            String FNum = rs.getString("myNumber");
            result.put("FNum", FNum == null ? "" : FNum);
            String FEntryID = rs.getString("entries.seq");
            result.put("FEntryID", FEntryID == null ? "" : FEntryID);
            if (FEntryID.equals("1")) {
                String FSerialNO = String.valueOf(System.currentTimeMillis()) + "--" + this.count;
                result.put("FSerialNO", FSerialNO == null ? "" : FSerialNO);
                this.FSerialNumber = FSerialNO;
                ++this.count;
            } else {
                result.put("FSerialNO", this.FSerialNumber == null ? "" : this.FSerialNumber);
            }
            String FExp = rs.getString("entries.description");
            result.put("FExp", FExp == null ? "" : FExp);
            String FAcctID = rs.getString("account.number");
            result.put("FAcctID", FAcctID == null ? "" : FAcctID);
            String FAcctName = rs.getString("account.longName");
            result.put("FAcctName", FAcctName == null ? "" : FAcctName);
            String reportingAmountCredit = rs.getString("reportingAmountCredit");
            result.put("FReportingCreditAmount", reportingAmountCredit == null ? "" : reportingAmountCredit);
            String reportingAmountDebit = rs.getString("reportingAmountDebit");
            result.put("FReportingDebitAmount", reportingAmountDebit == null ? "" : reportingAmountDebit);
            String FCyID = rs.getString("currency.number");
            result.put("FCyID", FCyID == null ? "" : FCyID);
            String FExchRate = rs.getString("entries.localExchangeRate");
            result.put("FExchRate", FExchRate == null ? Integer.valueOf(0) : FExchRate);
            String FDC = rs.getString("entries.entryDC");
            result.put("FDC", FDC == null ? "" : FDC);
            String FAsstAmt = rs.getString("assistRecords.originalAmount");
            String FFcyAmt = rs.getString("entries.originalAmount");
            if (FAsstAmt != null) {
                result.put("FFcyAmt", FFcyAmt == null ? Integer.valueOf(0) : FAsstAmt);
            } else {
                result.put("FFcyAmt", FFcyAmt == null ? Integer.valueOf(0) : FFcyAmt);
            }
            Long FQty = rs.getLong("entries.quantity");
            result.put("FQty", FQty == null ? (Number)0 : (Number)FQty);
            Long FAssistQty = rs.getLong("assistRecords.quantity");
            result.put("FAssistQty", FAssistQty == null ? (Number)0 : (Number)FAssistQty);
            Long FPrice = rs.getLong("entries.price");
            result.put("FPrice", FPrice == null ? (Number)0 : (Number)FPrice);
            String FAsstLocal = rs.getString("assistRecords.localAmount");
            String FDebit = rs.getString("localAmountDebit");
            if (FAsstLocal != null) {
                result.put("FDebit", FDebit == null ? Integer.valueOf(0) : FAsstLocal);
            } else {
                result.put("FDebit", FDebit == null ? Integer.valueOf(0) : FDebit);
            }
            String FCredit = rs.getString("localAmountCredit");
            if (FAsstLocal != null) {
                result.put("FCredit", FCredit == null ? Integer.valueOf(0) : FAsstLocal);
            } else {
                result.put("FCredit", FCredit == null ? Integer.valueOf(0) : FCredit);
            }
            String FPrepare = rs.getString("creator.number");
            result.put("FPrepare", FPrepare == null ? "" : FPrepare);
            String FAttchment = rs.getString("attachments");
            result.put("FAttchment", FAttchment == null ? Integer.valueOf(0) : FAttchment);
            String FUnitName = rs.getString("measureUnit.number");
            result.put("FUnitName", FUnitName == null ? "" : FUnitName);
            String FAssistUnit = rs.getString("measureUnit1.number");
            result.put("FAssistUnit", FAssistUnit == null ? "" : FAssistUnit);
            String FReference = rs.getString("description");
            result.put("FReference", FReference == null ? "" : FReference);
            result.put("FHasCashFlow", "");
            String FCashFlow = rs.getString("cashflowFlag");
            result.put("FCashFlow", FCashFlow == null ? Integer.valueOf(0) : FCashFlow);
            String FTransID = rs.getString("assistRecords.bizNumber");
            result.put("FTransID", FTransID == null ? "" : FTransID);
            String FSettlCode = rs.getString("settlementType.name");
            result.put("FSettlCode", FSettlCode == null ? "" : FSettlCode);
            String FSettleNO = rs.getString("assistRecords.settlementCode");
            result.put("FSettleNO", FSettleNO == null ? "" : FSettleNO);
            HashMap<String, Map> asstItemMap = new HashMap<String, Map>();
            Map asstResult = null;
            IPcaGeneralFacade facade = PcaGeneralFacadeFactory.getLocalInstance(ctx);
            String assGrpId = rs.getString("assGrp.id");
            if (asstItemMap.containsKey(assGrpId)) {
                asstResult = (Map)asstItemMap.get(assGrpId);
            } else {
                HashMap<String, String> key = new HashMap<String, String>();
                key.put("key", assGrpId);
                asstResult = facade.dealTask("getAsstItem", key);
                asstItemMap.put(assGrpId, asstResult);
            }
            if (asstResult != null) {
                AsstActTypeCollection col = (AsstActTypeCollection)asstResult.get("value");
                int count2 = 0;
                if (col != null) {
                    count2 = col.size();
                }
                for (int k = 0; k < count2; ++k) {
                    AsstActTypeInfo data = col.get(k);
                    int jj = k + 1;
                    result.put("FClsName" + jj, (String)data.get("asstTypes") == null ? "" : (String)data.get("asstTypes"));
                    result.put("FObjID" + jj, (String)data.get("asstItemNumbers") == null ? "" : (String)data.get("asstItemNumbers"));
                    result.put("FObjName" + jj, (String)data.get("asstItemNames") == null ? "" : (String)data.get("asstItemNames"));
                }
            }
            result.put("FInvNum", (FInvNum = rs.getString("assistRecords.invoiceNumber")) == null ? "" : FInvNum);
            String FTicketNum = rs.getString("assistRecords.ticketNumber");
            result.put("FTicketNum", FTicketNum == null ? "" : FTicketNum);
            String FCustomer = rs.getString("customer.name");
            result.put("FCustomer", FCustomer == null ? "" : FCustomer);
            boolean hasUserProperty = rs.getBoolean("account.hasUserProperty");
            if (hasUserProperty) {
                String FFeeType = rs.getString("assistRecords.feeType");
                result.put("FFeeType", FFeeType == null ? "" : FFeeType);
            }
            result.put("FHandler", (FHandler = rs.getString("handler1.name")) == null ? "" : FHandler);
            String FMaterial = rs.getString("material.name");
            result.put("FMaterial", FMaterial == null ? "" : FMaterial);
            String FOrgUnit = rs.getString("orgUnit.name");
            result.put("FOrgUnit", FOrgUnit == null ? "" : FOrgUnit);
            String FSupplier = rs.getString("supplier.name");
            result.put("FSupplier", FSupplier == null ? "" : FSupplier);
            Object FBizDate = rs.getObject("assistRecords.bizDate");
            result.put("FBizDate", FBizDate == null ? "" : FBizDate);
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        boolean isSelectedAll = (Boolean)paramMap.get("isSelectedAll");
        ArrayList selectedVouchers = (ArrayList)paramMap.get("selectedVouchers");
        HashSet<String> selectedIds = new HashSet<String>();
        if (selectedVouchers != null && !isSelectedAll) {
            selectedIds.addAll(selectedVouchers);
        } else {
            try {
                String filterValue = paramMap.get("bizCommonQueryFilter").toString();
                filterValue = filterValue.replace("$", "'");
                EntityViewInfo mainQuery = new EntityViewInfo();
                mainQuery.setFilter(new FilterInfo(filterValue));
                MetaDataPK mainQueryPK = new MetaDataPK(this.getExportQueryInfo(ctx));
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
                exec.setObjectView(mainQuery);
                IRowSet rs = exec.executeQuery();
                while (rs.next()) {
                    selectedIds.add(rs.getString("id"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.INCLUDE));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.ma.pca.app.PcVoucherExportQuery";
    }

    protected PcVoucherCollection getVoucherPkList(IObjectPK[] pkList) throws Exception {
        StringBuffer strFilter = new StringBuffer("");
        strFilter.append(pkList[0]);
        PcVoucherCollection voucherCollection = this.getVoucherCollection(strFilter.toString());
        PcCashflowRecordCollection cashflowCollection = this.getCashflowCollection(strFilter.toString());
        if (cashflowCollection.size() > 0) {
            this.mergeVoucherAndCashflow(voucherCollection, cashflowCollection);
        }
        return voucherCollection;
    }

    private void mergeVoucherAndCashflow(PcVoucherCollection voucherCollection, PcCashflowRecordCollection cashflowCollection) {
        for (PcCashflowRecordInfo cashflowRecord : cashflowCollection) {
            BOSUuid vchEntryId;
            BOSUuid vchId = cashflowRecord.getVoucher().getId();
            PcVoucherInfo voucher = (PcVoucherInfo)voucherCollection.getObject((Object)vchId);
            if (voucher == null) continue;
            cashflowRecord.setVoucher(voucher);
            PcVoucherEntryCollection entries = voucher.getEntries();
            PcVoucherEntryInfo entry = (PcVoucherEntryInfo)entries.getObject((Object)(vchEntryId = cashflowRecord.getEntry().getId()));
            if (entry == null) continue;
            cashflowRecord.setEntry(entry);
            entry.getCashflowRecords().add(cashflowRecord);
        }
    }

    private PcCashflowRecordCollection getCashflowCollection(String vchIdList) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)vchIdList, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("voucher.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("originalAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("reportingAmount"));
        sic.add(new SelectorItemInfo("primaryCoefficient"));
        sic.add(new SelectorItemInfo("supplementaryCoefficient"));
        sic.add(new SelectorItemInfo("voucher.number"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("opposingAccountEntry.seq"));
        sic.add(new SelectorItemInfo("primaryItem.number"));
        sic.add(new SelectorItemInfo("supplementaryItem.number"));
        sic.add(new SelectorItemInfo("assGrp.id"));
        sic.add(new SelectorItemInfo("type"));
        view.setSelector(sic);
        view.setFilter(filter);
        return PcCashflowRecordFactory.getRemoteInstance().getPcCashflowRecordCollection(view);
    }

    private PcVoucherCollection getVoucherCollection(String vchIdList) throws Exception {
        EntityViewInfo e = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)vchIdList, CompareType.INCLUDE));
        f.setMaskString(" #0 and #1 ");
        e.setFilter(f);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("profitCenter.number"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("attachments"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("isReverseVoucher"));
        sic.add(new SelectorItemInfo("hasReversed"));
        sic.add(new SelectorItemInfo("cashflowFlag"));
        sic.add(new SelectorItemInfo("isAC"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("sourceSys"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("poster.name"));
        sic.add(new SelectorItemInfo("canceller.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("poster.number"));
        sic.add(new SelectorItemInfo("canceller.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.description"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.localExchangeRate"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reportingExchangeRate"));
        sic.add(new SelectorItemInfo("entries.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.account.AC"));
        sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
        sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
        sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.customer.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.feeType"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.material.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.supplier.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.endDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.description"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.price"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
        e.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        sort.add(new SorterItemInfo("entries.seq"));
        e.getSorter().addObjectCollection((IObjectCollection)sort);
        return PcVoucherFactory.getRemoteInstance().getPcVoucherCollection(e);
    }

    public void solutionOnFinished(Context ctx) throws TaskExternalException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        String hasCashFlow = (String)paramMap.get("hasCashFlow");
        if (hasCashFlow != null && "false".equals(hasCashFlow)) {
            try {
                VoucherImpExpParam filterParam = this.getVoucherImpExpParam(paramMap);
                List<Set<String>> voucherNumList = this.getVoucherNumberGroup(ctx, tempTableName);
                for (int i = 0; i < voucherNumList.size(); ++i) {
                    Set<String> vnSet = voucherNumList.get(i);
                    PcWSVoucherCollection pcWSVchColl = PcCashFlowRecordDataImport.getVoucherList(ctx, tempTableName, vnSet);
                    boolean isSubmit = false;
                    String isSubmittoStr = (String)paramMap.get("isSubmit");
                    if (!StringUtils.isEmpty((String)isSubmittoStr)) {
                        isSubmit = Boolean.parseBoolean(isSubmittoStr);
                    }
                    Map<String, IObjectCollection> result = new HashMap();
                    String oprtState = (String)paramMap.get("oprtState");
                    if (!StringUtils.isEmpty((String)oprtState) && "checkVoucher".equals(oprtState)) {
                        IObjectCollection coll = PcVoucherImpFacadeFactory.getLocalInstance(ctx).checkVoucher((IObjectCollection)pcWSVchColl, false, isSubmit, false, false, "excel", filterParam);
                        result.put("cols", coll);
                        PcWSVoucherInfo pcWSVouherInfo = (PcWSVoucherInfo)coll.getObject(0);
                        String fileUuId = (String)pcWSVouherInfo.get("fileUuId");
                        int sheetId = (Integer)pcWSVouherInfo.get("sheetId");
                        result.put("fileUuId", (IObjectCollection)fileUuId);
                        result.put("sheetId", (IObjectCollection)Integer.valueOf(sheetId));
                    } else {
                        result = PcVoucherImpFacadeFactory.getLocalInstance(ctx).importVoucher((IObjectCollection)pcWSVchColl, false, false, isSubmit, false, "excel", filterParam);
                    }
                    PcWSVoucherCollection cols = (PcWSVoucherCollection)((Object)result.get("cols"));
                    HashSet<PcWSVoucherInfo> sucSet = new HashSet<PcWSVoucherInfo>();
                    HashSet<PcWSVoucherInfo> failedSet = new HashSet<PcWSVoucherInfo>();
                    HashSet<PcWSVoucherInfo> set = new HashSet<PcWSVoucherInfo>();
                    Iterator itor = cols.iterator();
                    while (itor.hasNext()) {
                        PcWSVoucherInfo pcWSVoucherInfo = (PcWSVoucherInfo)itor.next();
                        if (((Boolean)pcWSVoucherInfo.get("successful")).booleanValue()) {
                            sucSet.add(pcWSVoucherInfo);
                            continue;
                        }
                        failedSet.add(pcWSVoucherInfo);
                    }
                    for (PcWSVoucherInfo sucPcWsVoucher : sucSet) {
                        for (PcWSVoucherInfo faiItWsVoucher : failedSet) {
                            if (sucPcWsVoucher.getVoucherNumber() == null || !sucPcWsVoucher.getVoucherNumber().equals(faiItWsVoucher.getVoucherNumber()) || sucPcWsVoucher.getProfitCenterNumber() == null || !sucPcWsVoucher.getProfitCenterNumber().equals(faiItWsVoucher.getProfitCenterNumber()) || sucPcWsVoucher.getPeriodYear() != faiItWsVoucher.getPeriodYear() || sucPcWsVoucher.getPeriodNumber() != faiItWsVoucher.getPeriodNumber()) continue;
                            set.add(sucPcWsVoucher);
                            sucSet.remove(sucPcWsVoucher);
                            failedSet.remove(faiItWsVoucher);
                        }
                    }
                    HashSet<PcWSVoucherInfo> needRemoveSet = new HashSet<PcWSVoucherInfo>();
                    for (PcWSVoucherInfo sucPcWsVoucher : sucSet) {
                        for (PcWSVoucherInfo faiItWsVoucher : failedSet) {
                            if (sucPcWsVoucher.getVoucherNumber() == null || !sucPcWsVoucher.getVoucherNumber().equals(faiItWsVoucher.getVoucherNumber()) || sucPcWsVoucher.getProfitCenterNumber() == null || !sucPcWsVoucher.getProfitCenterNumber().equals(faiItWsVoucher.getProfitCenterNumber())) continue;
                            needRemoveSet.add(sucPcWsVoucher);
                        }
                    }
                    if (needRemoveSet != null && !needRemoveSet.isEmpty()) {
                        sucSet.removeAll(needRemoveSet);
                    }
                    String fileUuId = (String)result.get("fileUuId");
                    int sheetId = (Integer)result.get("sheetId");
                    RecordCollection col = this.getFailedRecordCollection(ctx, failedSet, (IObjectCollection)cols, set);
                    ArrayList<SuccessInfo> sucList = new ArrayList<SuccessInfo>();
                    SuccessInfo sucInfo = this.getVoucherSuccessfulCount(ctx, sucSet, fileUuId, sheetId, set);
                    sucList.add(sucInfo);
                    this.writeLog(col, sucList);
                }
                this.writeLogForVoucherNumberisNull(ctx);
                this.writeLog(this.excelColl, null);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }

    private void writeLogForVoucherNumberisNull(Context ctx) throws BOSException, SQLException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        sql.append("select FProfitCenterID,FCompanyID,FDate,FTransDate,FPeriod,FGroup,FNum,FEntryID,FExp,");
        sql.append("       FAcctID,FCyID,FExchRate,FDC,FFcyAmt,FQty,FAssistQty,FPrice,FDebit,");
        sql.append("       FCredit,FPrepare,FAttchment,FSerialNO,FUnitName,FAssistUnit,FReference,");
        sql.append("       FHasCashFlow,FCashFlow,FTransID,FSettlCode,FSettleNO,FClsName1,FObjID1,");
        sql.append("       FObjName1,FClsName2,FObjID2,FObjName2,FClsName3,FObjId3,FObjName3,");
        sql.append("       FClsName4,FObjID4,FObjName4,FClsName5,FObjID5,FObjName5,FClsName6,");
        sql.append("       FObjID6,FObjName6,FClsName7,FObjID7,FObjName7,FClsName8,FObjID8,FObjName8,");
        sql.append("       FInvNum,FTicketNum,FCustomer,FFeeType,FHandler,FMaterial,FOrgUnit,FSupplier,");
        sql.append("       FBizDate,FEndDate,lineNum,fileUuID ");
        sql.append(" from ").append(tempTableName);
        sql.append(" where fnum is null ");
        sql.append(" order by lineNum");
        if (tempTableName == null) {
            return;
        }
        RecordCollection col = new RecordCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs != null && rs.next()) {
            SimpleRecord rec = new SimpleRecord();
            rec.setRowNum(rs.getInt("lineNum"));
            rec.setFileUuId(rs.getString("fileUuID"));
            rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
            int size = voucherField.length;
            for (int i = 0; i < size; ++i) {
                DataToken value = new DataToken();
                value.name = voucherField[i];
                value.data = rs.getString(voucherField[i]);
                rec.put(voucherField[i], value);
            }
            StringBuffer msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)rs.getInt("lineNum")) + 4));
            msg.append(this.getRes(ctx, "number")).append("[").append(rs.getString("FNum") == null ? "" : rs.getString("FNum")).append("]");
            msg.append(this.getRes(ctx, "isnull")).append("!");
            rec.setMsg(msg.toString());
            col.add((IRecord)rec);
        }
        this.writeLog(col, null);
    }

    private String getVchLineErrorMsg(Context ctx, int row) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"no", (Locale)ctx.getLocale()));
        msg.append(row);
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"line", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"voucher", (Locale)ctx.getLocale()));
        return msg.toString();
    }

    private String getRes(Context ctx, String resName) {
        return ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    private VoucherImpExpParam getVoucherImpExpParam(Map paramMap) {
        VoucherImpExpParam filterParam = new VoucherImpExpParam();
        String errorDispose = (String)paramMap.get("errorDispose");
        if (!StringUtils.isEmpty((String)errorDispose)) {
            filterParam.setStopImpVoucher(Boolean.parseBoolean(errorDispose));
        }
        boolean halfInviableSaveVoucher = (Boolean)paramMap.get("halfInviableSaveVoucher");
        filterParam.setChkHalfInviableSaveVoucher(halfInviableSaveVoucher);
        boolean isSaveByOrgUser = (Boolean)paramMap.get("isSaveByOrgUser");
        filterParam.setSaveByOrgUser(isSaveByOrgUser);
        boolean isTempletVoucherCode = (Boolean)paramMap.get("isTempletVoucherCode");
        filterParam.setChkIsTempletVoucherCode(isTempletVoucherCode);
        filterParam.setAssistById(true);
        return filterParam;
    }

    private List<Set<String>> getVoucherNumberGroup(Context ctx, String tempTableName) throws BOSException, SQLException {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        StringBuffer sql = new StringBuffer();
        sql.append("select min(linenum) minLineNum, FNum from ");
        sql.append(tempTableName);
        sql.append(" where FNum is not null group by FNum order by minLineNum");
        if (tempTableName == null) {
            return new ArrayList<Set<String>>();
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int i = 0;
        HashSet<String> set = new HashSet<String>();
        while (rs != null && rs.next()) {
            set.add(rs.getString("FNum"));
            if (++i != 100) continue;
            result.add(set);
            i = 0;
            set = new HashSet();
        }
        if (i < 100 && set.size() > 0) {
            result.add(set);
        }
        return result;
    }

    private String convertSet2String(Set set) {
        StringBuffer result = new StringBuffer();
        for (PcWSVoucherInfo pv : set) {
            result.append("'").append(pv.getVoucherNumber()).append("',");
        }
        return result.substring(0, result.length() - 1);
    }

    private String convertSet2ProfitCenter(Set set) {
        StringBuffer result = new StringBuffer();
        for (PcWSVoucherInfo pv : set) {
            result.append("'").append(pv.getProfitCenterNumber()).append("',");
        }
        return result.substring(0, result.length() - 1);
    }

    private RecordCollection getFailedRecordCollection(Context ctx, Set failedSet, IObjectCollection cols, Set set) throws BOSException, SQLException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        RecordCollection result = new RecordCollection();
        if (failedSet.size() > 0) {
            sql.append("select FProfitCenterID,FCompanyID,FDate,FTransDate,FPeriod,FGroup,FNum,FEntryID,FExp,");
            sql.append("       FAcctID,FCyID,FExchRate,FDC,FFcyAmt,FQty,FAssistQty,FPrice,FDebit,");
            sql.append("       FCredit,FPrepare,FAttchment,FSerialNO,FUnitName,FAssistUnit,FReference,");
            sql.append("       FHasCashFlow,FCashFlow,FTransID,FSettlCode,FSettleNO,FClsName1,FObjID1,");
            sql.append("       FObjName1,FClsName2,FObjID2,FObjName2,FClsName3,FObjId3,FObjName3,");
            sql.append("       FClsName4,FObjID4,FObjName4,FClsName5,FObjID5,FObjName5,FClsName6,");
            sql.append("       FObjID6,FObjName6,FClsName7,FObjID7,FObjName7,FClsName8,FObjID8,FObjName8,");
            sql.append("       FInvNum,FTicketNum,FCustomer,FFeeType,FHandler,FMaterial,FOrgUnit,FSupplier,");
            sql.append("       FBizDate,FEndDate,lineNum,fileUuID ");
            sql.append(" from ").append(tempTableName);
            sql.append(" where fnum in (").append(this.convertSet2String(failedSet)).append(")");
            sql.append(" and FProfitCenterID in (").append(this.convertSet2ProfitCenter(failedSet)).append(")");
            sql.append(" order by lineNum");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs != null && rs.next()) {
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(rs.getInt("lineNum"));
                rec.setFileUuId(rs.getString("fileUuID"));
                rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
                int size = voucherField.length;
                for (int i = 0; i < size; ++i) {
                    DataToken value = new DataToken();
                    value.name = voucherField[i];
                    value.data = rs.getString(voucherField[i]);
                    rec.put(voucherField[i], value);
                }
                String voucherNum = rs.getString("FNum");
                int lineNum = rs.getInt("lineNum");
                int rowNum = RecordUtils.getRowNum((int)(lineNum + 4));
                for (PcWSVoucherInfo pcWSVoucherInfo : cols) {
                    if (StringUtils.isEmpty((String)voucherNum) || StringUtils.isEmpty((String)pcWSVoucherInfo.getVoucherNumber()) || !voucherNum.equals(pcWSVoucherInfo.getVoucherNumber())) continue;
                    rec.setMsg((String)pcWSVoucherInfo.get("voucherabstract"));
                }
                result.add((IRecord)rec);
            }
        }
        for (PcWSVoucherInfo pv : set) {
            sql = new StringBuffer();
            sql.append("select pv.fdescription, pd.fperiodnumber, vt.fname_l2, vt.fname_l1, vt.fname_l3, ");
            sql.append(" pc.fnumber profitcenternumber from t_pca_pcvoucher pv ");
            sql.append(" inner join t_bd_period pd on pd.fid = pv.fperiodid ");
            sql.append(" inner join t_bd_vouchertypes vt on vt.fid = pv.fvouchertypeid ");
            sql.append(" inner join t_org_profitcenter pc on pc.fid = pv.fprofitcenterid ");
            sql.append(" where pv.fdescription in (");
            sql.append("select FSerialNO from ").append(tempTableName);
            sql.append(" where FNum = '").append(pv.getVoucherNumber()).append("')");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows == null || !rows.next()) continue;
            String description = rows.getString("fdescription");
            int periodNumbe = rows.getInt("fperiodnumber");
            String vouchertype = rows.getString("fname_" + ctx.getLocale());
            String profitcenternumber = rows.getString("profitcenternumber");
            StringBuffer sql1 = new StringBuffer();
            sql1.append("select FProfitCenterID,FCompanyID,FDate,FTransDate,FPeriod,FGroup,FNum,FEntryID,FExp,");
            sql1.append("       FAcctID,FCyID,FExchRate,FDC,FFcyAmt,FQty,FAssistQty,FPrice,FDebit,");
            sql1.append("       FCredit,FPrepare,FAttchment,FSerialNO,FUnitName,FAssistUnit,FReference,");
            sql1.append("       FHasCashFlow,FCashFlow,FTransID,FSettlCode,FSettleNO,FClsName1,FObjID1,");
            sql1.append("       FObjName1,FClsName2,FObjID2,FObjName2,FClsName3,FObjId3,FObjName3,");
            sql1.append("       FClsName4,FObjID4,FObjName4,FClsName5,FObjID5,FObjName5,FClsName6,");
            sql1.append("       FObjID6,FObjName6,FClsName7,FObjID7,FObjName7,FClsName8,FObjID8,FObjName8,");
            sql1.append("       FInvNum,FTicketNum,FCustomer,FFeeType,FHandler,FMaterial,FOrgUnit,FSupplier,");
            sql1.append("       FBizDate,FEndDate,lineNum,fileUuID ");
            sql1.append(" from ").append(tempTableName);
            sql1.append(" where fnum in ('").append(pv.getVoucherNumber()).append("')");
            sql1.append("   and (FSerialNO <> '").append(description).append("' ");
            sql1.append("   or  FPeriod <> ").append(periodNumbe);
            sql1.append("   or  FGroup <> '").append(vouchertype).append("' ");
            sql1.append("   or  FProfitCenterID <> '").append(profitcenternumber).append("') ");
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
            while (rs1 != null && rs1.next()) {
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(rs1.getInt("lineNum"));
                rec.setFileUuId(rs1.getString("fileUuID"));
                rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
                int size = voucherField.length;
                for (int i = 0; i < size; ++i) {
                    DataToken value = new DataToken();
                    value.name = voucherField[i];
                    value.data = rs1.getString(voucherField[i]);
                    rec.put(voucherField[i], value);
                }
                String voucherNum = rs1.getString("FNum");
                int lineNum = rs1.getInt("lineNum");
                int rowNum = RecordUtils.getRowNum((int)(lineNum + 4));
                for (PcWSVoucherInfo pcWSVoucherInfo : cols) {
                    if (StringUtils.isEmpty((String)voucherNum) || StringUtils.isEmpty((String)pcWSVoucherInfo.getVoucherNumber()) || !voucherNum.equals(pcWSVoucherInfo.getVoucherNumber())) continue;
                    rec.setMsg((String)pcWSVoucherInfo.get("voucherabstract"));
                }
                result.add((IRecord)rec);
            }
        }
        return result;
    }

    private SuccessInfo getVoucherSuccessfulCount(Context ctx, Set sucSet, String fileUuId, int sheetId, Set set) throws BOSException, SQLException {
        int sucCount = 0;
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        if (sucSet.size() > 0) {
            sql.append("select count(1) count from ").append(tempTableName).append(" where fnum in (").append(this.convertSet2String(sucSet)).append(")").append(" and FProfitCenterID in (").append(this.convertSet2ProfitCenter(sucSet)).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.next()) {
                sucCount = rs.getInt("count");
            }
        }
        int count = 0;
        if (set.size() > 0) {
            sql = new StringBuffer();
            sql.append("select count(1) count from t_pca_pcvoucher pv ");
            sql.append(" inner join t_pca_pcvoucherentry pve on pve.fbillid = pv.fid ");
            sql.append(" where pv.fdescription in (");
            sql.append("  select FSerialNO from ").append(tempTableName).append(" where fnum in (").append(this.convertSet2String(set)).append("))");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows != null && rows.next()) {
                count = rows.getInt("count");
            }
        }
        SuccessInfo result = new SuccessInfo(fileUuId, sheetId, sucCount + count);
        return result;
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        if (ctx.get((Object)tempTableKey) == null) {
            try {
                this.cteateTempTable(ctx, tempTableKey);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        try {
            for (SimpleRecord record : coll) {
                this.insertDataIntoTempTable(ctx, record, tempTableName);
            }
        }
        catch (ParseException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return null;
    }

    private void cteateTempTable(Context ctx, String tempTableKey) throws Exception {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table pca_pcvoucher (").append("FProfitCenterID nvarchar(80),").append("FCompanyID nvarchar(80),").append("FDate DateTime,").append("FTransDate DateTime,").append("FPeriod int,").append("FGroup nvarchar(80),").append("FNum nvarchar(80),").append("FEntryID int,").append("FExp nvarchar(256),").append("FAcctID varchar(80),").append("FCyID varchar(80),").append("FExchRate decimal(19,9),").append("FDC int,").append("FFcyAmt decimal(19,4),").append("FQty decimal(19,4),").append("FAssistQty decimal(19,4),").append("FPrice decimal(19,4),").append("FDebit decimal(19,4),").append("FCredit decimal(19,4),").append("FPrepare nvarchar(80),").append("FAttchment int,").append("FSerialNO nvarchar(80),").append("FUnitName nvarchar(80),").append("FAssistUnit nvarchar(80),").append("FReference nvarchar(80),").append("FHasCashFlow int,").append("FCashFlow nvarchar(80),").append("FTransID nvarchar(80),").append("FSettlCode nvarchar(80),").append("FSettleNO nvarchar(80),").append("FClsName1 nvarchar(80),").append("FObjID1 nvarchar(80),").append("FObjName1 nvarchar(80),").append("FClsName2 nvarchar(80),").append("FObjID2 nvarchar(80),").append("FObjName2 nvarchar(80),").append("FClsName3 nvarchar(80),").append("FObjID3 nvarchar(80),").append("FObjName3 nvarchar(80),").append("FClsName4 nvarchar(80),").append("FObjID4 nvarchar(80),").append("FObjName4 nvarchar(80),").append("FClsName5 nvarchar(80),").append("FObjID5 nvarchar(80),").append("FObjName5 nvarchar(80),").append("FClsName6 nvarchar(80),").append("FObjID6 nvarchar(80),").append("FObjName6 nvarchar(80),").append("FClsName7 nvarchar(80),").append("FObjID7 nvarchar(80),").append("FObjName7 nvarchar(80),").append("FClsName8 nvarchar(80),").append("FObjID8 nvarchar(80),").append("FObjName8 nvarchar(80),").append("FInvNum nvarchar(80),").append("FTicketNum nvarchar(80),").append("FCustomer nvarchar(80),").append("FFeeType nvarchar(80),").append("FHandler nvarchar(80),").append("FMaterial nvarchar(80),").append("FOrgUnit nvarchar(80),").append("FSupplier nvarchar(80),").append("FBizDate DateTime,").append("FEndDate DateTime,").append("lineNum int,").append("fileUuID nvarchar(80))");
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        ctx.put((Object)tempTableKey, (Object)tempTableName);
    }

    /*
     * Unable to fully structure code
     */
    private void insertDataIntoTempTable(Context ctx, SimpleRecord data, String tempTableName) throws ParseException, BOSException {
        insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTableName);
        insertSql.append("(FProfitCenterID,FCompanyID, FDate, FTransDate, FPeriod, FGroup, FNum, FEntryID, FExp, ").append("FAcctID, FCyID, FExchRate, FDC, FFcyAmt, FQty, FAssistQty, FPrice, FDebit, ").append("FCredit, FPrepare, FAttchment, FSerialNO, FUnitName, FAssistUnit, FReference, ").append("FHasCashFlow, FCashFlow, FTransID, FSettlCode, FSettleNO, FClsName1, FObjID1, ").append("FObjName1, FClsName2, FObjID2, FObjName2, FClsName3, FObjId3, FObjName3, ").append("FClsName4, FObjID4, FObjName4, FClsName5, FObjID5, FObjName5, FClsName6, ").append("FObjID6, FObjName6, FClsName7, FObjID7, FObjName7, FClsName8, FObjID8, ").append("FObjName8, FInvNum, FTicketNum, FCustomer, FFeeType, FHandler, FMaterial, ").append("FOrgUnit, FSupplier, FBizDate, FEndDate, lineNum, fileUuID) ").append("values(?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ").append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ").append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        insertValue = new Object[66];
        insertValue[0] = this.getValue(data, "FProfitCenterID");
        insertValue[1] = this.getValue(data, "FCompanyID");
        fDate = this.getValue(data, "FDate");
        if (!StringUtils.isEmpty((String)fDate)) {
            try {
                utilDate = PcVoucherDataImport.dateTime_Formater.parse(fDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[2] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl26
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"BOOKDATE_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[2] = null;
        }
lbl26:
        // 3 sources

        fTransDate = this.getValue(data, "FTransDate");
        if (!StringUtils.isEmpty((String)fTransDate)) {
            try {
                utilDate = PcVoucherDataImport.dateTime_Formater.parse(fTransDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[3] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl43
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"BIZDATE_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[3] = null;
        }
lbl43:
        // 3 sources

        fPeriod = this.getValue(data, "FPeriod");
        if (!StringUtils.isEmpty((String)fPeriod)) {
            try {
                insertValue[4] = Integer.parseInt(fPeriod);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl58
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"PERIOD_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[4] = null;
        }
lbl58:
        // 3 sources

        insertValue[5] = this.getValue(data, "FGroup");
        insertValue[6] = this.getValue(data, "FNum");
        fEntryID = this.getValue(data, "FEntryID");
        if (!StringUtils.isEmpty((String)fEntryID)) {
            try {
                insertValue[7] = Integer.parseInt(fEntryID);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl75
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"SEQ_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[7] = null;
        }
lbl75:
        // 3 sources

        insertValue[8] = this.getValue(data, "FExp");
        insertValue[9] = this.getValue(data, "FAcctID");
        insertValue[10] = this.getValue(data, "FCyID");
        fExchRate = this.getValue(data, "FExchRate");
        insertValue[11] = StringUtils.isEmpty((String)fExchRate) == false ? new BigDecimal(fExchRate) : null;
        fDC = this.getValue(data, "FDC");
        if (!StringUtils.isEmpty((String)fDC)) {
            try {
                insertValue[12] = Integer.parseInt(fDC);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl95
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"DC_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[12] = null;
        }
lbl95:
        // 3 sources

        fFcyAmt = this.getValue(data, "FFcyAmt");
        insertValue[13] = StringUtils.isEmpty((String)fFcyAmt) == false ? new BigDecimal(fFcyAmt) : null;
        fQty = this.getValue(data, "FQty");
        insertValue[14] = StringUtils.isEmpty((String)fQty) == false ? new BigDecimal(fQty) : null;
        fAssistQty = this.getValue(data, "FAssistQty");
        insertValue[15] = StringUtils.isEmpty((String)fAssistQty) == false ? new BigDecimal(fAssistQty) : null;
        fPrice = this.getValue(data, "FPrice");
        insertValue[16] = StringUtils.isEmpty((String)fPrice) == false ? new BigDecimal(fPrice) : null;
        fDebit = this.getValue(data, "FDebit");
        insertValue[17] = StringUtils.isEmpty((String)fDebit) == false ? new BigDecimal(fDebit) : null;
        fCredit = this.getValue(data, "FCredit");
        insertValue[18] = StringUtils.isEmpty((String)fCredit) == false ? new BigDecimal(fCredit) : null;
        insertValue[19] = this.getValue(data, "FPrepare");
        fAttchment = this.getValue(data, "FAttchment");
        if (!StringUtils.isEmpty((String)fAttchment)) {
            try {
                insertValue[20] = Integer.parseInt(fAttchment);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl123
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"ATTEMENT_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[20] = null;
        }
lbl123:
        // 3 sources

        insertValue[21] = this.getValue(data, "FSerialNO");
        insertValue[22] = this.getValue(data, "FUnitName");
        insertValue[23] = this.getValue(data, "FAssistUnit");
        fReference = this.getFReference(data);
        insertValue[24] = fReference;
        fHasCashFlow = this.getValue(data, "FHasCashFlow");
        insertValue[25] = StringUtils.isEmpty((String)fHasCashFlow) == false ? Integer.valueOf(Integer.parseInt(fHasCashFlow)) : null;
        insertValue[26] = this.getValue(data, "FCashFlow");
        insertValue[27] = this.getValue(data, "FTransID");
        insertValue[28] = this.getValue(data, "FSettlCode");
        insertValue[29] = this.getValue(data, "FSettleNO");
        insertValue[30] = this.getValue(data, "FClsName1");
        insertValue[31] = this.getValue(data, "FObjID1");
        insertValue[32] = this.getValue(data, "FObjName1");
        insertValue[33] = this.getValue(data, "FClsName2");
        insertValue[34] = this.getValue(data, "FObjID2");
        insertValue[35] = this.getValue(data, "FObjName2");
        insertValue[36] = this.getValue(data, "FClsName3");
        insertValue[37] = this.getValue(data, "FObjID3");
        insertValue[38] = this.getValue(data, "FObjName3");
        insertValue[39] = this.getValue(data, "FClsName4");
        insertValue[40] = this.getValue(data, "FObjID4");
        insertValue[41] = this.getValue(data, "FObjName4");
        insertValue[42] = this.getValue(data, "FClsName5");
        insertValue[43] = this.getValue(data, "FObjID5");
        insertValue[44] = this.getValue(data, "FObjName5");
        insertValue[45] = this.getValue(data, "FClsName6");
        insertValue[46] = this.getValue(data, "FObjID6");
        insertValue[47] = this.getValue(data, "FObjName6");
        insertValue[48] = this.getValue(data, "FClsName7");
        insertValue[49] = this.getValue(data, "FObjID7");
        insertValue[50] = this.getValue(data, "FObjName7");
        insertValue[51] = this.getValue(data, "FClsName8");
        insertValue[52] = this.getValue(data, "FObjID8");
        insertValue[53] = this.getValue(data, "FObjName8");
        insertValue[54] = this.getValue(data, "FInvNum");
        insertValue[55] = this.getValue(data, "FTicketNum");
        insertValue[56] = this.getValue(data, "FCustomer");
        insertValue[57] = this.getValue(data, "FFeeType");
        insertValue[58] = this.getValue(data, "FHandler");
        insertValue[59] = this.getValue(data, "FMaterial");
        insertValue[60] = this.getValue(data, "FOrgUnit");
        insertValue[61] = this.getValue(data, "FSupplier");
        fBizDate = this.getValue(data, "FBizDate");
        if (!StringUtils.isEmpty((String)fBizDate)) {
            try {
                utilDate = PcVoucherDataImport.dateTime_Formater.parse(fBizDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[62] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl183
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"ASST_BIZDATE_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[62] = null;
        }
lbl183:
        // 3 sources

        fEndDate = this.getValue(data, "FEndDate");
        if (!StringUtils.isEmpty((String)fEndDate)) {
            try {
                utilDate = PcVoucherDataImport.dateTime_Formater.parse(fEndDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[63] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl200
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"ASST_ENDDATE_ERROR", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[63] = null;
        }
lbl200:
        // 3 sources

        insertValue[64] = data.getRowNum();
        insertValue[65] = data.getFileUuId();
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])insertValue);
    }

    private String getFReference(SimpleRecord data) {
        String fReference = this.getValue(data, "FReference");
        if (null == fReference || "".equals(fReference)) {
            return this.getValue(data, "FSerialNO");
        }
        return fReference;
    }

    protected String getValue(SimpleRecord data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = data.get((String)fieldName).data;
        return obj == null ? null : obj.toString().trim();
    }
}

