/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.dataImp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AutoTransException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.pca.AmortizeStandDataCollection;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeStandDataFactory;
import com.kingdee.eas.ma.pca.AmortizeStandDataInfo;
import com.kingdee.eas.ma.pca.AmortizeStandDataTypeEnum;
import com.kingdee.eas.ma.pca.AmortizeStandFactory;
import com.kingdee.eas.ma.pca.AmortizeStandInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class PcaAmortizeStandDataImport
extends AbstractDataTransmission {
    private static final String RES_PATH = "com.kingdee.eas.fi.gl.AutoTransResource";
    private static final int PER_PRECISION = 4;
    private static final int STR_LENGTH = 80;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final BigDecimal HUNDRED = new BigDecimal("100.00");
    private CompanyOrgUnitInfo company;
    private ProfitCenterOrgUnitInfo profitCenter;
    private String companyNumber = null;
    private AmortizeStandDataCollection amortizeStandDataColl = null;
    private String profitCenterNumber = null;
    private String amortizeStandDataId = null;

    private String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)name, (Locale)ctx.getOriginLocale());
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AmortizeStandDataInfo dataInfo = new AmortizeStandDataInfo();
        this.company = new CompanyOrgUnitInfo();
        this.profitCenter = new ProfitCenterOrgUnitInfo();
        Hashtable firstData = (Hashtable)hsData.get(new Integer(0));
        this.companyNumber = this.getString(firstData, "company.number");
        if (this.companyNumber == null || this.companyNumber.trim().length() == 0) {
            throw new TaskExternalException(this.getResource(ctx, "companyIsNull"));
        }
        try {
            this.company = (CompanyOrgUnitInfo)this.getOrgUnitInfo(ctx, "company", this.companyNumber);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        dataInfo.setCompany(this.company);
        String periodNumber = this.getString(firstData, "period.number");
        String periodTypeId = this.company.getAccountPeriodType().getId().toString();
        PeriodInfo period = null;
        if (periodNumber != null && periodNumber.trim().length() != 0) {
            try {
                period = this.getPeriodIdByPeriodNumber(ctx, this.company.getId().toString(), periodNumber, periodTypeId);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new TaskExternalException(this.getResource(ctx, "periodIsNull"));
        }
        dataInfo.setPeriod(period);
        int currentPeriod = 0;
        try {
            currentPeriod = GlUtils.getCurrentPeriod((Context)ctx, (String)this.company.getId().toString()).getNumber();
        }
        catch (EASBizException e2) {
            throw new TaskExternalException(e2.getMessage());
        }
        catch (BOSException e2) {
            throw new TaskExternalException(e2.getMessage());
        }
        if (currentPeriod != 0 && currentPeriod > period.getNumber()) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)"canNotModify", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{currentPeriod, periodNumber}));
        }
        String dataTypeStr = this.getString(firstData, "dataType");
        AmortizeStandDataTypeEnum dataType = null;
        if (dataTypeStr == null || dataTypeStr.trim().length() == 0) {
            throw new TaskExternalException(this.getResource(ctx, "classificationStandardIsNull"));
        }
        if (dataTypeStr.equals("1")) {
            dataType = AmortizeStandDataTypeEnum.ProfitCenterToProfitCenter;
        } else if (dataTypeStr.equals("2")) {
            dataType = AmortizeStandDataTypeEnum.CompanyToCompany;
        } else {
            throw new TaskExternalException(this.getResource(ctx, "classificationStandardNotExist"));
        }
        dataInfo.setDataType(dataType);
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            if (!this.isSltImportUpdate()) {
                if (!permission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(this.company.getId().toString()), "pca_AmortizeStandData_addnew")) {
                    throw new TaskExternalException(this.getResource(ctx, "noClassificationStandardAddPre"));
                }
            } else if (!permission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(this.company.getId().toString()), "pca_AmortizeStandData_update")) {
                throw new TaskExternalException(this.getResource(ctx, "noClassificationStandardModifyPre"));
            }
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.amortizeStandDataId = this.checkPeriodAndCompanyAndDataType(ctx, period.getId().toString(), this.company.getId().toString(), dataType.getValue());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (!this.isSltImportUpdate() && this.amortizeStandDataId != null) {
            throw new TaskExternalException(this.getResource(ctx, "classificationStandardIsExist"));
        }
        if (this.isSltImportUpdate() && this.amortizeStandDataId != null) {
            try {
                AmortizeStandDataFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(this.amortizeStandDataId));
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable data = (Hashtable)hsData.get(new Integer(i));
            int entrySeq = i + 1;
            String tmpValue = this.getString(data, "entry.seq");
            AmortizeStandDataEntryCollection dataEntry = dataInfo.getEntries();
            AmortizeStandDataEntryInfo entryInfo = null;
            if (entryInfo != null) continue;
            entryInfo = new AmortizeStandDataEntryInfo();
            entryInfo.setSeq(entrySeq);
            dataEntry.add(entryInfo);
            entryInfo.setBill(dataInfo);
            String amortizeStandStr = this.getString(data, "amortizeStand.name");
            AmortizeStandInfo amortizeStand = null;
            if (amortizeStandStr != null && amortizeStandStr.trim().length() != 0) {
                try {
                    amortizeStand = this.getAmortizeStandByName(ctx, amortizeStandStr);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(this.getResource(ctx, "classificationStandard"));
            }
            entryInfo.setAmortizeStand(amortizeStand);
            String orgNumber = this.getString(data, "orgUnit.number");
            if (orgNumber != null && orgNumber.trim().length() != 0) {
                if (dataTypeStr.equals("1")) {
                    try {
                        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)this.getOrgUnitInfo(ctx, "profitCenter", orgNumber);
                        entryInfo.setProfitCenter(profitCenter);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        CompanyOrgUnitInfo company1 = (CompanyOrgUnitInfo)this.getOrgUnitInfo(ctx, "company", orgNumber);
                        entryInfo.setCompany(company1);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                throw new TaskExternalException(this.getResource(ctx, "profitCenterIsNull"));
            }
            String measureUnit = this.getString(data, "measureUnit.number");
            MeasureUnitInfo measureUnitInfo = null;
            if (measureUnit == null || measureUnit.trim().length() == 0) {
                throw new TaskExternalException(this.getResource(ctx, "measureUnitIsNull"));
            }
            try {
                measureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(amortizeStand.getMeasureUnit().getId().toString()));
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (!measureUnit.equals(measureUnitInfo.getNumber())) {
                throw new TaskExternalException(this.getResource(ctx, "measureUnitError"));
            }
            String workloadStr = this.getString(data, "entries.workload");
            if (workloadStr == null || workloadStr.trim().length() == 0) {
                throw new TaskExternalException(this.getResource(ctx, "workLoadIsNull"));
            }
            if (workloadStr.indexOf(".") > 0) {
                int inputDataPrecision = workloadStr.length() - workloadStr.indexOf(".") - 1;
                if (measureUnitInfo.getQtyPrecision() < inputDataPrecision) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)"precisionError", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{measureUnitInfo.getQtyPrecision()}));
                }
            }
            BigDecimal workLoad = new BigDecimal(workloadStr);
            int precision = measureUnitInfo.getQtyPrecision();
            entryInfo.setWorkload(workLoad.setScale(precision));
        }
        return dataInfo;
    }

    public PeriodInfo getPeriodIdByPeriodNumber(Context ctx, String companyId, String periodNumber, String periodTypeId) throws BOSException, EASBizException, TaskExternalException {
        String periodId = null;
        PeriodInfo period = null;
        if (periodNumber != null) {
            String idSql = "select FID from T_BD_PERIOD where FTypeId = '" + periodTypeId + "' and fnumber = '" + periodNumber + "' ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)idSql);
            try {
                if (rs.next()) {
                    periodId = rs.getString("FID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (periodId == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)"periodError", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{periodNumber}));
        }
        period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        return period;
    }

    public AmortizeStandInfo getAmortizeStandByName(Context ctx, String name) throws BOSException, EASBizException, TaskExternalException {
        if (name == null || name.trim().length() == 0) {
            throw new TaskExternalException(this.getResource(ctx, "classificationStandardNameIsNull"));
        }
        AmortizeStandInfo amortizeStandInfo = null;
        String id = null;
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fid FROM T_PCA_AmortizeStand where FName_").append(ctx.getLocale()).append("=? ");
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            psStmt = cn.prepareStatement(sql.toString());
            psStmt.setString(1, name);
            rs = psStmt.executeQuery();
            if (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        if (id == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)"classificationStandardNameError", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{name}));
        }
        amortizeStandInfo = AmortizeStandFactory.getLocalInstance(ctx).getAmortizeStandInfo((IObjectPK)new ObjectUuidPK(id));
        return amortizeStandInfo;
    }

    public String checkPeriodAndCompanyAndDataType(Context ctx, String periodId, String companyId, String dataType) throws BOSException, EASBizException, TaskExternalException {
        FilterInfo filter = new FilterInfo();
        String fid = null;
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("dataType", (Object)dataType));
        boolean exists = AmortizeStandDataFactory.getLocalInstance(ctx).exists(filter);
        if (exists) {
            StringBuffer buf = new StringBuffer();
            buf.append("select fid from T_PCA_AmortizeStandData where fcompanyid = '").append(companyId).append("'");
            buf.append(" and fperiodid = '").append(periodId).append("'");
            buf.append(" and FDataType = '").append(dataType).append("'");
            ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
            IRowSet rs = dataAccess.getRowSet(buf.toString());
            try {
                if (rs.next()) {
                    fid = rs.getString("fid");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!this.isSltImportUpdate()) {
            // empty if block
        }
        return fid;
    }

    public OrgUnitInfo getOrgUnitInfo(Context ctx, String orgType, String number) throws BOSException, EASBizException {
        Object orgUnit = null;
        CompanyOrgUnitCollection companyCollection = null;
        ProfitCenterOrgUnitCollection profitCenterCollection = null;
        Object orgCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filterInfo);
        if (orgType.equals("company")) {
            companyCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            if (companyCollection == null || companyCollection.size() == 0) {
                throw new AutoTransException(AutoTransException.NUMBER_NOTIN_COMPANY, (Object[])new String[]{number});
            }
            return companyCollection.get(0);
        }
        profitCenterCollection = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitCollection(view);
        if (profitCenterCollection == null || profitCenterCollection.size() == 0) {
            throw new AutoTransException(AutoTransException.NUMBER_NOTIN_COMPANY, (Object[])new String[]{number});
        }
        return profitCenterCollection.get(0);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            String[] field = new String[]{"company.number", "period.number", "dataType", "amortizeStand.name", "orgUnit.number", "measureUnit.number", "entries.workload"};
            Hashtable<String, String> result = new Hashtable<String, String>();
            String companyNumber = rs.getString("company.number");
            result.put("company.number", companyNumber);
            String periodNumber = rs.getString("period.number");
            result.put("period.number", periodNumber);
            String dataType = rs.getString("dataType");
            result.put("dataType", dataType);
            String amortizeStandName = rs.getString("amortizeStand.name");
            result.put("amortizeStand.name", amortizeStandName);
            String profitCenterNumber = rs.getString("profitCenter.number");
            String company2Number = rs.getString("company2.number");
            result.put("orgUnit.number", profitCenterNumber == null ? company2Number : profitCenterNumber);
            String measureUnitNumber = rs.getString("measureUnit.number");
            result.put("measureUnit.number", measureUnitNumber);
            BigDecimal workload = rs.getBigDecimal("entries.workload");
            int precision = rs.getInt("measureUnit.qtyPrecision");
            result.put("entries.workload", workload == null ? "" : workload.setScale(precision).toString());
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        String selectedIds = paramMap.get("id").toString();
        if (selectedIds != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)selectedIds, CompareType.INCLUDE));
        } else {
            String companyId = paramMap.get("companyId").toString();
            String periodNumber = paramMap.get("periodNumber").toString();
            String periodTypeId = paramMap.get("periodTypeId").toString();
            String dataType = paramMap.get("dataType").toString();
            String id = "";
            String periodId = null;
            if (periodNumber != null) {
                String idSql = "select FID from T_BD_PERIOD where FTypeId = '" + periodTypeId + "' and fnumber = '" + periodNumber + "' ";
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)idSql);
                    if (rs.next()) {
                        periodId = rs.getString("FID");
                    }
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("period", periodId, CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("dataType", (Object)dataType));
            boolean exists = false;
            try {
                exists = AmortizeStandDataFactory.getLocalInstance(ctx).exists(filter1);
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            if (exists) {
                AmortizeStandDataInfo amortizeData = new AmortizeStandDataInfo();
                AmortizeStandDataEntryCollection amortizeDataEntrys = new AmortizeStandDataEntryCollection();
                StringBuffer buf = new StringBuffer();
                buf.append("select fid from T_PCA_AmortizeStandData where fcompanyid = '").append(companyId).append("'");
                buf.append(" and fperiodid = '").append(periodId).append("'");
                buf.append(" and FDataType = '").append(dataType).append("'");
                try {
                    ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
                    IRowSet rs = dataAccess.getRowSet(buf.toString());
                    if (rs.next()) {
                        id = rs.getString("fid");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.INCLUDE));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.ma.pca.app.PcaAmortizeStandDataExportQuery";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AmortizeStandDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currenctData) {
        String companyNumber = this.getString(currenctData, "company.number");
        String periodNumber = this.getString(currenctData, "period.number");
        String dataType = this.getString(currenctData, "dataType");
        if (companyNumber == null || companyNumber.trim().length() == 0 || periodNumber == null || periodNumber.trim().length() == 0 || dataType == null || dataType.trim().length() == 0) {
            return true;
        }
        return companyNumber.equals(this.getString(firstData, "company.number")) && periodNumber.equals(this.getString(firstData, "period.number")) && dataType.equals(this.getString(firstData, "dataType"));
    }

    private String getString(Hashtable values, String key) {
        Object value = values.get(key);
        if (value == null) {
            return null;
        }
        Object obj = ((DataToken)value).data;
        return obj == null ? null : obj.toString();
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (this.isSltImportUpdate() && this.amortizeStandDataId != null && this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(this.amortizeStandDataId))) {
                this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(this.amortizeStandDataId));
            }
            this.getController(ctx).submit(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }
}

