/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucherServiceFacade;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.app.voucher.ITransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.TransactVoucherColParameter;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherServiceFacadeFactory;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractTransactPcVoucherColService
implements ITransactVoucherColService {
    private static final int VOUCHER_NUM = 200;
    protected static final Logger log = Logger.getLogger(AbstractTransactPcVoucherColService.class);
    private IPcVoucher iVoucher = null;
    protected Set noPermIdSet = new LinkedHashSet();

    public void transactVoucherCol(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        Map result = this.transactVouchers(parameterObject);
        if (result.size() == 0) {
            return;
        }
        StringBuffer errMsg = new StringBuffer();
        for (Object id : parameterObject.getPkList()) {
            String error = (String)result.get(id.toString());
            if (error == null) continue;
            if (errMsg.length() > 0) {
                errMsg.append("\r\n");
            }
            errMsg.append(error);
        }
        if (errMsg.length() > 0) {
            throw this.getVoucherException(errMsg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map transactVouchers(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (parameterObject.getPkList() == null || parameterObject.getPkList().size() == 0) {
            return result;
        }
        LinkedHashSet[] IdSets = this.splitIdList2Idstr(parameterObject.getPkList(), 200);
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        PcVoucherProcessCache.initCache(parameterObject.getCtx(), cacheId);
        TransactVoucherColParameter tmpParaObj = null;
        try {
            for (int i = 0; i < IdSets.length; ++i) {
                tmpParaObj = new TransactVoucherColParameter();
                tmpParaObj.setCtx(parameterObject.getCtx());
                tmpParaObj.setIdSet((Set)IdSets[i]);
                tmpParaObj.setSys(parameterObject.getSys());
                tmpParaObj.setPreStatus(parameterObject.getPreStatus());
                tmpParaObj.setCheckViews(parameterObject.getCheckViews());
                Map iResult = this.batchVoucherCollection(tmpParaObj);
                result.putAll(iResult);
            }
        }
        finally {
            PcVoucherProcessCache.clearCache(parameterObject.getCtx(), cacheId);
        }
        if (this.noPermIdSet.size() > 0) {
            this.MergePermMsg(parameterObject.getCtx(), result);
        }
        return result;
    }

    protected abstract EntityViewInfo getEntityView(Set var1);

    protected VoucherException getVoucherException(String errMsg) {
        return new VoucherException(VoucherException.VOUCHER_FAIL, new Object[]{errMsg});
    }

    protected void machiningVoucherCollection(Context ctx, Set idSet, PcVoucherCollection voucherCollection) throws BOSException, EASBizException {
    }

    protected abstract void beforeTransactVoucherNewTrans(Context var1, PcVoucherInfo var2) throws BOSException, EASBizException;

    protected abstract void transactVoucherNewTrans(Context var1, TransactVoucherColParameter var2, PcVoucherInfo var3) throws BOSException, EASBizException;

    protected abstract String catchTransactException(Context var1, PcVoucherInfo var2, String var3, Exception var4);

    protected LinkedHashSet[] splitIdList2Idstr(List voucherIDList, int batchSize) {
        if (voucherIDList == null || voucherIDList.size() == 0) {
            return null;
        }
        LinkedHashSet idLinkedSet = new LinkedHashSet(voucherIDList);
        LinkedHashSet[] idSets = new LinkedHashSet[idLinkedSet.size() / batchSize + (idLinkedSet.size() % batchSize > 0 ? 1 : 0)];
        LinkedHashSet idSet = null;
        int num = 0;
        int index = 0;
        Iterator it = idLinkedSet.iterator();
        while (it.hasNext()) {
            if (index == num * batchSize) {
                idSet = new LinkedHashSet();
                idSets[num++] = idSet;
            }
            idSet.add(it.next());
            ++index;
        }
        return idSets;
    }

    protected Map batchVoucherCollection(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (parameterObject.getCtx() == null || parameterObject.getIdSet() == null) {
            return result;
        }
        Context ctx = parameterObject.getCtx();
        IPcVoucher iVoucher = this.getVoucherService(ctx);
        PcVoucherCollection allVoucherColl = iVoucher.getPcVoucherCollection(this.getEntityView(parameterObject.getIdSet()));
        PcVoucherCollection hasPermissionVoucherColl = this.getHasPermissionVoucherCollection(ctx, allVoucherColl);
        this.machiningVoucherCollection(ctx, parameterObject.getIdSet(), hasPermissionVoucherColl);
        PcVoucherInfo voucherInfo = null;
        Iterator idIter = parameterObject.getIdSet().iterator();
        while (idIter.hasNext()) {
            String voucherid = idIter.next().toString();
            voucherInfo = hasPermissionVoucherColl.get((Object)BOSUuid.read((String)voucherid));
            String oldNumber = "";
            try {
                if (voucherInfo == null) {
                    voucherInfo = allVoucherColl.get((Object)BOSUuid.read((String)voucherid));
                    if (!iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherid))) continue;
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getPermItemName());
                    Object[] object = new Object[]{voucherInfo.getProfitCenter().getName(), permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, object);
                    throw pe;
                }
                oldNumber = voucherInfo.getNumber();
                this.beforeTransactVoucherNewTrans(ctx, voucherInfo);
                this.checkPermission(ctx, voucherInfo);
                this.disablePermission();
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                this.transactVoucherNewTrans(ctx, parameterObject, voucherInfo);
            }
            catch (Exception e) {
                log.error((Object)"ERROR", (Throwable)e);
                if (e instanceof PermissionException) {
                    result.put(voucherid, "{0} " + e.getMessage());
                    this.noPermIdSet.add(voucherid);
                    continue;
                }
                result.put(voucherid, this.catchTransactException(ctx, voucherInfo, oldNumber, e));
            }
        }
        return result;
    }

    protected PcVoucherCollection getHasPermissionVoucherCollection(Context ctx, PcVoucherCollection allVoucherColl) throws BOSException, EASBizException {
        PcVoucherCollection hasPermissionVoucherColl = new PcVoucherCollection();
        HashMap compamyMap = new HashMap();
        int size = allVoucherColl.size();
        for (int i = 0; i < size; ++i) {
            PcVoucherInfo vch = allVoucherColl.get(i);
            String companyID = vch.getProfitCenter().getId().toString();
            Set<String> idSet = null;
            if (compamyMap.get(companyID) == null) {
                idSet = new HashSet();
                compamyMap.put(companyID, idSet);
            } else {
                idSet = (Set)compamyMap.get(companyID);
            }
            idSet.add(vch.getId().toString());
        }
        Iterator companyIter = compamyMap.keySet().iterator();
        while (companyIter.hasNext()) {
            String companyID = companyIter.next().toString();
            Set idSet = (Set)compamyMap.get(companyID);
            hasPermissionVoucherColl.addCollection(this.queryHasDataPermVoucherCollection(ctx, this.getQueryPermissionSql(ctx, companyID), this.getVoucherService(ctx), this.getEntityView(idSet)));
        }
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null) {
            cache.setVoucherCollection(this.getEntityView(new HashSet()).getSelector(), hasPermissionVoucherColl);
        }
        return hasPermissionVoucherColl;
    }

    private String getQueryPermissionSql(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(companyID);
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, this.getPermItemName());
        if (StringUtils.isEmpty((String)rule)) {
            return null;
        }
        return PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, this.getPermItemName());
    }

    protected void checkPermission(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        String companyid = voucherInfo.getProfitCenter().getId().toString();
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache.getFunctionPermMap().get(companyid) == null) {
            cache.getFunctionPermMap().put(companyid, false);
            this.checkFunctionPermission(ctx, (IObjectPK)new ObjectUuidPK(companyid), this.getPermItemName());
            cache.getFunctionPermMap().put(companyid, true);
        } else {
            Boolean hasFunctionPermission = (Boolean)cache.getFunctionPermMap().get(companyid);
            if (!hasFunctionPermission.booleanValue()) {
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getPermItemName());
                Object[] object = new Object[]{voucherInfo.getProfitCenter().getName(), permItemInfo.getAlias()};
                PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, object);
                throw pe;
            }
        }
    }

    abstract String getPermItemName();

    protected PcVoucherCollection queryHasDataPermVoucherCollection(Context ctx, String queryPermissionSql, IPcVoucher ivoucher, EntityViewInfo view) throws BOSException, EASBizException {
        if (queryPermissionSql != null && queryPermissionSql.trim().length() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)queryPermissionSql, CompareType.INNER));
            filterInfo.mergeFilter(view.getFilter(), "and");
            view.setFilter(filterInfo);
        }
        PcVoucherCollection vchColl = ivoucher.getPcVoucherCollection(view);
        return vchColl;
    }

    public void disablePermission() throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_ENTRYS_SERVICE");
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
    }

    private void checkFunctionPermission(Context ctx, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        permission.checkFunctionPermission((IObjectPK)userPK, orgPK, permItemName);
    }

    protected IVoucherServiceFacade getVoucherServiceFacade(Context ctx) throws BOSException {
        return PcVoucherServiceFacadeFactory.getLocalInstance(ctx);
    }

    private PcVoucherCollection getNoPermVouchers(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        return this.getVoucherService(ctx).getPcVoucherCollection(view);
    }

    private void MergePermMsg(Context ctx, Map result) throws EASBizException, BOSException {
        PcVoucherCollection vchCol = this.getNoPermVouchers(ctx, this.noPermIdSet);
        if (vchCol.size() < 1) {
            return;
        }
        ArrayList args = new ArrayList();
        Iterator it = this.noPermIdSet.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            PcVoucherInfo voucher = vchCol.get((Object)BOSUuid.read((String)id));
            String errMsg = (String)result.get(id);
            if (voucher == null || errMsg == null) continue;
            errMsg = new MessageFormat(errMsg).format(new String[]{voucher.getVoucherType().getName() + " " + voucher.getNumber()});
            result.put(id, errMsg);
        }
    }

    protected IPcVoucher getVoucherService(Context ctx) throws BOSException {
        if (this.iVoucher == null) {
            this.iVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        }
        return this.iVoucher;
    }
}

