/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.AbstractAntiCancelBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherPostProcessorInvokeFactory;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.PcaVoucherNumberOperator;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.ma.pca.validator.PcVoucherBaseAntiCancelValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidatorFactory;
import java.util.Map;

public class AntiCancelStandardPcVoucherService
extends AbstractAntiCancelBaseVoucherService {
    private PcVoucherValidator validator = null;

    public AntiCancelStandardPcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (PcVoucherInfo)voucherInfo, voucherInfo.getBizStatus());
    }

    protected void handleVoucherSubmitNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setNumber(PcaVoucherNumberOperator.build((Context)ctx).getNextValidNumber(voucherInfo, VoucherStatusEnum.SUBMITTED, false));
    }

    protected void initVoucherValidator(Context ctx) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam);
        if (this.validator == null) {
            this.validator = new PcVoucherValidator();
        }
        PcVoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        PcVoucherValidatorFactory.getVoucherValidator(ctx, ((Object)((Object)this)).getClass().getName(), this.validator);
    }

    protected void validatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.validator != null) {
            this.validator.validate(ctx, (BaseVoucherInfo)((PcVoucherInfo)voucherInfo));
        }
    }

    protected PcVoucherValidator getAdditionalValidator() throws BOSException {
        return null;
    }

    private PcVoucherValidator getValidator(GlParam sysParam) throws BOSException {
        PcVoucherValidator validator = new PcVoucherValidator();
        validator.addVoucherBaseValidator(new PcVoucherBaseAntiCancelValidator(sysParam));
        return validator;
    }

    protected void afterAntiCancel(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.invokeVoucherAntiCancelPostProcessor(ctx, voucherInfo);
    }

    private void invokeVoucherAntiCancelPostProcessor(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherPostProcessorInvokeFactory.invokeVoucherAntiCancelPostProcessor(ctx, (PcVoucherInfo)voucherInfo);
    }

    protected void requestBudgetSubstract(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, int action) throws BgCtrlException, EASBizException, BOSException {
        PcVoucherUtil.requestBudgetSubstract(ctx, (PcVoucherInfo)voucherInfo, sysParam, action);
    }

    protected void intoVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        PcaBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 6, false, false);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAntiCancelVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"GLG01", "GLG01_2", "GL_028", "GL_052", "GL_060", "GL_008", "GL_101"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "IAntiCancelVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"PCA_029", "PCA_032", "PCA_075"};
        PcaParam glParam = PcaParam.getPcaParams(ctx, paramList, profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo pcVoucherInfo = (PcVoucherInfo)voucherInfo;
        super.initGlParam(ctx, voucherInfo);
        PcaParam pcaParam = this.getPcaParam(ctx, pcVoucherInfo.getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected String getLogItemName() {
        return "pca_voucher_antiCancel";
    }
}

