/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.app.voucher.AuditBaseVoucherCollectionService;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class AuditPcVoucherCollectionService
extends AuditBaseVoucherCollectionService {
    private String cacheId;

    public AuditPcVoucherCollectionService(Context ctx) throws BOSException {
        super(ctx);
    }

    protected String getAuditPermissionItem() {
        return "pca_voucher090_audit";
    }

    protected void clearCache(Context ctx) {
        PcVoucherProcessCache.clearCache(ctx, this.cacheId);
    }

    protected void initCache(Context ctx) {
        this.cacheId = BOSUuid.create((String)"ABCD1234").toString();
        PcVoucherProcessCache.initCache(ctx, this.cacheId);
    }

    protected void auditVoucherCollection(Context ctx, LinkedHashSet idSet, BOSUuid auditorId) throws BOSException, EASBizException {
        IPcVoucher iVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        PcVoucherCollection allVoucherColl = iVoucher.getPcVoucherCollection(this.getEntityView(PcVoucherInfo.getAuditVoucherSelector(), idSet));
        PcVoucherCollection hasPermissionVoucherColl = this.getHasPermissionVoucherCollection(ctx, allVoucherColl);
        PcVoucherInfo voucherInfo = null;
        Iterator idIter = idSet.iterator();
        while (idIter.hasNext()) {
            String voucherid = idIter.next().toString();
            voucherInfo = hasPermissionVoucherColl.get((Object)BOSUuid.read((String)voucherid));
            String oldNumber = "";
            String oldVoucherType = "";
            try {
                if (voucherInfo == null) {
                    voucherInfo = allVoucherColl.get((Object)BOSUuid.read((String)voucherid));
                    if (!iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherid))) continue;
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getAuditPermissionItem());
                    Object[] object = new Object[]{voucherInfo.getCompany().getName(), permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_DATA_PERMISSION, object);
                    throw pe;
                }
                this.checkPermission(ctx, voucherInfo, this.getAuditPermissionItem());
                this.disablePermission();
                oldNumber = voucherInfo.getNumber();
                oldVoucherType = voucherInfo.getVoucherType() == null ? "" : (voucherInfo.getVoucherType().getName() == null ? "" : voucherInfo.getVoucherType().getName());
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                iVoucher.auditVoucherNewTrans((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), auditorId);
            }
            catch (Exception e) {
                String voucherStr;
                log.error((Object)"ERROR", (Throwable)e);
                if (e instanceof PermissionException) {
                    this.noPermErrors.put(voucherid, e.getMessage());
                    continue;
                }
                if (e instanceof MatchAssignmentException) {
                    voucherStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"MatchAssignmentException", (Locale)ctx.getLocale()), voucherInfo.getNumber());
                    this.commonErrors.put(voucherid, voucherStr);
                    continue;
                }
                voucherStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"voucher", (Locale)ctx.getLocale());
                String auditFailStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"AUDIT_FAIL", (Locale)ctx.getLocale());
                this.commonErrors.put(voucherid, voucherInfo.getProfitCenter().getName() + " " + voucherStr + oldVoucherType + oldNumber + auditFailStr + e.getMessage());
            }
        }
    }

    private PcVoucherCollection getHasPermissionVoucherCollection(Context ctx, PcVoucherCollection allVoucherColl) throws BOSException, EASBizException {
        IPcVoucher iVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        PcVoucherCollection hasPermissionVoucherColl = new PcVoucherCollection();
        HashMap compamyMap = new HashMap();
        int size = allVoucherColl.size();
        for (int i = 0; i < size; ++i) {
            PcVoucherInfo vch = allVoucherColl.get(i);
            String companyID = vch.getCompany().getId().toString();
            Set<String> idSet = null;
            if (compamyMap.get(companyID) == null) {
                idSet = new HashSet();
                compamyMap.put(companyID, idSet);
            } else {
                idSet = (Set)compamyMap.get(companyID);
            }
            idSet.add(vch.getId().toString());
        }
        Iterator companyIter = compamyMap.keySet().iterator();
        while (companyIter.hasNext()) {
            String companyID = companyIter.next().toString();
            Set idSet = (Set)compamyMap.get(companyID);
            hasPermissionVoucherColl.addCollection(this.queryHasDataPermVoucherCollection(ctx, this.getQueryPermissionSql(ctx, this.getAuditPermissionItem(), companyID), iVoucher, this.getEntityView(PcVoucherInfo.getAuditVoucherSelector(), idSet)));
        }
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null) {
            cache.setVoucherCollection(PcVoucherInfo.getAuditVoucherSelector(), hasPermissionVoucherColl);
        }
        return hasPermissionVoucherColl;
    }

    private PcVoucherCollection queryHasDataPermVoucherCollection(Context ctx, String queryPermissionSql, IPcVoucher ivoucher, EntityViewInfo view) throws BOSException, EASBizException {
        if (queryPermissionSql != null && queryPermissionSql.trim().length() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)queryPermissionSql, CompareType.INNER));
            filterInfo.mergeFilter(view.getFilter(), "and");
            view.setFilter(filterInfo);
        }
        PcVoucherCollection vchColl = ivoucher.getPcVoucherCollection(view);
        return vchColl;
    }

    private void checkPermission(Context ctx, PcVoucherInfo voucherInfo, String permItem) throws BOSException, EASBizException {
        String companyid = voucherInfo.getProfitCenter().getId().toString();
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache.getFunctionPermMap().get(companyid) == null) {
            cache.getFunctionPermMap().put(companyid, false);
            this.checkFunctionPermission(ctx, (IObjectPK)new ObjectUuidPK(companyid), permItem);
            cache.getFunctionPermMap().put(companyid, true);
        } else {
            Boolean hasFunctionPermission = (Boolean)cache.getFunctionPermMap().get(companyid);
            if (!hasFunctionPermission.booleanValue()) {
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permItem);
                Object[] object = new Object[]{voucherInfo.getProfitCenter().getName(), permItemInfo.getAlias()};
                PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, object);
                throw pe;
            }
        }
    }

    private PcVoucherCollection getNoPermVouchers(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        return PcVoucherFactory.getLocalInstance((Context)ctx).getPcVoucherCollection(view);
    }

    protected void processError(Context ctx, List voucherIdList) throws EASBizException, BOSException {
        if (this.commonErrors.size() <= 0 && this.noPermErrors.size() <= 0) {
            return;
        }
        PcVoucherCollection vchCol = null;
        if (this.noPermErrors.size() > 0) {
            vchCol = this.getNoPermVouchers(ctx, this.noPermErrors.keySet());
        }
        StringBuffer errMsg = new StringBuffer();
        for (Object pk : voucherIdList) {
            PcVoucherInfo voucher;
            String id = pk.toString();
            if (this.commonErrors.containsKey(id)) {
                errMsg.append("\r\n").append((String)this.commonErrors.get(id));
                continue;
            }
            if (!this.noPermErrors.containsKey(id) || vchCol == null || (voucher = vchCol.get((Object)BOSUuid.read((String)id))) == null) continue;
            errMsg.append("\r\n").append(voucher.getVoucherType().getName() + " " + voucher.getNumber()).append(" ").append((String)this.noPermErrors.get(id));
        }
        throw new VoucherException(VoucherException.AUDIT_FAILED, new Object[]{errMsg.toString()});
    }
}

