/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.AuditBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherBaseAuditValidator;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidator;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class AuditPcVoucherService
extends AuditBaseVoucherService {
    public AuditPcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    protected String getVoucherTable() {
        return "t_pca_pcvoucher";
    }

    protected void validate(Context ctx, BaseVoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException, EASBizException {
        PcVoucherValidator validator = this.getValidator(this.sysParam, auditorId.toString());
        if (validator != null) {
            validator.validate(ctx, (BaseVoucherInfo)((PcVoucherInfo)voucherInfo));
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    protected SelectorItemCollection getAuditSelector() {
        return PcVoucherInfo.getAuditVoucherSelector();
    }

    protected PcVoucherValidator getValidator(GlParam sysParam, String auditorId) throws BOSException {
        PcVoucherValidator validator = new PcVoucherValidator();
        validator.addVoucherBaseValidator(new PcVoucherBaseAuditValidator(sysParam, auditorId));
        return validator;
    }

    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return PcVoucherUtil.isExistVoucherCodingRule(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString(), (PcVoucherInfo)voucherInfo, VoucherStatusEnum.AUDITTED);
    }

    protected void afterAudit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, BgCtrlException, EASBizException {
        PcVoucherUtil.requestBudgetSubstract(ctx, (PcVoucherInfo)baseVoucherInfo, this.sysParam, 8);
    }

    protected void updateAuditStatus(Context ctx, BaseVoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException {
        PcVoucherOprateSharer.updateVoucherStatus(ctx, voucherInfo.getId().toString(), auditorId.toString(), VoucherStatusEnum.AUDITTED.getValue(), "FAuditorId");
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAuditVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramItems = new String[]{"G001", "GL_028", "GLG01", "GLG01_2", "GL_052", "G012", "GL_099"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramItems, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "IAuditVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramItems = new String[]{"PCA_029", "PCA_032", "PCA_047", "PCA_075", "PCA_0491"};
        PcaParam glParam = PcaParam.getPcaParams(ctx, paramItems, profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        super.initGlParam(ctx, voucherInfo);
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected void clearAuditBack(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean useWorkflow = false;
        boolean ishandAuditBack = sysParam.getBoolean("GL_099");
        if (!useWorkflow && ishandAuditBack && voucherInfo.getId().toString() != null) {
            DbUtil.execute((Context)ctx, (String)" update T_pca_PcVoucher set FIsAuditBack=0  where FID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
            DbUtil.execute((Context)ctx, (String)" delete from T_PCA_PcAuditOpinion  where FVoucherID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    protected String getLogItemName() {
        return "pca_voucher_audit";
    }
}

