/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.voucher.DeletePcVoucherService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DeleteAmortizationPcVoucherService
extends DeletePcVoucherService
implements IDeleteVoucherService {
    public DeleteAmortizationPcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    public void deleteVoucher(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        super.deleteVoucher(ctx, voucherInfo, isFromGL);
        this.deleteAmortLog(ctx, (PcVoucherInfo)voucherInfo);
    }

    public void deleteAmortLog(Context ctx, PcVoucherInfo voucherInfo) throws BOSException {
        String sqlAmortLog = "select vlog.FID,vlog.FAmortSchemeID,vlog.FPeriodID,vs.FAmortAmount,policy.famount FPolicyAmount  from t_gl_vchamortlog vlog inner join t_gl_vchamortscheme vs on vlog.famortschemeid=vs.fid  inner join t_gl_vchamortpolicy policy on policy.famortschemeid=vs.fid and policy.fperiodid=vlog.fperiodid  where vlog.FVoucherID=?";
        IRowSet rsAmortLog = DbUtil.executeQuery((Context)ctx, (String)sqlAmortLog, (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rsAmortLog.next()) {
                String amortSchemeId = rsAmortLog.getString("FAmortSchemeID");
                String periodId = rsAmortLog.getString("FPeriodID");
                String logId = rsAmortLog.getString("FID");
                BigDecimal amortAmount = rsAmortLog.getBigDecimal("FAmortAmount");
                BigDecimal policyAmount = rsAmortLog.getBigDecimal("FPolicyAmount");
                BigDecimal leftAmortAmount = amortAmount.subtract(policyAmount);
                String status = "1";
                if (leftAmortAmount.signum() != 0) {
                    status = "2";
                }
                String updateScheme = "update t_gl_vchamortscheme set famortamount=?,fstatus=? where fid=?";
                DbUtil.execute((Context)ctx, (String)updateScheme, (Object[])new Object[]{leftAmortAmount, new Integer(status), amortSchemeId});
                String updatePolicy = "update t_gl_vchamortpolicy set fisvouchered=0 where famortschemeid=? and fperiodid=?";
                DbUtil.execute((Context)ctx, (String)updatePolicy, (Object[])new Object[]{amortSchemeId, periodId});
                String delLog = "delete from t_gl_vchamortlog where fid=?";
                DbUtil.execute((Context)ctx, (String)delLog, (Object[])new Object[]{logId});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

