/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.DeleteBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherPostProcessorInvokeFactory;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.ma.pca.validator.PcVoucherBaseDeleteValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidatorFactory;
import java.util.Map;

public class DeletePcVoucherService
extends DeleteBaseVoucherService {
    private PcVoucherValidator validator = null;

    public DeletePcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected void validate(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        this.initVoucherValidator(ctx, voucherInfo, isFromGL);
        this.validateVoucher(ctx, voucherInfo);
    }

    protected void initVoucherValidator(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam, isFromGL);
        if (this.validator == null) {
            this.validator = new PcVoucherValidator();
        }
        PcVoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        PcVoucherValidatorFactory.getVoucherValidator(ctx, ((Object)((Object)this)).getClass().getName(), this.validator);
    }

    protected PcVoucherValidator getAdditionalValidator() throws BOSException {
        return null;
    }

    protected void beforeDelete(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException, GLException {
        if (voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            this.returnBudget(ctx, voucherInfo);
        }
    }

    protected void afterDelete(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException, GLException {
        this.deleteAdjustExchangeRateHistory(ctx, voucherInfo);
        this.deleteAutoTransVoucherRef(ctx, voucherInfo);
        this.deleteTransPLHistory(ctx, voucherInfo);
    }

    private PcVoucherValidator getValidator(GlParam sysParam, boolean isFromGL) throws BOSException {
        PcVoucherValidator validator = new PcVoucherValidator();
        validator.addVoucherBaseValidator(new PcVoucherBaseDeleteValidator(sysParam, isFromGL));
        return validator;
    }

    protected void validateVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.validator != null) {
            this.validator.validate(ctx, (BaseVoucherInfo)((PcVoucherInfo)voucherInfo));
        }
    }

    protected void recycleVoucherNumber(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        if (PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getProfitCenter().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
            this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
        } else {
            VoucherStatusEnum bizStatus = voucherInfo.getBizStatus();
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            if (PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getProfitCenter().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
                this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
            }
            voucherInfo.setBizStatus(bizStatus);
        }
    }

    protected String getLogItemName() {
        return "pca_voucher_remove";
    }

    protected void delete(Context ctx, BaseVoucherInfo baseVoucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherUtil._deleteAllAssistRecords(ctx, voucherInfo);
        PcVoucherUtil._deleteAllEntries(ctx, voucherInfo);
        PcVoucherUtil._deleteVoucher(ctx, voucherInfo);
    }

    protected void undoTransformFromVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        if (SourceType.NONE.equals((Object)voucherInfo.getSourceType()) || voucherInfo.getSourceBillId() != null) {
            IDAPTransformer iDAPTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            iDAPTransformer.undoTransformFromVoucher((BaseVoucherInfo)voucherInfo);
        }
    }

    protected void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (voucherInfo.getBizStatus().equals((Object)VoucherStatusEnum.SUBMITTED)) {
            this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 7, true, false);
        }
    }

    protected void invokeVoucherDeletePostProcessor(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherPostProcessorInvokeFactory.invokeVoucherDeletePostProcessor(ctx, voucherInfo);
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IDeleteVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"GL_009", "GLG01", "GL_028", "GL_052", "GLG02", "GL_060", "GL015", "GL_VOUCHERNUMBER_LOG"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        super.initGlParam(ctx, voucherInfo);
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "IDeleteVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        PcaParam glParam = PcaParam.getPcaParams(ctx, "PCA_019", profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }
}

