/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.DeletePcVoucherService;

public class DeleteReversePcVoucherService
extends DeletePcVoucherService
implements IDeleteVoucherService {
    public DeleteReversePcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    public void deleteVoucher(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        super.deleteVoucher(ctx, voucherInfo, isFromGL);
        this.clearReverseRelation(ctx, (PcVoucherInfo)voucherInfo);
    }

    private void clearReverseRelation(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        BOTRelationCollection relationCol;
        ObjectUuidPK pk = new ObjectUuidPK(voucherInfo.getId().toString());
        String srcVchId = voucherInfo.getSourceBillId();
        if (srcVchId != null) {
            this.removeRelation(ctx, srcVchId, (IObjectPK)pk);
        }
        if ((relationCol = PcVoucherUtil._getBotRelation(ctx, pk.toString(), voucherInfo.getBOSType())) != null) {
            int n = relationCol.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = relationCol.get(i);
                this.removeRelation(ctx, bot.getSrcObjectID(), (IObjectPK)pk);
            }
        }
    }

    private void removeRelation(Context ctx, String srcVchId, IObjectPK pk) throws BOSException, EASBizException {
        PcVoucherInfo srcVch = new PcVoucherInfo();
        BOSUuid id = BOSUuid.read((String)srcVchId);
        srcVch.setId(id);
        if (this.operateSharer.isVoucherExisted(ctx, (BaseVoucherInfo)srcVch)) {
            PcVoucherInfo reverVch = (PcVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(srcVchId), PcVoucherInfo.getReverseSelector());
            srcVch.setDescription(null);
            String strIndex = "(" + reverVch.getPeriod().getPeriodYear() + "." + reverVch.getPeriod().getPeriodNumber() + ")";
            String des = reverVch.getDescription();
            if (des != null) {
                if (des.indexOf("_") > 0) {
                    if (des.substring(0, des.lastIndexOf("_")).indexOf(strIndex) > -1) {
                        srcVch.setDescription(des.substring(des.indexOf(strIndex) + strIndex.length() + 1));
                    } else {
                        String bStr = des.substring(0, des.indexOf(strIndex));
                        String eStr = des.substring(des.indexOf(strIndex));
                        bStr = bStr.substring(bStr.indexOf("_") + 1);
                        eStr = eStr.substring(eStr.indexOf(strIndex) + strIndex.length());
                        srcVch.setDescription(bStr + eStr);
                    }
                } else if (des.indexOf(strIndex) > 0) {
                    srcVch.setDescription(des.substring(des.indexOf(strIndex) + strIndex.length()));
                } else {
                    srcVch.setDescription(des);
                }
            }
            srcVch.setId(id);
            srcVch.setHasReversed(false);
            PcVoucherUtil._removeBotRelation(ctx, srcVchId, pk.toString(), srcVch.getBOSType());
            this.iVoucher.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)srcVch);
        }
    }
}

