/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.validator.AbstractPcVoucherBaseValidator;
import com.kingdee.eas.util.app.ContextUtil;

public class PcVoucherBaseAuditValidator
extends AbstractPcVoucherBaseValidator {
    protected GlParam sysParam;
    protected String auditorId;

    protected PcVoucherBaseAuditValidator(GlParam sysParam, String auditorId) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
        this.auditorId = auditorId;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.checkMutex(ctx, voucherInfo);
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, voucherInfo, VoucherOperateStatusEnum.AUDIT);
        this.checkVoucherPeriodForAudit(ctx, voucherInfo);
        this.checkAuditBack(ctx, voucherInfo);
        this.checkAuditor(ctx, voucherInfo);
    }

    protected void checkMutex(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (PcaUtils.isExisted(ctx, voucherInfo)) {
            this.checkMutex(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    private void checkAuditor(Context ctx, PcVoucherInfo voucherInfo) throws VoucherException, GLException, BOSException {
        boolean ceatorNotAudit = this.sysParam.getBoolean("PCA_0491");
        if (ceatorNotAudit) {
            if (this.auditorId == null) {
                this.auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            }
            if (this.auditorId.equals(voucherInfo.getCreator().getId().toString())) {
                throw new VoucherException(VoucherException.CEATORNOTAUDIT);
            }
        }
    }

    private void checkAuditBack(Context ctx, PcVoucherInfo voucherInfo) throws VoucherException, GLException, BOSException {
        boolean useWorkflow = false;
        boolean ishandAuditBack = this.sysParam.getBoolean("GL_099");
        if (!useWorkflow && ishandAuditBack && voucherInfo.isIsAuditBack()) {
            throw new VoucherException(VoucherException.ISAUDITBACK);
        }
    }

    protected void checkVoucherPeriodForAudit(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriod = PcaUtils.getCurrentPeriod(ctx, voucherInfo.getProfitCenter().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getNumber() < currPeriod.getNumber()) {
            throw new VoucherException(VoucherException.AUDIT_CUR_PERIOD);
        }
    }
}

