/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReqStatus;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PcVoucherPersistence
implements IVoucherPersistence {
    protected static final Logger logger = Logger.getLogger(PcVoucherPersistence.class);
    protected GlParam sysParam;

    public PcVoucherPersistence(GlParam sysParam) throws BOSException {
        this.sysParam = sysParam;
    }

    public IObjectPK persistVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        if (voucherInfo.getEntryCount() > 0) {
            voucherInfo.setVoucherAbstract(voucherInfo.getEntries().get(0).getDescription());
        }
        if (voucherInfo.getSourceType().equals((Object)SourceType.PROFIT_AND_LOSS)) {
            voucherInfo.setIsMgCtrl(false);
        }
        this.calStandardQuantity(ctx, voucherInfo);
        if (voucherInfo.getNumber() == null || "".equals(voucherInfo.getNumber().trim())) {
            throw new VoucherException(VoucherException.NO_VOUCHERNUMBER);
        }
        return this.saveVoucher(ctx, voucherInfo);
    }

    private void calStandardQuantity(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean useQtyAsst = this.sysParam.getBoolean("G010");
        if (voucherInfo.getEntries() != null && voucherInfo.getSourceType() != SourceType.PROFIT_AND_LOSS && voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            IMeasureUnit iMeasureUnit = null;
            for (PcVoucherEntryInfo entryInfo : voucherInfo.getEntries()) {
                Iterator iteratorAssist;
                AccountViewInfo account = entryInfo.getAccount();
                if (account == null) continue;
                if (account.isIsQty() && (account.getCAA() == null || !useQtyAsst)) {
                    iMeasureUnit = this.calEntryStandardQuantity(ctx, entryInfo, iMeasureUnit);
                    continue;
                }
                if (useQtyAsst && account.getCAA() != null && account.isIsQty() && account.getCAA().isIsQty()) {
                    iteratorAssist = entryInfo.getAssistRecords().iterator();
                    BigDecimal entryStandQty = new BigDecimal("0.0");
                    while (iteratorAssist.hasNext()) {
                        PcVoucherAssistRecordInfo recordInfo = (PcVoucherAssistRecordInfo)iteratorAssist.next();
                        iMeasureUnit = this.calAssistRecordStandardQuantity(ctx, recordInfo, iMeasureUnit);
                        if (recordInfo.getStandardQuantity() == null) continue;
                        entryStandQty = entryStandQty.add(recordInfo.getStandardQuantity());
                    }
                    entryInfo.setStandardQuantity(entryStandQty);
                    continue;
                }
                if (!account.isIsQty()) {
                    this.clearEntryQuantity(entryInfo);
                    continue;
                }
                if (!account.isIsQty() || account.getCAA() == null || account.getCAA().isIsQty()) continue;
                iteratorAssist = entryInfo.getAssistRecords().iterator();
                while (iteratorAssist.hasNext()) {
                    this.clearAssistRecordQuantity((PcVoucherAssistRecordInfo)iteratorAssist.next());
                }
            }
        }
    }

    private void clearEntryQuantity(PcVoucherEntryInfo entryInfo) {
        entryInfo.setMeasureUnit(null);
        entryInfo.setQuantity(GlUtils.zero);
        entryInfo.setStandardQuantity(GlUtils.zero);
        if (entryInfo.getAccount().getCAA() != null && !entryInfo.getAccount().getCAA().isIsQty()) {
            Iterator iteratorAssist = entryInfo.getAssistRecords().iterator();
            while (iteratorAssist.hasNext()) {
                this.clearAssistRecordQuantity((PcVoucherAssistRecordInfo)iteratorAssist.next());
            }
        }
    }

    private void clearAssistRecordQuantity(PcVoucherAssistRecordInfo recordInfo) {
        recordInfo.setMeasureUnit(null);
        recordInfo.setAssistUnit(null);
        recordInfo.setQuantity(GlUtils.zero);
        recordInfo.setAssistQty(GlUtils.zero);
        recordInfo.setStandardQuantity(GlUtils.zero);
    }

    private IMeasureUnit calAssistRecordStandardQuantity(Context ctx, PcVoucherAssistRecordInfo recordInfo, IMeasureUnit iMeasureUnit) throws BOSException, EASBizException {
        MeasureUnitInfo measure = recordInfo.getMeasureUnit();
        if (measure != null) {
            BOSUuid measureId = measure.getId();
            BigDecimal coefficient = measure.getCoefficient();
            if (coefficient == null) {
                if (iMeasureUnit == null) {
                    iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
                }
                coefficient = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureId)).getCoefficient();
            }
            if (recordInfo.getQuantity() != null && coefficient != null) {
                recordInfo.setStandardQuantity(recordInfo.getQuantity().multiply(coefficient));
            }
        }
        return iMeasureUnit;
    }

    private IMeasureUnit calEntryStandardQuantity(Context ctx, PcVoucherEntryInfo entryInfo, IMeasureUnit iMeasureUnit) throws BOSException, EASBizException {
        MeasureUnitInfo measure = entryInfo.getMeasureUnit();
        if (measure != null) {
            BOSUuid measureId = measure.getId();
            BigDecimal coefficient = measure.getCoefficient();
            if (coefficient == null) {
                if (iMeasureUnit == null) {
                    iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
                }
                coefficient = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureId)).getCoefficient();
            }
            if (entryInfo.getQuantity() != null && coefficient != null) {
                entryInfo.setStandardQuantity(entryInfo.getQuantity().multiply(coefficient));
            }
        }
        return iMeasureUnit;
    }

    private IObjectPK saveVoucher(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        IObjectPK voucherPK;
        boolean isNew;
        boolean bl = isNew = !PcaUtils.isExisted(ctx, voucherInfo);
        if (isNew) {
            voucherPK = PcVoucherFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)voucherInfo);
            voucherInfo.put("id", voucherPK.getKeyValue("id"));
        } else {
            voucherInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            voucherPK = new ObjectUuidPK(voucherInfo.getId());
            PcVoucherFactory.getLocalInstance((Context)ctx).update(voucherPK, (CoreBaseInfo)voucherInfo);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iVoucherEntry = ORMappingDAO.getInstance((BOSObjectType)new PcVoucherEntryInfo().getBOSType(), (Context)ctx, (Connection)conn);
            IORMappingDAO iVoucherAssistRecord = ORMappingDAO.getInstance((BOSObjectType)new PcVoucherAssistRecordInfo().getBOSType(), (Context)ctx, (Connection)conn);
            if (!isNew) {
                iVoucherEntry.delete("select id where bill.id = '" + voucherPK + "'");
                iVoucherAssistRecord.delete("select id where bill.id = '" + voucherPK + "'");
            }
            this.saveVoucherEntry(voucherInfo, iVoucherEntry, iVoucherAssistRecord, isNew);
            this.deleteDisableEntries(ctx, voucherInfo, iVoucherEntry);
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return voucherPK;
    }

    private void deleteDisableEntries(Context ctx, PcVoucherInfo voucherInfo, IORMappingDAO iVoucherEntry) throws BOSException, EASBizException, DataAccessException {
        Vector vecEntries = voucherInfo.getRemovedEntries();
        if (vecEntries != null && vecEntries.size() > 0) {
            int n = vecEntries.size();
            IObjectPK[] pks = new IObjectPK[n];
            for (int i = 0; i < n; ++i) {
                pks[i] = new ObjectUuidPK((BOSUuid)vecEntries.get(i));
            }
            this.deleteAdjustCashflow(ctx, voucherInfo.getId().toString(), pks);
        }
    }

    private void deleteDisableRecords(PcVoucherInfo voucherInfo, IORMappingDAO iVoucherAssistRecord) throws DataAccessException {
        Vector vecRecords = voucherInfo.getRemovedRecords();
        if (vecRecords != null && vecRecords.size() > 0) {
            int n = vecRecords.size();
            IObjectPK[] pks = new IObjectPK[n];
            for (int i = 0; i < n; ++i) {
                pks[i] = new ObjectUuidPK((BOSUuid)vecRecords.get(i));
                iVoucherAssistRecord.deleteBatch(pks[i]);
            }
            iVoucherAssistRecord.executeBatch();
        }
    }

    private boolean isEdited(Context ctx, PcVoucherInfo voucherInfo) throws BOSException {
        String sql = "select top 1 fbizstatus from t_pca_pcvoucher where fid = ? and flastupdatetime = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString(), voucherInfo.getLastUpdateTime()});
        boolean exist = true;
        try {
            exist = rs.next();
            if (exist) {
                return false;
            }
        }
        catch (SQLException ex) {
            throw new BOSException("SQL ERROR!", (Throwable)ex);
        }
        return true;
    }

    private void deleteAdjustCashflow(Context ctx, String vchId, IObjectPK[] entryIds) throws BOSException, EASBizException {
        if (entryIds == null || entryIds.length < 1) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_gl_cashflowrecord where fvoucherid = ? and Fentryid=?  AND fitemFlag = 7");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < entryIds.length; ++i) {
            params.add(new Object[]{vchId, entryIds[i].toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
    }

    private void saveVoucherEntry(PcVoucherInfo voucherInfo, IORMappingDAO iVoucherEntry, IORMappingDAO iVoucherAssistRecord, boolean isNew) throws BOSException {
        Iterator iteratorEntry = voucherInfo.getEntries().iterator();
        PcVoucherEntryInfo voucherEntryInfo = null;
        logger.info((Object)"BT526171\uff1aSaving VoucherEntry!");
        while (iteratorEntry.hasNext()) {
            voucherEntryInfo = (PcVoucherEntryInfo)iteratorEntry.next();
            if (voucherEntryInfo.getLocalAmount() == null) {
                voucherEntryInfo.setLocalAmount(RptConstant.ZERO);
            }
            if (voucherEntryInfo.getQuantity() == null) {
                voucherEntryInfo.setQuantity(RptConstant.ZERO);
            }
            logger.info((Object)("BT526171\uff1aSaving VoucherEntry! Seq = " + voucherEntryInfo.getSeq() + " LocalAmount =" + voucherEntryInfo.getLocalAmount() + " scale = " + voucherEntryInfo.getLocalAmount().scale()));
            voucherEntryInfo.setBill(voucherInfo);
            if (voucherEntryInfo.getId() == null) {
                voucherEntryInfo.put("id", (Object)BOSUuid.create((BOSObjectType)voucherEntryInfo.getBOSType()));
            }
            voucherEntryInfo.setBill(voucherInfo);
            iVoucherEntry.addNewBatch((IObjectValue)voucherEntryInfo);
            this.saveVoucherAssistRecord(voucherInfo, voucherEntryInfo, iVoucherAssistRecord, isNew);
        }
        iVoucherEntry.executeBatch();
        iVoucherAssistRecord.executeBatch();
    }

    private void saveVoucherAssistRecord(PcVoucherInfo voucherInfo, PcVoucherEntryInfo voucherEntryInfo, IORMappingDAO iVoucherAssistRecord, boolean isNew) throws BOSException {
        if (voucherEntryInfo.getAccount() == null || voucherEntryInfo.getAccount().getCAA() == null && !voucherEntryInfo.getAccount().isHasUserProperty()) {
            return;
        }
        PcVoucherAssistRecordInfo voucherAssistRecordInfo2 = null;
        for (PcVoucherAssistRecordInfo voucherAssistRecordInfo2 : voucherEntryInfo.getAssistRecords()) {
            voucherAssistRecordInfo2.setReqStatus(ReqStatus.NONE);
            voucherAssistRecordInfo2.setEntry(voucherEntryInfo);
            voucherAssistRecordInfo2.setBill(voucherInfo);
            if (voucherAssistRecordInfo2.getId() == null) {
                voucherAssistRecordInfo2.put("id", (Object)BOSUuid.create((BOSObjectType)voucherAssistRecordInfo2.getBOSType()));
            }
            voucherAssistRecordInfo2.setBill(voucherInfo);
            voucherAssistRecordInfo2.setEntry(voucherEntryInfo);
            iVoucherAssistRecord.addNewBatch((IObjectValue)voucherAssistRecordInfo2);
        }
    }
}

