/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.TransactVoucherColParameter;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.AbstractTransactPcVoucherColService;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PostPcVoucherCollectionService
extends AbstractTransactPcVoucherColService {
    @Override
    protected void beforeTransactVoucherNewTrans(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    @Override
    protected String catchTransactException(Context ctx, PcVoucherInfo voucherInfo, String oldNumber, Exception ex) {
        String oldVchType = voucherInfo.getVoucherType() == null ? "" : (voucherInfo.getVoucherType().getName() == null ? "" : voucherInfo.getVoucherType().getName());
        return voucherInfo.getProfitCenter().getName() + " " + oldVchType + oldNumber + " " + ex.getMessage();
    }

    @Override
    protected EntityViewInfo getEntityView(Set idSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(PcVoucherInfo.getPostVoucherSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection soter = new SorterItemCollection();
        soter.add(new SorterItemInfo("number"));
        view.setSorter(soter);
        return view;
    }

    @Override
    protected void machiningVoucherCollection(Context ctx, Set idSet, PcVoucherCollection voucherCollection) throws BOSException, EASBizException {
        this.matchVoucherStatus(ctx, idSet, voucherCollection);
        this.checkInitState(ctx, idSet, voucherCollection);
    }

    private void checkInitState(Context ctx, Set idSet, PcVoucherCollection voucherCollection) throws EASBizException, BOSException {
        if (idSet.size() == 0) {
            return;
        }
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null) {
            HashMap<String, ProfitCenterOrgUnitInfo> proMap = new HashMap<String, ProfitCenterOrgUnitInfo>();
            HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
            int size = voucherCollection.size();
            for (int i = 0; i < size; ++i) {
                PcVoucherInfo vch = voucherCollection.get(i);
                ProfitCenterOrgUnitInfo profitCenter = vch.getProfitCenter();
                String profitCenterID = profitCenter.getId().toString();
                if (proMap.get(profitCenterID) == null) {
                    proMap.put(profitCenterID, profitCenter);
                }
                if (companyMap.get(profitCenterID) != null) continue;
                companyMap.put(profitCenterID, vch.getCompany());
            }
            Iterator iter = proMap.keySet().iterator();
            while (iter.hasNext()) {
                String profitCenterID = iter.next().toString();
                ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)proMap.get(profitCenterID);
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyMap.get(profitCenterID);
                boolean isGlSystemStarted = this.isPcaStarted(ctx, profitCenter.getId().toString(), company.getId().toString(), company.getAccountTable().getId().toString());
                boolean isAccountInited = false;
                if (!isGlSystemStarted) {
                    isAccountInited = this.isAccountInited(ctx, profitCenter);
                }
                cache.getGLCloseInitStateMap().put(profitCenterID, isGlSystemStarted);
                if (isGlSystemStarted) continue;
                cache.getAccountInitStateMap().put(profitCenterID, isAccountInited);
                cache.setAssistInitStateMap(this.checkAssistInited(ctx, idSet, profitCenterID));
                GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_028"}, (String)company.getId().toString());
                if (!glParam.getBoolean("GL_028")) continue;
                cache.setCussentInitStateMap(this.checkCussentInited(ctx, idSet, profitCenterID));
            }
        }
    }

    @Override
    String getPermItemName() {
        return "pca_voucher092_post";
    }

    @Override
    protected void transactVoucherNewTrans(Context ctx, TransactVoucherColParameter parameterObject, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(voucherInfo.getId().toString());
        Map checkViews = parameterObject.getCheckViews();
        if (SourceType.ACCOUNTADJUST.equals((Object)voucherInfo.getSourceType())) {
            PcVoucherFactory.getLocalInstance((Context)ctx).post((IObjectPK)pk, checkViews);
        } else {
            this.getVoucherServiceFacade(ctx).postVoucherNewTrans((IObjectPK)pk, checkViews);
        }
    }

    private void matchVoucherStatus(Context ctx, Set idSet, PcVoucherCollection voucherCollection) {
        for (int i = voucherCollection.size() - 1; i >= 0; --i) {
            PcVoucherInfo voucherInfo = voucherCollection.get(i);
            if (VoucherStatusEnum.AUDITTED.equals((Object)voucherInfo.getBizStatus())) continue;
            if (idSet.contains(voucherInfo.getId().toString())) {
                idSet.remove(voucherInfo.getId().toString());
            }
            voucherCollection.removeObject(i);
        }
    }

    private boolean isPcaStarted(Context ctx, String profitCenterID, String companyID, String accountTableID) throws EASBizException, BOSException {
        return PcVoucherUtil.closeInit(ctx, profitCenterID, companyID, accountTableID);
    }

    private boolean isAccountInited(Context ctx, ProfitCenterOrgUnitInfo curCompany) throws EASBizException, BOSException {
        return PcVoucherUtil.isAccountInited(ctx, curCompany.getId().toString());
    }

    private Map checkAssistInited(Context ctx, Set idSet, String companyId) throws EASBizException, BOSException {
        return PcVoucherUtil.checkAssitInited(ctx, this.idSetToList(idSet), companyId);
    }

    private Map checkCussentInited(Context ctx, Set idSet, String companyId) throws EASBizException, BOSException {
        return PcVoucherUtil.checkCussentInited(ctx, this.idSetToList(idSet), companyId);
    }

    private String idSetToList(Set idSet) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(it.next()).append("'");
        }
        return ids.toString();
    }

    @Override
    protected VoucherException getVoucherException(String errMsg) {
        return new VoucherException(VoucherException.POST_FAIL, new Object[]{errMsg});
    }

    @Override
    protected Map batchVoucherCollection(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (parameterObject.getCtx() == null || parameterObject.getIdSet() == null) {
            return result;
        }
        Context ctx = parameterObject.getCtx();
        IPcVoucher iVoucher = this.getVoucherService(ctx);
        PcVoucherCollection allVoucherColl = iVoucher.getPcVoucherCollection(this.getEntityView(parameterObject.getIdSet()));
        PcVoucherCollection hasPermissionVoucherColl = this.getHasPermissionVoucherCollection(ctx, allVoucherColl);
        this.machiningVoucherCollection(ctx, parameterObject.getIdSet(), hasPermissionVoucherColl);
        PcVoucherInfo voucherInfo = null;
        Iterator idIter = allVoucherColl.iterator();
        while (idIter.hasNext()) {
            String voucherid = ((PcVoucherInfo)idIter.next()).getId().toString();
            voucherInfo = hasPermissionVoucherColl.get((Object)BOSUuid.read((String)voucherid));
            String oldNumber = "";
            try {
                if (voucherInfo == null) {
                    voucherInfo = allVoucherColl.get((Object)BOSUuid.read((String)voucherid));
                    if (!iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherid))) continue;
                    if (voucherInfo.getBizStatus().getValue() != 3) {
                        oldNumber = voucherInfo.getNumber();
                        throw new VoucherException(VoucherException.VCH_CAN_NOT_POST);
                    }
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getPermItemName());
                    Object[] object = new Object[]{voucherInfo.getCompany().getName(), permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_DATA_PERMISSION, object);
                    throw pe;
                }
                oldNumber = voucherInfo.getNumber();
                this.beforeTransactVoucherNewTrans(ctx, voucherInfo);
                this.checkPermission(ctx, voucherInfo);
                this.disablePermission();
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                this.transactVoucherNewTrans(ctx, parameterObject, voucherInfo);
            }
            catch (Exception e) {
                log.error((Object)"ERROR", (Throwable)e);
                if (e instanceof PermissionException) {
                    result.put(voucherid, "{0} " + e.getMessage());
                    this.noPermIdSet.add(voucherid);
                    continue;
                }
                result.put(voucherid, this.catchTransactException(ctx, voucherInfo, oldNumber, e));
            }
        }
        return result;
    }
}

