/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.ma.pca.PcVoucherException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SubmitPcVoucherServiceHelper {
    protected static final Logger logger = Logger.getLogger(SubmitPcVoucherServiceHelper.class);

    public void checkAmountBalance(Context ctx, IObjectPK voucherPK, GlParam sysParam) throws BOSException, EASBizException {
        boolean usingRpt = sysParam.getBoolean("G001");
        StringBuffer sql = new StringBuffer();
        sql.append("select ve.fentrydc,ve.fseq,ve.flocalamount,ve.freportingamount,v.fnumber,av.fnumber facctnumber,\r\n");
        sql.append("av.FBw,t.fentryid,t.flocalamount fsumlocalamount,t.freportingamount fsumreportingamount \r\n");
        sql.append("from t_pca_pcvoucherentry ve \r\n");
        sql.append("inner join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("inner join t_pca_pcvoucher v on v.fid=ve.fbillid \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("  select fentryid,sum(flocalamount) flocalamount,sum(freportingamount) freportingamount from t_pca_pcvoucherassistrecord \r\n");
        sql.append("  where fbillid=? \r\n");
        sql.append("  group by fbillid,fentryid \r\n");
        sql.append(") t on ve.fid=t.fentryid \r\n");
        sql.append("where ve.fbillid=? \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherPK.toString(), voucherPK.toString()});
        try {
            BigDecimal totalVchDebitLocAmt = GlUtils.zero;
            BigDecimal totalVchCreditLocAmt = GlUtils.zero;
            BigDecimal totalVchDebitRptAmt = GlUtils.zero;
            BigDecimal totalVchCreditRptAmt = GlUtils.zero;
            boolean hasBwAcct = false;
            while (rs.next()) {
                BigDecimal locAmt = rs.getBigDecimal("flocalamount") == null ? GlUtils.zero : rs.getBigDecimal("flocalamount");
                BigDecimal rptAmt = rs.getBigDecimal("freportingamount") == null ? GlUtils.zero : rs.getBigDecimal("freportingamount");
                String entryId = rs.getString("fentryid");
                int isBw = rs.getInt("fbw");
                if (isBw == 1) {
                    hasBwAcct = true;
                }
                if (entryId != null && entryId.trim().length() > 0) {
                    BigDecimal sumLocAmt = rs.getBigDecimal("fsumlocalamount");
                    BigDecimal sumRptAmt = rs.getBigDecimal("fsumreportingamount");
                    if (locAmt.compareTo(sumLocAmt) != 0) {
                        throw new VoucherException(VoucherException.VCH_LINE_EQUAL_ASSIT_LOC, new Object[]{rs.getString("fnumber"), new Integer(rs.getInt("fseq")), rs.getString("facctnumber"), locAmt, sumLocAmt});
                    }
                    if (usingRpt && rptAmt.compareTo(sumRptAmt) != 0) {
                        throw new VoucherException(VoucherException.VCH_LINE_EQUAL_ASSIT_RPT, new Object[]{rs.getString("fnumber"), new Integer(rs.getInt("fseq")), rs.getString("facctnumber"), rptAmt, sumRptAmt});
                    }
                }
                if (1 == rs.getInt("fentrydc")) {
                    totalVchDebitLocAmt = totalVchDebitLocAmt.add(locAmt);
                    totalVchDebitRptAmt = totalVchDebitRptAmt.add(rptAmt);
                    continue;
                }
                totalVchCreditLocAmt = totalVchCreditLocAmt.add(locAmt);
                totalVchCreditRptAmt = totalVchCreditRptAmt.add(rptAmt);
            }
            if (!hasBwAcct) {
                if (totalVchDebitLocAmt.compareTo(totalVchCreditLocAmt) != 0) {
                    throw new PcVoucherException(PcVoucherException.LOCAL_DC_NOT_EQUAL, new Object[]{totalVchDebitLocAmt, totalVchCreditLocAmt});
                }
                if (usingRpt && totalVchDebitRptAmt.compareTo(totalVchCreditRptAmt) != 0) {
                    throw new PcVoucherException(PcVoucherException.REPORT_DC_NOT_EQUAL, new Object[]{totalVchDebitRptAmt, totalVchCreditRptAmt});
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }
}

