/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.voucher.SubmitStandradPcVoucherService;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidator;
import com.kingdee.eas.ma.pca.validator.ReversePcVoucherBaseSubmitValidator;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class SubmitReversePcVoucherService
extends SubmitStandradPcVoucherService {
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    public SubmitReversePcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IObjectPK submit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        IObjectPK pk = super.submit(ctx, voucherInfo);
        this.updateSrcVoucher(ctx, voucherInfo.getSrcVoucherInfo());
        if (voucherInfo.getId() == null) {
            this.saveReverseRelation(ctx, (PcVoucherInfo)voucherInfo);
        }
        return pk;
    }

    private void updateSrcVoucher(Context ctx, BaseVoucherInfo srcVch) throws BOSException, EASBizException {
        String des = srcVch.getDescription();
        String select = ResourceBase.getString((String)resource, (String)"HASREVERSED", (Locale)ctx.getLocale());
        select = select + "(" + srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber() + ")";
        if (des != null) {
            select = select + "_" + des;
        }
        srcVch.setDescription(srcVch.getNumber() + select);
        if (srcVch.getDescription().length() > 255) {
            srcVch.setDescription(srcVch.getDescription().substring(0, 255));
        }
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        iVoucher.update((IObjectPK)new ObjectUuidPK(srcVch.getId()), (CoreBaseInfo)srcVch);
    }

    private void saveReverseRelation(Context ctx, PcVoucherInfo voucherInfo) throws BOSException {
        VoucherUtil.saveBOTRelationInfo((Context)ctx, (String)voucherInfo.getSrcVoucherInfo().getId().toString(), (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), (BOSObjectType)voucherInfo.getBOSType());
    }

    @Override
    protected PcVoucherValidator getAdditionalValidator() {
        PcVoucherValidator validator = new PcVoucherValidator();
        validator.addVoucherBaseValidator(new ReversePcVoucherBaseSubmitValidator());
        return validator;
    }
}

