/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryCollection;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryFactory;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAdjExchRateHistory;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.AbstractSubmitBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherException;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherPostProcessorInvokeFactory;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.PcVoucherEntryAutoBalance;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherPersistence;
import com.kingdee.eas.ma.pca.app.voucher.SubmitPcVoucherServiceHelper;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.ma.pca.validator.PcVoucherAssistRecordSubmitValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherBaseSubmitValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherEntrySubmitValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidator;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidatorFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubmitStandradPcVoucherService
extends AbstractSubmitBaseVoucherService {
    protected static final Logger logger = Logger.getLogger(SubmitStandradPcVoucherService.class);
    private PcVoucherValidator validator = null;
    private String oldNumber = null;
    private String oldTypeName = null;
    private String oldPeriodId = null;
    private SubmitPcVoucherServiceHelper helper = new SubmitPcVoucherServiceHelper();

    public SubmitStandradPcVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    public IObjectPK submitVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return super.submitVoucher(ctx, voucherInfo);
    }

    protected boolean exist(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return PcaUtils.isExisted(ctx, (PcVoucherInfo)voucherInfo);
    }

    protected void initVoucherValidator(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam);
        if (this.validator == null) {
            this.validator = new PcVoucherValidator();
        }
        PcVoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        PcVoucherValidatorFactory.getVoucherValidator(ctx, ((Object)((Object)this)).getClass().getName(), this.validator);
    }

    protected void transactExistVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.setVchPropFromExistVch(ctx, voucherInfo);
        this.clearAuditBack(ctx, voucherInfo, this.sysParam);
    }

    protected void afterValidatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    protected IObjectPK submit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        this.handleSubmitVoucherNumber(ctx, (PcVoucherInfo)voucherInfo, this.sysParam);
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        IObjectPK voucherPK = this.saveVoucher(ctx, voucherInfo, this.sysParam);
        return voucherPK;
    }

    protected String getLogItemName() {
        return "pca_voucher_submit";
    }

    protected void dealAfterSubmit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        ObjectUuidPK voucherPK = new ObjectUuidPK(voucherInfo.getId().toString());
        boolean GL_112 = this.sysParam.getBoolean("GL_112");
        if (GL_112) {
            this.checkAmountBalance(ctx, (IObjectPK)voucherPK, this.sysParam);
        }
        PcVoucherOprateSharer.requestBudgetSubstract(ctx, voucherInfo, this.sysParam, 2);
        this.updateAdjustRateHistory(ctx, voucherInfo);
        this.invokeVoucherSubmitPostProcessor(ctx, voucherInfo);
    }

    private void updateAdjustRateHistory(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherInfo.getId().toString()));
            IAdjExchRateHistory adjHisInstance = AdjExchRateHistoryFactory.getLocalInstance((Context)ctx);
            AdjExchRateHistoryCollection coll = adjHisInstance.getAdjExchRateHistoryCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
            PcVoucherEntryCollection voucherEntryColl = voucherInfo.getEntries();
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                AdjExchRateHistoryInfo adjInfo = coll.get(i);
                for (int k = 0; k < voucherEntryColl.size(); ++k) {
                    PcVoucherEntryInfo voucherEntryInfo = voucherEntryColl.get(k);
                    if (!adjInfo.getAccount().getId().toString().equals(voucherEntryInfo.getAccount().getId().toString()) || !adjInfo.getCurrency().getId().toString().equals(voucherEntryInfo.getCurrency().getId().toString())) continue;
                    adjInfo.setExchRateAfter(voucherEntryInfo.getLocalExchangeRate());
                    if (adjInfo.getAccount().getCAA() != null && voucherEntryInfo.getAccount().getCAA() != null) {
                        PcVoucherAssistRecordCollection var = voucherEntryInfo.getAssistRecords();
                        int size = var.size();
                        for (int p = 0; p < size; ++p) {
                            PcVoucherAssistRecordInfo varInfo = var.get(p);
                            if (!adjInfo.getAssistHG().getId().toString().equals(varInfo.getAssGrp().getId().toString())) continue;
                            adjInfo.setBalanceAdjust(varInfo.getLocalAmount());
                            if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                                adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(varInfo.getLocalAmount()));
                                continue;
                            }
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(varInfo.getLocalAmount()));
                        }
                    } else {
                        adjInfo.setBalanceAdjust(voucherEntryInfo.getLocalAmount());
                        if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(voucherEntryInfo.getLocalAmount()));
                        } else {
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(voucherEntryInfo.getLocalAmount()));
                        }
                    }
                    adjHisInstance.update((IObjectPK)new ObjectUuidPK(adjInfo.getId()), (CoreBaseInfo)adjInfo);
                }
            }
        }
    }

    private void checkNumberRepeated(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.operateSharer.checkNumber(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
    }

    private void invokeVoucherSubmitPostProcessor(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherPostProcessorInvokeFactory.invokeVoucherSubmitPostProcessor(ctx, voucherInfo);
    }

    private IObjectPK saveVoucher(Context ctx, BaseVoucherInfo voucherInfo, GlParam glParam) throws EASBizException, BOSException {
        return this.getVoucherPersistence(this.sysParam).persistVoucher(ctx, voucherInfo);
    }

    protected void validatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (this.validator != null) {
            this.validator.validate(ctx, (BaseVoucherInfo)((PcVoucherInfo)voucherInfo));
        }
    }

    private void setVchPropFromExistVch(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean handleACNotice;
        boolean bl = handleACNotice = !voucherInfo.isFromSaveSubmit() && voucherInfo.isIsACNotice();
        if (handleACNotice) {
            PcVoucherInfo vch = (PcVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), PcVoucherInfo.getNumberTypePeriodSelector());
            this.oldNumber = vch.getNumber();
            this.oldTypeName = vch.getVoucherType().getName(ctx.getLocale());
            this.oldPeriodId = vch.getPeriod().getId().toString();
        }
        if (VoucherStatusEnum.TEMP == voucherInfo.getBizStatus()) {
            voucherInfo.setFromSaveSubmit(VoucherStatusEnum.TEMP == voucherInfo.getBizStatus());
        }
    }

    private void clearAcctCussent(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit()) {
            String sql = "delete from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_pca_pcvoucherassistrecord asst where asst.FBillID = ?)";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void clearAuditBack(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherInfo.setIsAuditBack(false);
        boolean ishandAuditBack = sysParam.getBoolean("GL_099");
        if (!voucherInfo.isFromSaveSubmit() && ishandAuditBack) {
            DbUtil.execute((Context)ctx, (String)" delete from T_PCA_PcAuditOpinion  where FVoucherID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void clearAcNotice(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        if (voucherInfo == null) {
            return;
        }
        boolean useACNotice = sysParam.getBoolean("GLG01");
        if (useACNotice) {
            boolean isNoticeBySubmit;
            boolean bl = isNoticeBySubmit = sysParam.getInt("GLG01_2") == 2;
            if (!isNoticeBySubmit && !voucherInfo.isFromSaveSubmit()) {
                AcNoticeUtil.clearAcNotice((Context)ctx, (String)voucherInfo.getId().toString());
            }
        }
    }

    protected IVoucherPersistence getVoucherPersistence(GlParam sysParam) throws BOSException {
        return new PcVoucherPersistence(sysParam);
    }

    protected void loadVoucherInfoForSubmit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherEntryAutoBalance autoBalance = new PcVoucherEntryAutoBalance();
        autoBalance.setSysParam(this.sysParam);
        autoBalance.setVoucherInfo(voucherInfo);
        autoBalance.setCtx(ctx);
        autoBalance.autoBalanceVoucherEntry();
        if (!voucherInfo.isPostedByUI()) {
            PcVoucherUtil.lazyLoad(ctx, voucherInfo, PcVoucherInfo.getDefaultSelector(), this.sysParam, true, false);
        } else {
            PcVoucherUtil.computeVoucherAttributeOld(voucherInfo, this.sysParam, true, true, ctx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleSubmitVoucherNumber(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException, VoucherException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        boolean isHandNumber = sysParam.getBoolean("PCA_031");
        if (isHandNumber && voucherInfo.getNumber() != null) {
            boolean isNumberValid = PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber);
            if (isNumberValid) {
                String preViewNumber;
                boolean isExitCodingRule = PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.SUBMITTED);
                if (isExitCodingRule && (preViewNumber = PcVoucherUtil.preViewNumber(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.SUBMITTED)).equals(voucherInfo.getNumber())) {
                    voucherInfo.setNumber(PcVoucherUtil.getNextNumber(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.SUBMITTED));
                }
            } else {
                if (PcaUtils.isExisted(ctx, voucherInfo)) throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                boolean isExitCodingRule = PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.SUBMITTED);
                if (!isExitCodingRule) throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                for (int count = 1; !PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < 1000; ++count) {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                }
            }
        } else if (!isHandNumber || voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) {
            if (PcaUtils.isExisted(ctx, voucherInfo)) {
                this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                for (int count = 1; !PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < 1000; ++count) {
                    voucherInfo.setNumber(null);
                    this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                }
            } else {
                voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                for (int count = 1; !PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < 1000; ++count) {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                }
            }
        }
        voucherInfo.setBizStatus(oldStatus);
    }

    private boolean isUpdateAcct(PcVoucherInfo voucherInfo, GlParam sysParam) throws GLException, BOSException {
        boolean allowCussent = sysParam.getBoolean("GL_028");
        boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
        boolean updateAcct = false;
        if (allowCussent && isInTimeVerify && !voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT) && !voucherInfo.getSourceType().equals((Object)SourceType.PROFIT_AND_LOSS)) {
            updateAcct = true;
        }
        return updateAcct;
    }

    private void sendReqRelation(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        if (voucherInfo == null) {
            return;
        }
        boolean useACNotice = sysParam.getBoolean("GLG01");
        if (useACNotice) {
            boolean isNoticeBySubmit;
            boolean bl = isNoticeBySubmit = sysParam.getInt("GLG01_2") == 2;
            if (isNoticeBySubmit) {
                if (voucherInfo.get("botrelation") != null) {
                    ctx.put((Object)"botrelation", voucherInfo.get("botrelation"));
                }
                ctx.put((Object)"VOUCHERID", (Object)voucherInfo.getId().toString());
                ctx.put((Object)"COMPANYID", (Object)voucherInfo.getCompany().getId().toString());
                AcNoticeUtil.dealAcNotice((Context)ctx, null);
            } else if (!voucherInfo.isFromSaveSubmit()) {
                AcNoticeUtil.clearAcNotice((Context)ctx, (String)voucherInfo.getId().toString());
            }
        }
    }

    private PcVoucherValidator getValidator(GlParam sysParam) throws BOSException {
        PcVoucherValidator validator = new PcVoucherValidator();
        validator.addVoucherBaseValidator(new PcVoucherBaseSubmitValidator(sysParam));
        validator.addVoucherEntryValidator(new PcVoucherEntrySubmitValidator(sysParam));
        validator.addVoucherAssistRecordValidator(new PcVoucherAssistRecordSubmitValidator(sysParam));
        return validator;
    }

    protected PcVoucherValidator getAdditionalValidator() {
        return null;
    }

    protected void checkAmountBalance(Context ctx, IObjectPK voucherPK, GlParam sysParam) throws BOSException, EASBizException {
        this.helper.checkAmountBalance(ctx, voucherPK, sysParam);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "ISubmitVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])GlUtils.getDefaultGLParamList(), (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        super.initGlParam(ctx, voucherInfo);
        if (((PcVoucherInfo)voucherInfo).getProfitCenter() == null) {
            throw new PcVoucherException(PcVoucherException.PROFITCENTER_CANNOT_NULL);
        }
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "ISubmitVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        PcaParam glParam = PcaParam.getPcaParams(ctx, PcaUtils.getDefaultPcaParamList(), profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }
}

