/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAntiAuditPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFacadeFactory;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SynPcVoucherAntiAuditPostProcessor
implements IVoucherAntiAuditPostProcessor {
    protected static final Logger logger = Logger.getLogger(SynPcVoucherAntiAuditPostProcessor.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;
    private static final String NEW_VOUCHER_NUMBER = "newVoucherNumber";

    public void process(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, SynVoucherUtil.getSynPcVoucherSelector());
        PeriodInfo voucherPeriodInfo = SynVoucherUtil.getVoucherPeriod(ctx, voucherInfo.getPeriod());
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.ANTIAUDIT);
            this.antiAuditVoucher(ctx, (IObjectPK)new ObjectUuidPK(pcVoucherInfo.getId().toString()), null);
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    public void antiAuditVoucher(Context ctx, IObjectPK pk, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        block7: {
            BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this.iVoucher.getValue(pk, this.getAnitAuditSelector());
            try {
                this._antiAuditVoucher(ctx, (IObjectValue)voucherInfo, preStatus);
            }
            catch (Exception e) {
                if (voucherInfo.get(NEW_VOUCHER_NUMBER) != null) {
                    try {
                        this.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get(NEW_VOUCHER_NUMBER));
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Recycle voucher number error when save voucher!", (Throwable)ex);
                    }
                }
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                if (!(e instanceof RuntimeException)) break block7;
                throw (RuntimeException)e;
            }
        }
    }

    protected SelectorItemCollection getAnitAuditSelector() {
        return PcVoucherInfo.getAnitAuditSelector();
    }

    protected void _antiAuditVoucher(Context ctx, IObjectValue model, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)model;
        HashMap param = GlUtils.getDefaultGLParam((Context)ctx, (String)voucherInfo.getCompany().getId().toString());
        param.putAll(PcaUtils.getDefaultPcaParam(ctx, ((PcVoucherInfo)model).getProfitCenter().getId().toString()));
        this.processBudget(ctx, voucherInfo, param);
        ctx.put((Object)"GL_VOUCHERNUMBER_LOG", param.get("GL_VOUCHERNUMBER_LOG"));
        this.processCodingRule(ctx, model, voucherInfo);
        this.updateAntiAuditStatus(ctx, voucherInfo.getId().toString());
        this.afterAntiAudit(ctx, voucherInfo, param);
    }

    protected void beforeAntiAudit(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException, VoucherException {
        boolean useWorkflow = false;
        PcVoucherInfo pcVoucherInfo = (PcVoucherInfo)voucherInfo;
        PcaParam sysParam = PcaParam.getPcaParams(ctx, "PCA_049", pcVoucherInfo.getProfitCenter().getId().toString());
        boolean antiMustAudit = sysParam.getBoolean("PCA_049");
        if (!useWorkflow && antiMustAudit && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(voucherInfo.getAuditor().getId().toString())) {
            throw new VoucherException(VoucherException.ANTIMUSTAUTI);
        }
    }

    private void processBudget(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException {
        Object budgetParam = param.get("PCA_075");
        if (budgetParam == null || !"0".equals(budgetParam)) {
            BgControlCaller bgControlCaller = new BgControlCaller();
            bgControlCaller.returnBudget(ctx, voucherInfo.getId());
        }
    }

    protected void processCodingRule(Context ctx, IObjectValue model, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (PcVoucherUtil.isExistVoucherCodingRule(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString(), (PcVoucherInfo)voucherInfo, voucherInfo.getBizStatus())) {
            this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)((PcVoucherInfo)model), VoucherStatusEnum.SUBMITTED);
            String sql = "update t_pca_pcvoucher set  fnumber=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getNumber(), voucherInfo.getId().toString()});
        }
    }

    protected void updateAntiAuditStatus(Context ctx, String voucherId) throws BOSException {
        PcVoucherOprateSharer.updateVoucherStatus(ctx, voucherId, null, VoucherStatusEnum.SUBMITTED.getValue(), "FAuditorid");
    }

    protected void afterAntiAudit(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException {
    }

    protected void recycleVoucherId(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            Throwable ex = null;
            try {
                this.iVoucher.recycleVoucherNumber(voucherInfo, voucherNumber);
            }
            catch (BOSException e) {
                ex = e;
                throw e;
            }
            catch (EASBizException e) {
                ex = e;
                throw e;
            }
            finally {
                boolean isLogVoucherNumber = false;
                if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                    isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
                }
                if (isLogVoucherNumber) {
                    this.logVoucherNumber(ctx, voucherInfo, voucherNumber, (Exception)ex);
                }
            }
        } else {
            BaseVoucherInfo previousVoucher = null;
            String[] value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    protected void logVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber, Exception ex) throws BOSException, EASBizException {
        PcVoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber((PcVoucherInfo)voucherInfo, voucherNumber, "recycleNumber", ex);
    }
}

