/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAntiCancelPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynPcVoucherAntiCancelPostProcessor
implements IVoucherAntiCancelPostProcessor {
    protected static final Logger logger = Logger.getLogger(SynPcVoucherAntiCancelPostProcessor.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;

    public void process(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, PcVoucherInfo.getDefaultProcessSelector());
        PeriodInfo voucherPeriodInfo = SynVoucherUtil.getVoucherPeriod(ctx, voucherInfo.getPeriod());
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.AUDIT);
            this.antiCancelVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo, null);
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    public void antiCancelVoucher(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum preStatus) throws EASBizException, BOSException {
        this.initGlParam(ctx, voucherInfo);
        voucherInfo.setBizStatus(this.operateSharer.getVoucherStatus(ctx, voucherInfo));
        this.antiCancel(ctx, voucherInfo, preStatus);
        this.afterAntiCancel(ctx, voucherInfo);
        if (voucherInfo.isIsReverseVoucher()) {
            this.reverseVoucher(ctx, (PcVoucherInfo)voucherInfo);
        }
    }

    private void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAntiCancelVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"GLG01", "GLG01_2", "GL_028", "GL_052", "GL_060", "GL_008", "GL_101"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "IAuditVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramItems = new String[]{"PCA_029", "PCA_032", "PCA_075"};
        PcaParam glParam = PcaParam.getPcaParams(ctx, paramItems, profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private void antiCancel(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum preStatus) throws EASBizException, BOSException {
        this.handleVoucherNumber(ctx, voucherInfo);
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setCanceller(null);
        this.operateSharer.updateVoucherStatus(ctx, voucherInfo, preStatus);
        this.requestBudgetSubstract(ctx, voucherInfo, this.sysParam, 2);
        this.intoVoucherLog(ctx, voucherInfo);
    }

    private void handleVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.existCodingRule(ctx, voucherInfo)) {
            this.operateSharer.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
            voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.SUBMITTED));
        }
    }

    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (PcVoucherInfo)voucherInfo, voucherInfo.getBizStatus());
    }

    protected void requestBudgetSubstract(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, int action) throws BgCtrlException, EASBizException, BOSException {
        PcVoucherUtil.requestBudgetSubstract(ctx, (PcVoucherInfo)voucherInfo, sysParam, action);
    }

    protected void intoVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        PcaBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 6, false, false);
    }

    protected void afterAntiCancel(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
    }

    private void reverseVoucher(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ObjectUuidPK srcVchPK = new ObjectUuidPK(BOSUuid.read((String)voucherInfo.getSourceBillId()));
        PcVoucherInfo srcVch = (PcVoucherInfo)this.iVoucher.getValue((IObjectPK)srcVchPK, PcVoucherInfo.getReverseSelector());
        if (voucherInfo.get("ReverseComplete") != null && Boolean.valueOf(voucherInfo.get("ReverseComplete").toString()).booleanValue()) {
            srcVch.setHasReversed(true);
            this.iVoucher.update((IObjectPK)srcVchPK, (CoreBaseInfo)srcVch);
        }
    }
}

