/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAntiPostPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynPcVoucherAntiPostPostProcessor
implements IVoucherAntiPostPostProcessor {
    protected static final Logger logger = Logger.getLogger(SynPcVoucherAntiPostPostProcessor.class);
    protected IVoucherOprateSharer operateSharer;
    protected GlParam sysParam = null;

    public void process(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, BaseVoucherInfo.getDefaultProcessSelector());
        PeriodInfo voucherPeriodInfo = SynVoucherUtil.getVoucherPeriod(ctx, voucherInfo.getPeriod());
        this.operateSharer = this.getOperateSharer(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.ANTIPOST);
            this.antiPostVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo, null);
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    public void antiPostVoucher(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        String voucherId = voucherInfo.getId().toString();
        if (SourceType.ACCOUNTADJUST.equals((Object)voucherInfo.getSourceType())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"903_VoucherControllerBean", (Locale)ctx.getLocale())));
        }
        HashMap param = GlUtils.getDefaultGLParam((Context)ctx, (String)voucherInfo.getCompany().getId().toString());
        this.postVoucher(ctx, voucherId, voucherInfo.getCompany().getId().toString(), 5, true, false, null);
        voucherInfo.setPoster(null);
        this.insertVoucherLog(ctx, voucherId);
        this.updateAntiPostStatus(ctx, voucherId);
        this.afterAntiPost(ctx, voucherInfo, voucherId, param);
    }

    protected void beforeAntiPost(Context ctx, BaseVoucherInfo voucherInfo, String voucherId, HashMap param) throws BOSException, EASBizException, VoucherException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_pca_pcvoucher where fsourcebillid=? and FIsReverseVoucher=1 and fbizstatus <> 0 and fbizstatus <> 2");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherId});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.CANNOT_ANTIPOST_REVERSED);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (voucherInfo.isIsClose()) {
            throw new VoucherException(VoucherException.CANNOT_UNPOST_CLOSE);
        }
        boolean useWorkflow = false;
        PcVoucherInfo pcVoucherInfo = (PcVoucherInfo)voucherInfo;
        PcaParam sysParam = PcaParam.getPcaParams(ctx, "PCA_0492", pcVoucherInfo.getProfitCenter().getId().toString());
        boolean postMustPost = sysParam.getBoolean("PCA_0492");
        if (!useWorkflow && postMustPost && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(voucherInfo.getPoster().getId().toString())) {
            throw new VoucherException(VoucherException.POSTMUSTPOST);
        }
    }

    protected void postVoucher(Context ctx, String vchID, String comId, int balType, boolean isUnPost, boolean hasNotice, Map checkViews) throws BOSException, EASBizException {
    }

    protected void insertVoucherLog(Context ctx, String voucherId) throws BOSException {
        PcaBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{voucherId}, 4, true, true);
    }

    protected void updateAntiPostStatus(Context ctx, String voucherId) throws BOSException {
        PcVoucherOprateSharer.updateVoucherStatus(ctx, voucherId, null, VoucherStatusEnum.AUDITTED.getValue(), "FPosterID");
    }

    protected void afterAntiPost(Context ctx, BaseVoucherInfo voucherInfo, String voucherId, HashMap param) throws BOSException, EASBizException {
    }
}

