/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAuditPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynPcVoucherAuditPostProcessor
implements IVoucherAuditPostProcessor {
    protected static final Logger logger = Logger.getLogger(SynPcVoucherAuditPostProcessor.class);
    protected GlParam sysParam = null;
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;

    public void process(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, SynVoucherUtil.getSynPcVoucherSelector());
        PeriodInfo voucherPeriodInfo = SynVoucherUtil.getVoucherPeriod(ctx, voucherInfo.getPeriod());
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.AUDIT);
            this.audit(ctx, (IObjectPK)new ObjectUuidPK(pcVoucherInfo.getId().toString()), voucherInfo.getAuditor().getId());
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    public void audit(Context ctx, IObjectPK pk, BOSUuid auditorId) throws BOSException, EASBizException {
        block7: {
            BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this.iVoucher.getValue(pk, this.getAuditSelector());
            this.initGlParam(ctx, voucherInfo);
            try {
                this.handleAuditVoucherNumber(ctx, voucherInfo);
                this.updateAuditStatus(ctx, voucherInfo, auditorId);
                this.afterAudit(ctx, voucherInfo);
            }
            catch (Exception e) {
                if (voucherInfo.get("newVoucherNumber") != null) {
                    try {
                        this.operateSharer.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get("newVoucherNumber"));
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Recycle voucher number error when audit voucher!", (Throwable)ex);
                    }
                }
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                if (!(e instanceof RuntimeException)) break block7;
                throw (RuntimeException)e;
            }
        }
    }

    protected SelectorItemCollection getAuditSelector() {
        return PcVoucherInfo.getAuditVoucherSelector();
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAuditVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramItems = new String[]{"G001", "GL_028", "GLG01", "GLG01_2", "GL_052", "G012", "GL_099"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramItems, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "IAuditVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramItems = new String[]{"PCA_029", "PCA_032", "PCA_047", "PCA_075", "PCA_0491"};
        PcaParam glParam = PcaParam.getPcaParams(ctx, paramItems, profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private void handleAuditVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.existCodingRule(ctx, voucherInfo)) {
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            this.operateSharer.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.AUDITTED);
            String sql = "update " + this.getVoucherTable() + " set fnumber=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getNumber(), voucherInfo.getId().toString()});
        }
    }

    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return PcVoucherUtil.isExistVoucherCodingRule(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString(), (PcVoucherInfo)voucherInfo, VoucherStatusEnum.AUDITTED);
    }

    protected String getVoucherTable() {
        return "t_pca_pcvoucher";
    }

    protected void updateAuditStatus(Context ctx, BaseVoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException {
        PcVoucherOprateSharer.updateVoucherStatus(ctx, voucherInfo.getId().toString(), auditorId.toString(), VoucherStatusEnum.AUDITTED.getValue(), "FAuditorId");
    }

    protected void afterAudit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, BgCtrlException, EASBizException {
        PcVoucherUtil.requestBudgetSubstract(ctx, (PcVoucherInfo)baseVoucherInfo, this.sysParam, 8);
    }
}

