/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherCancelPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFacadeFactory;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynPcVoucherCancelPostProcessor
implements IVoucherCancelPostProcessor {
    protected static final Logger logger = Logger.getLogger(SynPcVoucherCancelPostProcessor.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;
    private static final String NEW_VOUCHER_NUMBER = "newVoucherNumber";

    public void process(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, SynVoucherUtil.getSynPcVoucherSelector());
        PeriodInfo voucherPeriodInfo = SynVoucherUtil.getVoucherPeriod(ctx, voucherInfo.getPeriod());
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.AUDIT);
            this.cancelVoucher(ctx, (IObjectPK)new ObjectUuidPK(pcVoucherInfo.getId().toString()));
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    public void cancelVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block7: {
            BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this.iVoucher.getValue(pk, this.getCancelSelector());
            try {
                this._cancelVoucher(ctx, (IObjectValue)voucherInfo);
            }
            catch (Exception e) {
                if (voucherInfo.get(NEW_VOUCHER_NUMBER) != null) {
                    try {
                        this.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get(NEW_VOUCHER_NUMBER));
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Recycle voucher number error when save voucher!", (Throwable)ex);
                    }
                }
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                if (!(e instanceof RuntimeException)) break block7;
                throw (RuntimeException)e;
            }
        }
    }

    protected SelectorItemCollection getCancelSelector() {
        return PcVoucherInfo.getDefaultProcessSelector();
    }

    protected void _cancelVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)model;
        HashMap hmAllParam = this.getParamMap(ctx, voucherInfo);
        this.beforeCancel(ctx, voucherInfo, hmAllParam);
        this.insertVoucherLog(ctx, voucherInfo);
        this.operateSharer.updateVoucherStatus(ctx, voucherInfo, VoucherStatusEnum.CANCELLED);
        this.afterCancel(ctx, voucherInfo);
        BgControlCaller bgControlCaller = new BgControlCaller();
        bgControlCaller.returnBudget(ctx, voucherInfo.getId());
    }

    protected HashMap getParamMap(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        HashMap paramMap = PcaUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString());
        paramMap.putAll(PcaUtils.getDefaultPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString()));
        return paramMap;
    }

    protected void beforeCancel(Context ctx, BaseVoucherInfo voucherInfo, Map hmAllParam) throws EASBizException, BOSException {
        boolean removeDAP_void = Boolean.valueOf(hmAllParam.get("PCA_019_1").toString());
        if (voucherInfo.isIsReverseVoucher()) {
            String srcVchId = voucherInfo.getSourceBillId();
            PcVoucherInfo srcVch = new PcVoucherInfo();
            BOSUuid id = BOSUuid.read((String)srcVchId);
            srcVch.setId(id);
            srcVch.setHasReversed(false);
            this.iVoucher.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)srcVch);
        }
        this.processDap(ctx, voucherInfo, removeDAP_void);
        voucherInfo.setBizStatus(VoucherStatusEnum.CANCELLED);
        if (this.existCodingRule(ctx, voucherInfo)) {
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            ctx.put((Object)"GL_VOUCHERNUMBER_LOG", hmAllParam.get("GL_VOUCHERNUMBER_LOG"));
            this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
            voucherInfo.setBizStatus(VoucherStatusEnum.CANCELLED);
            voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.CANCELLED));
        } else {
            voucherInfo.setBizStatus(VoucherStatusEnum.CANCELLED);
        }
        voucherInfo.setCanceller(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (!voucherInfo.isIsReverseVoucher()) {
            voucherInfo.setIsReverseVoucher(false);
            if (removeDAP_void) {
                voucherInfo.setSourceBillId(null);
            }
        }
    }

    protected void processDap(Context ctx, BaseVoucherInfo voucherInfo, boolean removeDAP_void) throws BOSException, EASBizException {
        if (removeDAP_void && (SourceType.NONE.equals((Object)voucherInfo.getSourceType()) || voucherInfo.getSourceBillId() != null)) {
            IDAPTransformer iDAPTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            iDAPTransformer.undoTransformFromVoucher((BaseVoucherInfo)((PcVoucherInfo)voucherInfo));
        }
    }

    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (PcVoucherInfo)voucherInfo, voucherInfo.getBizStatus());
    }

    protected void recycleVoucherId(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            Throwable ex = null;
            try {
                this.iVoucher.recycleVoucherNumber(voucherInfo, voucherNumber);
            }
            catch (BOSException e) {
                ex = e;
                throw e;
            }
            catch (EASBizException e) {
                ex = e;
                throw e;
            }
            finally {
                boolean isLogVoucherNumber = false;
                if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                    isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
                }
                if (isLogVoucherNumber) {
                    this.logVoucherNumber(ctx, voucherInfo, voucherNumber, (Exception)ex);
                }
            }
        } else {
            BaseVoucherInfo previousVoucher = null;
            String[] value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    protected void logVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber, Exception ex) throws BOSException, EASBizException {
        PcVoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber((PcVoucherInfo)voucherInfo, voucherNumber, "recycleNumber", ex);
    }

    private void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 5, true, voucherInfo.getBizStatus() == VoucherStatusEnum.POSTED);
    }

    protected void afterCancel(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }
}

