/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherDeletePostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynPcVoucherDeletePostProcessor
implements IVoucherDeletePostProcessor {
    private static Logger logger = Logger.getLogger(SynPcVoucherDeletePostProcessor.class);
    protected IVoucherOprateSharer operateSharer;
    protected GlParam sysParam = null;
    protected IBaseVoucher iVoucher;

    public SynPcVoucherDeletePostProcessor() {
    }

    public SynPcVoucherDeletePostProcessor(IVoucherOprateSharer optSharer, IBaseVoucher iPcVoucher) {
        this.operateSharer = optSharer;
        this.iVoucher = iPcVoucher;
    }

    public void process(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, PcVoucherInfo.getDefaultSelector());
        PeriodInfo voucherPeriodInfo = SynVoucherUtil.getVoucherPeriod(ctx, voucherInfo.getPeriod());
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.DELETE);
            SynVoucherUtil.deleteBOTRelation(ctx, voucherInfo.getId().toString(), pcVoucherInfo.getId().toString());
            this.deleteVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo, false);
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    public void deleteVoucher(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        this.initGlParam(ctx, voucherInfo);
        if (voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            this.returnBudget(ctx, voucherInfo);
            this.clearReqRelation(ctx, voucherInfo, this.sysParam);
        }
        this.clearactAcctcussent(ctx, voucherInfo, this.sysParam);
        this.recycleVoucherNumber(ctx, voucherInfo);
        this.insertVoucherLog(ctx, voucherInfo);
        String logDetail = voucherInfo.getVoucherType().getName(ctx.getLocale()) + "-" + voucherInfo.getNumber();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)voucherInfo.getBOSType(), null, (String)logDetail, (String)this.getLogItemName());
        this.undoTransformFromVoucher(ctx, voucherInfo);
        this.delete(ctx, voucherInfo, this.sysParam);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        if (isFromGL) {
            this.submitDeleteWorkFlow(ctx, voucherInfo);
        }
        if (!isFromGL) {
            this.clearWebServiceCache(ctx, voucherInfo);
            this.submitDeleteWorkFlow(ctx, voucherInfo);
        }
        this.clearCFRequisition(ctx, voucherInfo);
        this.deleteBksVoucherMessage(ctx, voucherInfo, this.sysParam);
        this.deleteAdjustExchangeRateHistory(ctx, voucherInfo);
        this.deleteAutoTransVoucherRef(ctx, voucherInfo);
        this.deleteTransPLHistory(ctx, voucherInfo);
        if (voucherInfo.isIsReverseVoucher()) {
            this.clearReverseRelation(ctx, (PcVoucherInfo)voucherInfo);
        } else if (PcVoucherUtil.isAmortVoucher((PcVoucherInfo)voucherInfo)) {
            this.deleteAmortLog(ctx, (PcVoucherInfo)voucherInfo);
        }
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IDeleteVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"GL_009", "GLG01", "GL_028", "GL_052", "GLG02", "GL_060", "GL015"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "IDeleteVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        PcaParam glParam = PcaParam.getPcaParams(ctx, "PCA_019", profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private void returnBudget(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        BgControlCaller bgControlCaller = new BgControlCaller();
        bgControlCaller.returnBudget(ctx, BOSUuid.read((String)voucherInfo.getId().toString()));
    }

    private void clearReqRelation(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        boolean useAC = sysParam.getBoolean("GLG01");
        if (useAC) {
            IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance((Context)ctx);
            reqCtrl.clearReqRelation("'" + voucherInfo.getId().toString() + "'", true);
        }
    }

    private void clearactAcctcussent(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws GLException, BOSException {
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    protected void recycleVoucherNumber(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        if (PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getProfitCenter().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
            this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
        } else {
            VoucherStatusEnum bizStatus = voucherInfo.getBizStatus();
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            if (PcVoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getProfitCenter().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
                this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
            }
            voucherInfo.setBizStatus(bizStatus);
        }
    }

    protected void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.operateSharer.getVoucherStatus(ctx, voucherInfo) == VoucherStatusEnum.SUBMITTED) {
            this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 7, true, false);
        }
    }

    protected void undoTransformFromVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        if (SourceType.NONE.equals((Object)voucherInfo.getSourceType()) || voucherInfo.getSourceBillId() != null) {
            IDAPTransformer iDAPTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            iDAPTransformer.undoTransformFromVoucher((BaseVoucherInfo)voucherInfo);
        }
    }

    protected String getLogItemName() {
        return "pca_voucher_remove";
    }

    protected void delete(Context ctx, BaseVoucherInfo baseVoucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherUtil._deleteAllAssistRecords(ctx, voucherInfo);
        PcVoucherUtil._deleteAllEntries(ctx, voucherInfo);
        PcVoucherUtil._deleteVoucher(ctx, voucherInfo);
    }

    private void submitDeleteWorkFlow(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.iVoucher.deleteFun((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
    }

    private void clearWebServiceCache(Context ctx, BaseVoucherInfo voucherInfo) {
        GlWebServiceUtil.setWsObjectKeyMap((Context)ctx, (String)voucherInfo.getCompany().getNumber(), (String)"voucher", (String)voucherInfo.getDescription());
    }

    private void clearCFRequisition(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance((Context)ctx);
        iCFReq.clearRequisition((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
    }

    private void deleteBksVoucherMessage(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean canModifyVoucherFromMain = sysParam.getBoolean("GL015");
        if (!BooksUtil.isMasterBook((Context)ctx) && voucherInfo.isIsAccountCopy()) {
            String sql = "delete  from T_BKS_VoucherMessage where FTagVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    protected void deleteAdjustExchangeRateHistory(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType())) {
            String sql = "delete  from T_GL_adjexchratehistory where FVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
            sql = "delete  from T_GL_AdjRateVoucherRef where FVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void deleteAutoTransVoucherRef(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"delete from t_gl_AutoTransVoucherRef where fvoucherid = ?", (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    protected void deleteTransPLHistory(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        if (SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
            String sql = "delete  from T_GL_TransPlProgramVoucher where FVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void clearReverseRelation(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        BOTRelationCollection relationCol;
        ObjectUuidPK pk = new ObjectUuidPK(voucherInfo.getId().toString());
        String srcVchId = voucherInfo.getSourceBillId();
        if (srcVchId != null) {
            this.removeRelation(ctx, srcVchId, (IObjectPK)pk);
        }
        if ((relationCol = PcVoucherUtil._getBotRelation(ctx, pk.toString(), voucherInfo.getBOSType())) != null) {
            int n = relationCol.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = relationCol.get(i);
                this.removeRelation(ctx, bot.getSrcObjectID(), (IObjectPK)pk);
            }
        }
    }

    private void removeRelation(Context ctx, String srcVchId, IObjectPK pk) throws BOSException, EASBizException {
        PcVoucherInfo srcVch = new PcVoucherInfo();
        BOSUuid id = BOSUuid.read((String)srcVchId);
        srcVch.setId(id);
        if (this.operateSharer.isVoucherExisted(ctx, (BaseVoucherInfo)srcVch)) {
            PcVoucherInfo reverVch = (PcVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(srcVchId), PcVoucherInfo.getReverseSelector());
            srcVch.setDescription(null);
            String strIndex = "(" + reverVch.getPeriod().getPeriodYear() + "." + reverVch.getPeriod().getPeriodNumber() + ")";
            String des = reverVch.getDescription();
            if (des != null) {
                if (des.indexOf("_") > 0) {
                    if (des.substring(0, des.lastIndexOf("_")).indexOf(strIndex) > -1) {
                        srcVch.setDescription(des.substring(des.indexOf(strIndex) + strIndex.length() + 1));
                    } else {
                        String bStr = des.substring(0, des.indexOf(strIndex));
                        String eStr = des.substring(des.indexOf(strIndex));
                        bStr = bStr.substring(bStr.indexOf("_") + 1);
                        eStr = eStr.substring(eStr.indexOf(strIndex) + strIndex.length());
                        srcVch.setDescription(bStr + eStr);
                    }
                } else if (des.indexOf(strIndex) > 0) {
                    srcVch.setDescription(des.substring(des.indexOf(strIndex) + strIndex.length()));
                } else {
                    srcVch.setDescription(des);
                }
            }
            srcVch.setId(id);
            srcVch.setHasReversed(false);
            PcVoucherUtil._removeBotRelation(ctx, srcVchId, pk.toString(), srcVch.getBOSType());
            this.iVoucher.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)srcVch);
        }
    }

    public void deleteAmortLog(Context ctx, PcVoucherInfo voucherInfo) throws BOSException {
        String sqlAmortLog = "select vlog.FID,vlog.FAmortSchemeID,vlog.FPeriodID,vs.FAmortAmount,policy.famount FPolicyAmount  from t_gl_vchamortlog vlog inner join t_gl_vchamortscheme vs on vlog.famortschemeid=vs.fid  inner join t_gl_vchamortpolicy policy on policy.famortschemeid=vs.fid and policy.fperiodid=vlog.fperiodid  where vlog.FVoucherID=?";
        IRowSet rsAmortLog = DbUtil.executeQuery((Context)ctx, (String)sqlAmortLog, (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rsAmortLog.next()) {
                String amortSchemeId = rsAmortLog.getString("FAmortSchemeID");
                String periodId = rsAmortLog.getString("FPeriodID");
                String logId = rsAmortLog.getString("FID");
                BigDecimal amortAmount = rsAmortLog.getBigDecimal("FAmortAmount");
                BigDecimal policyAmount = rsAmortLog.getBigDecimal("FPolicyAmount");
                BigDecimal leftAmortAmount = amortAmount.subtract(policyAmount);
                String status = "1";
                if (leftAmortAmount.signum() != 0) {
                    status = "2";
                }
                String updateScheme = "update t_gl_vchamortscheme set famortamount=?,fstatus=? where fid=?";
                DbUtil.execute((Context)ctx, (String)updateScheme, (Object[])new Object[]{leftAmortAmount, new Integer(status), amortSchemeId});
                String updatePolicy = "update t_gl_vchamortpolicy set fisvouchered=0 where famortschemeid=? and fperiodid=?";
                DbUtil.execute((Context)ctx, (String)updatePolicy, (Object[])new Object[]{amortSchemeId, periodId});
                String delLog = "delete from t_gl_vchamortlog where fid=?";
                DbUtil.execute((Context)ctx, (String)delLog, (Object[])new Object[]{logId});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

