/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPostPostProcessor;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.PcaPeriodEndException;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynPcVoucherPostPostProcessor
implements IVoucherPostPostProcessor {
    protected static final Logger logger = Logger.getLogger(SynPcVoucherPostPostProcessor.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;

    public void process(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherCollection pcVoucherColl = SynVoucherUtil.getPcVoucherCollectionBySourceBillId(ctx, voucherInfo, PcVoucherInfo.getPostVoucherSelector());
        PeriodInfo voucherPeriodInfo = VoucherProcessCache.getPeriod((Context)ctx, (String)voucherInfo.getPeriod().getId().toString());
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.POST);
            this.postVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo, null);
        }
    }

    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new PcVoucherOprateSharer(ctx);
    }

    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return PcVoucherFactory.getLocalInstance((Context)ctx);
    }

    public void postVoucher(Context ctx, BaseVoucherInfo voucherInfo, Map checkViews) throws BOSException, EASBizException {
        this.initGlParam(ctx, voucherInfo);
        voucherInfo.setBizStatus(this.operateSharer.getVoucherStatus(ctx, voucherInfo));
        this.validatorVoucher(ctx, voucherInfo);
        this.doPost(ctx, voucherInfo, this.sysParam, checkViews);
        this.insertVoucherLog(ctx, voucherInfo);
        this.synVoucher2Books(ctx, voucherInfo, this.sysParam);
        this.submitworkflow(ctx, voucherInfo);
    }

    public void validatorVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.checkCloseInit(ctx, voucherInfo);
    }

    private void checkCloseInit(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo curPro = voucherInfo.getProfitCenter();
        boolean isClosed = false;
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getGLCloseInitStateMap().containsKey(curPro.getId().toString())) {
            isClosed = (Boolean)cache.getGLCloseInitStateMap().get(curPro.getId().toString());
        } else {
            isClosed = PcVoucherUtil.closeInit(ctx, curPro.getId().toString(), voucherInfo.getCompany().getId().toString(), voucherInfo.getCompany().getAccountTable().getId().toString());
            if (cache != null) {
                cache.getGLCloseInitStateMap().put(curPro.getId().toString(), isClosed);
            }
        }
        if (!isClosed) {
            this.checkAccountInited(ctx, voucherInfo);
            this.checkAssitInited(ctx, voucherInfo);
        }
    }

    private void checkAccountInited(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo curCompany = voucherInfo.getProfitCenter();
        boolean isAccountClosed = false;
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        isAccountClosed = cache != null && cache.getAccountInitStateMap().containsKey(curCompany.getId().toString()) ? (Boolean)cache.getAccountInitStateMap().get(curCompany.getId().toString()) : PcVoucherUtil.isAccountInited(ctx, curCompany.getId().toString());
        if (!isAccountClosed) {
            throw new PcaPeriodEndException(PcaPeriodEndException.PCA_INIT_NOT_CLOSED);
        }
    }

    private void checkAssitInited(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        String curCompanyID = voucherInfo.getProfitCenter().getId().toString();
        Map checkMap = null;
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        checkMap = cache != null ? cache.getAssistInitStateMap() : PcVoucherUtil.checkAssitInited(ctx, "'" + voucherInfo.getId().toString() + "'", curCompanyID);
        if (checkMap != null && checkMap.containsKey(voucherInfo.getId().toString())) {
            String errMsg = ((StringBuffer)checkMap.get(voucherInfo.getId().toString())).toString();
            throw new PcaPeriodEndException(PcaPeriodEndException.ASST_INIT_NOT_CLOSED, new String[]{errMsg});
        }
    }

    private void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "ISubmitVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"PCA_032", "PCA_046", "PCA_031"};
        PcaParam glParam = PcaParam.getPcaParams(ctx, paramList, profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IPostVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache((Context)ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = this.getParamList();
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected String[] getParamList() {
        String[] paramList = new String[]{"G001", "G012", "G010", "GLG01", "GLG01_2", "GL_008", "GL_028", "GL_052", "GL_056", "GL_VCH_POST_CONTROL"};
        return paramList;
    }

    private void doPost(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, Map checkViews) throws EASBizException, BOSException {
        this.post(ctx, voucherInfo, sysParam, checkViews);
        this.updateVoucherPostedStatus(ctx, voucherInfo);
    }

    protected void post(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, Map checkViews) throws EASBizException, BOSException {
    }

    protected void updateVoucherPostedStatus(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("Update t_pca_pcvoucher                                      \r\n");
        sqlUpdate.append("Set FBizStatus = 5 ,FPosterID = ?, FLastUpdateTime = ?   \r\n");
        sqlUpdate.append("Where FProfitCenterID = ? and FBizStatus =3 and fid = ? ");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])new Object[]{user.getId().toString(), GlUtils.getTime(), ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString(), voucherInfo.getId().toString()});
    }

    protected void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 3, false, true);
    }

    protected void synVoucher2Books(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
    }

    private void submitworkflow(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        boolean useWorkflow = false;
        if (useWorkflow) {
            this.iVoucher.postVoucher((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }
}

