/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastEntry;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryCollection;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryFactory;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAdjExchRateHistory;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherSubmitPostProcessor;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherEntryAutoBalance;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherPersistence;
import com.kingdee.eas.ma.pca.app.voucher.SubmitPcVoucherServiceHelper;
import com.kingdee.eas.ma.pca.app.voucher.SynPcVoucherDeletePostProcessor;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class SynPcVoucherSubmitPostProcessor
implements IVoucherSubmitPostProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.voucher.SynPcVoucherSubmitPostProcessor");
    protected GlParam sysParam = null;
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";
    protected SubmitPcVoucherServiceHelper helper = new SubmitPcVoucherServiceHelper();
    protected Map<String, Set<String>> orgProfitAcctMapping = new HashMap<String, Set<String>>();
    protected Map<String, Boolean> relatedCompanyCurrencyMapping = new HashMap<String, Boolean>();
    protected Map<String, AssistCustomizedPropertyCollection> accountAssistCustomizedMapping = new HashMap<String, AssistCustomizedPropertyCollection>();
    protected Map<String, CompanyOrgUnitInfo> profitRelatedCompanyMapping = new HashMap<String, CompanyOrgUnitInfo>();
    protected Set<String> profitAcctIds = new HashSet<String>();

    protected PcVoucherCollection getPcVoucherColl(Context ctx, VoucherInfo voucherInfo, int submit_value) throws EASBizException, BOSException {
        return SynVoucherUtil.transVoucher2PcVoucherCollectionNew(ctx, voucherInfo, 1);
    }

    public void process(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        boolean isAdjust = SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType());
        String companyId = voucherInfo.getCompany().getId().toString();
        boolean commonVoucherProcess = SynVoucherUtil.isNeedSynPcVoucher(ctx, companyId);
        boolean useProfitCenterAccount = SynVoucherUtil.isUseProfitCenterAccount(ctx, companyId);
        if (!commonVoucherProcess) {
            return;
        }
        this.validate(ctx, voucherInfo, commonVoucherProcess, useProfitCenterAccount);
        PcVoucherCollection pcVoucherColl = this.getPcVoucherColl(ctx, voucherInfo, 1);
        PeriodInfo voucherPeriodInfo = VoucherProcessCache.getPeriod((Context)ctx, (String)voucherInfo.getPeriod().getId().toString());
        if (null == voucherInfo.getCreator().getName()) {
            voucherInfo.getCreator().setName(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
        }
        if (null == voucherInfo.getCreator().getNumber()) {
            voucherInfo.getCreator().setNumber(ContextUtil.getCurrentUserInfo((Context)ctx).getNumber());
        }
        BOTRelationInfo botRelationInfo = this.getSynBOTRelationInfo(voucherInfo);
        HashSet<String> idSet = new HashSet<String>();
        this.iVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        this.operateSharer = new PcVoucherOprateSharer(ctx);
        HashMap profitCenterVoucherType = new HashMap();
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherInfo.getProfitCenter(), VoucherOperateStatusEnum.SUBMIT);
            SynVoucherUtil.profitCenterBalanceDebitCreditAmount(ctx, pcVoucherInfo);
            CompanyOrgUnitInfo company = PcaUtils.getRelatedCompany(ctx, pcVoucherInfo.getProfitCenter().getId().toString());
            if (pcVoucherInfo.getProfitCenter() != null && pcVoucherInfo.getProfitCenter().getCU() != null && pcVoucherInfo.getProfitCenter().getCU().getId() != null) {
                String cuId = pcVoucherInfo.getProfitCenter().getCU().getId().toString();
                FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU");
                VoucherTypeCollection vtCol = PcaUtils.getVoucherTypeCollection(ctx, filterVT, cuId);
                if (vtCol.isEmpty() && company != null) {
                    cuId = company.getCU().getId().toString();
                    filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU");
                    vtCol = PcaUtils.getVoucherTypeCollection(ctx, filterVT, cuId);
                }
                VoucherTypeInfo defaultVoucherType = null;
                VoucherTypeInfo voucherType = pcVoucherInfo.getVoucherType();
                boolean isExist = false;
                if (vtCol != null && vtCol.size() > 0) {
                    VoucherTypeInfo vtDefault = vtCol.get(0);
                    for (VoucherTypeInfo vt : vtCol) {
                        if (voucherType.getId().toString().equals(vt.getId().toString())) {
                            isExist = true;
                        }
                        if (!vt.isPretermit()) continue;
                        vtDefault = vt;
                    }
                    defaultVoucherType = vtDefault;
                }
                if (!isExist) {
                    pcVoucherInfo.setVoucherType(defaultVoucherType);
                }
                if (pcVoucherInfo.getVoucherType() == null) {
                    String msg = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1096_MainProfitCenterDoNotHasVoucherType"), pcVoucherInfo.getProfitCenter().getName());
                    throw new EASBizException(new NumericExceptionSubItem("102", msg.toString()));
                }
            }
            pcVoucherInfo.put("isAdjust", (Object)isAdjust);
            IObjectPK pk = this.submitVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo);
            this.insertSynBOTRelation(ctx, botRelationInfo, pk);
            idSet.add(pk.toString());
        }
        VoucherStatusEnum status = (VoucherStatusEnum)voucherInfo.get("old_bizStatus");
        if (status == null || VoucherStatusEnum.TEMP.equals((Object)status)) {
            return;
        }
        this.deleteNotSynPcVoucher(ctx, voucherInfo.getId().toString(), idSet);
    }

    private Set<String> getRelatedCompanyIds(Context ctx, String profitCenterId) throws BOSException {
        Map datas = VoucherProcessCache.getDatas((Context)ctx, (String)"getRelatedCompanyIds");
        if (datas.containsKey(profitCenterId)) {
            return (Set)datas.get(profitCenterId);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(profitCenterId);
        Set relatedCompanyIdSet = GlUtils.getRelatedCompanyIds((Context)ctx, idSet);
        datas.put(profitCenterId, relatedCompanyIdSet);
        return relatedCompanyIdSet;
    }

    public void validate(Context ctx, VoucherInfo voucherInfo, boolean commonVoucherProcess, boolean useProfitCenterAccount) throws BOSException, EASBizException {
        if (!commonVoucherProcess || !useProfitCenterAccount) {
            return;
        }
        this.getOrgProfitAcctMapping(ctx, voucherInfo);
        StringBuffer msg = new StringBuffer();
        Iterator iter = voucherInfo.getEntries().iterator();
        String companyId = voucherInfo.getCompany().getId().toString();
        while (iter.hasNext()) {
            VoucherEntryInfo entryInfo = (VoucherEntryInfo)iter.next();
            if (entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().getId() == null) continue;
            ProfitCenterOrgUnitInfo profitCenterInfo = entryInfo.getProfitCenter();
            String profitCenterId = profitCenterInfo.getId().toString();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(profitCenterId);
            Set<String> relatedCompanyIdSet = this.getRelatedCompanyIds(ctx, profitCenterId);
            String relatedCompanyId = (String)relatedCompanyIdSet.toArray()[0];
            boolean isMainRelatedCompany = companyId.equals(relatedCompanyId);
            boolean isAsstAccountChange = this.getIsAsstAccountChange(ctx, entryInfo.getAccount().getId().toString());
            if (isMainRelatedCompany && !isAsstAccountChange) continue;
            CompanyOrgUnitInfo relatedCompany = null;
            if (this.profitRelatedCompanyMapping.containsKey(profitCenterId)) {
                relatedCompany = this.profitRelatedCompanyMapping.get(profitCenterId);
            } else {
                relatedCompany = GlUtils.getCompanyById((Context)ctx, (String)relatedCompanyId);
                this.profitRelatedCompanyMapping.put(profitCenterId, relatedCompany);
            }
            if (this.orgProfitAcctMapping.get(relatedCompanyId) == null) {
                msg.append(this.checkAccountNumber(ctx, entryInfo, relatedCompany));
                continue;
            }
            Set<Object> acctIds = this.orgProfitAcctMapping.get(relatedCompanyId) != null ? this.orgProfitAcctMapping.get(relatedCompanyId) : new HashSet();
            if (acctIds.contains(entryInfo.getAccount().getId().toString())) continue;
            msg.append(this.checkAccountNumber(ctx, entryInfo, relatedCompany));
        }
        if (msg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("102", msg.toString()));
        }
    }

    protected String checkAccountNumber(Context ctx, VoucherEntryInfo entryInfo, CompanyOrgUnitInfo relatedCompany) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer();
        int seq = entryInfo.getSeq();
        String profitCenterId = entryInfo.getProfitCenter().getId().toString();
        String profitCenterName = entryInfo.getProfitCenter().getName();
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        String accountNumber = accountViewInfo != null ? accountViewInfo.getNumber() : "";
        String accountId = accountViewInfo != null ? accountViewInfo.getId().toString() : "";
        AccountTableInfo accountTableInfo = relatedCompany.getAccountTable();
        String accountTableId = accountTableInfo != null ? accountTableInfo.getId().toString() : "";
        String relatedCompanyId = relatedCompany.getId().toString();
        CurrencyInfo currencyInfo = entryInfo.getCurrency();
        AccountViewInfo mainAccountViewInfo = null;
        String accountKey = profitCenterId + accountId;
        if (VoucherProcessCache.getCache((Context)ctx).getRelatedCompanyAccountMapping().containsKey(accountKey)) {
            mainAccountViewInfo = (AccountViewInfo)VoucherProcessCache.getCache((Context)ctx).getRelatedCompanyAccountMapping().get(accountKey);
        } else {
            mainAccountViewInfo = this.getAccountViewInfo(ctx, accountNumber, accountTableId, relatedCompanyId);
            VoucherProcessCache.getCache((Context)ctx).setRelatedCompanyAccountMapping(accountKey, mainAccountViewInfo);
        }
        if (mainAccountViewInfo == null) {
            String mainCompanyDoNotHasAccount = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1090_MainCompanyDoNotHasAccount", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber);
            msg.append(mainCompanyDoNotHasAccount).append("\r\n ");
        } else if (mainAccountViewInfo.isIsCFreeze()) {
            String mainCompanyAccountIsCFreeze = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1097_MainCompanyAccountIsCFreeze", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber);
            msg.append(mainCompanyAccountIsCFreeze).append("\r\n ");
        } else if (!mainAccountViewInfo.isIsLeaf()) {
            String mainCompanyAccountIsNotLeaf = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1091_MainCompanyAccountIsNotLeaf", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber);
            msg.append(mainCompanyAccountIsNotLeaf).append("\r\n ");
        } else {
            boolean hasON = false;
            String currencyKey = mainAccountViewInfo.getId().toString() + currencyInfo.getId().toString() + relatedCompany.getId().toString();
            hasON = this.relatedCompanyCurrencyMapping.containsKey(currencyKey) ? this.relatedCompanyCurrencyMapping.get(currencyKey).booleanValue() : this.checkCurrencyAndMainAccount(ctx, mainAccountViewInfo, currencyInfo, relatedCompany);
            if (!hasON) {
                String name = currencyInfo.getName();
                if (StringUtils.isEmpty((Object)name)) {
                    name = this.getCurrencyInfo(ctx, currencyInfo.getId().toString()).getName();
                }
                String mainAccountDoNotHasCurrency = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1092_MainAccountDoNotHasCurrency", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber, name);
                msg.append(mainAccountDoNotHasCurrency).append("\r\n ");
            } else {
                AsstAccountInfo entryAccountCaa = entryInfo.getCAA();
                AsstAccountInfo mainAccountCaa = mainAccountViewInfo.getCAA();
                IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
                if (entryAccountCaa == null && mainAccountCaa != null || entryAccountCaa != null && mainAccountCaa != null && !iAsstAccount.compare((IObjectPK)new ObjectUuidPK(mainAccountCaa.getId().toString()), (IObjectPK)new ObjectUuidPK(entryAccountCaa.getId().toString()))) {
                    boolean isAsstAccountChange = this.getIsAsstAccountChange(ctx, mainAccountViewInfo.getId().toString());
                    if (!isAsstAccountChange) {
                        StringBuffer msgName = new StringBuffer();
                        String[] mainCaaName = mainAccountCaa != null ? mainAccountCaa.getName().split("\\+") : new String[]{};
                        String[] entryCaaName = entryAccountCaa != null ? entryAccountCaa.getName().split("\\+") : new String[]{};
                        List<String> mainCaaList = Arrays.asList(mainCaaName);
                        List<String> entryCaaList = Arrays.asList(entryCaaName);
                        for (String str : mainCaaList) {
                            if (entryCaaList.contains(str)) continue;
                            msgName.append(str).append("+");
                        }
                        if (msgName.length() > 0) {
                            msgName.deleteCharAt(msgName.length() - 1);
                        }
                        String mainCompanyDoNotHasAsstAccount = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1093_MainCompanyDoNotHasAsstAccount", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber, msgName.toString());
                        msg.append(mainCompanyDoNotHasAsstAccount).append("\r\n ");
                    } else {
                        String checkAccountIsNecessary;
                        boolean userPropertySame;
                        if (mainAccountViewInfo.isHasUserProperty() && !(userPropertySame = this.checkIsSameUserProperty(ctx, accountViewInfo, mainAccountViewInfo)) && (checkAccountIsNecessary = this.checkAccountIsNecessary(ctx, mainAccountViewInfo)).length() > 0) {
                            String mainAccountPropertyIsNecessary = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1095_MainAccountPropertyIsNecessary", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber, checkAccountIsNecessary);
                            msg.append(mainAccountPropertyIsNecessary).append("\r\n");
                        }
                        VoucherProcessCache.getCache((Context)ctx).setRelatedCompanyAccountSuccessMapping(accountKey, mainAccountViewInfo);
                    }
                } else {
                    String checkAccountIsNecessary;
                    boolean userPropertySame;
                    if (mainAccountViewInfo.isHasUserProperty() && !(userPropertySame = this.checkIsSameUserProperty(ctx, accountViewInfo, mainAccountViewInfo)) && (checkAccountIsNecessary = this.checkAccountIsNecessary(ctx, mainAccountViewInfo)).length() > 0) {
                        String mainAccountPropertyIsNecessary = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1095_MainAccountPropertyIsNecessary", (Locale)ctx.getLocale()), seq, profitCenterName, accountNumber, checkAccountIsNecessary);
                        msg.append(mainAccountPropertyIsNecessary).append("\r\n");
                    }
                    VoucherProcessCache.getCache((Context)ctx).setRelatedCompanyAccountSuccessMapping(accountKey, mainAccountViewInfo);
                }
            }
        }
        return msg.toString();
    }

    private boolean getIsAsstAccountChange(Context ctx, String accountId) throws BOSException {
        Map datas = VoucherProcessCache.getDatas((Context)ctx, (String)"getIsAsstAccountChange");
        if (datas.containsKey(accountId)) {
            return (Boolean)datas.get(accountId);
        }
        boolean result = false;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid from t_bd_asstaccountchange where faccountid = ").append("'").append(accountId).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            result = false;
            throw new BOSException((Throwable)e);
        }
        datas.put(accountId, result);
        return result;
    }

    private String checkAccountIsNecessary(Context ctx, AccountViewInfo mainAccountViewInfo) throws BOSException {
        StringBuffer result = new StringBuffer();
        String mainAccountId = mainAccountViewInfo.getId().toString();
        AssistCustomizedPropertyCollection mainCustomizedPropertyCollection = null;
        if (this.accountAssistCustomizedMapping.containsKey(mainAccountId)) {
            mainCustomizedPropertyCollection = this.accountAssistCustomizedMapping.get(mainAccountId);
        } else {
            mainCustomizedPropertyCollection = this.getCustomizedPropertyCollection(ctx, mainAccountId);
            this.accountAssistCustomizedMapping.put(mainAccountId, mainCustomizedPropertyCollection);
        }
        if (mainCustomizedPropertyCollection != null && mainCustomizedPropertyCollection.size() > 0) {
            for (int i = 0; i < mainCustomizedPropertyCollection.size(); ++i) {
                AssistCustomizedPropertyInfo customPropInfo = mainCustomizedPropertyCollection.get(i);
                if (!customPropInfo.isIsCreditNecessary() && !customPropInfo.isIsDebitNecessary()) continue;
                result.append(customPropInfo.getCustomizedType().getName());
                if (i == mainCustomizedPropertyCollection.size() - 1) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    private boolean checkIsSameUserProperty(Context ctx, AccountViewInfo accountViewInfo, AccountViewInfo mainAccountViewInfo) throws BOSException {
        if (!accountViewInfo.isHasUserProperty()) {
            return false;
        }
        AssistCustomizedPropertyCollection customizedPropertyCollection = null;
        AssistCustomizedPropertyCollection mainCustomizedPropertyCollection = null;
        String accountId = accountViewInfo.getId().toString();
        String mainAccountId = mainAccountViewInfo.getId().toString();
        if (this.accountAssistCustomizedMapping.containsKey(accountId)) {
            customizedPropertyCollection = this.accountAssistCustomizedMapping.get(accountId);
        } else {
            customizedPropertyCollection = this.getCustomizedPropertyCollection(ctx, accountId);
            this.accountAssistCustomizedMapping.put(accountId, customizedPropertyCollection);
        }
        if (this.accountAssistCustomizedMapping.containsKey(mainAccountId)) {
            mainCustomizedPropertyCollection = this.accountAssistCustomizedMapping.get(mainAccountId);
        } else {
            mainCustomizedPropertyCollection = this.getCustomizedPropertyCollection(ctx, mainAccountId);
            this.accountAssistCustomizedMapping.put(mainAccountId, mainCustomizedPropertyCollection);
        }
        if (customizedPropertyCollection != null && customizedPropertyCollection.size() > 0 && mainCustomizedPropertyCollection != null && mainCustomizedPropertyCollection.size() > 0) {
            int mainSize;
            int size = customizedPropertyCollection.size();
            if (size != (mainSize = mainCustomizedPropertyCollection.size())) {
                return false;
            }
            int sameCount = 0;
            for (int i = 0; i < size; ++i) {
                AssistCustomizedPropertyInfo customPropInfo = customizedPropertyCollection.get(i);
                for (int j = 0; j < size; ++j) {
                    AssistCustomizedPropertyInfo mainCustomPropInfo = mainCustomizedPropertyCollection.get(j);
                    if (!customPropInfo.getCustomizedType().getId().toString().equals(mainCustomPropInfo.getCustomizedType().getId().toString())) continue;
                    ++sameCount;
                }
            }
            if (sameCount != size) {
                return false;
            }
        }
        return true;
    }

    private AssistCustomizedPropertyCollection getCustomizedPropertyCollection(Context ctx, String accountId) throws BOSException {
        AssistCustomizedPropertyCollection customizedPropertyCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("ISDEBITNECESSARY"));
        sic.add(new SelectorItemInfo("ISCREDITNECESSARY"));
        sic.add(new SelectorItemInfo("customizedType.id"));
        sic.add(new SelectorItemInfo("customizedType.name"));
        sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("account.id", (Object)accountId));
        filterItems.add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setFilter(filterInfo);
        IAssistCustomizedProperty customProp = AssistCustomizedPropertyFactory.getLocalInstance((Context)ctx);
        customizedPropertyCollection = customProp.getAssistCustomizedPropertyCollection(view);
        return customizedPropertyCollection;
    }

    private boolean checkCurrencyAndMainAccount(Context ctx, AccountViewInfo accountViewInfo, CurrencyInfo currencyInfo, CompanyOrgUnitInfo relatedCompany) {
        boolean hasON = false;
        String currencyId = currencyInfo.getId().toString();
        int value = accountViewInfo.getAccountingcurrency().getValue();
        if (value == 1) {
            AccountCurrencyCollection accountCurrencyColl = accountViewInfo.getAccountCurrency();
            Iterator iter = accountCurrencyColl.iterator();
            while (iter.hasNext()) {
                CurrencyInfo curInfo = ((AccountCurrencyInfo)iter.next()).getCurrency();
                String curId = curInfo.getId().toString();
                if (!curId.equals(currencyId)) continue;
                hasON = true;
            }
        } else if (value == 2) {
            hasON = true;
        } else if (value == 0) {
            String curId = relatedCompany.getBaseCurrency().getId().toString();
            hasON = curId.equals(currencyId);
        }
        this.relatedCompanyCurrencyMapping.put(accountViewInfo.getId().toString() + currencyInfo.getId().toString() + relatedCompany.getId().toString(), hasON);
        return hasON;
    }

    private AccountViewInfo getAccountViewInfo(Context ctx, String accountNumber, String accountTableId, String companyId) throws BOSException, EASBizException {
        AccountViewCollection accountColl = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isSelfFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("isChangeCurrency"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("companyID.number"));
        sic.add(new SelectorItemInfo("currencyID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.number"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("CAA.count"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        sic.add(new SelectorItemInfo("category"));
        sic.add(new SelectorItemInfo("accrualDirection"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
        view.setFilter(filterInfo);
        accountColl = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (accountColl != null && accountColl.size() > 0) {
            return accountColl.get(0);
        }
        return null;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws EASBizException, BOSException {
        CurrencyInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        info = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), sic);
        return info;
    }

    private IObjectValue findObjectValue(IObjectCollection coll, String fieldName, String number) {
        for (int i = 0; i < coll.size(); ++i) {
            ObjectBaseInfo info = (ObjectBaseInfo)coll.getObject(i);
            if (info.getString(fieldName) == null || !info.getString(fieldName).equals(number)) continue;
            return info;
        }
        return null;
    }

    public void getOrgProfitAcctMapping(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        if (company.getAccountTable() == null || company.getAccountTable().getId() == null) {
            company = GlUtils.getCompanyById((Context)ctx, (String)company.getId().toString());
        }
        String oql = " select id, newAcct.id, acctRefContrast.company.id where id in (select e.FID from T_BD_AcctRefContrast a inner join  T_BD_AcctRefContrastEntry e on e.FAcctRefContrastID = a.fid where a.FRefType = 3 and a.FIsEnabled = 1 and a.fstcompanyid ='" + company.getId() + "' and a.FEnabledAcctTableID = '" + company.getAccountTable().getId() + "') order by acctRefContrast.company.id ";
        try {
            IAccountRefContrastEntry ir = AccountRefContrastEntryFactory.getLocalInstance((Context)ctx);
            AccountRefContrastEntryCollection arc = ir.getAccountRefContrastEntryCollection(oql);
            for (int i = 0; i < arc.size(); ++i) {
                Set<Object> AcctIds;
                AccountRefContrastEntryInfo arcEntryInfo = arc.get(i);
                if (arcEntryInfo.getNewAcct() == null || arcEntryInfo.getNewAcct().getId() == null) continue;
                CompanyOrgUnitInfo companyInfo = arcEntryInfo.getAcctRefContrast().getCompany();
                if (this.orgProfitAcctMapping.get(companyInfo.getId().toString()) != null) {
                    AcctIds = this.orgProfitAcctMapping.get(companyInfo.getId().toString());
                    AcctIds.add(arcEntryInfo.getNewAcct().getId().toString());
                    this.orgProfitAcctMapping.put(companyInfo.getId().toString(), AcctIds);
                } else {
                    AcctIds = new HashSet<String>();
                    AcctIds.add(arcEntryInfo.getNewAcct().getId().toString());
                    this.orgProfitAcctMapping.put(companyInfo.getId().toString(), AcctIds);
                }
                this.profitAcctIds.add(arcEntryInfo.getNewAcct().getId().toString());
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public IObjectPK submitVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo == null) {
            return null;
        }
        this.initGlParam(ctx, voucherInfo);
        boolean vchExists = this.exist(ctx, voucherInfo);
        if (vchExists) {
            this.transactExistVoucher(ctx, voucherInfo);
            this.insertVoucherLogBeforSubmit(ctx, voucherInfo);
        }
        this.loadVoucherInfoForSubmit(ctx, voucherInfo);
        IObjectPK voucherPK = this.submit(ctx, voucherInfo);
        this.dealAfterSubmit(ctx, voucherInfo);
        this.insertVoucherLogAfterSubmit(ctx, voucherPK, vchExists);
        return voucherPK;
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = SynVoucherUtil.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        PcaParam pcaParam = this.getPcaParam(ctx, ((PcVoucherInfo)voucherInfo).getProfitCenter().getId().toString());
        Map pcaMap = pcaParam.getParamMap();
        for (Map.Entry e : pcaMap.entrySet()) {
            this.sysParam.setParam((String)e.getKey(), e.getValue());
        }
    }

    protected PcaParam getPcaParam(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        String cacheKey = "PCA" + profitCenterId + "ISubmitVoucherService";
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof PcaParam) {
            return (PcaParam)cache.getSysParams().get(cacheKey);
        }
        PcaParam glParam = PcaParam.getPcaParams(ctx, PcaUtils.getDefaultPcaParamList(), profitCenterId);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected boolean exist(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return PcaUtils.isExisted(ctx, (PcVoucherInfo)voucherInfo);
    }

    protected void transactExistVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.setVchPropFromExistVch(ctx, voucherInfo);
        this.clearAuditBack(ctx, voucherInfo, this.sysParam);
    }

    private void setVchPropFromExistVch(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (VoucherStatusEnum.TEMP == voucherInfo.getBizStatus()) {
            voucherInfo.setFromSaveSubmit(VoucherStatusEnum.TEMP == voucherInfo.getBizStatus());
        }
    }

    private void clearAuditBack(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherInfo.setIsAuditBack(false);
        boolean ishandAuditBack = sysParam.getBoolean("GL_099");
        if (!voucherInfo.isFromSaveSubmit() && ishandAuditBack) {
            DbUtil.execute((Context)ctx, (String)" delete from T_PCA_PcAuditOpinion  where FVoucherID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void insertVoucherLogBeforSubmit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherStatusEnum bizStatus = this.operateSharer.getVoucherStatus(ctx, voucherInfo);
        if (bizStatus == VoucherStatusEnum.SUBMITTED) {
            this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 2, true, false);
        }
    }

    protected void loadVoucherInfoForSubmit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherEntryAutoBalance autoBalance = new PcVoucherEntryAutoBalance();
        autoBalance.setSysParam(this.sysParam);
        autoBalance.setVoucherInfo(voucherInfo);
        autoBalance.setCtx(ctx);
        autoBalance.autoBalanceVoucherEntry();
        if (!voucherInfo.isPostedByUI()) {
            PcVoucherUtil.lazyLoad(ctx, voucherInfo, PcVoucherInfo.getDefaultSelector(), this.sysParam, false, true);
        } else {
            PcVoucherUtil.computeVoucherAttribute(voucherInfo, this.sysParam, true, false, ctx);
        }
    }

    protected IObjectPK submit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean needSaveAdjustRelation = voucherInfo.getId() == null;
        this.handleSubmitVoucherNumber(ctx, (PcVoucherInfo)voucherInfo, this.sysParam);
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        String logDetail = voucherInfo.getVoucherType().getName(ctx.getLocale()) + "-" + voucherInfo.getNumber();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"saveVoucher", (BOSObjectType)voucherInfo.getBOSType(), null, (String)logDetail, (String)"pca_voucher_submit");
        IObjectPK voucherPK = this.saveVoucher(ctx, voucherInfo, this.sysParam);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        if (voucherInfo.isIsReverseVoucher()) {
            this.updateSrcVoucher(ctx, voucherInfo.getSrcVoucherInfo());
            if (voucherInfo.getId() == null) {
                this.saveReverseRelation(ctx, (PcVoucherInfo)voucherInfo);
            }
        } else if (SourceType.ADJUST.equals((Object)voucherInfo.getSourceType()) && needSaveAdjustRelation) {
            this.saveAdjustRelation(ctx, (PcVoucherInfo)voucherInfo);
        }
        return voucherPK;
    }

    private void handleSubmitVoucherNumber(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException, VoucherException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        boolean isHandNumber = sysParam.getBoolean("PCA_031");
        if (isHandNumber && voucherInfo.getNumber() != null) {
            if (!PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber)) {
                throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
            }
        } else {
            IPcVoucher iPcVoucher;
            PcVoucherInfo pcVoucherInfo;
            if (voucherInfo.getId() != null && (voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) && (pcVoucherInfo = (PcVoucherInfo)(iPcVoucher = PcVoucherFactory.getLocalInstance((Context)ctx)).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()))) != null) {
                voucherInfo.setNumber(pcVoucherInfo.getNumber());
            }
            if (!isHandNumber || voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) {
                if (PcaUtils.isExisted(ctx, voucherInfo)) {
                    this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                    for (int count = 1; !PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < 1000; ++count) {
                        voucherInfo.setNumber(null);
                        this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                    }
                } else {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                    for (int count = 1; !PcaUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < 1000; ++count) {
                        voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                    }
                }
            }
        }
        voucherInfo.setBizStatus(oldStatus);
    }

    private IObjectPK saveVoucher(Context ctx, BaseVoucherInfo voucherInfo, GlParam glParam) throws EASBizException, BOSException {
        return this.getVoucherPersistence(this.sysParam).persistVoucher(ctx, voucherInfo);
    }

    protected IVoucherPersistence getVoucherPersistence(GlParam sysParam) throws BOSException {
        return new PcVoucherPersistence(sysParam);
    }

    private void updateSrcVoucher(Context ctx, BaseVoucherInfo srcVch) throws BOSException, EASBizException {
        String des = srcVch.getDescription();
        String select = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"HASREVERSED", (Locale)ctx.getLocale());
        select = select + "(" + srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber() + ")";
        if (des != null) {
            select = select + "_" + des;
        }
        srcVch.setDescription(srcVch.getNumber() + select);
        if (srcVch.getDescription().length() > 255) {
            srcVch.setDescription(srcVch.getDescription().substring(0, 255));
        }
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        iVoucher.update((IObjectPK)new ObjectUuidPK(srcVch.getId()), (CoreBaseInfo)srcVch);
    }

    private void saveReverseRelation(Context ctx, PcVoucherInfo voucherInfo) throws BOSException {
        VoucherUtil.saveBOTRelationInfo((Context)ctx, (String)voucherInfo.getSrcVoucherInfo().getId().toString(), (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), (BOSObjectType)voucherInfo.getBOSType());
    }

    private void saveAdjustRelation(Context ctx, PcVoucherInfo voucherInfo) throws BOSException {
        PcVoucherUtil.saveBOTRelationInfo(ctx, voucherInfo.getSourceBillId(), (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), voucherInfo.getBOSType());
    }

    protected void dealAfterSubmit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        ObjectUuidPK voucherPK = new ObjectUuidPK(voucherInfo.getId().toString());
        boolean GL_112 = this.sysParam.getBoolean("GL_112");
        if (GL_112) {
            // empty if block
        }
        PcVoucherOprateSharer.requestBudgetSubstract(ctx, voucherInfo, this.sysParam, 2);
        this.updateAdjustRateHistory(ctx, voucherInfo);
    }

    protected void checkAmountBalance(Context ctx, IObjectPK voucherPK, GlParam sysParam) throws BOSException, EASBizException {
        this.helper.checkAmountBalance(ctx, voucherPK, sysParam);
    }

    private void updateAdjustRateHistory(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherInfo.getId().toString()));
            IAdjExchRateHistory adjHisInstance = AdjExchRateHistoryFactory.getLocalInstance((Context)ctx);
            AdjExchRateHistoryCollection coll = adjHisInstance.getAdjExchRateHistoryCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
            PcVoucherEntryCollection voucherEntryColl = voucherInfo.getEntries();
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                AdjExchRateHistoryInfo adjInfo = coll.get(i);
                for (int k = 0; k < voucherEntryColl.size(); ++k) {
                    PcVoucherEntryInfo voucherEntryInfo = voucherEntryColl.get(k);
                    if (!adjInfo.getAccount().getId().toString().equals(voucherEntryInfo.getAccount().getId().toString()) || !adjInfo.getCurrency().getId().toString().equals(voucherEntryInfo.getCurrency().getId().toString())) continue;
                    adjInfo.setExchRateAfter(voucherEntryInfo.getLocalExchangeRate());
                    if (adjInfo.getAccount().getCAA() != null && voucherEntryInfo.getAccount().getCAA() != null) {
                        PcVoucherAssistRecordCollection var = voucherEntryInfo.getAssistRecords();
                        int size = var.size();
                        for (int p = 0; p < size; ++p) {
                            PcVoucherAssistRecordInfo varInfo = var.get(p);
                            if (!adjInfo.getAssistHG().getId().toString().equals(varInfo.getAssGrp().getId().toString())) continue;
                            adjInfo.setBalanceAdjust(varInfo.getLocalAmount());
                            if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                                adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(varInfo.getLocalAmount()));
                                continue;
                            }
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(varInfo.getLocalAmount()));
                        }
                    } else {
                        adjInfo.setBalanceAdjust(voucherEntryInfo.getLocalAmount());
                        if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(voucherEntryInfo.getLocalAmount()));
                        } else {
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(voucherEntryInfo.getLocalAmount()));
                        }
                    }
                    adjHisInstance.update((IObjectPK)new ObjectUuidPK(adjInfo.getId()), (CoreBaseInfo)adjInfo);
                }
            }
        }
    }

    private void insertVoucherLogAfterSubmit(Context ctx, IObjectPK voucherPK, boolean vchExists) throws BOSException, EASBizException {
        this.operateSharer.insertVoucherLog(new String[]{voucherPK.toString()}, vchExists ? 2 : 1, false, false);
    }

    private void deleteNotSynPcVoucher(Context ctx, String voucherId, Set idSet) throws BOSException, EASBizException {
        IPcVoucher iPcVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)voucherId));
        if (idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.NOTINCLUDE));
        }
        evi.setFilter(filter);
        SelectorItemCollection sic = PcVoucherInfo.getDefaultSelector();
        evi.setSelector(sic);
        PcVoucherCollection pcVoucherColl = iPcVoucher.getPcVoucherCollection(evi);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.deleteBOTRelation(ctx, voucherId, pcVoucherInfo.getId().toString());
            SynPcVoucherDeletePostProcessor deleteProcessor = new SynPcVoucherDeletePostProcessor(new PcVoucherOprateSharer(ctx), (IBaseVoucher)PcVoucherFactory.getLocalInstance((Context)ctx));
            deleteProcessor.deleteVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo, false);
        }
    }

    protected void insertSynBOTRelation(Context ctx, BOTRelationInfo botRelationInfo, IObjectPK pk) throws BOSException {
        BOTRelationCollection botRelationColl = new BOTRelationCollection();
        BOTRelationInfo tempBotRelationInfo = (BOTRelationInfo)botRelationInfo.clone();
        tempBotRelationInfo.setDestObjectID(pk.toString());
        tempBotRelationInfo.setDestEntityID(new PcVoucherInfo().getBOSType().toString());
        botRelationColl.add(tempBotRelationInfo);
        SynVoucherUtil.insertBOTRelation(ctx, botRelationColl);
    }

    protected BOTRelationInfo getSynBOTRelationInfo(VoucherInfo voucherInfo) {
        BOTRelationInfo botRelationInfo = new BOTRelationInfo();
        botRelationInfo.setSrcObjectID(voucherInfo.getId().toString());
        botRelationInfo.setSrcEntityID(new VoucherInfo().getBOSType().toString());
        botRelationInfo.setDate(new Date());
        String operatorID = voucherInfo.getCreator().getName() != null ? voucherInfo.getCreator().getName() : voucherInfo.getCreator().getNumber();
        botRelationInfo.setOperatorID(operatorID);
        botRelationInfo.setIsEffected(true);
        botRelationInfo.setType(0);
        return botRelationInfo;
    }
}

