/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherException;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.voucher.PcVoucherOprateSharer;
import com.kingdee.eas.ma.pca.app.voucher.SynPcVoucherDeletePostProcessor;
import com.kingdee.eas.ma.pca.app.voucher.SynPcVoucherSubmitPostProcessor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SynPcVoucherSubmitPostProcessor2
extends SynPcVoucherSubmitPostProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.voucher.SynPcVoucherSubmitPostProcessor2");

    @Override
    public void process(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        logger.error((Object)("SynPcVoucherProcess 1->voucherInfo:" + voucherInfo.getId().toString()));
        String companyId = voucherInfo.getCompany().getId().toString();
        boolean commonVoucherProcess = SynVoucherUtil.isNeedSynPcVoucher(ctx, companyId);
        if (!commonVoucherProcess) {
            return;
        }
        logger.error((Object)("SynPcVoucherProcess 2->validate " + voucherInfo.getId().toString()));
        boolean useProfitCenterAccount = SynVoucherUtil.isUseProfitCenterAccount(ctx, companyId);
        this.validate(ctx, voucherInfo, true, useProfitCenterAccount);
        Map<String, CompanyOrgUnitInfo> relatedCompanyCUs = this.validate(ctx, voucherInfo, useProfitCenterAccount);
        logger.error((Object)("SynPcVoucherProcess 3->getPcVoucherColl " + voucherInfo.getId().toString()));
        PcVoucherCollection pcVoucherColl = this.getPcVoucherColl(ctx, voucherInfo, 1);
        logger.error((Object)("SynPcVoucherProcess 4->checkVoucherPeriod " + voucherInfo.getId().toString()));
        PeriodInfo voucherPeriodInfo = VoucherProcessCache.getPeriod((Context)ctx, (String)voucherInfo.getPeriod().getId().toString());
        this.checkVoucherPeriod(ctx, voucherPeriodInfo, pcVoucherColl, VoucherOperateStatusEnum.SUBMIT);
        HashSet<String> profitCentIdSet = new HashSet<String>();
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.profitCenterBalanceDebitCreditAmount(ctx, pcVoucherInfo);
            profitCentIdSet.add(pcVoucherInfo.getProfitCenter().getId().toString());
        }
        if (!useProfitCenterAccount) {
            logger.error((Object)("SynPcVoucherProcess 4->getRelatedCompanyCUs " + voucherInfo.getId().toString()));
            relatedCompanyCUs = PcaUtils.getRelatedCompanyCUs(ctx, profitCentIdSet);
        }
        HashMap<String, VoucherTypeCollection> cuCollVTMap = new HashMap<String, VoucherTypeCollection>();
        int j2 = pcVoucherColl.size();
        for (int i = 0; i < j2; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            if (pcVoucherInfo.getProfitCenter() == null || pcVoucherInfo.getProfitCenter().getCU() == null || pcVoucherInfo.getProfitCenter().getCU().getId() == null) continue;
            String profitCenterID = pcVoucherInfo.getProfitCenter().getId().toString();
            String cuId = pcVoucherInfo.getProfitCenter().getCU().getId().toString();
            logger.error((Object)("SynPcVoucherProcess 4->pcVoucherVTCol " + voucherInfo.getId().toString()));
            VoucherTypeCollection pcVoucherVTCol = new VoucherTypeCollection();
            if (cuCollVTMap.containsKey(cuId)) {
                pcVoucherVTCol = (VoucherTypeCollection)cuCollVTMap.get(cuId);
            } else {
                FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU");
                pcVoucherVTCol = PcaUtils.getVoucherTypeCollection(ctx, filterVT, cuId);
                cuCollVTMap.put(cuId, pcVoucherVTCol);
            }
            logger.error((Object)("SynPcVoucherProcess 4->adjustVoucherType 1 " + voucherInfo.getId().toString()));
            this.adjustVoucherType(pcVoucherInfo, pcVoucherVTCol);
            if (pcVoucherInfo.getVoucherType() == null && relatedCompanyCUs.containsKey(profitCenterID)) {
                String relatedCompanyCU = relatedCompanyCUs.get(profitCenterID).getCU().getId().toString();
                logger.error((Object)("SynPcVoucherProcess 4->relatedVoucherVTCol " + voucherInfo.getId().toString()));
                VoucherTypeCollection relatedVoucherVTCol = new VoucherTypeCollection();
                if (cuCollVTMap.containsKey(relatedCompanyCU)) {
                    relatedVoucherVTCol = (VoucherTypeCollection)cuCollVTMap.get(relatedCompanyCU);
                } else {
                    FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(relatedCompanyCU), "id", "adminCU");
                    relatedVoucherVTCol = PcaUtils.getVoucherTypeCollection(ctx, filterVT, relatedCompanyCU);
                    cuCollVTMap.put(cuId, relatedVoucherVTCol);
                }
                logger.error((Object)("SynPcVoucherProcess 4->adjustVoucherType 2 " + voucherInfo.getId().toString()));
                this.adjustVoucherType(pcVoucherInfo, pcVoucherVTCol);
            }
            if (pcVoucherInfo.getVoucherType() != null) continue;
            String msg = MessageFormat.format(EASResource.getString((String)this.GL_RESOURCE, (String)"1096_MainProfitCenterDoNotHasVoucherType"), pcVoucherInfo.getProfitCenter().getName());
            throw new EASBizException(new NumericExceptionSubItem("102", msg.toString()));
        }
        logger.error((Object)("SynPcVoucherProcess 4.2 " + voucherInfo.getId().toString()));
        HashSet<String> oldPcaVoucherIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)voucherInfo.getId().toString()));
        view.setFilter(filter);
        PcVoucherCollection oldPcaVouchers = PcVoucherFactory.getLocalInstance((Context)ctx).getPcVoucherCollection(view);
        for (int i = 0; i < oldPcaVouchers.size(); ++i) {
            oldPcaVoucherIds.add(oldPcaVouchers.get(i).getId().toString());
        }
        BOTRelationInfo botRelationInfo = this.getSynBOTRelationInfo(voucherInfo);
        boolean isAdjust = SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType());
        this.iVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        this.operateSharer = new PcVoucherOprateSharer(ctx);
        HashSet<String> newPcaVoucherIds = new HashSet<String>();
        int j3 = pcVoucherColl.size();
        for (int i = 0; i < j3; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            pcVoucherInfo.put("isAdjust", (Object)isAdjust);
            if (pcVoucherInfo.getId() != null && oldPcaVoucherIds.contains(pcVoucherInfo.getId().toString())) {
                pcVoucherInfo.setExist(true);
            }
            logger.error((Object)("SynPcVoucherProcess 4.2 submitVoucher " + voucherInfo.getId().toString()));
            IObjectPK pk = this.submitVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo);
            logger.error((Object)("SynPcVoucherProcess 4.2 insertSynBOTRelation " + voucherInfo.getId().toString()));
            this.insertSynBOTRelation(ctx, botRelationInfo, pk);
            newPcaVoucherIds.add(pk.toString());
        }
        logger.error((Object)("SynPcVoucherProcess 5 deleteNotSynPcVoucher " + voucherInfo.getId().toString()));
        oldPcaVoucherIds.removeAll(newPcaVoucherIds);
        if (oldPcaVoucherIds.size() > 0) {
            this.deleteSynPcVoucher(ctx, voucherInfo.getId().toString(), oldPcaVoucherIds);
            logger.error((Object)("SynPcVoucherProcess 5 deleteSynPcVoucher done -> " + voucherInfo.getId().toString()));
        }
        logger.error((Object)("finish SynPcVoucherProcess 5->voucherInfo:" + voucherInfo.getId().toString()));
    }

    public Map<String, CompanyOrgUnitInfo> validate(Context ctx, VoucherInfo voucherInfo, boolean useProfitCenterAccount) throws BOSException, EASBizException {
        Map<String, CompanyOrgUnitInfo> relatedCompanyInfoMap = new HashMap<String, CompanyOrgUnitInfo>();
        if (!useProfitCenterAccount) {
            return relatedCompanyInfoMap;
        }
        this.getOrgProfitAcctMapping(ctx, voucherInfo);
        VoucherEntryCollection entryCol = voucherInfo.getEntries();
        HashSet<String> profitCentIdSet = new HashSet<String>();
        HashSet<String> accountSet = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            VoucherEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().getId() == null) continue;
            profitCentIdSet.add(entryInfo.getProfitCenter().getId().toString());
            accountSet.add(entryInfo.getAccount().getId().toString());
        }
        relatedCompanyInfoMap = PcaUtils.getRelatedCompanyCUs(ctx, profitCentIdSet);
        Map<String, Boolean> isAsstAccountChangeMap = PcaUtils.getIsAsstAccountChange(ctx, accountSet);
        StringBuffer msg = new StringBuffer();
        Iterator iter = voucherInfo.getEntries().iterator();
        String companyId = voucherInfo.getCompany().getId().toString();
        while (iter.hasNext()) {
            VoucherEntryInfo entryInfo = (VoucherEntryInfo)iter.next();
            if (entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().getId() == null) continue;
            String profitCenterId = entryInfo.getProfitCenter().getId().toString();
            CompanyOrgUnitInfo relatedCompany = relatedCompanyInfoMap.get(profitCenterId);
            String relatedCompanyId = relatedCompany.getId().toString();
            boolean isMainRelatedCompany = companyId.equals(relatedCompanyId);
            boolean isAsstAccountChange = isAsstAccountChangeMap.get(entryInfo.getAccount().getId().toString());
            if (isMainRelatedCompany && !isAsstAccountChange) continue;
            if (this.orgProfitAcctMapping.get(relatedCompanyId) == null) {
                msg.append(this.checkAccountNumber(ctx, entryInfo, relatedCompany));
                continue;
            }
            Set acctIds = this.orgProfitAcctMapping.get(relatedCompanyId) != null ? (Set)this.orgProfitAcctMapping.get(relatedCompanyId) : new HashSet();
            if (acctIds.contains(entryInfo.getAccount().getId().toString())) continue;
            msg.append(this.checkAccountNumber(ctx, entryInfo, relatedCompany));
        }
        if (msg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("102", msg.toString()));
        }
        return relatedCompanyInfoMap;
    }

    protected void adjustVoucherType(PcVoucherInfo pcVoucherInfo, VoucherTypeCollection vtCol) {
        VoucherTypeInfo defaultVoucherType = null;
        VoucherTypeInfo voucherType = pcVoucherInfo.getVoucherType();
        boolean isExist = false;
        if (vtCol != null && vtCol.size() > 0) {
            VoucherTypeInfo vtDefault = vtCol.get(0);
            for (VoucherTypeInfo vt : vtCol) {
                if (voucherType.getId().toString().equals(vt.getId().toString())) {
                    isExist = true;
                    break;
                }
                if (!vt.isPretermit()) continue;
                vtDefault = vt;
            }
            defaultVoucherType = vtDefault;
        }
        if (!isExist) {
            pcVoucherInfo.setVoucherType(defaultVoucherType);
        }
    }

    protected void checkVoucherPeriod(Context ctx, PeriodInfo voucherPeriodInfo, PcVoucherCollection pcVoucherColl, VoucherOperateStatusEnum operateEnum) throws BOSException, EASBizException {
        if (voucherPeriodInfo == null || pcVoucherColl == null || pcVoucherColl.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCurrentPeriodID, sysStaCtr.FProfitCenterID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID = sysSta.FID ");
        sql.append(" and sysSta.FName = ").append(SystemEnum.PROFIT_CENTER_ACCOUNTING.getValue()).append(" ");
        StringBuffer tempSql = new StringBuffer();
        int threshold = 500;
        int count = 0;
        int size = pcVoucherColl.size();
        for (int i = 0; i < pcVoucherColl.size(); ++i) {
            if (count == 0) {
                tempSql.setLength(0);
                tempSql.append(" and sysStaCtr.FProfitCenterID in (");
            }
            if (count > 1) {
                tempSql.append(", ");
            }
            tempSql.append("'").append(pcVoucherColl.get(i).getProfitCenter().getId().toString()).append("'");
            if (++count != threshold && count != size) continue;
            tempSql.append(")");
            count = 0;
            StringBuffer querySql = new StringBuffer();
            querySql.append(sql).append(tempSql);
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            if (iRowSet == null || iRowSet.size() <= 0) continue;
            HashMap periodProfitCenterMap = new HashMap();
            try {
                while (iRowSet.next()) {
                    Set<String> profitCenterSet;
                    String periodID = iRowSet.getString("FCurrentPeriodID");
                    String profitCenterID = iRowSet.getString("FProfitCenterID");
                    if (periodProfitCenterMap.containsKey(periodID)) {
                        profitCenterSet = (Set)periodProfitCenterMap.get(periodID);
                        profitCenterSet.add(profitCenterID);
                        continue;
                    }
                    profitCenterSet = new HashSet();
                    profitCenterSet.add(profitCenterID);
                    periodProfitCenterMap.put(periodID, profitCenterSet);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
            if (periodProfitCenterMap.size() <= 0) continue;
            Set periodSet = periodProfitCenterMap.keySet();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", periodSet, CompareType.INCLUDE));
            view.setFilter(filter);
            PeriodCollection periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
            for (int j = 0; j < periodCollection.size(); ++j) {
                PeriodInfo pcaPeriodInfo = periodCollection.get(j);
                if (voucherPeriodInfo.getNumber() >= pcaPeriodInfo.getNumber()) continue;
                Set profitCenterIDSet = (Set)periodProfitCenterMap.get(pcaPeriodInfo.getId().toString());
                Iterator profitCenterIterator = profitCenterIDSet.iterator();
                StringBuffer profitCenterNames = new StringBuffer();
                while (profitCenterIterator.hasNext()) {
                    String profitCenterID = (String)profitCenterIterator.next();
                    for (int k = 0; k < pcVoucherColl.size(); ++k) {
                        ProfitCenterOrgUnitInfo profitCenter = pcVoucherColl.get(k).getProfitCenter();
                        if (!profitCenterID.equals(profitCenter.getId().toString())) continue;
                        if (profitCenterNames.length() > 0) {
                            profitCenterNames.append(", ");
                        }
                        profitCenterNames.append(profitCenter.getName());
                    }
                }
                throw new PcVoucherException(PcVoucherException.VOUCHER_PERIOD_BEFORE_PCAPERIOD, new String[]{profitCenterNames.toString(), operateEnum.getAlias()});
            }
        }
    }

    protected void deleteSynPcVoucher(Context ctx, String voucherId, Set idSet) throws BOSException, EASBizException {
        IPcVoucher iPcVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)voucherId));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = PcVoucherInfo.getDefaultSelector();
        evi.setSelector(sic);
        PcVoucherCollection pcVoucherColl = iPcVoucher.getPcVoucherCollection(evi);
        int j = pcVoucherColl.size();
        for (int i = 0; i < j; ++i) {
            PcVoucherInfo pcVoucherInfo = pcVoucherColl.get(i);
            SynVoucherUtil.deleteBOTRelation(ctx, voucherId, pcVoucherInfo.getId().toString());
            SynPcVoucherDeletePostProcessor deleteProcessor = new SynPcVoucherDeletePostProcessor(new PcVoucherOprateSharer(ctx), (IBaseVoucher)PcVoucherFactory.getLocalInstance((Context)ctx));
            deleteProcessor.deleteVoucher(ctx, (BaseVoucherInfo)pcVoucherInfo, false);
        }
    }
}

