/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class PcaRptAccountBalanceIDCreator
implements IGLRptIDCreator {
    private GLRptBaseCondition cond;
    private Map profitCenters = new HashMap();
    private SimpleCompanyUserObject rootObj;

    public PcaRptAccountBalanceIDCreator(String mainTableAlias, GLRptBaseCondition cond) {
        this.cond = cond;
        this.initCompanyMap(cond);
    }

    private void initCompanyMap(GLRptBaseCondition cond) {
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.merger || cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            ProfitCenterOrgUnitInfo[] profitCenterArrays = cond.getProfitCenters();
            for (int i = 0; i < profitCenterArrays.length; ++i) {
                ProfitCenterOrgUnitInfo profitCenter = profitCenterArrays[i];
                SimpleCompanyUserObject simpleProfitCenter = new SimpleCompanyUserObject();
                simpleProfitCenter.setCompanyId(profitCenter.getId().toString());
                simpleProfitCenter.setLeaf(profitCenter.isIsLeaf());
                simpleProfitCenter.setLevel(profitCenter.getLevel());
                simpleProfitCenter.setName(profitCenter.getName());
                this.profitCenters.put(simpleProfitCenter.getCompanyId(), simpleProfitCenter);
            }
            if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
                this.rootObj = new SimpleCompanyUserObject();
                this.rootObj.setCompanyId(cond.getProfitCenter().getId().toString());
                this.rootObj.setName(cond.getProfitCenter().getName());
                this.profitCenters.put(cond.getProfitCenter().getId().toString(), this.rootObj);
            } else {
                SimpleCompanyUserObject adminCompany = new SimpleCompanyUserObject();
                adminCompany.setCompanyId("00000000-0000-0000-0000-000000000000CCE7AED4");
                this.profitCenters.put(adminCompany.getCompanyId(), adminCompany);
            }
        } else if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)cond.getTreeModelOfProfitCenter();
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            this.rootObj = (SimpleCompanyUserObject)root.getUserObject();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
                this.profitCenters.put(userObject.getCompanyId(), userObject);
            }
        }
    }

    public String getIDSelect() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("t.").append("KSQL_SEQ").append(", t.").append("SQL_BATCH");
        if (this.cond.getCompanyDisplayMode() != CompanyDisplayModeEnum.enumerate) {
            sql.append(", t.FProfitCenterID treeID ");
        }
        return sql.toString();
    }

    public GLRptID create(ResultSet rs) throws SQLException {
        GLRptTreeNode node = new GLRptTreeNode(rs.getInt("SQL_BATCH"), rs.getInt("KSQL_SEQ"));
        SimpleCompanyUserObject obj = this.getTreeNodeObjectById(rs.getString("treeID"));
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            if (obj != null) {
                if (obj.getCompanyId().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                    node.setLevel(0);
                    node.setLeaf(false);
                } else {
                    node.setLevel(1);
                    node.setLeaf(true);
                }
                node.setUserObject((Object)obj);
            }
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode() && obj != null) {
            if (obj.getCompanyId().equals(this.rootObj.getCompanyId())) {
                node.setLevel(0);
                node.setLeaf(false);
            } else {
                node.setLevel(1);
                node.setLeaf(true);
            }
            node.setUserObject((Object)obj);
        }
        return node;
    }

    public SimpleCompanyUserObject getTreeNodeObjectById(String objId) {
        SimpleCompanyUserObject obj = (SimpleCompanyUserObject)this.profitCenters.get(objId);
        if (obj == null) {
            return this.rootObj;
        }
        return obj;
    }
}

