/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultPcaRptIDCreator
implements IGLRptIDCreator {
    private GLRptBaseCondition cond;
    private Map profitCenters = new HashMap();
    private SimpleCompanyUserObject rootObj;

    public DefaultPcaRptIDCreator(String mainTableAlias, GLRptBaseCondition cond) {
        this.cond = cond;
        if (cond.getTreeModelOfProfitCenter() != null) {
            this.initCompanyMap(cond);
        }
    }

    private void initCompanyMap(GLRptBaseCondition cond) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)cond.getTreeModelOfProfitCenter();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        this.rootObj = (SimpleCompanyUserObject)root.getUserObject();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            this.profitCenters.put(userObject.getCompanyId(), userObject);
        }
    }

    public String getIDSelect() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("t.").append("KSQL_SEQ").append(", t.").append("SQL_BATCH");
        if (!this.cond.getProfitCenter().isIsBizUnit() && this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level) {
            sql.append(", t.FProfitCenterID treeID ");
        }
        return sql.toString();
    }

    public GLRptID create(ResultSet rs) throws SQLException {
        SimpleCompanyUserObject obj;
        GLRptTreeNode node = new GLRptTreeNode(rs.getInt("SQL_BATCH"), rs.getInt("KSQL_SEQ"));
        if (!this.cond.getProfitCenter().isIsBizUnit() && this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && (obj = this.getTreeNodeObjectById(rs.getString("treeID"))) != null) {
            node.setLevel(obj.getLevel());
            node.setLeaf(obj.isLeaf());
            node.setUserObject((Object)obj);
        }
        return node;
    }

    public SimpleCompanyUserObject getTreeNodeObjectById(String objId) {
        SimpleCompanyUserObject obj = (SimpleCompanyUserObject)this.profitCenters.get(objId);
        if (obj == null) {
            return this.rootObj;
        }
        return obj;
    }
}

