/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLRptHelper;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQueryHelper;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.ma.pca.rpt.app.PcaRptAccountBalanceIDCreator;
import com.kingdee.eas.ma.pca.rpt.app.dao.DefaultPcaRptIDCreator;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAccountBalPageQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAccountBalQueryHelper;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAccountFilter;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptBalNextPeriodQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptField;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class PcaRptAccountBalanceDao
extends AbstractGLRptDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.rpt.app.PcaRptAccountBalanceDao");
    protected GLRptAccountBalanceCondition cond;
    protected int assistCount = -1;
    private Set accountIdSet4Sum;
    private String accountIdStr4Sum;
    private String accountTempTable4Sum;
    private Map<String, Integer> actTypeMap;
    private ProfitCenterOrgUnitInfo profitCenter;
    private String sysStatusTmpTable;

    public ProfitCenterOrgUnitInfo getProfitCenter() {
        return this.profitCenter;
    }

    protected GLRptBalNextPeriodQuery getRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new PcaRptBalNextPeriodQuery(ctx, cond);
    }

    protected PeriodInfo initPeriod() throws EASBizException, BOSException {
        PeriodInfo startPeriod = PcaUtils.getProfitCenterStartPeriod(this.cond.getCtx(), 1006, this.cond.getProfitCenter().getId().toString());
        return startPeriod;
    }

    protected void updateVoucherBalance() throws BOSException {
        String[] profitCenterIds = GLRptDaoUtil.set2StringArray((Set)this.cond.getProfitCenterIds());
        PcaBalanceFacadeFactory.getLocalInstance(this.cond.getCtx()).updateVoucherBalance(profitCenterIds);
    }

    protected void setTreeModelOfCompany() throws BOSException {
        this.cond.setTreeModelOfProfitCenter((Object)this.getTreeModeOfProfitCenter(this.cond.getCtx(), this.profitCenter));
    }

    protected CompanyOrgUnitInfo initCompany() throws EASBizException, BOSException {
        this.cond = (GLRptAccountBalanceCondition)this.getQueryCondition();
        CompanyOrgUnitInfo company = super.initCompany();
        this.initProfitOrg();
        this.cond.getCtx().put((Object)"isPca", (Object)true);
        return company;
    }

    private void initProfitOrg() {
        this.profitCenter = this.cond.getProfitCenter();
    }

    public PcaRptAccountBalanceDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        if (this.actTypeMap == null) {
            this.actTypeMap = GLRptHelper.initAcctTypeMap((Context)ctx);
        }
    }

    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        if (this.cond.getDisplayAsstDetail()) {
            this.assistCount = this.getAssistColumnCount();
        }
    }

    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        GLRptTreeNode node = null;
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            node = (GLRptTreeNode)rowSet.getObject("profitCenterName");
            if (this.cond.getDisplayAsstDetail() && rowSet.getInt("FIsAssist") == 1) {
                node.setShow(false);
            }
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() && node != null && node.getParentNode() != null) {
            rowSet.updateObject(GLRptField.currencyName.getName(), null);
        }
        if (this.cond.getDisplayAsstDetail() && rowSet.getInt("FIsAssist") == 1 || CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() && node != null && node.getParentNode() != null) {
            rowSet.updateObject(GLRptField.accountName.getName(), null);
            rowSet.updateObject(GLRptField.accountNumber.getName(), null);
        }
    }

    public IGLRptIDCreator getGLRptIDCreator(String mainTableAlias, GLRptField field) {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            return new PcaRptAccountBalanceIDCreator(mainTableAlias, (GLRptBaseCondition)this.cond);
        }
        return new DefaultPcaRptIDCreator(mainTableAlias, (GLRptBaseCondition)this.cond);
    }

    private void appendAmountSumSelect(StringBuffer sql, String currencyId, String companyId) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginDebitSum(sql, "Qty", "Qty");
            } else {
                sql.append(",0.0 FYearBeginDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginDebitSum(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FYearBeginDebitBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginDebitSum(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendYearBeginDebitSum(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginCreditSum(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FYearBeginCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginCreditSum(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FYearBeginCreditBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginCreditSum(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendYearBeginCreditSum(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginDebitSum(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FBeginDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginDebitSum(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FBeginDebitBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginDebitSum(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginDebitSum(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginCreditSum(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FBeginCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginCreditSum(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FBeginCreditBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginCreditSum(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginCreditSum(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TB.FDebit").append("Qty*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FDebitQty");
            } else {
                sql.append(", 0.0 FDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FDebitFor) FDebitFor       \r\n");
            } else {
                sql.append(", 0.0  FDebitFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FDebitLocal) FDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FDebitRpt) FDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TB.FCredit").append("Qty*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FCreditQty");
            } else {
                sql.append(", 0.0 FCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FCreditFor) FCreditFor     \r\n");
            } else {
                sql.append(", 0.0  FCreditFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FCreditLocal) FCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FCreditRpt) FCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TB.FYearDebitQty*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FYearDebitQty");
            } else {
                sql.append(", 0.0 FYearDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearDebitFor) FYearDebitFor       \r\n");
            } else {
                sql.append(", 0.0  FYearDebitFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearDebitLocal) FYearDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearDebitRpt) FYearDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TB.FYearCreditQty*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FYearCreditQty");
            } else {
                sql.append(", 0.0 FYearCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearCreditFor) FYearCreditFor     \r\n");
            } else {
                sql.append(", 0.0  FYearCreditFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearCreditLocal) FYearCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearCreditRpt) FYearCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndDebitSum(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FEndDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndDebitSum(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0 FEndDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndDebitSum(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndDebitSum(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndCreditSum(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FEndCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndCreditSum(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0 FEndCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndCreditSum(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndCreditSum(sql, "Rpt", "BalanceRpt");
        }
    }

    private IRowSet getAccountSumAmount(IRowSet rs) throws EASBizException, BOSException, SQLException {
        String companyId = null;
        companyId = CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() ? rs.getString("FProfitCenterID") : this.cond.getProfitCenter().getId().toString();
        String currencyId = null;
        if (this.isAllCurrency() && (currencyId = rs.getString("FCurrencyID")) != null && currencyId.trim().length() == 0) {
            currencyId = null;
        }
        if (!(CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode() || this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst())) {
            return this.getAccountAmountForMerger(rs, currencyId, companyId);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 xxx");
        this.appendAmountSumSelect(sql, currencyId, companyId);
        int bwType = -1;
        if (this.cond.getIncludeBWAccount()) {
            bwType = rs.getInt("FBWType");
        }
        if (this.isCreateDataTempTable()) {
            sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TB \r\n");
            sql.append(" INNER JOIN T_BD_AccountView av on TB.FAccountID = av.FID \r\n");
            if (this.isShowQty()) {
                sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  \r\n");
            }
            if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst() && (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode())) {
                sql.append(" WHERE ((av.FCAA IS NULL AND FIsAssist = 0 and (av.fisleaf = 1 or av.flevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append("))");
                sql.append(" OR (av.FCAA IS not NULL AND FIsAssist = 0 and av.FLevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append(" and av.FIsLeaf = 0) ");
                sql.append(" OR (av.FCAA IS not NULL AND FIsAssist = 1 )) \r\n");
            } else {
                if (this.cond.isShowLeafAccount()) {
                    sql.append(" WHERE ").append(" av.FIsLeaf = 1 ");
                } else if (this.cond.getAccountLevelEnd() == 1) {
                    sql.append(" WHERE ").append(" av.flevel = 1 ");
                } else {
                    sql.append(" WHERE av.fid in (").append(this.getAccountIdFilter4Sum()).append(")");
                }
                if (this.cond.getDisplayAsstDetail()) {
                    sql.append(" and tb.FIsAssist = 0 ");
                }
            }
            if (this.isAllCurrency()) {
                sql.append(" and TB.FCurrencyID is not null and TB.FCurrencyID <> ' ' \r\n");
            }
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                if (companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                    sql.append(" and tb.FProfitCenterID <> '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
                } else {
                    sql.append(" and tb.FProfitCenterID = '").append(companyId).append("'");
                }
            }
            if (this.isAllCurrency()) {
                if (currencyId != null && currencyId.trim().length() > 0) {
                    sql.append(" and TB.FCurrencyID = '").append(currencyId).append("'");
                } else {
                    sql.append(" and TB.FCurrencyID != ' '");
                }
            }
            if (bwType == 0 || bwType == 1) {
                sql.append(" and TB.FBWType = ").append(bwType);
            }
        } else {
            sql.append(" from (").append(this.getBalanceSumSQL(false, bwType));
            if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst()) {
                sql.append(" union all ").append(this.getBalanceSumSQL(true, bwType));
            }
            sql.append(") tb ");
            sql.append(" left outer join T_BD_AccountView av on tb.FAccountID = av.FID ");
            if (this.isShowQty()) {
                sql.append(" left outer join T_BD_MeasureUnit mu on mu.FID = av.FMeasureUnitID  ");
            }
        }
        return this.executeQuery(sql.toString());
    }

    private void insertAccountBalance(String plVoucherTempTable) throws EASBizException, BOSException {
        String accountFilter;
        String userID = ContextUtil.getCurrentUserInfo((Context)this.getContex()).getId().toString();
        String companyID = this.cond.getCompany().getId().toString();
        boolean showExist = this.cond.isOptionAmountZero() || this.cond.getOptionYearAmountZero() || this.cond.isOptionAmountAndBalZero() || this.cond.getOptionYearAmountAndBalZero();
        StringBuffer sqlAccount = new StringBuffer();
        StringBuffer select = new StringBuffer();
        ArrayList<Object> sp = new ArrayList<Object>();
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append("\n select * from (\n");
        } else {
            sqlAccount.append("\n select TP.* from (\n");
        }
        sqlAccount.append(" select TA.FID FAccountId ");
        select.append(" select TA.FID FAccountId ");
        if (this.isCreateDataTempTable()) {
            sqlAccount.append(", TA.FNumber accountNumber ");
            select.append(", TA.FNumber accountNumber");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(", TA.").append(this.getAccountName());
            sqlAccount.append(" accountName");
        }
        sqlAccount.append(", 0 FIsAccountTotal ");
        select.append(", 0 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sqlAccount.append(" ,TA.fbw FBWType, 0 FIsAccountBWSum ");
        }
        if (this.isAllCurrency()) {
            sqlAccount.append(" ,isnull(TB.FCurrencyID,'").append(this.getCompany().getBaseCurrency().getId().toString()).append("') FCurrencyID, 0 FIsCurrencyTotal ");
            select.append(" ,isnull(TB.FCurrencyID,'").append(this.getCompany().getBaseCurrency().getId().toString()).append("') FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(",TB.FProfitCenterId FProfitCenterID ");
            select.append(",TA.FProfitCenterId FProfitCenterId ");
        } else if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(",tr.FProfitCenterId FProfitCenterID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            select.append(",0 FIsAssist, ' ' FAssistGrpID ");
            sqlAccount.append(",0 FIsAssist, ' ' FAssistGrpID ");
        }
        if (this.isShowQty()) {
            sqlAccount.append(", MU.FID FMeasureUnitID");
            sqlAccount.append(", MU.fname_").append(this.getContex().getLocale()).append(" measureUnit");
        }
        if (this.isCreateDataTempTable()) {
            this.addInsertSqlForCurrency(sqlAccount);
            this.addInsertSqlForCurrencyBySelect(select);
        }
        sqlAccount.append(" FROM T_BD_AccountView TA\t\r\n");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append("inner join (select  r.FToUnitID id ,r.ffromUnitid FProfitCenterID from T_ORG_UnitRelation r ");
            sqlAccount.append(" inner join T_ORG_TypeRelation u on r.FTypeRelationID = u.FID ");
            sqlAccount.append(" WHERE r.ffromUnitid in " + this.cond.getProfitCenterIdsStr());
            sqlAccount.append(" AND u.FFromType = 6 AND u.ftoType = 1) tr on  tr.id = TA.fcompanyid \r\n");
        }
        sqlAccount.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = TA.FMeasureUnitID  \r\n");
        sqlAccount.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql((String)"TA", (String)userID, (String)companyID, (Context)this.getContex()));
        if (showExist) {
            sqlAccount.append(" inner join \t");
        } else {
            sqlAccount.append(" left outer join ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(" (");
            sqlAccount.append(select.toString());
            sqlAccount.append(" from (");
            sqlAccount.append("select ta.fid fid,ta.fnumber fnumber,tr.fprofitcenterid fprofitcenterid ");
            sqlAccount.append("from t_bd_accountview ta  \r\n");
            sqlAccount.append("inner join t_bd_accountview pav on pav.fnumber = ta.fnumber and pav.faccounttableid = ta.faccounttableid and pav.fcompanyid = '").append(this.cond.getCompany().getId()).append("' ");
            sqlAccount.append("inner join ( select  r.FToUnitID id ,r.ffromUnitid fprofitcenterid from T_ORG_UnitRelation r inner join T_ORG_TypeRelation u ");
            sqlAccount.append(" on r.FTypeRelationID = u.FID WHERE r.ffromUnitid in " + this.cond.getProfitCenterIdsStr());
            sqlAccount.append(" AND u.FFromType = 6 AND u.ftoType = 1) tr");
            sqlAccount.append(" on  tr.id = ta.fcompanyid ");
            sqlAccount.append(" where ta.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' \r\n");
            String accountFilterSql = new PcaRptAccountFilter(this.getContex(), (GLRptBaseCondition)this.cond, "pav", "pav.fid", "pav.fcompanyid", false).getSQL();
            if (accountFilterSql != null) {
                sqlAccount.append(" \r\n AND ");
                sqlAccount.append(accountFilterSql);
            }
            sqlAccount.append(") TA");
            if (showExist) {
                sqlAccount.append(" inner join \t");
            } else {
                sqlAccount.append(" left outer join ");
            }
        }
        sqlAccount.append("( ");
        sqlAccount.append(this.getAccountBalanceSQL(sp));
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(") TB on TA.fnumber = TB.accountnumber and TB.fprofitcenterid = TA.fprofitcenterid ");
        }
        sqlAccount.append(" ) TB ON ");
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(" TA.Fid = TB.accountId \r\n");
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sqlAccount.append(" and tr.fprofitcenterid = TB.fprofitcenterid \r\n");
            }
        } else {
            sqlAccount.append(" TA.FNumber = TB.accountNumber \r\n");
        }
        sqlAccount.append(" WHERE TA.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' \r\n");
        if (this.cond.isShowLeafAccount()) {
            sqlAccount.append(" and TA.fisleaf = 1 \r\n");
        } else {
            sqlAccount.append(" and TA.flevel <= ? \r\n");
            sp.add(new Integer(this.cond.getAccountLevelEnd()));
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAccount.append(" AND TA.FCompanyId in ").append(this.cond.getCompanyIdsStr()).append(" \r\n");
        } else {
            sqlAccount.append(" AND TA.FCompanyId = ? \r\n");
            sp.add(this.getCompany().getId().toString());
        }
        if (!this.cond.getIncludeBWAccount()) {
            sqlAccount.append(" AND TA.FBW = 0 ");
        }
        if ((accountFilter = new PcaRptAccountFilter(this.getContex(), (GLRptBaseCondition)this.cond, "TA", "TA.fid", "TA.fcompanyid", false).getSQL()) != null) {
            sqlAccount.append(" AND ").append(accountFilter);
        }
        sqlAccount.append(") TP ");
        StringBuffer where = new StringBuffer();
        if (!this.cond.isNotIncluePLVoucher()) {
            where = this.buildWhereFilterSql("TP");
        }
        if (where.length() > 0 && this.cond.isNotIncluePLVoucher()) {
            if (this.isCreateDataTempTable()) {
                where.append(" or TP.accountNumber in (select accountNumber from ").append(plVoucherTempTable).append(")");
            } else {
                where.append(" or TP.accountID in (select accountid from ").append(plVoucherTempTable).append(")");
            }
        }
        sqlAccount.append(where);
        String sql = sqlAccount.toString();
        if (this.cond.isNotIncluePLVoucher()) {
            sql = this.getNotIncludePLVoucherSQL(sql, plVoucherTempTable);
        }
        this.insertData(sql, sp);
    }

    private void insertAssistBalance(String plVoucherTempTable) throws EASBizException, BOSException {
        StringBuffer sqlAssist = new StringBuffer();
        sqlAssist.append(" select TB.FAccountID ");
        if (this.isCreateDataTempTable()) {
            sqlAssist.append(" , TB.accountNumber");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(",TB.accountName");
        }
        sqlAssist.append(", 0 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sqlAssist.append(", TB.FBWType, 0 FIsAccountBWSum ");
        }
        if (this.isAllCurrency()) {
            sqlAssist.append(", TB.FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(", TB.FProfitCenterID ");
        }
        sqlAssist.append(", 1 FIsAssist, TB.FAssistGrpID FAssistGrpID");
        if (this.isShowQty()) {
            sqlAssist.append(", MU.FID FMeasureUnitID");
            sqlAssist.append(", MU.fname_").append(this.getContex().getLocale()).append(" measureUnit");
        }
        if (this.isCreateDataTempTable()) {
            this.addInsertSqlForCurrency(sqlAssist);
        }
        ArrayList params = new ArrayList();
        sqlAssist.append(" FROM (").append(this.getAssistBalanceSQL(params)).append(") TB \r\n");
        if (this.isShowQty()) {
            sqlAssist.append(" LEFT OUTER JOIN T_BD_AccountView TA ON TA.FID = TB.FAccountID LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = TA.FMeasureUnitID   \r\n");
        }
        StringBuffer where = new StringBuffer();
        if (!this.cond.isNotIncluePLVoucher()) {
            where = this.buildWhereFilterSqlForAssist();
        }
        sqlAssist.append(where);
        String sql = sqlAssist.toString();
        if (this.cond.isNotIncluePLVoucher()) {
            sql = this.getNotIncludePLVoucherSQL(sql, plVoucherTempTable);
        }
        this.insertData(sql, params);
    }

    protected boolean addAsstDataPermissionFilter(StringBuffer filter) throws EASBizException, BOSException {
        if (this.cond == null || !this.cond.getRptParams().useAccountPermission() || !this.cond.getDisplayAsstDetail()) {
            return false;
        }
        AsstAccountCollection asstAccountColl = this.getAsstAccountCollection();
        StringBuffer sql = new StringBuffer();
        boolean existPermSql = false;
        for (int m = 0; m < asstAccountColl.size(); ++m) {
            AsstAccountInfo caa = asstAccountColl.get(m);
            if (m > 0) {
                sql.append(" OR ");
            }
            sql.append("(");
            sql.append("assGrp.FAsstAccountID = '").append(caa.getId().toString()).append("'");
            AsstActGroupDetailCollection detailColl = caa.getAsstActGpDt();
            for (int n = 0; n < detailColl.size(); ++n) {
                AsstActTypeInfo at = detailColl.get(n).getAsstActType();
                if (at.getPermissionItem() == null) continue;
                try {
                    String permSql;
                    String strPermItem = at.getPermissionItem();
                    boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU((Context)this.cond.getCtx(), (String)strPermItem);
                    String companyId = this.cond.getCompany().getId().toString();
                    if (isPermissionByCU) {
                        companyId = this.cond.getCompany().getCU().getId().toString();
                    }
                    if ((permSql = GLRptDaoUtil.getDataPermissionSQL((Context)this.cond.getCtx(), (String)companyId, (String)at.getPermissionItem())) == null) continue;
                    sql.append(" and ").append("assGrp.").append(at.getMappingFieldName()).append(" in (").append(permSql).append(")");
                    existPermSql = true;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Get permission sql error!", (Throwable)e);
                }
            }
            sql.append(")");
        }
        if (existPermSql) {
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            filter.append("(").append(sql).append(")");
        }
        return existPermSql;
    }

    private AsstAccountCollection getAsstAccountCollection() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
        FilterInfo filter = new FilterInfo();
        StringBuffer accountIdSql = new StringBuffer();
        accountIdSql.append(" select lav.fid from t_bd_accountview lav ");
        accountIdSql.append(" inner join t_bd_accountview av on lav.fcompanyid = av.fcompanyid  ");
        accountIdSql.append(" and lav.faccounttableid = av.faccounttableid ");
        accountIdSql.append(" and (charindex(av.flongnumber||'!', lav.flongnumber) = 1 or av.fid = lav.fid)");
        accountIdSql.append(" where av.fid in (").append("SELECT distinct FAccountID FROM ").append(this.getDataSourceTableName()).append(" where FIsAccountTotal =0 and FIsAssist = 0").append(")");
        accountIdSql.append(" and lav.fcaa is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIdSql.toString(), CompareType.INNER));
        view.setFilter(filter);
        AccountViewCollection accountColl = AccountViewFactory.getLocalInstance((Context)this.cond.getCtx()).getAccountViewCollection(view);
        AsstAccountCollection asstAccountColl = new AsstAccountCollection();
        for (int i = 0; i < accountColl.size(); ++i) {
            AsstAccountInfo caa = accountColl.get(i).getCAA();
            if (asstAccountColl.contains((Object)caa.getId())) continue;
            asstAccountColl.add(caa);
        }
        return asstAccountColl;
    }

    private String getAssistBalanceSQL(List params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select b.faccountid ");
        if (this.isCreateDataTempTable()) {
            sql.append(", av.fnumber accountNumber");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(",av.").append(this.getAccountName());
            sql.append(" accountName");
        }
        if (this.cond.getIncludeBWAccount()) {
            sql.append(", av.fbw fbwtype");
        }
        sql.append(", b.fassistgrpid ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(", b.fprofitcenterid ");
        }
        if (this.isAllCurrency()) {
            sql.append(", b.fcurrencyid ");
        }
        if (this.isCreateDataTempTable()) {
            GLRptAccountBalQueryHelper helper = this.getQueryHelper();
            sql.append(helper.getAmountSelectSQL());
            sql.append(" from ").append(this.getAssistBalanceTable()).append(" b \r\n");
            sql.append(" inner join t_bd_accountview av on av.fid = b.faccountid \r\n");
            sql.append(" inner join ").append(this.sysStatusTmpTable).append(" ssc on ssc.fprofitcenterid = b.fprofitcenterid \r\n");
        } else {
            sql.append(" from ").append(this.getAssistBalanceTable()).append(" b ");
        }
        sql.append("\n inner join t_bd_assistAntHG assGrp on assGrp.FID=b.FAssistGrpID");
        sql.append(" where ");
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" b.fprofitcenterid = ? \r\n");
            params.add(this.cond.getProfitCenter().getId().toString());
        } else {
            sql.append(" b.fprofitcenterid in ").append(this.cond.getProfitCenterIdsStr()).append("\r\n");
        }
        int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        if (beginPeriod > this.cond.getCurrPeriod().getNumber()) {
            sql.append(" and  b.fperiod <= ? and ( b.fperiod >= ? or  b.fperiod >= ssc.fcurrPeriod) \r\n");
            Integer startPeriod = new Integer(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
            Integer endPeriod = new Integer(this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
            params.add(endPeriod);
            params.add(startPeriod);
        } else {
            sql.append(" and b.fperiod in ");
            sql.append(SQLUtil.buildPeriodNumbersInSql((boolean)false, (GLRptBaseCondition)this.cond));
        }
        if (this.cond.isAfterCurrPeriod()) {
            sql.append(" and b.fperiod >= ssc.fstartPeriod \r\n");
        }
        if (SQLUtil.isQueryByCurrency((GLRptBaseCondition)this.cond)) {
            sql.append(" and b.fcurrencyid = ? \r\n");
            params.add(this.cond.getCurrencyID());
        }
        if (this.isCreateDataTempTable()) {
            sql.append(" and av.faccounttableid = '").append(this.cond.getAccountTableId()).append("' ");
        }
        sql.append(" and exists (select 1 from ").append(this.getDataSourceTableName()).append(" t where ");
        if (this.isCreateDataTempTable()) {
            sql.append(" t.accountnumber = av.fnumber ");
        } else {
            sql.append(" t.faccountid = b.faccountid ");
        }
        if (this.isAllCurrency()) {
            sql.append(" and b.fcurrencyid = t.fcurrencyid ");
        }
        sql.append(") \r\n");
        this.addAsstDataPermissionFilter(sql);
        if (this.isCreateDataTempTable() || this.cond.getPeriodYearStart() != this.cond.getPeriodYearEnd() || this.cond.getPeriodNumberStart() != this.cond.getPeriodNumberEnd()) {
            sql.append(" group by b.faccountid ");
            if (this.isCreateDataTempTable()) {
                sql.append(", av.fnumber ");
            }
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",av.").append(this.getAccountName());
            }
            if (this.cond.getIncludeBWAccount()) {
                sql.append(", av.fbw");
            }
            if (this.isAllCurrency()) {
                sql.append(", b.fcurrencyid ");
            }
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                sql.append(", b.fprofitcenterid ");
            }
            sql.append(", b.fassistgrpid ");
        }
        return sql.toString();
    }

    private String getAccountBalanceSQL(List params) throws EASBizException, BOSException {
        String accountFilter;
        StringBuffer sql = new StringBuffer();
        sql.append(" select av.fid accountId ");
        if (this.isCreateDataTempTable()) {
            sql.append(" , av.fnumber accountNumber ");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(",av.").append(this.getAccountName());
            sql.append(" accountName");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(", ' ' fassistgrpid ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(", b.fprofitcenterid fprofitcenterid ");
        }
        if (this.isAllCurrency()) {
            sql.append(", b.fcurrencyid ");
        }
        if (this.isCreateDataTempTable()) {
            GLRptAccountBalQueryHelper helper = this.getQueryHelper();
            sql.append(helper.getAmountSelectSQL());
        }
        sql.append(" from ").append(this.getAccountBalanceTable()).append(" b \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = b.faccountid  \r\n");
        if (this.isCreateDataTempTable()) {
            sql.append(" inner join ").append(this.sysStatusTmpTable).append(" ssc on ssc.fprofitcenterid = b.fprofitcenterid ");
        }
        sql.append(" where ");
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" b.fprofitcenterid = ? \r\n");
            params.add(this.cond.getProfitCenter().getId().toString());
        } else {
            sql.append(" b.fprofitcenterid in ").append(this.cond.getProfitCenterIdsStr()).append("\r\n");
        }
        int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        if (beginPeriod > this.cond.getCurrPeriod().getNumber()) {
            sql.append(" and b.fperiod <= ? and (b.fperiod >= ? or b.fperiod >= ssc.fcurrPeriod) \r\n");
            Integer startPeriod = new Integer(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
            Integer endPeriod = new Integer(this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
            params.add(endPeriod);
            params.add(startPeriod);
        } else {
            sql.append(" and b.fperiod in ");
            sql.append(SQLUtil.buildPeriodNumbersInSql((boolean)false, (GLRptBaseCondition)this.cond));
        }
        if (this.cond.isAfterCurrPeriod()) {
            sql.append(" and b.fperiod >= ssc.fstartPeriod \r\n");
        }
        if (SQLUtil.isQueryByCurrency((GLRptBaseCondition)this.cond)) {
            sql.append(" and b.fcurrencyid = ? \r\n");
            params.add(this.cond.getCurrencyID());
        }
        if (this.cond.isShowLeafAccount()) {
            if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(" and av.fisleaf = 1 \r\n");
            }
        } else {
            sql.append(" and av.flevel <= ? \r\n");
            params.add(new Integer(this.cond.getAccountLevelEnd()));
        }
        if ((accountFilter = new PcaRptAccountFilter(this.getContex(), (GLRptBaseCondition)this.cond, "av", "av.fid", "b.forgunitid", false).getSQL()) != null) {
            sql.append(" and ").append(accountFilter);
        }
        sql.append(" and av.faccounttableid = ? \r\n");
        params.add(this.cond.getAccountTableId());
        sql.append(" group by av.fid ");
        if (this.isCreateDataTempTable()) {
            sql.append(", av.fnumber");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(",av.").append(this.getAccountName());
        }
        if (this.isAllCurrency()) {
            sql.append(" ,b.fcurrencyid ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(" ,b.fprofitcenterid ");
        }
        return sql.toString();
    }

    protected void insertAccountSum(boolean isBW) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct ' ' FAccountID ");
        if (this.isCreateDataTempTable()) {
            sql.append(", to_char(null) accountNumber");
        }
        sql.append(", 1 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            if (isBW) {
                sql.append(" ,TP.FBWType ");
                sql.append(" ,1 FIsAccountBWSum ");
            } else {
                sql.append(" ,2 FBWType ");
                sql.append(" ,2 FIsAccountBWSum ");
            }
        }
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.FProfitCenterID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",0 FIsAssist, ' ' FAssistGrpID ");
        }
        sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TP \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" where TP.FProfitCenterID is not null");
        }
        ArrayList params = new ArrayList();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("FAccountID");
        if (this.isCreateDataTempTable()) {
            fields.add("accountNumber");
        }
        fields.add("FIsAccountTotal");
        if (this.cond.getIncludeBWAccount()) {
            fields.add("FBWType");
            fields.add("FIsAccountBWSum");
        }
        if (this.isAllCurrency()) {
            fields.add("FCurrencyID");
            fields.add("FIsCurrencyTotal");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            fields.add("FProfitCenterID");
        }
        if (this.cond.getDisplayAsstDetail()) {
            fields.add("FIsAssist");
            fields.add("FAssistGrpID");
        }
        String[] fs = new String[fields.size()];
        this.insertData(fields.toArray(fs), sql.toString(), params);
    }

    protected String createPLVoucherTempTable() throws BOSException, EASBizException {
        String accountFilter;
        StringBuffer struct = new StringBuffer();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            struct.append("profitcenterid varchar(44),");
        }
        struct.append("accountid varchar(44),accountNumber nvarchar(80)");
        if (this.isAllCurrency()) {
            struct.append(",currencyid varchar(44)");
        }
        if (this.cond.getDisplayAsstDetail()) {
            struct.append(",hgid varchar(44)");
        }
        if (this.isShowFor()) {
            struct.append(",debitfor NUMERIC(28,10)");
            struct.append(",creditfor NUMERIC(28,10)");
            struct.append(",yeardebitfor NUMERIC(28,10)");
            struct.append(",yearcreditfor NUMERIC(28,10)");
        }
        if (this.isShowLocal()) {
            struct.append(",debitlocal NUMERIC(28,10)");
            struct.append(",creditlocal NUMERIC(28,10)");
            struct.append(",yeardebitlocal NUMERIC(28,10)");
            struct.append(",yearcreditlocal NUMERIC(28,10)");
        }
        if (this.isShowRpt()) {
            struct.append(",debitrpt NUMERIC(28,10)");
            struct.append(",creditrpt NUMERIC(28,10)");
            struct.append(",yeardebitrpt NUMERIC(28,10)");
            struct.append(",yearcreditrpt NUMERIC(28,10)");
        }
        if (this.isShowQty()) {
            struct.append(",debitqty NUMERIC(28,10)");
            struct.append(",creditqty NUMERIC(28,10)");
            struct.append(",yeardebitqty NUMERIC(28,10)");
            struct.append(",yearcreditqty NUMERIC(28,10)");
        }
        StringBuffer indexStr = new StringBuffer();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            indexStr.append(" profitcenterid, ");
        }
        indexStr.append("accountNumber");
        if (this.isAllCurrency()) {
            indexStr.append(",currencyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            indexStr.append(",hgid ");
        }
        String plVoucherTempTable = GLTempTableUtil.createDBSysTempTable((Context)this.getContex(), (String)struct.toString(), (String)indexStr.toString());
        StringBuffer sql = new StringBuffer("select ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append("v.fprofitcenterid profitcenterid,");
        }
        sql.append("av.fid accountid, av.fnumber accountNumber");
        if (this.isAllCurrency()) {
            sql.append(",ve.fcurrencyid currencyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",' ' hgid ");
        }
        if (this.isShowFor()) {
            sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then ve.FOriginalAmount else 0 end)").append(" debitfor \r\n");
            sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then ve.FOriginalAmount else 0 end)").append(" creditfor \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FOriginalAmount else 0 end) yeardebitfor \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FOriginalAmount else 0 end) yearcreditfor \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then ve.FLocalAmount else 0 end) debitlocal \r\n");
            sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then ve.FLocalAmount else 0 end) creditlocal \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FLocalAmount else 0 end) yeardebitlocal \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FLocalAmount else 0 end) yearcreditlocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then ve.FReportingAmount else 0 end) debitrpt \r\n");
            sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then ve.FReportingAmount else 0 end) creditrpt \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FReportingAmount else 0 end) yeardebitrpt \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FReportingAmount else 0 end) yearcreditrpt \r\n");
        }
        if (this.isShowQty()) {
            sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then ve.FStandardQuantity else 0 end) debitqty \r\n");
            sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then ve.FStandardQuantity else 0 end) creditqty \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FStandardQuantity else 0 end) yeardebitqty \r\n");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ve.FStandardQuantity else 0 end) yearcreditqty \r\n");
        }
        sql.append(" from t_pca_pcvoucher v \r\n");
        sql.append(" inner join t_pca_pcvoucherentry ve on ve.fbillid = v.fid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid \r\n");
        ArrayList<Object> sp = new ArrayList<Object>();
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        sql.append(" where v.fbizstatus ").append(this.cond.getOptionPosting() ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and v.fprofitcenterid = ?");
            sp.add(this.cond.getProfitCenter().getId().toString());
        } else {
            sql.append(" and v.fprofitcenterid in ").append(this.cond.getProfitCenterIdsStr());
        }
        sql.append(" and av.faccounttableid = ? ");
        sp.add(this.cond.getAccountTableId());
        if (this.cond.isShowLeafAccount() && (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) && (accountFilter = new PcaRptAccountFilter(this.getContex(), (GLRptBaseCondition)this.cond, "av", "av.fid", "v.fcompanyid", false).getSQL()) != null) {
            sql.append(" and ").append(accountFilter);
        }
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
        sp.add(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
        sp.add(this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
        if (!(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || this.isAllCurrency())) {
            sql.append(" and ve.fcurrencyid = ?");
            sp.add(this.cond.getCurrencyID());
        }
        sql.append("\r\n group by ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append("v.fprofitcenterid, ");
        }
        sql.append("av.fid, av.fnumber");
        if (this.isAllCurrency()) {
            sql.append(",ve.fcurrencyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(" union all ");
            sql.append(" select ");
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                sql.append("v.fprofitcenterid profitcenterid,");
            }
            sql.append("av.fid accountid, av.fnumber accountNumber");
            if (this.isAllCurrency()) {
                sql.append(",ve.fcurrencyid currencyid");
            }
            sql.append(",r.fassgrpid hgid");
            if (this.isShowFor()) {
                sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then r.FOriginalAmount else 0 end)").append(" debitfor \r\n");
                sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then r.FOriginalAmount else 0 end)").append(" creditfor \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FOriginalAmount else 0 end) yeardebitfor \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FOriginalAmount else 0 end) yearcreditfor \r\n");
            }
            if (this.isShowLocal()) {
                sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then r.FLocalAmount else 0 end) debitlocal \r\n");
                sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then r.FLocalAmount else 0 end) creditlocal \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FLocalAmount else 0 end) yeardebitlocal \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FLocalAmount else 0 end) yearcreditlocal \r\n");
            }
            if (this.isShowRpt()) {
                sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then r.FReportingAmount else 0 end) debitrpt \r\n");
                sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then r.FReportingAmount else 0 end) creditrpt \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FReportingAmount else 0 end) yeardebitrpt \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FReportingAmount else 0 end) yearcreditrpt \r\n");
            }
            if (this.isShowQty()) {
                sql.append(" ,sum(case ve.FEntryDC when ").append(1).append(" then r.FStandardQuantity else 0 end) debitqty \r\n");
                sql.append(" ,sum(case ve.FEntryDC when ").append(0).append(" then r.FStandardQuantity else 0 end) creditqty \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FStandardQuantity else 0 end) yeardebitqty \r\n");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then r.FStandardQuantity else 0 end) yearcreditqty \r\n");
            }
            sql.append(" from t_pca_pcvoucher v \r\n");
            sql.append(" inner join t_pca_pcvoucherentry ve on ve.fbillid = v.fid \r\n");
            sql.append(" inner join t_pca_pcvoucherassistrecord r on r.fbillid = v.fid and r.fentryid = ve.fid \r\n");
            sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid \r\n");
            sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
            sql.append(" where v.fbizstatus ").append(this.cond.getOptionPosting() ? " in (1,3,5)" : "=5");
            sql.append(" and fsourcetype = ").append(1);
            if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
                sql.append(" and v.fprofitcenterid = ?");
                sp.add(this.cond.getProfitCenter().getId().toString());
            } else {
                sql.append(" and v.fprofitcenterid in ").append(this.cond.getProfitCenterIdsStr());
            }
            sql.append(" and av.faccounttableid = ? ");
            sp.add(this.cond.getAccountTableId());
            if (this.cond.isShowLeafAccount() && (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) && (accountFilter = new PcaRptAccountFilter(this.getContex(), (GLRptBaseCondition)this.cond, "av", "av.fid", "v.fcompanyid", false).getSQL()) != null) {
                sql.append(" and ").append(accountFilter);
            }
            sql.append(" and pd.ftypeid = ?");
            sp.add(this.cond.getPeriodTypeId());
            sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
            sp.add(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart());
            sp.add(this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd());
            if (!(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || this.isAllCurrency())) {
                sql.append(" and ve.fcurrencyid = ?");
                sp.add(this.cond.getCurrencyID());
            }
            sql.append("\r\n group by ");
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                sql.append("v.fprofitcenterid , ");
            }
            sql.append("av.fid, av.fnumber,");
            if (this.isAllCurrency()) {
                sql.append("ve.fcurrencyid,");
            }
            sql.append("r.fassgrpid");
        }
        DbUtil.execute((Context)this.getContex(), (String)("insert into " + plVoucherTempTable + " " + sql.toString()), (Object[])sp.toArray());
        try {
            if (!this.cond.isShowLeafAccount() || CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
                this.insertPLAccountSum(plVoucherTempTable);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
        return plVoucherTempTable;
    }

    private void insertPLAccountSum(String table) throws BOSException, EASBizException, SQLException {
        for (int maxLevel = this.getMaxPLAccountLevel(table); maxLevel > 1; --maxLevel) {
            StringBuffer accountSum = new StringBuffer(" select ");
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                accountSum.append("t.profitcenterid profitcenterid,");
            }
            accountSum.append("av.fid accountid, av.fnumber accountNumber");
            if (this.isAllCurrency()) {
                accountSum.append(",t.currencyid currencyid ");
            }
            if (this.cond.getDisplayAsstDetail()) {
                accountSum.append(",' ' hgid ");
            }
            if (this.isShowFor()) {
                accountSum.append(" ,sum(debitfor) debitfor \r\n");
                accountSum.append(" ,sum(creditfor) creditfor \r\n");
                accountSum.append(" ,sum(yeardebitfor) yeardebitfor \r\n");
                accountSum.append(" ,sum(yearcreditfor) yearcreditfor \r\n");
            }
            if (this.isShowLocal()) {
                accountSum.append(" ,sum(debitlocal) debitlocal \r\n");
                accountSum.append(" ,sum(creditlocal) creditlocal \r\n");
                accountSum.append(" ,sum(yeardebitlocal) yeardebitlocal \r\n");
                accountSum.append(" ,sum(yearcreditlocal) yearcreditlocal \r\n");
            }
            if (this.isShowRpt()) {
                accountSum.append(" ,sum(debitrpt) debitrpt \r\n");
                accountSum.append(" ,sum(creditrpt) creditrpt \r\n");
                accountSum.append(" ,sum(yeardebitrpt) yeardebitrpt \r\n");
                accountSum.append(" ,sum(yearcreditrpt) yearcreditrpt \r\n");
            }
            if (this.isShowQty()) {
                accountSum.append(" ,sum(debitqty) debitqty \r\n");
                accountSum.append(" ,sum(creditqty) creditqty \r\n");
                accountSum.append(" ,sum(yeardebitqty) yeardebitqty \r\n");
                accountSum.append(" ,sum(yearcreditqty) yearcreditqty \r\n");
            }
            accountSum.append(" from ").append(table).append(" t \r\n");
            accountSum.append(" inner join t_bd_accountview lav on lav.fid = t.accountid \r\n");
            accountSum.append(" inner join t_bd_accountview av on av.fid = lav.fparentid \r\n");
            accountSum.append(" where lav.flevel = ? ");
            if (this.cond.getDisplayAsstDetail()) {
                accountSum.append(" and t.hgid = ' ' \r\n");
            }
            accountSum.append(" group by \r\n");
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                accountSum.append("t.profitcenterid, ");
            }
            accountSum.append("av.fid, av.fnumber ");
            if (this.isAllCurrency()) {
                accountSum.append(",t.currencyid ");
            }
            ArrayList<Integer> params = new ArrayList<Integer>();
            params.add(new Integer(maxLevel));
            this.execute("insert into " + table + accountSum.toString(), params.toArray());
        }
    }

    private int getMaxPLAccountLevel(String plBalanceTable) throws BOSException, SQLException, EASBizException {
        int maxLevel = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(av.flevel) maxLevel from ").append(plBalanceTable).append(" temp \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = temp.accountid \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" and av.fcompanyid = temp.profitcenterid  ");
        }
        IRowSet rs = this.executeQuery(sql.toString());
        while (rs.next()) {
            maxLevel = rs.getInt("maxLevel");
        }
        return maxLevel;
    }

    protected String getNotIncludePLVoucherSQL(String sqlToBeExcute, String plVoucherTempTable) throws BOSException, EASBizException {
        boolean balanceDirSamAsAccount = this.cond.isBalanceDirSamAsAccount();
        StringBuffer tempSql = new StringBuffer();
        StringBuffer where = this.buildWhereFilterSql(" tpnl ");
        if (where.length() > 0) {
            tempSql.append(" select tpnl.* from (");
        }
        tempSql.append(" select t1.FAccountID, t1.accountNumber");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            tempSql.append(", t1.accountName");
        }
        tempSql.append(", t1.FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            tempSql.append(" ,t1.FBWType ");
            tempSql.append(" ,t1.FIsAccountBWSum ");
        }
        if (this.isAllCurrency()) {
            tempSql.append(",t1.FCurrencyID ");
            tempSql.append(",t1.FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            tempSql.append(",t1.FProfitCenterID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            tempSql.append(",t1.FIsAssist ");
            tempSql.append(",t1.FAssistGrpID ");
        }
        if (this.isShowQty()) {
            tempSql.append(", t1.FMeasureUnitID  \r\n");
            tempSql.append(", t1.measureUnit  \r\n");
            tempSql.append(", t1.FBeginQty  \r\n");
        }
        if (this.isShowFor()) {
            tempSql.append(", t1.FBeginBalanceFor\t\r\n");
        }
        if (this.isShowLocal()) {
            tempSql.append(", t1.FBeginBalanceLocal\t\r\n");
        }
        if (this.isShowRpt()) {
            tempSql.append(", t1.FBeginBalanceRpt\t\r\n");
        }
        if (this.isShowQty()) {
            tempSql.append(", t1.FDebitQty - isnull(t2.DebitQty,0) FDebitQty \r\n");
        }
        if (this.isShowFor()) {
            tempSql.append(", t1.FDebitFor - isnull(t2.DebitFor,0) FDebitFor");
        }
        if (this.isShowLocal()) {
            tempSql.append(", t1.FDebitLocal - isnull(t2.DebitLocal,0) FDebitLocal");
        }
        if (this.isShowRpt()) {
            tempSql.append(", t1.FDebitRpt - isnull(t2.DebitRpt,0) FDebitRpt");
        }
        if (this.isShowQty()) {
            tempSql.append(", t1.FCreditQty - isnull(t2.CreditQty,0) FCreditQty \r\n");
        }
        if (this.isShowFor()) {
            tempSql.append(", t1.FCreditFor - isnull(t2.CreditFor,0) FCreditFor \r\n");
        }
        if (this.isShowLocal()) {
            tempSql.append(", t1.FCreditLocal - isnull(t2.CreditLocal,0) FCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            tempSql.append(", t1.FCreditRpt - isnull(t2.CreditRpt,0) FCreditRpt \r\n");
        }
        if (this.isShowQty()) {
            tempSql.append(", t1.FYearDebitQty - isnull(t2.YearDebitQty,0) FYearDebitQty \r\n");
        }
        if (this.isShowFor()) {
            tempSql.append(", t1.FYearDebitFor - isnull(t2.YearDebitFor,0) FYearDebitFor");
        }
        if (this.isShowLocal()) {
            tempSql.append(", t1.FYearDebitLocal - isnull(t2.YearDebitLocal,0) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            tempSql.append(", t1.FYearDebitRpt - isnull(t2.YearDebitRpt,0) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            tempSql.append(", t1.FYearCreditQty - isnull(t2.YearCreditQty,0) FYearCreditQty \r\n");
        }
        if (this.isShowFor()) {
            tempSql.append(", t1.FYearCreditFor - isnull(t2.YearCreditFor,0) FYearCreditFor\t\r\n");
        }
        if (this.isShowLocal()) {
            tempSql.append(", t1.FYearCreditLocal - isnull(t2.YearCreditLocal,0) FYearCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            tempSql.append(", t1.FYearCreditRpt - isnull(t2.YearCreditRpt,0) FYearCreditRpt \r\n");
        }
        if (this.isShowQty()) {
            tempSql.append(", t1.FEndQty + isnull(t2.CreditQty,0) - isnull(t2.DebitQty, 0) FEndQty \r\n");
        }
        if (this.isShowFor()) {
            tempSql.append(", t1.FEndBalanceFor + isnull(t2.CreditFor,0) - isnull(t2.DebitFor,0) FEndBalanceFor \r\n");
        }
        if (this.isShowLocal()) {
            tempSql.append(", t1.FEndBalanceLocal + isnull(t2.CreditLocal,0) - isnull(t2.DebitLocal,0) FEndBalanceLocal \r\n");
        }
        if (this.isShowRpt()) {
            tempSql.append(", t1.FEndBalanceRpt + isnull(t2.CreditRpt,0) - isnull(t2.DebitRpt,0) FEndBalanceRpt \r\n");
        }
        tempSql.append(" from (").append(sqlToBeExcute).append(") t1 \r\n");
        tempSql.append(" left outer join ").append(plVoucherTempTable).append(" t2 on t1.accountNumber = t2.accountNumber ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            tempSql.append(" and t1.fprofitcenterid = t2.profitcenterid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            tempSql.append(" and t1.FAssistGrpID = t2.hgid ");
        }
        if (this.isAllCurrency()) {
            tempSql.append(" and t1.fcurrencyid = t2.currencyid ");
        }
        if (where.length() > 0) {
            tempSql.append(") tpnl \r\n");
            tempSql.append(where);
        }
        return tempSql.toString();
    }

    protected void insertCurrencySum() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FAccountID, TP.accountNumber");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.accountName");
        }
        sql.append(", TP.FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sql.append(" ,TP.FBWType ");
            sql.append(" ,TP.FIsAccountBWSum ");
        }
        sql.append(",' ' FCurrencyID, 1 FIsCurrencyTotal ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.FProfitCenterID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",0 FIsAssist,' ' FAssistGrpID ");
        }
        if (this.isShowQty()) {
            sql.append(", '' FMeasureUnitID");
            sql.append(", '' measureUnit");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FBeginQty) FBeginQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FBeginBalanceLocal,0)) FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FBeginBalanceRpt,0)) FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FDebitQty) FDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FDebitLocal,0)) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FDebitRpt,0)) FDebitRPT");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FCreditQty) FCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FCreditLocal,0)) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FCreditRpt,0)) FCreditRPT");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FYearDebitQty) FYearDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FYearDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FYearDebitLocal,0)) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FYearDebitRpt,0)) FYearDebitRPT");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FYearCreditQty) FYearCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FYearCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FYearCreditLocal,0)) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FYearCreditRpt,0)) FYearCreditRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",sum(FEndQty) FEndQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FEndBalanceLocal,0)) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FEndBalanceRpt,0)) FEndBalanceRpt");
        }
        sql.append("\r\n FROM ").append(this.getDataSourceTableName()).append(" TP \r\n");
        sql.append(" left outer join T_BD_AccountView TA ON TP.FAccountID = TA.FID \t\t\t\r\n");
        if (this.isShowQty()) {
            sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = TA.FMeasureUnitID  \r\n");
        }
        if (this.isAllCurrency()) {
            sql.append(" where TP.FCurrencyID is not null \r\n");
        }
        sql.append(" group by TP.FIsAccountTotal, TP.FAccountID, TP.accountNumber ");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(", TP.accountName");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.FProfitCenterID ");
        }
        if (this.cond.getIncludeBWAccount()) {
            sql.append(",TP.FBWType,TP.FIsAccountBWSum ");
        }
        this.insertData(sql.toString());
    }

    protected void insertCompanySum() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(" '' FAccountID");
        } else {
            sql.append(" TP.FAccountID");
        }
        sql.append(" ,TP.accountNumber");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(", TP.accountName");
        }
        sql.append(", TP.FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sql.append(" ,TP.FBWType ");
            sql.append(" ,TP.FIsAccountBWSum ");
        }
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID, TP.FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(",'").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(", '").append(this.cond.getProfitCenter().getId().toString()).append("'");
        } else if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        sql.append(" FProfitCenterID ");
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",0 FIsAssist,' ' FAssistGrpID ");
        }
        if (this.isShowQty()) {
            sql.append(", '' FMeasureUnitID");
            sql.append(", '' measureUnit");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FBeginQty");
            } else {
                sql.append(",sum(FBeginQty) FBeginQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FBeginBalanceFor) FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FBeginBalanceLocal) FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FBeginBalanceRpt) FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FDebitQty");
            } else {
                sql.append(",sum(FDebitQty) FDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FDebitFor) FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FDebitLocal) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FDebitRpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FCreditQty");
            } else {
                sql.append(",sum(FCreditQty) FCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FCreditFor) FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FCreditLocal) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FCreditRpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearDebitQty");
            } else {
                sql.append(",sum(FYearDebitQty) FYearDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearDebitFor) FYearDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearDebitLocal) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearDebitRpt) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearCreditQty");
            } else {
                sql.append(",sum(FYearCreditQty) FYearCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearCreditFor) FYearCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearCreditLocal) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearCreditRpt) FYearCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FEndQty");
            } else {
                sql.append(",sum(FEndQty) FEndQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FEndBalanceFor) FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FEndBalanceLocal) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FEndBalanceRpt) FEndBalanceRpt");
        }
        sql.append(" \r\n");
        sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TP \r\n");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" inner join t_org_profitcenter cp on cp.fid = tp.FProfitCenterID \r\n");
            sql.append(" where ");
            sql.append(" cp.flevel = ? ");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" where TP.FProfitCenterID is not null \r\n");
        }
        sql.append(" group by ");
        if (CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode()) {
            sql.append("TP.FAccountID, ");
        }
        sql.append(" TP.accountNumber");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(", TP.accountName");
        }
        sql.append(", TP.FIsAccountTotal ");
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID, TP.FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        if (this.cond.getIncludeBWAccount()) {
            sql.append(",TP.FBWType,TP.FIsAccountBWSum ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            int maxLevel;
            for (int i = maxLevel = this.getMaxProfitCenterLevel(); i > this.cond.getProfitCenter().getLevel(); --i) {
                ArrayList<Integer> sp = new ArrayList<Integer>();
                sp.add(new Integer(i));
                this.insertData(sql.toString(), sp);
            }
        } else if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            this.insertData(sql.toString());
        }
    }

    protected int getMaxProfitCenterLevel() throws BOSException {
        IRowSet rs = this.executeQuery("select max(FLevel) maxLevel from t_org_profitcenter where fid in " + this.cond.getProfitCenterIdsStr());
        try {
            if (rs.next()) {
                return rs.getInt("maxLevel");
            }
            return 1;
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
    }

    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new PcaRptAccountBalPageQuery(this.getContex(), this.cond, this.isCreateDataTempTable(), this.getQueryHelper());
    }

    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        if (this.isCreateDataTempTable()) {
            selector.add(GLRptField.accountNumberMerger);
        } else {
            selector.add(GLRptField.accountNumber);
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            if (this.cond.getRptParams().isAccountShowLongName()) {
                selector.add(GLRptField.accountDisplayNameMerger);
            } else {
                selector.add(GLRptField.accountNameMerger);
            }
        } else {
            selector.add(this.cond.getRptParams().isAccountShowLongName() ? GLRptField.accountDisplayName : GLRptField.accountName);
        }
        selector.add(GLRptField.accountDC);
        selector.add(new GLRptField("FIsAccountTotal", "t.FIsAccountTotal", "FIsAccountTotal", "INT"));
        if (this.cond.getIncludeBWAccount()) {
            selector.add(new GLRptField("FBWType", "t.FBWType", "FBWType", "INT"));
            selector.add(new GLRptField("FIsAccountBWSum", "t.FIsAccountBWSum", "FIsAccountBWSum", "INT"));
        }
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.currencyName);
            selector.add(GLRptField.currencyPre);
            selector.add(new GLRptField("FIsCurrencyTotal", "t.FIsCurrencyTotal", "FIsCurrencyTotal", "INT"));
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            selector.add(PcaRptField.profitCenterID);
            selector.add(PcaRptField.profitCenterName);
        }
        if (this.cond.getDisplayAsstDetail()) {
            selector.add(new GLRptField("FIsAssist", "t.FIsAssist", "FIsAssist", "INT"));
            selector.add(GLRptField.HG);
            selector.add(GLRptField.HGName);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.measureUnitID);
            selector.add(GLRptField.accountMeasureUnitName);
            selector.add(GLRptField.yearBeginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearBeginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearBeginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearBeginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.endQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.endBalanceRpt);
        }
        return selector;
    }

    protected GLRptField getFreezeField() {
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            return PcaRptField.profitCenterName;
        }
        if (this.isAllCurrency()) {
            return GLRptField.currencyName;
        }
        return GLRptField.accountName;
    }

    public GLRptField getTreeColmun() {
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            return PcaRptField.profitCenterName;
        }
        return null;
    }

    public void buildData() throws BOSException, EASBizException {
        this.insertData();
    }

    protected void insertData() throws BOSException, EASBizException {
        String plVoucherTempTable = null;
        if (this.cond.isNotIncluePLVoucher()) {
            plVoucherTempTable = this.createPLVoucherTempTable();
        }
        if (this.isCreateDataTempTable()) {
            this.createSysStatusTmpTable();
        }
        this.insertAccountBalance(plVoucherTempTable);
        if (this.cond.getIncludeBWAccount()) {
            this.insertAccountSum(true);
        }
        this.insertAccountSum(false);
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.insertCompanySum();
        }
        if (this.isAllCurrency()) {
            this.insertCurrencySum();
        }
        if (this.cond.getDisplayAsstDetail()) {
            this.insertAssistBalance(plVoucherTempTable);
        }
    }

    private StringBuffer buildWhereFilterSqlForAssist() throws EASBizException, BOSException {
        StringBuffer str;
        StringBuffer where = new StringBuffer();
        where.append(" where 1 = 1 ");
        if (this.cond.isOptionAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((TB.FDebitFor <> 0) OR (TB.FCreditFor <>0 )) ");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FDebitLocal <> 0) OR (TB.FCreditLocal <>0 )) ");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append("((TB.FDebitRpt <> 0) OR (TB.FCreditRpt <>0 )) ");
            }
            where.append(" and (").append(str).append(")");
        }
        if (this.cond.isOptionBalanceZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" (TB.FEndBalanceFor <> 0) ");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" (TB.FEndBalanceLocal <> 0) ");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" (TB.FEndBalanceRpt <> 0) ");
            }
            where.append(" and (").append(str).append(") ");
        }
        if (this.cond.getOptionYearAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((TB.FYearDebitFor <> 0) OR (TB.FYearCreditFor <>0 )) ");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FYearDebitLocal <> 0) OR (TB.FYearCreditLocal <>0 )) ");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FYearDebitRpt <> 0) OR (TB.FYearCreditRpt <>0 )) ");
            }
            where.append(" and (").append(str).append(") ");
        }
        if (this.cond.isOptionAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((TB.FDebitFor <> 0) OR (TB.FCreditFor <>0 ) OR (TB.FEndBalanceFor <> 0)) ");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FDebitLocal <> 0) OR (TB.FCreditLocal <>0 ) OR (TB.FEndBalanceLocal <> 0)) ");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FDebitRpt <> 0) OR (TB.FCreditRpt <>0 ) OR (TB.FEndBalanceRpt <> 0)) ");
            }
            where.append(" and (").append(str).append(") ");
        }
        if (this.cond.getOptionYearAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((TB.FYearDebitFor <> 0) OR (TB.FYearCreditFor <>0 ) OR (TB.FEndBalanceFor <> 0)) ");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FYearDebitLocal <> 0) OR (TB.FYearCreditLocal <>0 ) OR (TB.FEndBalanceLocal <> 0)) ");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((TB.FYearDebitRpt <> 0) OR (TB.FYearCreditRpt <>0 ) OR (TB.FEndBalanceRpt <> 0)) ");
            }
            where.append(" and (").append(str).append(") ");
        }
        return where;
    }

    private StringBuffer buildWhereFilterSql(String t) throws EASBizException, BOSException {
        StringBuffer str;
        StringBuffer where = new StringBuffer();
        where.append(" where 1 = 1 ");
        if (this.cond.isOptionAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FDebitFor <> 0) OR (").append(t).append(".FCreditFor <>0 ))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FDebitLocal <> 0) OR (").append(t).append(".FCreditLocal <>0 ))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FDebitRpt <> 0) OR (").append(t).append(".FCreditRpt <>0 ))");
            }
            where.append(" and (").append(str).append(" ) ");
        }
        if (this.cond.isOptionBalanceZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(" and (").append(str).append(" ) ");
        }
        if (this.cond.getOptionYearAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FYearDebitFor <> 0) OR (").append(t).append(".FYearCreditFor <>0 ))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitLocal <> 0) OR (").append(t).append(".FYearCreditLocal <>0 ))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitRpt <> 0) OR (").append(t).append(".FYearCreditRpt <>0 ))");
            }
            where.append(" and (").append(str).append(" ) ");
        }
        if (this.cond.isOptionAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FDebitFor <> 0) OR (").append(t).append(".FCreditFor <>0 ) OR (").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FDebitLocal <> 0) OR (").append(t).append(".FCreditLocal <>0 ) OR (").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FDebitRpt <> 0) OR (").append(t).append(".FCreditRpt <>0 ) OR (").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(" and (").append(str).append(" ) ");
        }
        if (this.cond.getOptionYearAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FYearDebitFor <> 0) OR (").append(t).append(".FYearCreditFor <>0 ) OR (").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitLocal <> 0) OR (").append(t).append(".FYearCreditLocal <>0 ) OR (").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitRpt <> 0) OR (").append(t).append(".FYearCreditRpt <>0 ) OR (").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(" and (").append(str).append(" ) ");
        }
        return where;
    }

    private String getBalanceSumSQL(boolean isAsstBal, int bwType) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.faccountid");
        if (this.isAllCurrency()) {
            sql.append(", t.fcurrencyid");
        }
        GLRptAccountBalQueryHelper helper = this.getQueryHelper();
        sql.append(helper.getAmountSelectSQL());
        sql.append(helper.getFromSQL(isAsstBal, this.getDataSourceTableName()));
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        sql.append(helper.getWhereSQL());
        if (bwType == 0 || bwType == 1) {
            sql.append(" and t.FBWType = ").append(bwType);
        }
        if (!isAsstBal) {
            if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst() && (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode())) {
                sql.append(" and ((av.FCAA IS NULL AND t.FIsAssist = 0 and (av.fisleaf = 1 or av.flevel = ").append(this.cond.getAccountLevelEnd()).append("))");
                sql.append(" OR (av.FCAA IS not NULL AND t.FIsAssist = 0 and av.FLevel = ").append(this.cond.getAccountLevelEnd()).append(" and av.FIsLeaf = 0)) ");
            } else if (this.cond.isShowLeafAccount()) {
                sql.append(" and ").append(" av.FIsLeaf = 1 ");
            } else if (this.cond.getAccountLevelEnd() == 1) {
                sql.append(" and ").append(" av.flevel = 1 ");
            } else {
                sql.append(" and b.faccountid in (").append(this.getAccountIdFilter4Sum()).append(")");
            }
        }
        sql.append(" group by t.faccountid");
        if (this.isAllCurrency()) {
            sql.append(", t.fcurrencyid");
        }
        return sql.toString();
    }

    private AccountViewCollection getAccountInfoByTempTable() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.cond.getCompanyIds(), CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.getCompany().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.cond.getAccountTableId()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select faccountid from " + this.getDataSourceTableName()), CompareType.INNER));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("companyID.id"));
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return AccountViewFactory.getLocalInstance((Context)this.getContex()).getAccountViewCollection(view);
    }

    private void setAcountSumAmount(IRowSet rs, IGLRptRowData rowData) throws BOSException, SQLException, EASBizException {
        if (!rs.next()) {
            return;
        }
        if (this.isShowQty()) {
            rowData.updateBigDecimal("FYearBeginDebitQty", rs.getBigDecimal("FYearBeginDebitQty"));
            rowData.updateBigDecimal("FYearBeginCreditQty", rs.getBigDecimal("FYearBeginCreditQty"));
            rowData.updateBigDecimal("FBeginDebitQty", rs.getBigDecimal("FBeginDebitQty"));
            rowData.updateBigDecimal("FBeginCreditQty", rs.getBigDecimal("FBeginCreditQty"));
            rowData.updateBigDecimal("FDebitQty", rs.getBigDecimal("FDebitQty"));
            rowData.updateBigDecimal("FCreditQty", rs.getBigDecimal("FCreditQty"));
            rowData.updateBigDecimal("FYearDebitQty", rs.getBigDecimal("FYearDebitQty"));
            rowData.updateBigDecimal("FYearCreditQty", rs.getBigDecimal("FYearCreditQty"));
            rowData.updateBigDecimal("FEndDebitQty", rs.getBigDecimal("FEndDebitQty"));
            rowData.updateBigDecimal("FEndCreditQty", rs.getBigDecimal("FEndCreditQty"));
        }
        if (this.isShowFor()) {
            rowData.updateBigDecimal("FYearBeginDebitBalanceFor", rs.getBigDecimal("FYearBeginDebitBalanceFor"));
            rowData.updateBigDecimal("FYearBeginCreditBalanceFor", rs.getBigDecimal("FYearBeginCreditBalanceFor"));
            rowData.updateBigDecimal("FBeginDebitBalanceFor", rs.getBigDecimal("FBeginDebitBalanceFor"));
            rowData.updateBigDecimal("FBeginCreditBalanceFor", rs.getBigDecimal("FBeginCreditBalanceFor"));
            rowData.updateBigDecimal("FDebitFor", rs.getBigDecimal("FDebitFor"));
            rowData.updateBigDecimal("FCreditFor", rs.getBigDecimal("FCreditFor"));
            rowData.updateBigDecimal("FYearDebitFor", rs.getBigDecimal("FYearDebitFor"));
            rowData.updateBigDecimal("FYearCreditFor", rs.getBigDecimal("FYearCreditFor"));
            rowData.updateBigDecimal("FEndDebitBalanceFor", rs.getBigDecimal("FEndDebitBalanceFor"));
            rowData.updateBigDecimal("FEndCreditBalanceFor", rs.getBigDecimal("FEndCreditBalanceFor"));
        }
        if (this.isShowLocal()) {
            rowData.updateBigDecimal("FYearBeginDebitBalanceLocal", rs.getBigDecimal("FYearBeginDebitBalanceLocal"));
            rowData.updateBigDecimal("FYearBeginCreditBalanceLocal", rs.getBigDecimal("FYearBeginCreditBalanceLocal"));
            rowData.updateBigDecimal("FBeginDebitBalanceLocal", rs.getBigDecimal("FBeginDebitBalanceLocal"));
            rowData.updateBigDecimal("FBeginCreditBalanceLocal", rs.getBigDecimal("FBeginCreditBalanceLocal"));
            rowData.updateBigDecimal("FDebitLocal", rs.getBigDecimal("FDebitLocal"));
            rowData.updateBigDecimal("FCreditLocal", rs.getBigDecimal("FCreditLocal"));
            rowData.updateBigDecimal("FYearDebitLocal", rs.getBigDecimal("FYearDebitLocal"));
            rowData.updateBigDecimal("FYearCreditLocal", rs.getBigDecimal("FYearCreditLocal"));
            rowData.updateBigDecimal("FEndDebitBalanceLocal", rs.getBigDecimal("FEndDebitBalanceLocal"));
            rowData.updateBigDecimal("FEndCreditBalanceLocal", rs.getBigDecimal("FEndCreditBalanceLocal"));
        }
        if (this.isShowRpt()) {
            rowData.updateBigDecimal("FYearBeginDebitBalanceRpt", rs.getBigDecimal("FYearBeginDebitBalanceRpt"));
            rowData.updateBigDecimal("FYearBeginCreditBalanceRpt", rs.getBigDecimal("FYearBeginCreditBalanceRpt"));
            rowData.updateBigDecimal("FBeginDebitBalanceRpt", rs.getBigDecimal("FBeginDebitBalanceRpt"));
            rowData.updateBigDecimal("FBeginCreditBalanceRpt", rs.getBigDecimal("FBeginCreditBalanceRpt"));
            rowData.updateBigDecimal("FDebitRpt", rs.getBigDecimal("FDebitRpt"));
            rowData.updateBigDecimal("FCreditRpt", rs.getBigDecimal("FCreditRpt"));
            rowData.updateBigDecimal("FYearDebitRpt", rs.getBigDecimal("FYearDebitRpt"));
            rowData.updateBigDecimal("FYearCreditRpt", rs.getBigDecimal("FYearCreditRpt"));
            rowData.updateBigDecimal("FEndDebitBalanceRpt", rs.getBigDecimal("FEndDebitBalanceRpt"));
            rowData.updateBigDecimal("FEndCreditBalanceRpt", rs.getBigDecimal("FEndCreditBalanceRpt"));
        }
    }

    private boolean isAccounTotal(IRowSet rs) throws SQLException {
        return !(rs.getString("FAccountID") != null && rs.getString("FAccountID").trim().length() != 0 || rs.getString("accountNumber") != null && rs.getString("accountNumber").trim().length() != 0);
    }

    protected void setYearBegin(IRowSet rs, IGLRptRowData rowData) throws SQLException, BOSException, EASBizException, NumberFormatException {
        if (this.isShowQty()) {
            this.setYearBegin(rs, rowData, "Qty", "Qty");
        }
        if (this.isShowFor()) {
            this.setYearBegin(rs, rowData, "For", "BalanceFor");
        }
        if (this.isShowLocal()) {
            this.setYearBegin(rs, rowData, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.setYearBegin(rs, rowData, "Rpt", "BalanceRpt");
        }
    }

    private void setYearBegin(IRowSet rs, IGLRptRowData rowData, String suffix, String balSuffix) throws SQLException, EASBizException, BOSException {
        BigDecimal yearCredit;
        BigDecimal yearDebit;
        BigDecimal end = rs.getBigDecimal("FEnd" + balSuffix);
        if (end == null) {
            end = GlUtils.zero;
        }
        if ((yearDebit = rs.getBigDecimal("FYearDebit" + suffix)) == null) {
            yearDebit = GlUtils.zero;
        }
        if ((yearCredit = rs.getBigDecimal("FYearCredit" + suffix)) == null) {
            yearCredit = GlUtils.zero;
        }
        BigDecimal amount = end.subtract(yearDebit).add(yearCredit);
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        if (dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount()) {
            if (new BigDecimal(dc.toString()).intValue() == 1) {
                rowData.updateBigDecimal("FYearBeginDebit" + balSuffix, amount);
            } else {
                rowData.updateBigDecimal("FYearBeginCredit" + balSuffix, amount.negate());
            }
        } else if (amount.doubleValue() < 0.0) {
            rowData.updateBigDecimal("FYearBeginCredit" + balSuffix, amount.negate());
        } else {
            rowData.updateBigDecimal("FYearBeginDebit" + balSuffix, amount);
        }
    }

    private void appendYearBeginDebitSum(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (this.cond.isBalanceDirSamAsAccount()) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + " > 0 ");
        }
        sql.append(" THEN (TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type).append(")");
        sql.append(" ELSE 0.0 END) FYearBeginDebit" + suff + "     \r\n");
    }

    private void appendYearBeginCreditSum(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (this.cond.isBalanceDirSamAsAccount()) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + " < 0 ");
        }
        sql.append(" THEN -1 * (TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + ") ");
        sql.append(" ELSE 0.0 END) FYearBeginCredit" + suff + "      \r\n");
    }

    private void appendPeriodBeginDebitSum(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(" ,sum(CASE WHEN ");
        if (this.cond.isBalanceDirSamAsAccount()) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FBegin" + suff + " > 0 ");
        }
        sql.append(" THEN TB.FBegin" + suff);
        sql.append(" ELSE 0.0 END) FBeginDebit" + suff + "     \r\n");
    }

    private void appendPeriodBeginCreditSum(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (this.cond.isBalanceDirSamAsAccount()) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FBegin" + suff + " < 0 ");
        }
        sql.append(" THEN -1 * TB.FBegin" + suff);
        sql.append(" ELSE 0.0 END) FBeginCredit" + suff + "\t\r\n");
    }

    private void appendPeriodEndDebitSum(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (this.cond.isBalanceDirSamAsAccount()) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FEnd" + suff + ">0");
        }
        sql.append(" THEN TB.FEnd" + suff);
        if (type.equals("Qty")) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FEndDebit" + suff + "    \r\n");
    }

    private void appendPeriodEndCreditSum(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (this.cond.isBalanceDirSamAsAccount()) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FEnd" + suff + "<0");
        }
        sql.append(" THEN -1*TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndCredit" + suff + "  \r\n");
    }

    private void setAsstName(IRowSet rs, IGLRptRowData rowData) throws SQLException, EASBizException, BOSException {
        String asstNameL = rs.getString(GLRptField.HGName.getName());
        String asstNameD = rs.getString("FdisplaynameGroup");
        String asstNameN = rs.getString("FNumberGroup");
        if (asstNameL != null && asstNameL.trim().length() > 0) {
            asstNameL = asstNameL.substring(0, asstNameL.length() - 1);
            asstNameD = asstNameD.substring(0, asstNameD.length() - 1);
            asstNameN = asstNameN.substring(0, asstNameN.length() - 1);
            String[] strAsstNameL = asstNameL.split(";");
            String[] strAsstNameD = asstNameD.split(";");
            String[] strAsstNameN = asstNameN.split(";");
            String number = null;
            int acctTypeFlag = 0;
            for (int i = 0; i < strAsstNameL.length && i < this.assistCount; ++i) {
                if (strAsstNameL[i] == null) continue;
                if (number == null && this.actTypeMap.get(number = strAsstNameN[i].substring(0, strAsstNameN[i].indexOf("_!"))) != null) {
                    acctTypeFlag = this.actTypeMap.get(number);
                }
                String realName = GLRptHelper.getAssDisplayName((boolean)this.cond.getRptParams().isAssitemShowNumber(), (boolean)this.cond.getRptParams().isShowLongNameForGeneral(), (boolean)this.cond.getRptParams().isShowLongNumberForGeneral(), (int)acctTypeFlag, (String)strAsstNameL[i], (String)strAsstNameD[i], (String)strAsstNameN[i]);
                rowData.updateString("FAsstAccountName" + i, realName);
            }
        }
    }

    private void setBalance(IRowSet rs, IGLRptRowData rowData) throws SQLException, EASBizException, BOSException {
        boolean isEndDebit = this.isEndDebit(rs);
        if (this.isShowQty()) {
            BigDecimal endQty = rs.getBigDecimal("FEndQty");
            if (endQty == null) {
                endQty = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitQty", endQty);
            } else {
                rowData.updateBigDecimal("FEndCreditQty", endQty.negate());
            }
        }
        if (this.isShowFor()) {
            BigDecimal endBalFor = rs.getBigDecimal("FEndBalanceFor");
            if (endBalFor == null) {
                endBalFor = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitBalanceFor", endBalFor);
            } else {
                rowData.updateBigDecimal("FEndCreditBalanceFor", endBalFor.negate());
            }
        }
        if (this.isShowLocal()) {
            BigDecimal endBalLocal = rs.getBigDecimal("FEndBalanceLocal");
            if (endBalLocal == null) {
                endBalLocal = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitBalanceLocal", endBalLocal);
            } else {
                rowData.updateBigDecimal("FEndCreditBalanceLocal", endBalLocal.negate());
            }
        }
        if (this.isShowRpt()) {
            BigDecimal endBalRpt = rs.getBigDecimal("FEndBalanceRpt");
            if (endBalRpt == null) {
                endBalRpt = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitBalanceRpt", endBalRpt);
            } else {
                rowData.updateBigDecimal("FEndCreditBalanceRpt", endBalRpt.negate());
            }
        }
        boolean isBeginDebit = this.isBeginDebit(rs);
        if (this.isShowQty()) {
            BigDecimal beginQty = rs.getBigDecimal("FBeginQty");
            if (beginQty == null) {
                beginQty = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitQty", beginQty);
            } else {
                rowData.updateBigDecimal("FBeginCreditQty", beginQty.negate());
            }
        }
        if (this.isShowFor()) {
            BigDecimal beginBalFor = rs.getBigDecimal("FBeginBalanceFor");
            if (beginBalFor == null) {
                beginBalFor = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitBalanceFor", beginBalFor);
            } else {
                rowData.updateBigDecimal("FBeginCreditBalanceFor", beginBalFor.negate());
            }
        }
        if (this.isShowLocal()) {
            BigDecimal beginBalLocal = rs.getBigDecimal("FBeginBalanceLocal");
            if (beginBalLocal == null) {
                beginBalLocal = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitBalanceLocal", beginBalLocal);
            } else {
                rowData.updateBigDecimal("FBeginCreditBalanceLocal", beginBalLocal.negate());
            }
        }
        if (this.isShowRpt()) {
            BigDecimal beginBalRpt = rs.getBigDecimal("FBeginBalanceRpt");
            if (beginBalRpt == null) {
                beginBalRpt = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitBalanceRpt", beginBalRpt);
            } else {
                rowData.updateBigDecimal("FBeginCreditBalanceRpt", beginBalRpt.negate());
            }
        }
    }

    private boolean isEndDebit(IRowSet rs) throws SQLException, EASBizException, BOSException {
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        boolean isSameDC = dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount();
        boolean isDebit = true;
        if (isSameDC) {
            isDebit = new BigDecimal(dc.toString()).intValue() == 1;
        } else {
            BigDecimal amount = GlUtils.zero;
            if (this.isShowFor()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceFor.getName());
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceLocal.getName());
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceRpt.getName());
            }
            isDebit = amount == null || amount.doubleValue() >= 0.0;
        }
        return isDebit;
    }

    private boolean isBeginDebit(IRowSet rs) throws SQLException, EASBizException, BOSException {
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        boolean isSameDC = dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount();
        boolean isDebit = true;
        if (isSameDC) {
            isDebit = new BigDecimal(dc.toString()).intValue() == 1;
        } else {
            BigDecimal amount = GlUtils.zero;
            if (this.isShowFor()) {
                amount = rs.getBigDecimal(GLRptField.beginBalanceFor.getName());
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
                amount = rs.getBigDecimal(GLRptField.beginBalanceLocal.getName());
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
                amount = rs.getBigDecimal(GLRptField.beginBalanceRpt.getName());
            }
            isDebit = amount == null || amount.doubleValue() >= 0.0;
        }
        return isDebit;
    }

    protected int getAssistColumnCount() throws BOSException, EASBizException {
        String accountFilter;
        ArrayList<Object> sp = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(asst.fcount) fcount");
        sql.append(" from t_bd_accountview av");
        sql.append(" inner join t_bd_asstaccount asst on asst.fid = av.fcaa");
        sql.append(" where av.fisleaf = 1");
        sql.append(" and av.faccounttableid = ?");
        sp.add(this.cond.getAccountTableId());
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and av.fcompanyid = ? ");
            sp.add(this.getCompany().getId().toString());
        } else {
            sql.append(" and av.fcompanyid in ").append(this.cond.getCompanyIdsStr());
        }
        if (!this.cond.getIncludeBWAccount()) {
            sql.append(" and av.FBW = 0 ");
        }
        if (!this.cond.isShowLeafAccount()) {
            sql.append(" and av.flevel <= ? \r\n");
            sp.add(this.cond.getAccountLevelEnd());
        }
        if ((accountFilter = new PcaRptAccountFilter(this.getContex(), (GLRptBaseCondition)this.cond, "av", "av.fid", "av.fcompanyid", false, true, this.cond.getCompanyIdsStr()).getSQL()) != null) {
            sql.append(" and ").append(accountFilter);
        }
        IRowSet result = DbUtil.executeQuery((Context)this.getContex(), (String)sql.toString(), (Object[])sp.toArray());
        int assCount = 0;
        try {
            if (result.next()) {
                assCount = result.getInt("fcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return assCount;
    }

    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws SQLException, BOSException, EASBizException {
        super.toGLRptRowData(rs, rowData);
        if (this.cond.getDisplayAsstDetail()) {
            this.setAsstName(rs, (IGLRptRowData)rowData);
        }
        this.setBalance(rs, (IGLRptRowData)rowData);
        if (this.isAccounTotal(rs)) {
            this.setAcountSumAmount(this.getAccountSumAmount(rs), (IGLRptRowData)rowData);
        } else {
            this.setYearBegin(rs, (IGLRptRowData)rowData);
        }
    }

    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        GLRptTableHeadInfo headInfo = new GLRptTableHeadInfo();
        this.addTableHeadColumn(headInfo, new GLRptField("KSQL_SEQ", "INT"));
        if (!this.isCreateSeqTable()) {
            this.addTableHeadColumn(headInfo, new GLRptField("SQL_BATCH", "INT"));
        }
        GLRptSelector selector = this.getGLRptSelector();
        if (this.getGLRptSelector() == null) {
            return headInfo;
        }
        Iterator it = selector.iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = (GLRptField)it.next();
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    this.addTableHeadCreditColumn(headInfo, (GLRptField)creditList.get(i));
                }
                creditList.clear();
            }
            if (field.isYearBegin()) {
                creditList.add(field);
                lastPrefix = "FYearBegin";
            } else if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.addTableHeadColumn(headInfo, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                this.addTableHeadCreditColumn(headInfo, (GLRptField)creditList.get(i));
            }
            creditList.clear();
        }
        headInfo.setHeadTitle(this.getHeadTitles());
        return headInfo;
    }

    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = !this.cond.isShowQty() && this.isSingleAmountFiled() ? new String[][]{this.getTitleRow1(), this.getTitleRow2()} : new String[][]{this.getTitleRow1(), this.getTitleRow2(), this.getTitleRow3()};
        return titles;
    }

    protected void addTableHeadCreditColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        String prefix = null;
        if (field.isYearBegin()) {
            prefix = "FYearBegin";
        } else if (field.isBegin()) {
            prefix = "FBegin";
        } else if (field.isEnd()) {
            prefix = "FEnd";
        }
        GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
        colInfo.setNumeral(true);
        colInfo.setColName(prefix + "Credit" + field.getBalSuffix());
        colInfo.setWidth(field.getLength());
        if (field.isQty()) {
            colInfo.setScale(this.cond.getQtyScale());
        } else {
            CurrencyInfo currency = this.getQueryCurrencyInfo();
            if (currency != null && field.getName().endsWith("For")) {
                colInfo.setScale(currency.getPrecision());
            } else if (field.getName().endsWith("Local")) {
                colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
            } else if (this.getCompany().getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                colInfo.setScale(this.getCompany().getReportCurrency().getPrecision());
            }
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
    }

    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field.isYearBegin() || field.isBegin() || field.isEnd()) {
            String prefix = null;
            if (field.isYearBegin()) {
                prefix = "FYearBegin";
            } else if (field.isBegin()) {
                prefix = "FBegin";
            } else if (field.isEnd()) {
                prefix = "FEnd";
            }
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setNumeral(true);
            colInfo.setColName(prefix + "Debit" + field.getBalSuffix());
            colInfo.setWidth(field.getLength());
            if (field.isQty()) {
                colInfo.setScale(this.cond.getQtyScale());
            } else {
                CurrencyInfo currency = this.getQueryCurrencyInfo();
                if (currency != null && field.getName().endsWith("For")) {
                    colInfo.setScale(currency.getPrecision());
                } else if (field.getName().endsWith("Local")) {
                    colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
                } else if (this.getCompany().getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                    colInfo.setScale(this.getCompany().getReportCurrency().getPrecision());
                }
            }
            if (colInfo != null && this.getFreezeField() == field) {
                colInfo.setFreeze(true);
            }
        } else if (GLRptField.HGName == field) {
            for (int i = 0; i < this.assistCount; ++i) {
                GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
                colInfo.setColName("FAsstAccountName" + i);
                colInfo.setWidth(120);
                if (colInfo == null || this.getFreezeField() != field) continue;
                colInfo.setFreeze(true);
            }
        } else if (GLRptField.accountDC == field) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setWidth(-1);
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field.isYearBegin() || field.isBegin() || field.isEnd()) {
            colTitles.add(field.getTitle());
            colTitles.add(field.getTitle());
        } else if (field.isDebit() || field.isCredit()) {
            colTitles.add("period_happened");
        } else if (field.isYearDebit() || field.isYearCredit()) {
            colTitles.add("sum_year");
        } else if (GLRptField.HGName == field) {
            for (int i = 0; i < this.assistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else {
            colTitles.add(field.getTitle());
        }
    }

    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator it = this.getGLRptSelector().iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = (GLRptField)it.next();
            if (field.getName() == null) continue;
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    colTitles.add("dir_credit");
                }
                creditList.clear();
            }
            if (field.isYearBegin()) {
                creditList.add(field);
                lastPrefix = "FYearBegin";
            } else if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.setRow2Title(colTitles, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                colTitles.add("dir_credit");
            }
            creditList.clear();
        }
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.isYearBegin() || field.isBegin() || field.isEnd()) {
            colTitles.add("dir_debit");
        } else if (GLRptField.HGName == field) {
            for (int i = 0; i < this.assistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (field.isYearDebit()) {
            colTitles.add("dir_debit");
        } else if (field.isYearCredit()) {
            colTitles.add("dir_credit");
        } else {
            colTitles.add(field.getTitle());
        }
    }

    protected String[] getTitleRow3() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator it = this.getGLRptSelector().iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = (GLRptField)it.next();
            if (field.getName() == null) continue;
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    this.setRow3Title(colTitles, (GLRptField)creditList.get(i));
                }
                creditList.clear();
            }
            if (field.isYearBegin()) {
                creditList.add(field);
                lastPrefix = "FYearBegin";
            } else if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.setRow3Title(colTitles, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                this.setRow3Title(colTitles, (GLRptField)creditList.get(i));
            }
            creditList.clear();
        }
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void setRow3Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.getType() == "NUMERIC(29,10)") {
            if (field.isQty()) {
                colTitles.add("asst_quantity");
            } else if (this.isSingleAmountFiled()) {
                colTitles.add("money_amount");
            } else if (field.getName().endsWith("For")) {
                colTitles.add("currency_for");
            } else if (field.getName().endsWith("Local")) {
                colTitles.add("currency_local");
            } else if (field.getName().endsWith("Rpt")) {
                colTitles.add("currency_rpt");
            }
        } else if (GLRptField.HGName == field) {
            for (int i = 0; i < this.assistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else {
            colTitles.add(field.getTitle());
        }
    }

    protected int getExpandLevel() {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            if (this.cond.isDisplayLeafCompany()) {
                return 1;
            }
            return 0;
        }
        return this.getExpandLevel("");
    }

    private int getExpandLevel(String a) {
        int level = -1;
        if (this.getTreeColmun() != null) {
            if (this.profitCenter.isIsBizUnit()) {
                level = 1;
            } else {
                int rootLevel = ((SimpleCompanyUserObject)((DefaultMutableTreeNode)this.cond.getTreeModelOfProfitCenter()).getUserObject()).getLevel();
                level = this.cond.getExpandCompanyLevel() + rootLevel - 1;
            }
        }
        return level;
    }

    private String getAccountName() throws EASBizException, BOSException {
        if (this.cond.getRptParams().isAccountShowLongName()) {
            return "FdisplayName_" + this.getContex().getLocale();
        }
        return "FName_" + this.getContex().getLocale();
    }

    private boolean isNeedQty(String companyId) {
        return CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode() || !companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4");
    }

    private Set getAccountIdSet4Sum() throws EASBizException, BOSException {
        if (this.accountIdSet4Sum != null) {
            return this.accountIdSet4Sum;
        }
        AccountViewCollection accounts = this.getAccountInfoByTempTable();
        if (accounts == null || accounts.size() == 0) {
            return null;
        }
        Iterator it = accounts.iterator();
        ArrayList<AccountViewInfo> paccounts = new ArrayList<AccountViewInfo>();
        this.accountIdSet4Sum = new HashSet();
        while (it.hasNext()) {
            AccountViewInfo account = (AccountViewInfo)it.next();
            if (!paccounts.isEmpty()) {
                Iterator pit = paccounts.iterator();
                AccountViewInfo ac = (AccountViewInfo)pit.next();
                if (account.getLongNumber().startsWith(ac.getLongNumber()) && account.getCompanyID().getId().equals((Object)ac.getCompanyID().getId())) continue;
                paccounts.add(0, account);
                this.accountIdSet4Sum.add(account.getId().toString());
                continue;
            }
            paccounts.add(account);
            this.accountIdSet4Sum.add(account.getId().toString());
        }
        return this.accountIdSet4Sum;
    }

    private String getAccountIdsStr4Sum() throws BOSException, EASBizException {
        if (this.getAccountIdSet4Sum().size() > 50) {
            this.accountTempTable4Sum = GLRptDaoUtil.createIdTempTable((Context)this.getContex(), (Set)this.getAccountIdSet4Sum());
            return "select fid from " + this.accountTempTable4Sum;
        }
        StringBuffer accountIds = new StringBuffer();
        Set accountIdSet = this.getAccountIdSet4Sum();
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            return "''";
        }
        Iterator it = accountIdSet.iterator();
        accountIds.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            accountIds.append(",'").append(it.next()).append("'");
        }
        return accountIds.toString();
    }

    private String getAccountIdFilter4Sum() throws EASBizException, BOSException {
        if (this.accountIdStr4Sum == null) {
            this.accountIdStr4Sum = this.getAccountIdsStr4Sum();
        }
        return this.accountIdStr4Sum;
    }

    public void releaseTempTable() {
        super.releaseTempTable();
    }

    private IRowSet getAccountAmountForMerger(IRowSet rs, String currencyId, String companyId) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 xxx");
        this.appendAmountTotalSumSelect(sql, currencyId, companyId);
        sql.append(" FROM (").append(this.getDataSourceTableNameForMeger(rs, currencyId, companyId)).append(") TB \r\n");
        return this.executeQuery(sql.toString());
    }

    private String getDataSourceTableNameForMeger(IRowSet rs, String currencyId, String companyId) throws EASBizException, BOSException, SQLException {
        int bwType;
        StringBuffer sql = new StringBuffer();
        sql.append("select tg.accountnumber,tg.accountname ");
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FBeginQty");
            } else {
                sql.append(",sum(FBeginQty) FBeginQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FBeginBalanceFor) FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FBeginBalanceLocal) FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FBeginBalanceRpt) FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FDebitQty");
            } else {
                sql.append(",sum(FDebitQty) FDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FDebitFor) FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FDebitLocal) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FDebitRpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FCreditQty");
            } else {
                sql.append(",sum(FCreditQty) FCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FCreditFor) FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FCreditLocal) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FCreditRpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearDebitQty");
            } else {
                sql.append(",sum(FYearDebitQty) FYearDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearDebitFor) FYearDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearDebitLocal) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearDebitRpt) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearCreditQty");
            } else {
                sql.append(",sum(FYearCreditQty) FYearCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearCreditFor) FYearCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearCreditLocal) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearCreditRpt) FYearCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FEndQty");
            } else {
                sql.append(",sum(FEndQty) FEndQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FEndBalanceFor) FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FEndBalanceLocal) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FEndBalanceRpt) FEndBalanceRpt");
        }
        sql.append(" from ").append(this.getDataSourceTableName()).append(" tg \r\n");
        sql.append(" INNER JOIN T_BD_AccountView av on tg.FAccountID = av.FID \r\n");
        if (this.isShowQty()) {
            sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  \r\n");
        }
        if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst()) {
            sql.append(" WHERE ((av.FCAA IS NULL AND FIsAssist = 0 and (av.fisleaf = 1 or av.flevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append("))");
            sql.append(" OR (av.FCAA IS not NULL AND FIsAssist = 0 and av.FLevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append(" and av.FIsLeaf = 0) ");
            sql.append(" OR (av.FCAA IS not NULL AND FIsAssist = 1 )) \r\n");
        } else {
            if (this.cond.isShowLeafAccount()) {
                sql.append(" WHERE ").append(" av.FIsLeaf = 1 ");
            } else if (this.cond.getAccountLevelEnd() == 1) {
                sql.append(" WHERE ").append(" av.flevel = 1 ");
            } else {
                sql.append(" WHERE av.fid in (").append(this.getAccountIdFilter4Sum()).append(")");
            }
            if (this.cond.getDisplayAsstDetail()) {
                sql.append(" and tg.FIsAssist = 0 ");
            }
        }
        if (this.isAllCurrency()) {
            sql.append(" and tg.FCurrencyID is not null and tg.FCurrencyID <> ' ' \r\n");
        }
        if (companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            sql.append(" and tg.FProfitCenterID <> '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        } else {
            sql.append(" and tg.FProfitCenterID = '").append(companyId).append("'");
        }
        if (this.isAllCurrency()) {
            if (currencyId != null && currencyId.trim().length() > 0) {
                sql.append(" and tg.FCurrencyID = '").append(currencyId).append("'");
            } else {
                sql.append(" and tg.FCurrencyID != ' '");
            }
        }
        if (this.cond.getIncludeBWAccount() && ((bwType = rs.getInt("FBWType")) == 0 || bwType == 1)) {
            sql.append(" and tg.FBWType = ").append(bwType);
        }
        sql.append(" group by tg.accountnumber,tg.accountname \r\n");
        return sql.toString();
    }

    private void appendAmountTotalSumSelect(StringBuffer sql, String currencyId, String companyId) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginDebitTotal(sql, "Qty", "Qty");
            } else {
                sql.append(",0.0 FYearBeginDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginDebitTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FYearBeginDebitBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginDebitTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendYearBeginDebitTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginCreditTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FYearBeginCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginCreditTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FYearBeginCreditBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginCreditTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendYearBeginCreditTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginDebitTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FBeginDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginDebitTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FBeginDebitBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginDebitTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginDebitTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginCreditTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FBeginCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginCreditTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FBeginCreditBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginCreditTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginCreditTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FDebitQty) FDebitQty       \r\n");
            } else {
                sql.append(", 0.0 FDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FDebitFor) FDebitFor       \r\n");
            } else {
                sql.append(", 0.0  FDebitFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FDebitLocal) FDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FDebitRpt) FDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FCreditQty) FCreditQty\t   \r\n");
            } else {
                sql.append(", 0.0 FCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FCreditFor) FCreditFor     \r\n");
            } else {
                sql.append(", 0.0  FCreditFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FCreditLocal) FCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FCreditRpt) FCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FYearDebitQty) FYearDebitQty       \r\n");
            } else {
                sql.append(", 0.0 FYearDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearDebitFor) FYearDebitFor       \r\n");
            } else {
                sql.append(", 0.0  FYearDebitFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearDebitLocal) FYearDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearDebitRpt) FYearDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FYearCreditQty) FYearCreditQty\t   \r\n");
            } else {
                sql.append(", 0.0 FYearCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearCreditFor) FYearCreditFor     \r\n");
            } else {
                sql.append(", 0.0  FYearCreditFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearCreditLocal) FYearCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearCreditRpt) FYearCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndDebitTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FEndDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndDebitTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0 FEndDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndDebitTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndDebitTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndCreditTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FEndCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndCreditTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0 FEndCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndCreditTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndCreditTotal(sql, "Rpt", "BalanceRpt");
        }
    }

    private void addInsertSqlForCurrency(StringBuffer sql) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            this.appendPeriodBegin(sql, "Qty", "Qty");
        }
        if (this.isShowFor()) {
            this.appendPeriodBegin(sql, "For", "BalanceFor");
        }
        if (this.isShowLocal()) {
            this.appendPeriodBegin(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBegin(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(",case when TA.FIsQty = 0 then 0 else isnull(TB.FDebitQty,0) end FDebitQty       \r\n");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FDebitFor,0) FDebitFor       \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FDebitLocal,0) FDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FDebitRpt,0) FDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            sql.append(",case when TA.FIsQty = 0 then 0 else isnull(TB.FCreditQty,0) end FCreditQty\t   \r\n");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FCreditFor,0) FCreditFor     \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FCreditLocal,0) FCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FCreditRpt,0) FCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            sql.append(",case when TA.FIsQty = 0 then 0 else isnull(TB.FYearDebitQty,0) end FYearDebitQty       \r\n");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FYearDebitFor,0) FYearDebitFor       \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FYearDebitLocal,0) FYearDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FYearDebitRpt,0) FYearDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            sql.append(",case when TA.FIsQty = 0 then 0 else isnull(TB.FYearCreditQty,0) end FYearCreditQty\t   \r\n");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FYearCreditFor,0) FYearCreditFor     \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FYearCreditLocal,0) FYearCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FYearCreditRpt,0) FYearCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            this.appendPeriodEnd(sql, "Qty", "Qty");
        }
        if (this.isShowFor()) {
            this.appendPeriodEnd(sql, "For", "BalanceFor");
        }
        if (this.isShowLocal()) {
            this.appendPeriodEnd(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEnd(sql, "Rpt", "BalanceRpt");
        }
    }

    private void addInsertSqlForCurrencyBySelect(StringBuffer sql) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            sql.append(", TB.FBegin").append("Qty").append(" FBeginQty");
        }
        if (this.isShowFor()) {
            this.appendPeriodBegin(sql, "For", "BalanceFor");
        }
        if (this.isShowLocal()) {
            this.appendPeriodBegin(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBegin(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FDebitQty,0) FDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FDebitFor,0) FDebitFor       \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FDebitLocal,0) FDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FDebitRpt,0) FDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FCreditQty,0) FCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FCreditFor,0) FCreditFor     \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FCreditLocal,0) FCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FCreditRpt,0) FCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FYearDebitQty,0) FYearDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FYearDebitFor,0) FYearDebitFor       \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FYearDebitLocal,0) FYearDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FYearDebitRpt,0) FYearDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FYearCreditQty,0) FYearCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FYearCreditFor,0) FYearCreditFor     \r\n");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FYearCreditLocal,0) FYearCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FYearCreditRpt,0) FYearCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FEnd").append("Qty").append(" FEndQty");
        }
        if (this.isShowFor()) {
            this.appendPeriodEnd(sql, "For", "BalanceFor");
        }
        if (this.isShowLocal()) {
            this.appendPeriodEnd(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEnd(sql, "Rpt", "BalanceRpt");
        }
    }

    private void appendPeriodBegin(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", TB.FBegin" + suff);
    }

    private void appendPeriodEnd(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", TB.FEnd" + suff);
    }

    private void appendYearBeginDebitTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + " > 0 ");
        sql.append(" THEN (TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type).append(")");
        sql.append(" ELSE 0.0 END) FYearBeginDebit" + suff + "     \r\n");
    }

    private void appendYearBeginCreditTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + " < 0 ");
        sql.append(" THEN -1 * (TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + ") ");
        sql.append(" ELSE 0.0 END) FYearBeginCredit" + suff + "      \r\n");
    }

    private void appendPeriodBeginDebitTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(" ,sum(CASE WHEN ");
        sql.append(" TB.FBegin" + suff + " > 0 ");
        sql.append(" THEN TB.FBegin" + suff);
        sql.append(" ELSE 0.0 END) FBeginDebit" + suff + "     \r\n");
    }

    private void appendPeriodBeginCreditTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FBegin" + suff + " < 0 ");
        sql.append(" THEN -1 * TB.FBegin" + suff);
        sql.append(" ELSE 0.0 END) FBeginCredit" + suff + "\t\r\n");
    }

    private void appendPeriodEndDebitTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FEnd" + suff + ">0");
        sql.append(" THEN TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndDebit" + suff + "    \r\n");
    }

    private void appendPeriodEndCreditTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FEnd" + suff + "<0");
        sql.append(" THEN -1*TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndCredit" + suff + "  \r\n");
    }

    protected DefaultKingdeeTreeNode getTreeModeOfProfitCenter(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws BOSException {
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && this.cond.getTreeModelOfCompany() == null) {
            if (!this.cond.getProfitCenterIds().isEmpty()) {
                return PcaUtils.getTreeModeOfProfitCenter(ctx, profitCenter, this.cond.getProfitCenterIds());
            }
            return PcaUtils.getTreeModeOfProfitCenter(ctx, profitCenter);
        }
        return null;
    }

    protected String getAccountBalanceTable() {
        return PCABalanceUtils.getAccountBalanceTable(this.getQueryCondition());
    }

    protected String getAssistBalanceTable() {
        return PCABalanceUtils.getAssistBalanceTable(this.getQueryCondition());
    }

    protected GLRptAccountBalQueryHelper getQueryHelper() {
        return new PcaRptAccountBalQueryHelper(this.cond);
    }

    protected void createSysStatusTmpTable() throws BOSException {
        int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fprofitcenterid, startPeriod startPeriod, currPeriod, case when startPeriod > pd then startPeriod else pd end period");
        sql.append(" from (select fprofitcenterid, spd.fnumber startPeriod, cpd.fnumber currPeriod,");
        sql.append(" case when cpd.fnumber < ").append(beginPeriod).append(" then cpd.fnumber else ").append(beginPeriod).append(" end pd");
        sql.append(" from t_bd_SystemStatusCtrol ssc");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(1006);
        sql.append(" inner join t_bd_period spd on spd.fid = ssc.fstartperiodid ");
        sql.append(" inner join t_bd_period cpd on cpd.fid = ssc.fcurrentperiodid ");
        sql.append(" where ssc.fprofitcenterid in ").append(this.cond.getProfitCenterIdsStr()).append(") t");
        this.sysStatusTmpTable = GLTempTableUtil.createDBSysTempTable((Context)this.getContex(), (String)"fprofitcenterid varchar(44), fstartPeriod INT, fcurrPeriod INT, period INT");
        DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + this.sysStatusTmpTable + sql.toString()));
    }
}

