/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerAccountTreeDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAccountBalQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAsstactBalQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptVoucherAssistQuery;
import java.util.Set;

public class PcaRptSubLedgerAccountTreeDao
extends GLRptSubLedgerAccountTreeDao {
    private static final String ASST_BALANCE = "\"PCASSISTBALANCE\"";
    private static final String ACCOUNT_BALANCE = "\"PCACCOUNTBALANCE\"";
    private static final String VOUCHER_ENTRIES = "\"ENTRIES\"";
    private static final String ACCOUNT = "\"ACCOUNT\"";
    private static final String VOUCHER = "\"PCVOUCHER\"";

    public PcaRptSubLedgerAccountTreeDao(Context ctx) {
        super(ctx);
        ctx.put((Object)"isPca", (Object)true);
    }

    protected boolean isBizUnit() {
        ProfitCenterOrgUnitInfo profitCenter = this.cond.getProfitCenter();
        this.cond.getCtx().put((Object)"isPca", (Object)true);
        return profitCenter.isIsBizUnit() && this.cond.getAccountTableId() == null;
    }

    protected void updateVoucherBalance() throws BOSException {
        String[] profitCenterIds = GLRptDaoUtil.set2StringArray((Set)this.cond.getProfitCenterIds());
        this.cond.getCtx().put((Object)"isPca", (Object)true);
        PcaBalanceFacadeFactory.getLocalInstance(this.cond.getCtx()).updateVoucherBalance(profitCenterIds);
    }

    protected GLRptAccountBalQuery getRptAccountBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new PcaRptAccountBalQuery(ctx, (OrgUnitInfo)company, cond, false, false);
    }

    protected GLRptAsstactBalQuery getRptAsstactBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond) throws EASBizException, BOSException {
        return new PcaRptAsstactBalQuery(ctx, (OrgUnitInfo)company, (GLRptAsstactBaseCondition)cond, false, false);
    }

    protected GLRptVoucherAssistQuery getRptVoucherAssistQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isOnlyQty) {
        return new PcaRptVoucherAssistQuery(ctx, cond, false);
    }

    protected String getAccBalFilterSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(this.getAccountBalFilter("lacc"));
        } else {
            sql.append(this.getAccountBalFilter("pacc"));
        }
        if (this.cond.isShowLeafAccount()) {
            sql.append(" and pacc.fisleaf = 1 ");
        } else {
            sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
        }
        return sql.toString();
    }

    protected String getAccountMapSQL() throws EASBizException, BOSException {
        boolean showExist;
        StringBuffer sql = new StringBuffer();
        sql.append(" select pacc.faccounttypeid, pacc.fid accountId, pacc.fnumber accountNumber");
        sql.append(", pacc.fcaa, pacc.flevel, pacc.fisleaf, pacc.fisqty, pacc.fcompanyid, pacc.fhasuserproperty");
        sql.append(", pacc.").append(this.cond.isAccountShowLongName() ? "fdisplayname_" : "fname_");
        sql.append(this.ctx.getLocale().toString()).append(" accountName");
        sql.append(" from t_bd_accountview pacc ");
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details || !this.cond.isShowLeafAccount()) {
            if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
                if (this.cond.isOptionAmountZero() || this.includeAssFilter() || this.cond.isOptionAmountAndBalZero()) {
                    sql.append(" inner join t_bd_accountview lacc on charindex(pacc.flongnumber, lacc.flongnumber) = 1 and lacc.faccounttableid = pacc.faccounttableid");
                } else {
                    sql.append(" inner join t_bd_accountview lacc on pacc.flongnumber = lacc.flongnumber and lacc.faccounttableid = pacc.faccounttableid");
                }
            } else if (this.cond.isOptionAmountZero() || this.includeAssFilter() || this.cond.isOptionAmountAndBalZero()) {
                sql.append(" inner join t_bd_accountview lacc on charindex(pacc.flongnumber, lacc.flongnumber) = 1 and lacc.faccounttableid = pacc.faccounttableid");
                sql.append(" and lacc.fcompanyid = pacc.fcompanyid ");
            }
        }
        sql.append(" where ");
        boolean bl = showExist = this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero();
        if (this.cond.isOptionAmountZero()) {
            sql.append(this.getVoucherFilterSQL());
        } else if (this.includeAssFilter()) {
            sql.append(this.getAsstBalFilterSQL());
        } else {
            sql.append(this.getAccBalFilterSQL());
        }
        String accFilter = new GLRptAccountFilter(this.ctx, (GLRptBaseCondition)this.cond, "pacc", "pacc.fid", "pacc.fcompanyid", false).getSQL();
        if (accFilter != null) {
            sql.append(" and ").append(accFilter);
        }
        sql.append(" and pacc.faccounttableid = '").append(this.cond.getAccountTableId()).append("'");
        Set caaIdSet = this.cond.getAsstAccountIdSet();
        if (!caaIdSet.isEmpty()) {
            sql.append(" and pacc.fcaa in ").append(GLRptDaoUtil.set2String((Set)caaIdSet));
        }
        sql.append(" order by pacc.faccounttypeid, pacc.fnumber ");
        return sql.toString();
    }

    protected String getVoucherFilterSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(this.getVoucherFilter("lacc"));
            if (this.cond.isShowLeafAccount()) {
                sql.append(" and pacc.fisleaf = 1 ");
            } else {
                sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
            }
        } else if (this.cond.isShowLeafAccount()) {
            sql.append(this.getVoucherFilter("pacc"));
        } else {
            sql.append(this.getVoucherFilter("lacc"));
            sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
        }
        return sql.toString();
    }

    protected String getAsstBalFilterSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            sql.append(this.getAsstBalFilter("lacc"));
            if (this.cond.isShowLeafAccount()) {
                sql.append(" and pacc.fisleaf = 1 ");
            } else {
                sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
            }
            return sql.toString();
        }
        if (this.cond.isShowLeafAccount()) {
            return this.getAsstBalFilter("pacc");
        }
        sql.append(this.getAsstBalFilter("lacc"));
        sql.append(" and pacc.flevel <= ").append(this.cond.getAccountLevelEnd());
        return sql.toString();
    }

    protected String getAssistBalanceTableAlias() {
        return ASST_BALANCE;
    }

    protected String getAccountBalanceTableAlias() {
        return ACCOUNT_BALANCE;
    }

    protected String getVoucherEntryTableAlias() {
        return VOUCHER_ENTRIES;
    }
}

