/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBeginPeriodBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerSpliter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerVoucherQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAccountBeginPeriodBalQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptAsstactBeginPeriodBalQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptBalNextPeriodQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptField;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptSubLedgerPageQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptSubLedgerSpliter;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptSubLedgerVoucherQuery;
import com.kingdee.eas.ma.pca.rpt.app.dao.PcaRptVoucherField;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class PcaRptSubLedgerDao
extends GLRptSubLedgerDao {
    private ProfitCenterOrgUnitInfo profitOrg;
    private GLRptSubLedgerCondition cond;

    public PcaRptSubLedgerDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
    }

    protected CompanyOrgUnitInfo initCompany() throws EASBizException, BOSException {
        this.cond = (GLRptSubLedgerCondition)this.getQueryCondition();
        CompanyOrgUnitInfo company = super.initCompany();
        this.cond.getCtx().put((Object)"isPca", (Object)true);
        this.initProfitOrg();
        return company;
    }

    protected PeriodInfo initPeriod() throws EASBizException, BOSException {
        PeriodInfo startPeriod = PcaUtils.getProfitCenterStartPeriod(this.cond.getCtx(), 1006, this.cond.getProfitCenter().getId().toString());
        return startPeriod;
    }

    private void initProfitOrg() {
        this.profitOrg = this.cond.getProfitCenter();
    }

    protected ProfitCenterOrgUnitInfo getProfitCenter() {
        return this.profitOrg;
    }

    protected void updateVoucherBalance() throws BOSException {
        String[] profitCenterIds = GLRptDaoUtil.set2StringArray((Set)this.cond.getProfitCenterIds());
        PcaBalanceFacadeFactory.getLocalInstance(this.cond.getCtx()).updateVoucherBalance(profitCenterIds);
    }

    protected void setTreeModelOfCompany() throws BOSException {
        this.cond.setTreeModelOfProfitCenter((Object)this.getTreeModeOfProfitCenter(this.cond.getCtx(), (GLRptBaseCondition)this.cond, this.profitOrg));
    }

    protected DefaultKingdeeTreeNode getTreeModeOfProfitCenter(Context ctx, GLRptBaseCondition cond, ProfitCenterOrgUnitInfo profitCenter) throws BOSException {
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && cond.getTreeModelOfCompany() == null) {
            if (!cond.getProfitCenterIds().isEmpty()) {
                return PcaUtils.getTreeModeOfProfitCenter(ctx, profitCenter, cond.getProfitCenterIds());
            }
            return PcaUtils.getTreeModeOfProfitCenter(ctx, profitCenter);
        }
        return null;
    }

    public GLRptField getTreeColmun() {
        return null;
    }

    protected int getExpandLevel() {
        int level = -1;
        if (this.getTreeColmun() != null) {
            if (this.profitOrg.isIsBizUnit()) {
                level = 1;
            } else {
                int rootLevel = ((SimpleCompanyUserObject)((DefaultMutableTreeNode)this.cond.getTreeModelOfProfitCenter()).getUserObject()).getLevel();
                level = this.cond.getExpandCompanyLevel() + rootLevel - 1;
            }
        }
        return level;
    }

    protected boolean isGroupByCompany() throws EASBizException, BOSException {
        return this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && this.getGLRptSelector().contains(PcaRptField.profitCenterName);
    }

    protected void insertBeginBalance(GLRptQuery query, boolean isAsstBal) throws EASBizException, BOSException {
        query.setSelector(this.getBeginBalQuerySelector(isAsstBal));
        query.addGLRptFilter((GLRptFilter)new GLRptSubLedgerDao.AmountFilter((GLRptSubLedgerDao)this, isAsstBal));
        List fields = this.getInsertBalField(isAsstBal);
        String[] fs = new String[fields.size()];
        fs = fields.toArray(fs);
        StringBuffer sql = this.dealWithGroupBySQL(query);
        this.insertData(fs, sql.toString());
    }

    private StringBuffer dealWithGroupBySQL(GLRptQuery query) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        GLRptSelector selector = query.getSelector();
        if (selector == null || selector.isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        boolean first = true;
        for (GLRptField field : selector) {
            if (!field.isTempTableField()) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append("SUM(p1.").append(field.getName()).append(") ").append(field.getName());
                continue;
            }
            sql.append("p1.").append(field.getName()).append(" ").append(field.getName());
        }
        sql.append(" FROM (").append(query.getSQL()).append(") p1 ");
        sql.append(" GROUP BY ");
        boolean isFirst = true;
        for (GLRptField field : selector) {
            if (!field.isTempTableField()) continue;
            if (isFirst) {
                isFirst = false;
            } else if (field.getType() != "NUMERIC(29,10)") {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)") continue;
            sql.append("p1.").append(field.getName());
        }
        return sql;
    }

    protected int getMaxCompanyLevel() throws BOSException {
        IRowSet rs = this.executeQuery("select max(FLevel) maxLevel from t_org_profitcenter where fid in " + this.cond.getProfitCenterIdsStr());
        try {
            if (rs.next()) {
                return rs.getInt("maxLevel");
            }
            return 1;
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
    }

    protected GLRptSubLedgerSpliter getSpliter() {
        return new PcaRptSubLedgerSpliter(this.getContex(), this, (OrgUnitInfo)this.getProfitCenter(), this.cond);
    }

    protected void setOrgUnitSelector(GLRptSelector selector) {
        selector.add(GLRptVoucherField.companyID);
        selector.add(PcaRptVoucherField.profitCenterID);
        selector.add(PcaRptVoucherField.profitCenterName);
    }

    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new PcaRptSubLedgerPageQuery(this.getContex(), this.cond, this.getIsShowAccount());
    }

    protected GLRptQuery getRptAccountBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new PcaRptAccountBeginPeriodBalQuery(ctx, company, cond, isCreateDataTempTable);
    }

    protected GLRptBalNextPeriodQuery getRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new PcaRptBalNextPeriodQuery(ctx, cond);
    }

    protected GLRptSubLedgerVoucherQuery getRptSubLedgerVoucherQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond, boolean isOnlyQty) {
        return new PcaRptSubLedgerVoucherQuery(ctx, company, cond, isOnlyQty);
    }

    protected GLRptAsstactBeginPeriodBalQuery getRptAsstactBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMu, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new PcaRptAsstactBeginPeriodBalQuery(ctx, company, cond, isMu, isCreateDataTempTable);
    }
}

