/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class AbstractPcVoucherBaseValidator
implements IVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(AbstractPcVoucherBaseValidator.class);
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";
    private static final boolean[][] voucherStatus = new boolean[][]{{true, false, false, false, false, false}, {true, true, false, false, false, false}, {true, true, true, false, false, false}, {false, true, false, false, true, false}, {false, false, false, true, false, false}, {false, true, false, true, false, true}, {false, true, false, true, true, true}, {false, false, false, true, false, false}, {false, false, false, false, false, true}, {false, true, false, false, false, false}, {false, false, true, false, false, false}, {false, false, false, false, false, true}};

    public abstract void validate(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected void checkStatusAndOperate(Context ctx, PcVoucherInfo voucherInfo, VoucherOperateStatusEnum operateStatus) throws BOSException, EASBizException {
        if (PcaUtils.isExisted(ctx, voucherInfo)) {
            int i = operateStatus.getValue();
            int j = voucherInfo.getBizStatus().getValue();
            Object[] info = new String[]{operateStatus.toString(), voucherInfo.getBizStatus().toString()};
            if (!voucherStatus[i][j]) {
                throw new VoucherException(VoucherException.STATUS_AND_OPERATE, info);
            }
        }
    }

    protected void checkVoucherPeriod(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        PeriodInfo currPeriod = PcaUtils.getCurrentPeriod(ctx, voucherInfo.getProfitCenter().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getPeriodYear() < currPeriod.getPeriodYear() || voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() && voucherInfo.getPeriod().getPeriodNumber() < currPeriod.getPeriodNumber()) {
            throw new VoucherException(VoucherException.PERIOD_NOT_VAILD);
        }
    }

    protected void checkVoucherType(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        String cuId = null;
        if (voucherInfo.getCompany() != null && voucherInfo.getCompany().getCU() != null) {
            cuId = voucherInfo.getCompany().getCU().getId().toString();
        }
        if (!PcVoucherUtil.isExistedVoucherType(ctx, cuId, voucherInfo.getVoucherType().getId().toString())) {
            throw new VoucherException(VoucherException.VOUCHERTYOENOTSEE);
        }
    }

    protected boolean existsCashOrBankAccount(Context ctx, String voucherId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        CoreBaseInfo model = PcVoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherId), sic);
        return ((PcVoucherInfo)model).existsCashOrBankAccount();
    }

    protected void checkPiaoJu(Context ctx, String id, GlParam sysParam, boolean isSubmit) throws BOSException, EASBizException {
        boolean isFzz = sysParam.getBoolean("GL_060");
        if (!isFzz) {
            return;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("  select a.fnumber,a.fcompanyid,b.fcurrencyid,sum(c.foriginalamount) famount, c.fsettlementcode,d.fbankaccountid,f.fnttypeid  \r\n");
        sql.append("\tfrom  \t\r\n");
        sql.append("\tt_pca_pcvoucher a,t_pca_pcvoucherentry b ,t_pca_pcvoucherassistrecord c, \t\t\r\n");
        sql.append("\tt_bd_assistanthg d ,t_bd_accountview e\t,t_bd_settlementtype f,T_NT_NTType g\t\t\t\r\n");
        sql.append(" where a.fid=b.fbillid \t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.fid=c.fentryid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.faccountid=e.fid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and c.fassgrpid=d.fid\tand d.fbankaccountid is not null\t\t\t\t\t\r\n");
        sql.append("  and c.fsettlementtypeid=f.fid\t\t\t\t\t\t\t\t\r\n");
        sql.append("  and f.fnttypeid=g.fid and g.fgroup=1 \t\t\t\t\t\t\t\r\n");
        sql.append(" and a.fsourcetype=0 and e.fisbank=1 and b.fentrydc=0\t\t\r\n");
        sql.append(" and a.fid=?\tgroup by a.fnumber,a.fcompanyid,b.fcurrencyid,c.fsettlementcode,d.fbankaccountid,f.fnttypeid\t\t\t\r\n");
        StringBuffer sqlCheck = new StringBuffer("");
        sqlCheck.append(" select f.fid,f.fstate,f.famount,h.fceiling,f.fpaymentbillnum \t from  \t\t\r\n");
        sqlCheck.append(" t_nt_cheque f,T_NT_NTType g ,T_NT_ChequeAppRec h \t\t\t\t\t\t\t\r\n");
        sqlCheck.append("  where f.fapplyrecid=h.fid and g.fid=f.fnttypeid and g.fgroup=1 \t\t\t\r\n");
        sqlCheck.append(" \tand f.fcompanyid=?\tand f.fbankacctid=?  \t\t\t\t\t\t\t\t\r\n");
        sqlCheck.append(" \tand f.fcurrencyid=?\tand f.fnumber=?\tand g.fid=? \t\t\t\t\t\t\r\n");
        String update = "update t_nt_cheque set fPaymentBillNum=? where fid=? ";
        String updateFalse = "update t_nt_cheque set fPaymentBillNum=null where fid=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        if (set != null) {
            try {
                while (set.next()) {
                    String number = set.getString("fnumber");
                    String comid = set.getString("fcompanyid");
                    String bankAccid = set.getString("fbankaccountid");
                    String curid = set.getString("fcurrencyid");
                    String settlementcode = set.getString("fsettlementcode");
                    String nttype = set.getString("fnttypeid");
                    BigDecimal amount = set.getBigDecimal("famount");
                    if (isSubmit && settlementcode == null) {
                        throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                    }
                    IRowSet checkset = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString(), (Object[])new Object[]{comid, bankAccid, curid, settlementcode, nttype});
                    if (checkset != null && checkset.next()) {
                        String chequeid = checkset.getString("fid");
                        BigDecimal checkamount = checkset.getBigDecimal("famount");
                        BigDecimal ceiling = checkset.getBigDecimal("fceiling");
                        int state = checkset.getInt("fstate");
                        String paymentbillnum = checkset.getString("fpaymentbillnum");
                        if (isSubmit) {
                            if (paymentbillnum != null) {
                                throw new VoucherException(VoucherException.TICKEDHASRELATED);
                            }
                            if (checkamount != null && ChequeStatusEnum.WRITTEN_OFF.getValue() == state && checkamount.compareTo(amount) != 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT2);
                            }
                            if (ceiling != null && ceiling.compareTo(amount) < 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT3);
                            }
                            DbUtil.execute((Context)ctx, (String)update, (Object[])new Object[]{number, chequeid});
                            continue;
                        }
                        DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{chequeid});
                        continue;
                    }
                    if (!isSubmit) continue;
                    throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void checkACNoticeCorrelation(Context ctx, String vchId) throws BOSException, EASBizException {
        AcNoticeUtil.checkACNoticeCorrelation((Context)ctx, (String)vchId);
    }

    protected void checkVerifiedStatus(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        boolean hasVerified;
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit() && voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance((Context)ctx).hasVerify(voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    protected void checkMutex(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ObjectUpdateLock lock = mutexService.getObjectUpdateLock(pk.toString());
        if (lock != null) {
            String mutexUserName = lock.getUserName();
            String curUserName = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
            if (!curUserName.equalsIgnoreCase(mutexUserName)) {
                throw new VoucherException(VoucherException.VOUCHER_IN_EDITING);
            }
        }
    }

    public boolean checkOriginalAmount(Context ctx, PcVoucherInfo info) throws EASBizException, BOSException {
        int i;
        BigDecimal creditAmount = new BigDecimal("0.00");
        BigDecimal debitAmount = new BigDecimal("0.00");
        PcVoucherEntryCollection collection = info.getEntries();
        if (collection == null || collection.size() <= 1) {
            return false;
        }
        String currencyName = null;
        ICurrency currencyIface = CurrencyFactory.getLocalInstance((Context)ctx);
        for (i = 0; i < collection.size() - 1; ++i) {
            PcVoucherEntryInfo entryInfo1 = collection.get(i);
            PcVoucherEntryInfo entryInfo2 = collection.get(i + 1);
            if (currencyName == null) {
                currencyName = ((CurrencyInfo)currencyIface.getValue((IObjectPK)new ObjectUuidPK(entryInfo1.getCurrency().getId()))).getName();
            }
            if (entryInfo1.getAccount().isBw()) {
                return false;
            }
            if (entryInfo1.getCurrency().getId().equals((Object)entryInfo2.getCurrency().getId())) continue;
            return false;
        }
        for (i = 0; i < collection.size(); ++i) {
            PcVoucherEntryInfo entryInfo = collection.get(i);
            if (entryInfo.getOriginalAmount() == null) continue;
            if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC())) {
                debitAmount = debitAmount.add(entryInfo.getOriginalAmount());
                continue;
            }
            creditAmount = creditAmount.add(entryInfo.getOriginalAmount());
        }
        if (creditAmount.compareTo(debitAmount) != 0) {
            throw new VoucherException(VoucherException.ORIGINAL_DC_NOT_EQUAL, new Object[]{currencyName + " ", debitAmount.toString(), creditAmount.toString()});
        }
        return false;
    }
}

