/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcVoucherEntrySaveValidator
implements IVoucherEntryValidator {
    protected static final Logger logger = Logger.getLogger(PcVoucherEntrySaveValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected PcVoucherInfo voucherInfo;
    protected PcVoucherEntryInfo entryInfo;

    public PcVoucherEntrySaveValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo, BaseVoucherEntryInfo baseEntryInfo) throws BOSException, EASBizException {
        PcVoucherEntryInfo entryInfo;
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.entryInfo = entryInfo = (PcVoucherEntryInfo)baseEntryInfo;
        this.checkEntryDC(ctx, voucherInfo, entryInfo);
        this.checkEntryAccount(ctx, voucherInfo, entryInfo);
        if (entryInfo.getReportingAmount() != null && entryInfo.getReportingAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
    }

    private void checkEntryAccount(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (accountViewInfo == null) {
            return;
        }
        String number = accountViewInfo.getNumber();
        if (accountViewInfo.isIsGFreeze() || accountViewInfo.isIsCFreeze() || accountViewInfo.isIsSelfFreeze()) {
            throw new VoucherException(VoucherException.ACCOUNT_FREEZE, new Object[]{this.getSeq()[0], accountViewInfo.getNumber()});
        }
        boolean isleaf = accountViewInfo.isIsLeaf();
        if (!isleaf) {
            throw new VoucherException(VoucherException.NOTACCOUNTOFCU, (Object[])new String[]{String.valueOf(entryInfo.getSeq()), number});
        }
        CompanyOrgUnitInfo org = null;
        if (voucherInfo.get("defaultRelatedCompany") != null && voucherInfo.get("defaultRelatedCompany") instanceof CompanyOrgUnitInfo) {
            org = (CompanyOrgUnitInfo)voucherInfo.get("defaultRelatedCompany");
        } else if (voucherInfo.get("defaultRelatedCompany") != null) {
            Map orgMap = (Map)voucherInfo.get("defaultRelatedCompany");
            org = PcaUtils.getCompanyById(orgMap.get("id").toString());
        } else {
            org = PcaUtils.getRelatedCompany(ctx, voucherInfo.getProfitCenter().getId().toString());
        }
        if (org == null || org.getCU() == null || org.getCU().getId() == null) {
            org = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String companyId = accountViewInfo.getCompanyID().getId().toString();
        String accountbale = accountViewInfo.getAccountTableID().getId().toString();
        if (!(accountViewInfo == null || org.getId().toString().equals(accountViewInfo.getCompanyID().getId().toString()) && org.getAccountTable().getId().toString().equals(accountViewInfo.getAccountTableID().getId().toString()))) {
            PcVoucherUtil.replaceAccount(ctx, org.getId().toString(), org.getAccountTable().getId().toString(), entryInfo);
        }
    }

    private void checkEntryDC(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws VoucherException {
        if (entryInfo.get("entryDC") == null) {
            throw new VoucherException(VoucherException.ENTRYDC_CANNOT_NULL, (Object[])this.getSeq());
        }
    }

    private Integer[] getSeq() {
        Integer[] lineSeq = new Integer[]{new Integer(this.entryInfo.getSeq())};
        return lineSeq;
    }
}

