/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PcVoucherValidatorOperatorSharer {
    private static final Logger logger = Logger.getLogger(PcVoucherValidatorOperatorSharer.class);

    protected void checkPiaoJu(Context ctx, String id, GlParam sysParam, boolean isSubmit) throws BOSException, EASBizException {
        boolean isFzz = sysParam.getBoolean("GL_060");
        if (!isFzz) {
            return;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("  select a.fnumber,a.fcompanyid,b.fcurrencyid,sum(c.foriginalamount) famount, c.fsettlementcode,d.fbankaccountid,f.fnttypeid  \r\n");
        sql.append("\tfrom  \t\r\n");
        sql.append("\tt_pca_pcvoucher a,t_pca_pcvoucherentry b ,t_pca_pcvoucherassistrecord c, \t\t\r\n");
        sql.append("\tt_bd_assistanthg d ,t_bd_accountview e\t,t_bd_settlementtype f,T_NT_NTType g\t\t\t\r\n");
        sql.append(" where a.fid=b.fbillid \t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.fid=c.fentryid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.faccountid=e.fid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and c.fassgrpid=d.fid\tand d.fbankaccountid is not null\t\t\t\t\t\r\n");
        sql.append("  and c.fsettlementtypeid=f.fid\t\t\t\t\t\t\t\t\r\n");
        sql.append("  and f.fnttypeid=g.fid and g.fgroup=1 \t\t\t\t\t\t\t\r\n");
        sql.append(" and a.fsourcetype=0 and e.fisbank=1 and b.fentrydc=0\t\t\r\n");
        sql.append(" and a.fid=?\tgroup by a.fnumber,a.fcompanyid,b.fcurrencyid,c.fsettlementcode,d.fbankaccountid,f.fnttypeid\t\t\t\r\n");
        StringBuffer sqlCheck = new StringBuffer("");
        sqlCheck.append(" select f.fid,f.fstate,f.famount,h.fceiling,f.fpaymentbillnum \t from  \t\t\r\n");
        sqlCheck.append(" t_nt_cheque f,T_NT_NTType g ,T_NT_ChequeAppRec h \t\t\t\t\t\t\t\r\n");
        sqlCheck.append("  where f.fapplyrecid=h.fid and g.fid=f.fnttypeid and g.fgroup=1 \t\t\t\r\n");
        sqlCheck.append(" \tand f.fcompanyid=?\tand f.fbankacctid=?  \t\t\t\t\t\t\t\t\r\n");
        sqlCheck.append(" \tand f.fcurrencyid=?\tand f.fnumber=?\tand g.fid=? \t\t\t\t\t\t\r\n");
        String update = "update t_nt_cheque set fPaymentBillNum=? where fid=? ";
        String updateFalse = "update t_nt_cheque set fPaymentBillNum=null where fid=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        if (set != null) {
            try {
                while (set.next()) {
                    String number = set.getString("fnumber");
                    String comid = set.getString("fcompanyid");
                    String bankAccid = set.getString("fbankaccountid");
                    String curid = set.getString("fcurrencyid");
                    String settlementcode = set.getString("fsettlementcode");
                    String nttype = set.getString("fnttypeid");
                    BigDecimal amount = set.getBigDecimal("famount");
                    if (isSubmit && settlementcode == null) {
                        throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                    }
                    IRowSet checkset = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString(), (Object[])new Object[]{comid, bankAccid, curid, settlementcode, nttype});
                    if (checkset != null && checkset.next()) {
                        String chequeid = checkset.getString("fid");
                        BigDecimal checkamount = checkset.getBigDecimal("famount");
                        BigDecimal ceiling = checkset.getBigDecimal("fceiling");
                        int state = checkset.getInt("fstate");
                        String paymentbillnum = checkset.getString("fpaymentbillnum");
                        if (isSubmit) {
                            if (paymentbillnum != null) {
                                throw new VoucherException(VoucherException.TICKEDHASRELATED);
                            }
                            if (checkamount != null && ChequeStatusEnum.WRITTEN_OFF.getValue() == state && checkamount.compareTo(amount) != 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT2);
                            }
                            if (ceiling != null && ceiling.compareTo(amount) < 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT3);
                            }
                            DbUtil.execute((Context)ctx, (String)update, (Object[])new Object[]{number, chequeid});
                            continue;
                        }
                        DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{chequeid});
                        continue;
                    }
                    if (!isSubmit) continue;
                    throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void checkVerifiedStatus(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        boolean hasVerified;
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit() && voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance((Context)ctx).hasVerify(voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }
}

