/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ReversePcVoucherValidatorUtils {
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    public static int checkReverse(Context ctx, PcVoucherInfo vch, PcVoucherInfo srcVch, StringBuffer msgCollector) throws BOSException {
        String srcVchId = srcVch.getId().toString();
        boolean isNew = vch.getId() == null;
        Map mapSrcVch = ReversePcVoucherValidatorUtils.getSrcVoucherInfo(ctx, srcVchId);
        Map mapReverseVch = ReversePcVoucherValidatorUtils.getReverseVoucher(ctx, vch, srcVchId, isNew);
        PcVoucherEntryCollection entries = vch.getEntries();
        HashMap<String, Comparable<Boolean>> recordMap = new HashMap<String, Comparable<Boolean>>();
        recordMap.put("canReverse", Boolean.valueOf(true));
        recordMap.put("reverseComplete", Boolean.valueOf(true));
        recordMap.put("msgCollector", msgCollector);
        int index = 0;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            PcVoucherEntryInfo entry = entries.get(i);
            PcVoucherAssistRecordCollection colAssist = entry.getAssistRecords();
            if (colAssist == null || colAssist.size() == 0) {
                ReversePcVoucherValidatorUtils.checkEntry(ctx, mapSrcVch, mapReverseVch, recordMap, vch, entry, index++);
                continue;
            }
            int assistSize = colAssist.size();
            for (int j = 0; j < assistSize; ++j) {
                PcVoucherAssistRecordInfo assist = colAssist.get(j);
                ReverseRecord reverseValue = (ReverseRecord)mapReverseVch.get(index);
                ReverseRecord srcValue = (ReverseRecord)mapSrcVch.get(index);
                ++index;
                List checkList = ReversePcVoucherValidatorUtils.transAssistValues(srcValue, reverseValue, assist);
                ReversePcVoucherValidatorUtils.checkRecord(ctx, recordMap, checkList, vch, entry, assist);
            }
        }
        if (!Boolean.valueOf(recordMap.get("canReverse").toString()).booleanValue()) {
            msgCollector = new StringBuffer(recordMap.get("msgCollector").toString());
            return -1;
        }
        if (Boolean.valueOf(recordMap.get("reverseComplete").toString()).booleanValue()) {
            srcVch.setHasReversed(true);
            return 0;
        }
        srcVch.setHasReversed(false);
        return 1;
    }

    private static void checkEntry(Context ctx, Map mapSrcVch, Map mapReverseVch, Map recordMap, PcVoucherInfo voucher, PcVoucherEntryInfo entry, int index) {
        ReverseRecord srcValue = (ReverseRecord)mapSrcVch.get(index);
        ReverseRecord reverseValue = (ReverseRecord)mapReverseVch.get(index);
        List checkList = ReversePcVoucherValidatorUtils.transEntryValues(srcValue, reverseValue, entry);
        ReversePcVoucherValidatorUtils.checkRecord(ctx, recordMap, checkList, voucher, entry, null);
    }

    private static List transEntryValues(ReverseRecord srcValue, ReverseRecord reverseValue, PcVoucherEntryInfo entry) {
        ArrayList checkList = new ArrayList();
        BigDecimal leftVeOrigAmount = GlUtils.zero;
        BigDecimal leftVeLocalAmount = GlUtils.zero;
        BigDecimal leftVeReportingAmount = GlUtils.zero;
        BigDecimal leftVeQuantity = GlUtils.zero;
        BigDecimal srcVeOrigAmount = srcValue.getVeOrigAmount();
        BigDecimal srcVeLocalAmount = srcValue.getVeLocalAmount();
        BigDecimal srcVeReportingAmount = srcValue.getVeReportingAmount();
        BigDecimal srcVeQuantity = srcValue.getVeQuantity();
        if (reverseValue == null) {
            leftVeOrigAmount = srcVeOrigAmount.negate();
            leftVeLocalAmount = srcVeLocalAmount.negate();
            leftVeReportingAmount = srcVeReportingAmount.negate();
            leftVeQuantity = srcVeQuantity.negate();
        } else {
            BigDecimal reverseVeOrigAmount = reverseValue.getVeOrigAmount();
            BigDecimal reverseVeLocalAmount = reverseValue.getVeLocalAmount();
            BigDecimal reverseVeReportingAmount = reverseValue.getVeReportingAmount();
            BigDecimal reverseVeQuantity = reverseValue.getVeQuantity();
            leftVeOrigAmount = srcVeOrigAmount.add(reverseVeOrigAmount).negate();
            leftVeLocalAmount = srcVeLocalAmount.add(reverseVeLocalAmount).negate();
            leftVeReportingAmount = srcVeReportingAmount.add(reverseVeReportingAmount).negate();
            leftVeQuantity = srcVeQuantity.add(reverseVeQuantity).negate();
        }
        ArrayList<Number> listVeOrigAmount = new ArrayList<Number>();
        listVeOrigAmount.add(leftVeOrigAmount);
        listVeOrigAmount.add(entry.getOriginalAmount());
        listVeOrigAmount.add(0);
        listVeOrigAmount.add(0);
        ArrayList<Number> listVeLocalAmount = new ArrayList<Number>();
        listVeLocalAmount.add(leftVeLocalAmount);
        listVeLocalAmount.add(entry.getLocalAmount());
        listVeLocalAmount.add(0);
        listVeLocalAmount.add(1);
        ArrayList<Number> listVeReportingAmount = new ArrayList<Number>();
        listVeReportingAmount.add(leftVeReportingAmount);
        listVeReportingAmount.add(entry.getReportingAmount());
        listVeReportingAmount.add(0);
        listVeReportingAmount.add(2);
        ArrayList<Number> listVeQuantity = new ArrayList<Number>();
        listVeQuantity.add(leftVeQuantity);
        listVeQuantity.add(entry.getQuantity());
        listVeQuantity.add(0);
        listVeQuantity.add(3);
        checkList.add(listVeOrigAmount);
        checkList.add(listVeLocalAmount);
        checkList.add(listVeReportingAmount);
        checkList.add(listVeQuantity);
        return checkList;
    }

    private static List transAssistValues(ReverseRecord srcValue, ReverseRecord reverseValue, PcVoucherAssistRecordInfo assist) {
        ArrayList checkList = new ArrayList();
        BigDecimal leftAssistOrigAmount = GlUtils.zero;
        BigDecimal leftAssistLocalAmount = GlUtils.zero;
        BigDecimal leftAssistReportingAmount = GlUtils.zero;
        BigDecimal leftAssistQuantity = GlUtils.zero;
        BigDecimal srcAssistOrigAmount = srcValue.getAssistOrigAmount();
        BigDecimal srcAssistLocalAmount = srcValue.getAssistLocalAmount();
        BigDecimal srcAssistReportingAmount = srcValue.getAssistReportingAmount();
        BigDecimal srcAssistQuantity = srcValue.getAssistQuantity();
        if (reverseValue == null) {
            leftAssistOrigAmount = srcAssistOrigAmount.negate();
            leftAssistLocalAmount = srcAssistLocalAmount.negate();
            leftAssistReportingAmount = srcAssistReportingAmount.negate();
            leftAssistQuantity = srcAssistQuantity.negate();
        } else {
            BigDecimal reverseAssistOrigAmount = reverseValue.getAssistOrigAmount();
            BigDecimal reverseAssistLocalAmount = reverseValue.getAssistLocalAmount();
            BigDecimal reverseAssistReportingAmount = reverseValue.getAssistReportingAmount();
            BigDecimal reverseAssistQuantity = reverseValue.getAssistQuantity();
            leftAssistOrigAmount = srcAssistOrigAmount.add(reverseAssistOrigAmount).negate();
            leftAssistLocalAmount = srcAssistLocalAmount.add(reverseAssistLocalAmount).negate();
            leftAssistReportingAmount = srcAssistReportingAmount.add(reverseAssistReportingAmount).negate();
            leftAssistQuantity = srcAssistQuantity.add(reverseAssistQuantity).negate();
        }
        ArrayList<Number> listAssistOrigAmount = new ArrayList<Number>();
        listAssistOrigAmount.add(leftAssistOrigAmount);
        listAssistOrigAmount.add(assist.getOriginalAmount());
        listAssistOrigAmount.add(1);
        listAssistOrigAmount.add(0);
        ArrayList<Number> listAssistLocalAmount = new ArrayList<Number>();
        listAssistLocalAmount.add(leftAssistLocalAmount);
        listAssistLocalAmount.add(assist.getLocalAmount());
        listAssistLocalAmount.add(1);
        listAssistLocalAmount.add(1);
        ArrayList<Number> listAssistReportingAmount = new ArrayList<Number>();
        listAssistReportingAmount.add(leftAssistReportingAmount);
        listAssistReportingAmount.add(assist.getReportingAmount());
        listAssistReportingAmount.add(1);
        listAssistReportingAmount.add(2);
        ArrayList<Number> listAssistQuantity = new ArrayList<Number>();
        listAssistQuantity.add(leftAssistQuantity);
        listAssistQuantity.add(assist.getQuantity());
        listAssistQuantity.add(1);
        listAssistQuantity.add(3);
        checkList.add(listAssistOrigAmount);
        checkList.add(listAssistLocalAmount);
        checkList.add(listAssistReportingAmount);
        checkList.add(listAssistQuantity);
        return checkList;
    }

    private static Map getSrcVoucherInfo(Context ctx, String srcVchId) throws BOSException {
        StringBuffer sqlSrcVch = new StringBuffer();
        sqlSrcVch.append(" select ve.fseq fveseq \r\n");
        sqlSrcVch.append(" ,ve.FOriginalAmount FOriginalAmount \r\n");
        sqlSrcVch.append(" ,ve.flocalamount fvelocalamount \r\n");
        sqlSrcVch.append(" ,ve.FReportingAmount FReportingAmount \r\n");
        sqlSrcVch.append(" ,ve.FQuantity fvequantity \r\n");
        sqlSrcVch.append(" ,ve.FStandardQuantity FStandardQuantity \r\n");
        sqlSrcVch.append(" ,assist.fseq fassistseq \r\n");
        sqlSrcVch.append(" ,assist.FOriginalAmount FOriginalAmount \r\n");
        sqlSrcVch.append(" ,assist.flocalamount fassistlocalamount \r\n");
        sqlSrcVch.append(" ,assist.FReportingAmount FReportingAmount \r\n");
        sqlSrcVch.append(" ,assist.FQuantity fassistquantity \r\n");
        sqlSrcVch.append(" ,assist.FStandardQuantity FStandardQuantity \r\n");
        sqlSrcVch.append(" from t_pca_pcvoucherentry ve \r\n");
        sqlSrcVch.append(" left join t_pca_pcvoucherassistrecord assist on ve.fid=assist.fentryid \r\n");
        sqlSrcVch.append(" where ve.fbillid = ? \r\n");
        sqlSrcVch.append(" order by ve.fseq,assist.fseq \r\n");
        IRowSet rsSrcVch = DbUtil.executeQuery((Context)ctx, (String)sqlSrcVch.toString(), (Object[])new Object[]{srcVchId});
        HashMap<Integer, ReverseRecord> mapSrcVch = new HashMap<Integer, ReverseRecord>();
        try {
            ReverseRecord record = null;
            int index = 0;
            while (rsSrcVch.next()) {
                record = new ReverseRecord();
                record.setVeSeq(rsSrcVch.getInt(1));
                record.setVeOrigAmount(rsSrcVch.getBigDecimal(2) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(2));
                record.setVeLocalAmount(rsSrcVch.getBigDecimal(3) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(3));
                record.setVeReportingAmount(rsSrcVch.getBigDecimal(4) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(4));
                record.setVeQuantity(rsSrcVch.getBigDecimal(5) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(5));
                record.setVeStdQantity(rsSrcVch.getBigDecimal(6) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(6));
                record.setAssistSeq(rsSrcVch.getInt(7));
                record.setAssistOrigAmount(rsSrcVch.getBigDecimal(8) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(8));
                record.setAssistLocalAmount(rsSrcVch.getBigDecimal(9) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(9));
                record.setAssistReportingAmount(rsSrcVch.getBigDecimal(10) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(10));
                record.setAssistQuantity(rsSrcVch.getBigDecimal(11) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(11));
                record.setAssistStdQantity(rsSrcVch.getBigDecimal(12) == null ? GlUtils.zero : rsSrcVch.getBigDecimal(12));
                mapSrcVch.put(index++, record);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL Error!", (Throwable)e);
        }
        return mapSrcVch;
    }

    private static Map getReverseVoucher(Context ctx, PcVoucherInfo vch, String srcVchId, boolean isNew) throws BOSException {
        ArrayList<String> sqlReverseParams = new ArrayList<String>();
        StringBuffer sqlReverseVch = new StringBuffer();
        sqlReverseVch.append("select ve.fseq fveseq,sum(ve.foriginalamount) fveoriginalamount,sum(ve.flocalamount) fvelocalamount,\r\n");
        sqlReverseVch.append("sum(ve.freportingamount) fvereportingamount, sum(ve.FQuantity) fvequantity,\r\n");
        sqlReverseVch.append("sum(ve.FStandardQuantity) FveStandardQuantity, \r\n");
        sqlReverseVch.append("assist.fseq fassistseq,sum(assist.foriginalamount) fassistoriginalamount,\r\n");
        sqlReverseVch.append("sum(assist.flocalamount) fassistlocalamount,sum(assist.freportingamount) fassistreportingamount, \r\n");
        sqlReverseVch.append("sum(assist.FQuantity) fassistquantity, \r\n");
        sqlReverseVch.append("sum(assist.FStandardQuantity) FassistStandardQuantity \r\n");
        sqlReverseVch.append("from t_pca_pcvoucherentry ve \r\n");
        sqlReverseVch.append("inner join t_pca_pcvoucher v on ve.fbillid=v.fid \r\n");
        sqlReverseVch.append("left join t_pca_pcvoucherassistrecord assist on ve.fid=assist.fentryid \r\n");
        sqlReverseVch.append("where v.fsourcebillid = ? and v.FIsReverseVoucher=1 \r\n");
        sqlReverseParams.add(srcVchId);
        if (!isNew) {
            sqlReverseVch.append("and v.fid <> ? \r\n");
            sqlReverseParams.add(vch.getId().toString());
        }
        sqlReverseVch.append(" and v.fbizstatus <> 2 and v.fbizstatus <> 0\r\n");
        sqlReverseVch.append("group by ve.fseq,assist.fseq\r\n");
        sqlReverseVch.append("order by ve.fseq,assist.fseq \r\n");
        IRowSet rsReverseVch = DbUtil.executeQuery((Context)ctx, (String)sqlReverseVch.toString(), (Object[])sqlReverseParams.toArray());
        HashMap<Integer, ReverseRecord> mapReverseVch = new HashMap<Integer, ReverseRecord>();
        try {
            ReverseRecord record = null;
            int index = 0;
            while (rsReverseVch.next()) {
                record = new ReverseRecord();
                record.setVeSeq(rsReverseVch.getInt(1));
                record.setVeOrigAmount(rsReverseVch.getBigDecimal(2) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(2));
                record.setVeLocalAmount(rsReverseVch.getBigDecimal(3) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(3));
                record.setVeReportingAmount(rsReverseVch.getBigDecimal(4) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(4));
                record.setVeQuantity(rsReverseVch.getBigDecimal(5) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(5));
                record.setVeStdQantity(rsReverseVch.getBigDecimal(6) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(6));
                record.setAssistSeq(rsReverseVch.getInt(7));
                record.setAssistOrigAmount(rsReverseVch.getBigDecimal(8) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(8));
                record.setAssistLocalAmount(rsReverseVch.getBigDecimal(9) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(9));
                record.setAssistReportingAmount(rsReverseVch.getBigDecimal(10) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(10));
                record.setAssistQuantity(rsReverseVch.getBigDecimal(11) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(11));
                record.setAssistStdQantity(rsReverseVch.getBigDecimal(12) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(12));
                mapReverseVch.put(index++, record);
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        return mapReverseVch;
    }

    private static void checkRecord(Context ctx, Map recordMap, List checkList, PcVoucherInfo voucher, PcVoucherEntryInfo entry, PcVoucherAssistRecordInfo assist) {
        int size = checkList.size();
        for (int i = 0; i < size; ++i) {
            StringBuffer sb = (StringBuffer)recordMap.get("msgCollector");
            List list = (List)checkList.get(i);
            BigDecimal leftAmount = (BigDecimal)list.get(0);
            BigDecimal vchAmount = (BigDecimal)list.get(1);
            Integer entryFlag = (Integer)list.get(2);
            Integer amountFlag = (Integer)list.get(3);
            int compareResult = 0;
            String str = "";
            if (amountFlag == 0) {
                str = ResourceBase.getString((String)resource, (String)"OrigAmount", (Locale)ctx.getLocale());
            } else if (amountFlag == 1) {
                str = ResourceBase.getString((String)resource, (String)"LocalAmount", (Locale)ctx.getLocale());
            } else if (amountFlag == 2) {
                str = ResourceBase.getString((String)resource, (String)"RptAmount", (Locale)ctx.getLocale());
            } else if (amountFlag == 3) {
                str = ResourceBase.getString((String)resource, (String)"Quanty", (Locale)ctx.getLocale());
            }
            if (vchAmount.signum() != leftAmount.signum()) {
                recordMap.put("canReverse", false);
                if (entryFlag == 0 || voucher.isWebVoucher()) {
                    sb.append(ReversePcVoucherValidatorUtils.getResource(ctx, resource, "BEYOND_SRC_ENTRY_DIFFERENT", new Object[]{new Integer(entry.getSeq()), str, vchAmount})).append("\r\n");
                    continue;
                }
                if (entryFlag != 1) continue;
                sb.append(ReversePcVoucherValidatorUtils.getResource(ctx, resource, "BEYOND_SRC_ASSIST_DIFFERENT", new Object[]{new Integer(entry.getSeq()), new Integer(assist.getSeq()), str, vchAmount})).append("\r\n");
                continue;
            }
            compareResult = leftAmount.signum() >= 0 ? vchAmount.compareTo(leftAmount) : leftAmount.compareTo(vchAmount);
            if (compareResult > 0) {
                recordMap.put("canReverse", false);
                if (entryFlag == 0 || voucher.isWebVoucher()) {
                    sb.append(ReversePcVoucherValidatorUtils.getResource(ctx, resource, "BEYOND_SRC_AMOUNT_ENTRY", new Object[]{new Integer(entry.getSeq()), str, vchAmount, str, leftAmount})).append("\r\n");
                } else if (entryFlag == 1) {
                    sb.append(ReversePcVoucherValidatorUtils.getResource(ctx, resource, "BEYOND_SRC_AMOUNT_ASSIST", new Object[]{new Integer(entry.getSeq()), new Integer(assist.getSeq()), str, vchAmount, str, leftAmount})).append("\r\n");
                }
            } else if (compareResult < 0) {
                recordMap.put("reverseComplete", false);
            }
            recordMap.put("msgCollector", sb);
        }
    }

    private static String getResource(Context ctx, String resName, String key, Object[] params) {
        String message = ResourceBase.getString((String)resName, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    private static class ReverseRecord {
        private int veSeq = 0;
        private BigDecimal veOrigAmount = GlUtils.zero;
        private BigDecimal veLocalAmount = GlUtils.zero;
        private BigDecimal veReportingAmount = GlUtils.zero;
        private BigDecimal veQuantity = GlUtils.zero;
        private BigDecimal veStdQantity = GlUtils.zero;
        private int assistSeq = 0;
        private BigDecimal assistOrigAmount = GlUtils.zero;
        private BigDecimal assistLocalAmount = GlUtils.zero;
        private BigDecimal assistReportingAmount = GlUtils.zero;
        private BigDecimal assistQuantity = GlUtils.zero;
        private BigDecimal assistStdQantity = GlUtils.zero;

        private ReverseRecord() {
        }

        public int getVeSeq() {
            return this.veSeq;
        }

        public void setVeSeq(int veSeq) {
            this.veSeq = veSeq;
        }

        public BigDecimal getVeOrigAmount() {
            return this.veOrigAmount;
        }

        public void setVeOrigAmount(BigDecimal veOrigAmount) {
            this.veOrigAmount = veOrigAmount;
        }

        public BigDecimal getVeLocalAmount() {
            return this.veLocalAmount;
        }

        public void setVeLocalAmount(BigDecimal veLocalAmount) {
            this.veLocalAmount = veLocalAmount;
        }

        public BigDecimal getVeReportingAmount() {
            return this.veReportingAmount;
        }

        public void setVeReportingAmount(BigDecimal veReportingAmount) {
            this.veReportingAmount = veReportingAmount;
        }

        public BigDecimal getVeQuantity() {
            return this.veQuantity;
        }

        public void setVeQuantity(BigDecimal veQuantity) {
            this.veQuantity = veQuantity;
        }

        public BigDecimal getVeStdQantity() {
            return this.veStdQantity;
        }

        public void setVeStdQantity(BigDecimal veStdQantity) {
            this.veStdQantity = veStdQantity;
        }

        public int getAssistSeq() {
            return this.assistSeq;
        }

        public void setAssistSeq(int assistSeq) {
            this.assistSeq = assistSeq;
        }

        public BigDecimal getAssistOrigAmount() {
            return this.assistOrigAmount;
        }

        public void setAssistOrigAmount(BigDecimal assistOrigAmount) {
            this.assistOrigAmount = assistOrigAmount;
        }

        public BigDecimal getAssistLocalAmount() {
            return this.assistLocalAmount;
        }

        public void setAssistLocalAmount(BigDecimal assistLocalAmount) {
            this.assistLocalAmount = assistLocalAmount;
        }

        public BigDecimal getAssistReportingAmount() {
            return this.assistReportingAmount;
        }

        public void setAssistReportingAmount(BigDecimal assistReportingAmount) {
            this.assistReportingAmount = assistReportingAmount;
        }

        public BigDecimal getAssistQuantity() {
            return this.assistQuantity;
        }

        public void setAssistQuantity(BigDecimal assistQuantity) {
            this.assistQuantity = assistQuantity;
        }

        public BigDecimal getAssistStdQantity() {
            return this.assistStdQantity;
        }

        public void setAssistStdQantity(BigDecimal assistStdQantity) {
            this.assistStdQantity = assistStdQantity;
        }
    }
}

