/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.AbstractTemplatePcVoucherInfo;
import com.kingdee.eas.ma.pca.PcCashflowRecordCollection;
import com.kingdee.eas.ma.pca.PcCashflowRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherAgent;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordAgent;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryAgent;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.TemplatePcCashflowRecordCollection;
import com.kingdee.eas.ma.pca.TemplatePcCashflowRecordInfo;
import com.kingdee.eas.ma.pca.TemplatePcVoucherAsstRecordCollection;
import com.kingdee.eas.ma.pca.TemplatePcVoucherAsstRecordInfo;
import com.kingdee.eas.ma.pca.TemplatePcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.TemplatePcVoucherEntryInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TemplatePcVoucherInfo
extends AbstractTemplatePcVoucherInfo
implements Serializable {
    private static final Logger logger = Logger.getLogger(TemplatePcVoucherInfo.class);

    public TemplatePcVoucherInfo() {
    }

    protected TemplatePcVoucherInfo(String pkField) {
        super(pkField);
    }

    public void setEntries(TemplatePcVoucherEntryCollection entries) {
        this.put("entries", (Object)entries);
    }

    public void setCashflowFetched(boolean fetched) {
        this.put("fetched", fetched);
    }

    public boolean getCashflowFetched() {
        boolean fetched = false;
        if (this.get("fetched") != null) {
            fetched = (Boolean)this.get("fetched");
        }
        return fetched;
    }

    public void setCashflowRecords(TemplatePcCashflowRecordCollection cfs) {
        this.put("fetched", true);
        this.put("cashflowRecords", (Object)cfs);
    }

    public TemplatePcCashflowRecordCollection getCashflowRecords() {
        return (TemplatePcCashflowRecordCollection)((Object)this.get("cashflowRecords"));
    }

    public void setCashFlowAccountDiffCollection(CashFlowAccountDiffCollection col) {
        this.put("CashFlowAccountDiffCollection", col);
    }

    public CashFlowAccountDiffCollection getCashFlowAccountDiffCollection() {
        return (CashFlowAccountDiffCollection)this.get("CashFlowAccountDiffCollection");
    }

    public Vector getRemovedEntries() {
        return (Vector)this.get("removedEntries");
    }

    public void setRemovedEntries(Vector removedEntries) {
        this.put("removedEntries", removedEntries);
    }

    public Vector getRemovedRecords() {
        return (Vector)this.get("removedRecords");
    }

    public void setRemovedRecords(Vector removedRecords) {
        this.put("removedRecords", removedRecords);
    }

    public void setVoucherTypeDetail(Object[] vtDetail) {
        this.put("vtDetail", vtDetail);
    }

    public Object[] getVoucherTypeDetail() {
        return (Object[])this.get("vtDetail");
    }

    public static SelectorItemCollection getDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.accountPeriodType.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency.name"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("company.baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("company.reportCurrency.number"));
        sic.add(new SelectorItemInfo("company.reportCurrency.name"));
        sic.add(new SelectorItemInfo("company.reportCurrency.precision"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("company.reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("company.reportConvertMode"));
        sic.add(new SelectorItemInfo("company.CU.id"));
        sic.add(new SelectorItemInfo("company.CU.number"));
        sic.add(new SelectorItemInfo("company.accountTable.id"));
        sic.add(new SelectorItemInfo("company.adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("profitCenter.id"));
        sic.add(new SelectorItemInfo("profitCenter.number"));
        sic.add(new SelectorItemInfo("profitCenter.name"));
        sic.add(new SelectorItemInfo("profitCenter.CU.id"));
        sic.add(new SelectorItemInfo("profitCenter.CU.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("attachments"));
        sic.add(new SelectorItemInfo("voucherType.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.id"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.number"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.name"));
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("localDebitAmount"));
        sic.add(new SelectorItemInfo("localCreditAmount"));
        sic.add(new SelectorItemInfo("reportingDebitAmount"));
        sic.add(new SelectorItemInfo("reportingCreditAmount"));
        sic.add(new SelectorItemInfo("cashflowFlag"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.description"));
        sic.add(new SelectorItemInfo("entries.account.id"));
        sic.add(new SelectorItemInfo("entries.account.longNumber"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.account.name"));
        sic.add(new SelectorItemInfo("entries.account.displayName"));
        sic.add(new SelectorItemInfo("entries.account.level"));
        sic.add(new SelectorItemInfo("entries.account.DC"));
        sic.add(new SelectorItemInfo("entries.account.AC"));
        sic.add(new SelectorItemInfo("entries.account.bw"));
        sic.add(new SelectorItemInfo("entries.account.ACNotice"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.account.control"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        sic.add(new SelectorItemInfo("entries.account.isCashEquivalent"));
        sic.add(new SelectorItemInfo("entries.account.hasUserProperty"));
        sic.add(new SelectorItemInfo("entries.account.isGFreeze"));
        sic.add(new SelectorItemInfo("entries.account.isCFreeze"));
        sic.add(new SelectorItemInfo("entries.account.isSelfFreeze"));
        sic.add(new SelectorItemInfo("entries.account.isLeaf"));
        sic.add(new SelectorItemInfo("entries.account.PLType"));
        sic.add(new SelectorItemInfo("entries.account.accountingcurrency"));
        sic.add(new SelectorItemInfo("entries.account.accountCurrency.id"));
        sic.add(new SelectorItemInfo("entries.account.accountCurrency.currency.id"));
        sic.add(new SelectorItemInfo("entries.account.isChangeCurrency"));
        sic.add(new SelectorItemInfo("entries.account.companyID.id"));
        sic.add(new SelectorItemInfo("entries.account.currencyID.id"));
        sic.add(new SelectorItemInfo("entries.account.measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("entries.account.accountTableID.id"));
        sic.add(new SelectorItemInfo("entries.account.accountTypeID.id"));
        sic.add(new SelectorItemInfo("entries.account.accountTypeID.property"));
        sic.add(new SelectorItemInfo("entries.account.CAA.id"));
        sic.add(new SelectorItemInfo("entries.account.longName"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.account.CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("entries.account.CAA.isQty"));
        sic.add(new SelectorItemInfo("entries.account.CAA.name"));
        sic.add(new SelectorItemInfo("entries.account.CAA.number"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.currency.deletedStatus"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.measureUnit.isDisabled"));
        sic.add(new SelectorItemInfo("entries.measureUnit.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.localExchangeRate"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reportingExchangeRate"));
        sic.add(new SelectorItemInfo("entries.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
        sic.add(new SelectorItemInfo("entries.assistRecords.description"));
        sic.add(new SelectorItemInfo("entries.assistRecords.price"));
        sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.isFullProp"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnitID.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnitID.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnitID.isDisabled"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnitID.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.displayNameGroup"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.longNameGroup"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.asstAccount.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.isFullProp"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.feeType"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.customer.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.customer.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.customer.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.supplier.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.supplier.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.supplier.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.material.id"));
        sic.add(new SelectorItemInfo("entries.assistRecords.material.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.material.number"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.id"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.name"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.number"));
        sic.add(new SelectorItemInfo("templateVoucherGroup.parent.id"));
        return sic;
    }

    public CashflowFlag computeCashflowFlag() {
        boolean cashAccExist = false;
        boolean pnlAccExist = false;
        boolean elseAccExist = false;
        int count = this.getEntryCount();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo acc = this.getEntries().get(i).getAccount();
            if (acc == null) continue;
            if (acc.isIsCash() || acc.isIsBank() || acc.isIsCashEquivalent()) {
                cashAccExist = true;
                continue;
            }
            if (AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) {
                pnlAccExist = true;
                continue;
            }
            elseAccExist = true;
        }
        CashflowFlag flag = null;
        flag = cashAccExist && pnlAccExist ? CashflowFlag.BOTH_CASH_AND_PNL : (cashAccExist && elseAccExist ? CashflowFlag.ONLY_CASHACCOUNT : (pnlAccExist && elseAccExist ? CashflowFlag.ONLY_PNLACCOUNT : CashflowFlag.NONE));
        return flag;
    }

    public PcVoucherInfo transfer() {
        PcVoucherInfo info = null;
        if (this.get("isWeb") == null) {
            try {
                info = PcVoucherAgent.create();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (info == null) {
            info = new PcVoucherInfo();
        }
        info.setSourceSys(SystemEnum.PROFIT_CENTER_ACCOUNTING);
        info.setSourceType(SourceType.HANDCRAFT);
        info.setBizStatus(VoucherStatusEnum.TEMP);
        info.setAttachments(this.getAttachments());
        info.setCompany(this.getCompany());
        info.setProfitCenter(this.getProfitCenter());
        info.setCreateTime(null);
        if (this.get("isWeb") == null) {
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            info.setHandler(SysContext.getSysContext().getCurrentUserInfo());
        }
        info.setCU(this.getCU());
        info.setCurrency(this.getCurrency());
        info.setDescription(this.getDescription());
        info.setDisplayFormat(this.getDisplayFormat());
        info.setEntryCount(this.getEntryCount());
        info.setHasCashAccount(this.isHasCashAccount());
        info.setHasEffected(this.isHasEffected());
        info.setLastUpdateTime(null);
        info.setVoucherType(this.getVoucherType());
        info.setVoucherTypeDetail(this.getVoucherTypeDetail());
        PcVoucherEntryCollection entries = this.transferEntry(this.getEntries());
        info.setEntries(entries);
        if (entries != null && entries.size() > 0) {
            BigDecimal lcCreAmount = Constants.ZERO;
            BigDecimal loDebAmount = Constants.ZERO;
            BigDecimal rcCreAmount = Constants.ZERO;
            BigDecimal roDebAmount = Constants.ZERO;
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                PcVoucherEntryInfo entryInfo = entries.get(i);
                if (entryInfo.getLocalAmount() == null || entryInfo.getEntryDC() == null) continue;
                if (entryInfo.getEntryDC().getValue() == 0) {
                    lcCreAmount = lcCreAmount.add(entryInfo.getLocalAmount());
                    rcCreAmount = rcCreAmount.add(entryInfo.getReportingAmount());
                    continue;
                }
                loDebAmount = loDebAmount.add(entryInfo.getLocalAmount());
                roDebAmount = roDebAmount.add(entryInfo.getReportingAmount());
            }
            info.setLocalCreditAmount(lcCreAmount);
            info.setLocalDebitAmount(loDebAmount);
            info.setReportingCreditAmount(rcCreAmount);
            info.setReportingDebitAmount(roDebAmount);
        } else {
            info.setLocalCreditAmount(this.getLocalCreditAmount());
            info.setLocalDebitAmount(this.getLocalDebitAmount());
            info.setReportingCreditAmount(this.getReportingCreditAmount());
            info.setReportingDebitAmount(this.getReportingDebitAmount());
        }
        info.setEntryCount(this.getEntryCount());
        info.setCashflowFlag(this.getCashflowFlag());
        PcCashflowRecordCollection tcr = this.transferCashflow(this.getCashflowRecords(), info);
        info.setCashflowRecords(tcr);
        return info;
    }

    public PcVoucherEntryCollection transferEntry(TemplatePcVoucherEntryCollection entry) {
        PcVoucherEntryCollection entryCol = new PcVoucherEntryCollection();
        if (entry != null && entry.size() > 0) {
            int count = entry.size();
            for (int i = 0; i < count; ++i) {
                TemplatePcVoucherEntryInfo entryInfo = entry.get(i);
                PcVoucherEntryInfo info = this.transferEntry(entryInfo);
                entryCol.add(info);
            }
        }
        return entryCol;
    }

    public PcVoucherEntryInfo transferEntry(TemplatePcVoucherEntryInfo entry) {
        PcVoucherEntryInfo info = null;
        if (this.get("isWeb") == null) {
            try {
                info = PcVoucherEntryAgent.create();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (info == null) {
            info = new PcVoucherEntryInfo();
        }
        info.setAccount(entry.getAccount());
        PcVoucherAssistRecordCollection tvar = this.transferAsst(entry.getAssistRecords());
        info.setAssistRecords(tvar);
        info.setCurrency(entry.getCurrency());
        info.setDescription(entry.getDescription());
        info.setDisplayFormat(entry.getDisplayFormat());
        info.setEntryDC(entry.getEntryDC());
        info.setMeasureUnit(entry.getMeasureUnit());
        if (entry.getAccount() != null && entry.getAccount().getCAA() != null && tvar != null) {
            BigDecimal orAmount = Constants.ZERO;
            BigDecimal loAmount = Constants.ZERO;
            BigDecimal reAmount = Constants.ZERO;
            int count = tvar.size();
            for (int i = 0; i < count; ++i) {
                PcVoucherAssistRecordInfo asstInfo = tvar.get(i);
                if (asstInfo.getOriginalAmount() != null) {
                    orAmount = orAmount.add(asstInfo.getOriginalAmount());
                }
                if (asstInfo.getLocalAmount() != null) {
                    loAmount = loAmount.add(asstInfo.getLocalAmount());
                }
                if (asstInfo.getReportingAmount() == null) continue;
                reAmount = reAmount.add(asstInfo.getReportingAmount());
            }
            info.setOriginalAmount(orAmount);
            info.setLocalAmount(loAmount);
            info.setReportingAmount(reAmount);
        } else {
            info.setOriginalAmount(entry.getOriginalAmount());
            info.setLocalAmount(entry.getLocalAmount());
            info.setReportingAmount(entry.getReportingAmount());
        }
        info.setLocalExchangeRate(entry.getLocalExchangeRate());
        info.setReportingExchangeRate(entry.getReportingExchangeRate());
        info.setPrice(entry.getPrice());
        info.setQuantity(entry.getQuantity());
        info.setStandardQuantity(entry.getStandardQuantity());
        info.setSeq(entry.getSeq());
        info.setOprStatus(1);
        return info;
    }

    public PcVoucherAssistRecordCollection transferAsst(TemplatePcVoucherAsstRecordCollection asstCol) {
        PcVoucherAssistRecordCollection asst = new PcVoucherAssistRecordCollection();
        if (asst != null && asstCol.size() > 0) {
            int count = asstCol.size();
            for (int i = 0; i < count; ++i) {
                TemplatePcVoucherAsstRecordInfo asstInfo = asstCol.get(i);
                PcVoucherAssistRecordInfo info = this.transferAsst(asstInfo);
                asst.add(info);
            }
        }
        return asst;
    }

    public PcVoucherAssistRecordInfo transferAsst(TemplatePcVoucherAsstRecordInfo asstInfo) {
        PcVoucherAssistRecordInfo info = null;
        if (this.get("isWeb") == null) {
            try {
                info = PcVoucherAssistRecordAgent.create();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (info == null) {
            info = new PcVoucherAssistRecordInfo();
        }
        info.setAssGrp(asstInfo.getAssGrp());
        info.setBizDate(new Date());
        info.setEndDate(new Date());
        info.setDescription(asstInfo.getDescription());
        info.setIsFullProp(asstInfo.isIsFullProp());
        info.setLocalAmount(asstInfo.getLocalAmount());
        info.setOriginalAmount(asstInfo.getOriginalAmount());
        info.setReportingAmount(asstInfo.getReportingAmount());
        info.setQuantity(asstInfo.getQuantity());
        info.setSeq(asstInfo.getSeq());
        info.setStandardQuantity(asstInfo.getStandardQuantity());
        info.setPrice(asstInfo.getPrice());
        info.setMeasureUnit(asstInfo.getMeasureUnitID());
        info.setBizNumber(asstInfo.getBizNumber());
        info.setSettlementCode(asstInfo.getSettlementCode());
        info.setTicketNumber(asstInfo.getTicketNumber());
        info.setInvoiceNumber(asstInfo.getInvoiceNumber());
        info.setFeeType(asstInfo.getFeeType());
        info.setSettlementType(asstInfo.getSettlementType());
        info.setCustomer(asstInfo.getCustomer());
        info.setSupplier(asstInfo.getSupplier());
        info.setOrgUnit(asstInfo.getOrgUnit());
        info.setMaterial(asstInfo.getMaterial());
        info.setHandler(asstInfo.getHandler());
        info.setOprStatus(1);
        return info;
    }

    public PcCashflowRecordCollection transferCashflow(TemplatePcCashflowRecordCollection cashflow, PcVoucherInfo tempInfo) {
        if (cashflow == null) {
            return null;
        }
        HashMap<String, PcVoucherEntryInfo> enMap = new HashMap<String, PcVoucherEntryInfo>();
        PcVoucherEntryCollection entries = tempInfo.getEntries();
        if (entries != null && entries.size() > 0) {
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                PcVoucherEntryInfo info = entries.get(i);
                enMap.put(String.valueOf(info.getSeq()), info);
            }
            tempInfo.setEntriesMap(enMap);
        }
        PcCashflowRecordCollection col = new PcCashflowRecordCollection();
        if (cashflow != null && cashflow.size() > 0) {
            int count = cashflow.size();
            for (int i = 0; i < count; ++i) {
                TemplatePcCashflowRecordInfo cashflowInfo = cashflow.get(i);
                PcCashflowRecordInfo info = this.transferCashflow(cashflowInfo, tempInfo);
                col.add(info);
            }
            tempInfo.setCashflowFetched(this.getCashflowFetched());
        }
        return col;
    }

    public PcCashflowRecordInfo transferCashflow(TemplatePcCashflowRecordInfo cashflow, PcVoucherInfo tempInfo) {
        PcCashflowRecordInfo info = new PcCashflowRecordInfo();
        Map entriesMap = tempInfo.getEntriesMap();
        String seq = String.valueOf(cashflow.getEntry().getSeq());
        PcVoucherEntryInfo entryInfo = (PcVoucherEntryInfo)entriesMap.get(seq);
        String oppseq = String.valueOf(cashflow.getOpposingAccountEntry().getSeq());
        PcVoucherEntryInfo oppEntryInfo = (PcVoucherEntryInfo)entriesMap.get(oppseq);
        info.setEntry(entryInfo);
        info.setOpposingAccountEntry(oppEntryInfo);
        info.setAccount(entryInfo.getAccount());
        info.setCurrency(entryInfo.getCurrency());
        info.setEntryDC(entryInfo.getEntryDC());
        info.setOppAccount(oppEntryInfo.getAccount());
        info.setOppEntryDC(oppEntryInfo.getEntryDC());
        info.setCreateTime(cashflow.getCreateTime());
        info.setCreator(cashflow.getCreator());
        info.setCU(cashflow.getCU());
        info.setDisplayFormat(cashflow.getDisplayFormat());
        info.setLastUpdateTime(cashflow.getLastUpdateTime());
        info.setLastUpdateUser(cashflow.getLastUpdateUser());
        info.setLocalAmount(cashflow.getLocalAmount());
        info.setOriginalAmount(cashflow.getOriginalAmount());
        info.setPrimaryItem(cashflow.getPrimaryItem());
        info.setPrimaryCoefficient(cashflow.getPrimaryCoefficient());
        info.setReportingAmount(cashflow.getReportingAmount());
        info.setSupplementaryItem(cashflow.getSupplementaryItem());
        info.setSupplementaryCoefficient(cashflow.getSupplementaryCoefficient());
        info.setSeq(cashflow.getSeq());
        info.setVoucher(tempInfo);
        info.setItemFlag(cashflow.getItemFlag() != null ? cashflow.getItemFlag() : ItemFlag.PRIMARY);
        return info;
    }

    public Map getEntriesMap() {
        return (Map)this.get("entriesMap");
    }

    public void setEntriesMap(Map entriesMap) {
        this.put("entriesMap", entriesMap);
    }

    public String getBizOrgPropertyName() {
        return "profitCenter";
    }
}

