/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.scmcommon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.scmcommon.MAException;
import com.kingdee.eas.ma.scmcommon.app.AbstractTaskProgressFacadeControllerBean;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.ma.scmcommon.tools.Utils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaskProgressFacadeControllerBean
extends AbstractTaskProgressFacadeControllerBean {
    private static final long serialVersionUID = -8137229779626623375L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.scmcommon.app.TaskProgressFacadeControllerBean");
    private static final String TABLE_BOSTYPE = "39F80B34";
    private static final String resClassName = "com.kingdee.eas.ma.scmcommon.MAResource";
    private static final String ABORT_MSG = new MAException(MAException.TASK_ABORT).getMessage();
    private static final int P_MAX_TASKS = 10;

    @Override
    protected String _createTask(Context ctx, Map params) throws BOSException, EASBizException {
        IRowSet rs;
        String catalog = (String)params.get("catalog");
        String parentId = (String)params.get("parentId");
        String orgId = (String)params.get("orgId");
        String remark = (String)params.get("Remark");
        String seqParam = (String)params.get("seq");
        if (catalog == null) {
            throw new MAException(MAException.CATALOGISNULL);
        }
        int seq = 0;
        if (seqParam != null) {
            seq = Integer.parseInt(seqParam);
        }
        String creatorId = ctx.getCaller().toString();
        String sql = null;
        Object[] sqlparams = null;
        if (parentId == null) {
            sql = "select count(*) taskcount from T_MAS_Progress where FParentID is null and FCreatorID = ? and FCatalog = ?  and FStatus = 1 ";
            sqlparams = new Object[]{creatorId, catalog};
            rs = SQLUtils.executeQuery(ctx, sql, sqlparams);
            int taskCount = 0;
            try {
                if (rs.next()) {
                    taskCount = rs.getInt("taskcount");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (taskCount >= 1) {
                throw new MAException(MAException.ONLYONE);
            }
            sql = "select count(*) taskcount from T_MAS_Progress where FParentID is null and FCatalog = ? and FStatus = 1 ";
            sqlparams = new Object[]{catalog};
            rs = SQLUtils.executeQuery(ctx, sql, sqlparams);
            taskCount = 0;
            try {
                if (rs.next()) {
                    taskCount = rs.getInt("taskcount");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (taskCount > 10) {
                throw new MAException(MAException.TASK_OVER);
            }
        } else {
            sql = "select FStatus from T_MAS_Progress where FID = ? ";
            sqlparams = new Object[]{parentId};
            rs = SQLUtils.executeQuery(ctx, sql, sqlparams);
            int status = -1;
            try {
                if (rs.next()) {
                    status = rs.getInt("FStatus");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (status == -1) {
                throw new MAException(MAException.TASK_ISNOTEXISTED);
            }
            if (status != 1) {
                throw new MAException(MAException.PARENT_TASK_ABORT);
            }
        }
        sql = "insert into T_MAS_Progress (FID,FCreatorID,FCatalog,FTaskSeq,FParentID,FComplete,FStartTime,FRemark,FOrgId) values (?,?,?,?,?,0,now(),?,?) ";
        String taskID = BOSUuid.create((String)TABLE_BOSTYPE).toString();
        sqlparams = new Object[]{taskID, creatorId, catalog, seq, parentId, remark, orgId};
        SQLUtils.execute(ctx, sql, sqlparams);
        return taskID;
    }

    @Override
    protected Map _batchCreateTask(Context ctx, Map params) throws BOSException, EASBizException {
        String catalog = (String)params.get("catalog");
        List rows = (List)params.get("rows");
        Map result = this.batchCreateTask(ctx, params, catalog, rows);
        return result;
    }

    private Map batchCreateTask(Context ctx, Map params, String catalog, List rows) throws BOSException, EASBizException {
        Map result = this.checkTaskMutex(ctx, params);
        if (rows.size() == 0) {
            return result;
        }
        HashMap<String, String> taskParams = new HashMap<String, String>();
        taskParams.put("catalog", catalog);
        String parenttaskid = this.createTask(ctx, taskParams);
        ArrayList tasklist = new ArrayList();
        HashMap task = null;
        Map row = null;
        String taskid = null;
        taskParams.put("parentId", parenttaskid);
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            row = (Map)rows.get(i);
            task = new HashMap();
            taskParams.put("seq", i + "");
            taskParams.put("orgId", (String)row.get("orgId"));
            taskParams.put("Remark", (String)row.get("rowid"));
            taskid = this.createTask(ctx, taskParams);
            task.put("rowid", row.get("rowid"));
            task.put("orgid", row.get("orgId"));
            task.put("taskid", taskid);
            tasklist.add(task);
        }
        result.put("parenttaskid", parenttaskid);
        result.put("tasklist", tasklist);
        return result;
    }

    private void removeRows(List rows, String key, String value) {
        Map row = null;
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            row = (Map)rows.get(i);
            if (!row.get(key).equals(value)) continue;
            rows.remove(i);
            break;
        }
    }

    private synchronized Map checkTaskMutex(Context ctx, Map params) throws BOSException, EASBizException {
        String catalog = (String)params.get("catalog");
        List rows = (List)params.get("rows");
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        StringBuffer sqlStr = new StringBuffer();
        int errorCount = 0;
        if (Utils.taskMutex.contains(catalog)) {
            sqlStr.append(" select count(FOrgId) count  from T_MAS_Progress a");
            sqlStr.append(" where a.FParentID is not null  and a.FStatus = 1 ");
            sqlStr.append(" and a.FCatalog in (" + Utils.ListToString(Utils.taskMutex, null) + ") ");
            sqlStr.append(" and a.FOrgId  in (" + Utils.ListToString(rows, "orgId") + ") ");
            sqlStr.append(" and exists(select 1 from T_MAS_Progress b where a.FParentID =b.fid and b.FStatus =1)");
            sqlStr.append(" group by FOrgId ");
            IRowSet rs = SQLUtils.executeQuery(ctx, sqlStr.toString());
            try {
                if (rs.next()) {
                    errorCount = rs.getInt("count");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (errorCount >= 1) {
                sqlStr.setLength(0);
                sqlStr.append("select FOrgId,FCatalog from T_MAS_Progress ");
                sqlStr.append("where FParentID is not null  and FStatus = 1 ");
                sqlStr.append("and FCatalog in (" + Utils.ListToString(Utils.taskMutex, null) + ") ");
                sqlStr.append("and FOrgId  in (" + Utils.ListToString(rows, "orgId") + ") ");
                try {
                    String FOrgId = null;
                    String FCatalog = null;
                    String errorString = null;
                    HashMap<String, String> error = new HashMap<String, String>();
                    rs = SQLUtils.executeQuery(ctx, sqlStr.toString());
                    while (rs.next()) {
                        FOrgId = rs.getString("FOrgId");
                        FCatalog = rs.getString("FCatalog");
                        if (FCatalog.equals(catalog)) {
                            errorString = new MAException(MAException.ONLYONEORG).getMessage();
                        } else {
                            String taskName = ResourceBase.getString((String)resClassName, (String)Utils.taskNameMap.get(FCatalog), (Locale)ctx.getLocale());
                            errorString = new MAException(MAException.ONLYONECATALOG, new Object[]{taskName}).getMessage();
                        }
                        error.put(FOrgId, errorString);
                        this.removeRows(rows, "orgId", FOrgId);
                    }
                    result.put("ERROR_MSG", error);
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        result.put("ERROR_COUNT", Integer.valueOf(errorCount));
        return result;
    }

    @Override
    protected Map _getProgress(Context ctx, String taskID) throws BOSException, EASBizException {
        String sql = "select FID,FDescription,FComplete,FStartTime,FCompleteTime,FCatalog,FTaskSeq,FParentID,FRemark,FStatus from T_MAS_Progress where FId = ? ";
        Object[] params = new Object[]{taskID};
        IRowSet rs = SQLUtils.executeQuery(ctx, sql, params);
        Map retMap = null;
        try {
            if (rs.next()) {
                retMap = this.rs2Map(rs);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return retMap;
    }

    @Override
    protected void _updateProgress(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer("update T_MAS_Progress set FCompleteTime = now() ");
        if (params.containsKey("Complete")) {
            sqlBuf.append(",FComplete = ").append(params.get("Complete"));
        }
        if (params.containsKey("Description")) {
            sqlBuf.append(",FDescription = '").append(params.get("Description")).append("'");
        }
        if (params.containsKey("Remark")) {
            sqlBuf.append(",FRemark = '").append(params.get("Remark")).append("'");
        }
        if (params.containsKey("Status")) {
            sqlBuf.append(",FStatus = ").append(params.get("Status"));
        }
        sqlBuf.append(" where FId = '").append(params.get("TaskID")).append("'");
        SQLUtils.execute(ctx, sqlBuf.toString());
    }

    @Override
    protected List _getSubTaskProgress(Context ctx, String parentTaskId) throws BOSException, EASBizException {
        String sql = "select FId,FDescription,FComplete,FStartTime,FCompleteTime,FCatalog,FTaskSeq,FParentID,FRemark,FStatus from T_MAS_Progress where FParentID = ? ";
        Object[] params = new Object[]{parentTaskId};
        IRowSet rs = SQLUtils.executeQuery(ctx, sql, params);
        ArrayList<Map> retList = new ArrayList<Map>();
        try {
            Map retMap = null;
            while (rs.next()) {
                retMap = this.rs2Map(rs);
                retList.add(retMap);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return retList;
    }

    private Map rs2Map(IRowSet rs) throws SQLException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("ID", rs.getString("FID"));
        retMap.put("Complete", rs.getInt("FComplete"));
        retMap.put("Description", rs.getString("FDescription"));
        retMap.put("StartTime", rs.getTimestamp("FStartTime"));
        retMap.put("CompleteTime", rs.getTimestamp("FCompleteTime"));
        retMap.put("Seq", rs.getInt("FTaskSeq"));
        retMap.put("Status", rs.getInt("FStatus"));
        retMap.put("Catalog", rs.getString("FCatalog"));
        retMap.put("ParentID", rs.getString("FParentID"));
        retMap.put("Remark", rs.getString("FRemark"));
        return retMap;
    }

    @Override
    protected String _getDoingTask(Context ctx, String userID, String taskCatalog) throws BOSException, EASBizException {
        String sql = "select FID from T_MAS_Progress where FParentID is null and FCreatorID = ? and FCatalog = ? and FStatus = 1 ";
        Object[] sqlparams = new Object[]{userID, taskCatalog};
        IRowSet rs = SQLUtils.executeQuery(ctx, sql, sqlparams);
        String taskId = null;
        try {
            if (rs.next()) {
                taskId = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return taskId;
    }

    @Override
    protected void _abortTask(Context ctx, String taskID) throws BOSException, EASBizException {
        String sql = "update T_MAS_Progress set FCompleteTime = now(), FDescription = '" + ABORT_MSG + "',FStatus = 3 ";
        Object[] sqlparams = new Object[]{taskID};
        SQLUtils.execute(ctx, sql + "where FID in ( ? ) ", sqlparams);
        String whereSql = "where FId IN (select FID from T_MAS_Progress where FParentID in ( ? ) and FStatus = 3) ";
        sqlparams = new Object[]{taskID};
        SQLUtils.execute(ctx, sql + whereSql, sqlparams);
    }

    @Override
    protected List _getSubTask(Context ctx, String parentId, String catalog) throws BOSException, EASBizException {
        String sql = "select FId,FDescription,FComplete,FStartTime,FCompleteTime,FCatalog,FTaskSeq,FParentID,FRemark,FStatus from T_MAS_Progress where FParentID = ? and FCatalog in ( ? )";
        Object[] sqlparams = new Object[]{parentId, catalog};
        IRowSet rs = SQLUtils.executeQuery(ctx, sql, sqlparams);
        ArrayList<Map> retList = new ArrayList<Map>();
        try {
            Map retMap = null;
            while (rs.next()) {
                retMap = this.rs2Map(rs);
                retList.add(retMap);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return retList;
    }

    @Override
    protected Map _getDoingTaskNew(Context ctx, String userID, String taskCatalog) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FCatalog from T_MAS_Progress ");
        sql.append("where FParentID is null and FCreatorID = ? ");
        sql.append("and FCatalog in (").append(taskCatalog).append(") and FStatus = 1 ");
        Object[] sqlparams = new Object[]{userID};
        IRowSet rs = SQLUtils.executeQuery(ctx, sql.toString(), sqlparams);
        String taskid = null;
        String catalog = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (rs.next()) {
                taskid = rs.getString("FID");
                catalog = rs.getString("FCatalog");
                map.put("taskid", taskid);
                map.put("catalog", catalog);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    @Override
    protected void _updateSubTaskProgress(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer("update T_MAS_Progress set FCompleteTime = now() ");
        if (params.containsKey("Complete")) {
            sqlBuf.append(",FComplete = ").append(params.get("Complete"));
        }
        if (params.containsKey("Description")) {
            sqlBuf.append(",FDescription = '").append(params.get("Description")).append("'");
        }
        if (params.containsKey("Remark")) {
            sqlBuf.append(",FRemark = '").append(params.get("Remark")).append("'");
        }
        if (params.containsKey("Status")) {
            sqlBuf.append(",FStatus = ").append(params.get("Status"));
        }
        sqlBuf.append(" where FparentId = '").append(params.get("TaskID")).append("'");
        SQLUtils.execute(ctx, sqlBuf.toString());
    }
}

