/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.scmcommon.app.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.scmcommon.TaskProgressFacadeFactory;
import com.kingdee.eas.ma.scmcommon.app.thread.SyncLock;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class SyncTask
implements Runnable {
    private static Logger logger = Logger.getLogger(SyncTask.class);
    private SyncLock lock;
    private String lockType;
    private Object inParam;
    private String taskid;
    private Context ctx;

    public String getTaskid() {
        return this.taskid;
    }

    public SyncTask(Context ctx, String taskid, SyncLock lock, String lockType, Object inParam) {
        this.ctx = ctx;
        this.taskid = taskid;
        this.lock = lock;
        this.lockType = lockType;
        this.inParam = inParam;
    }

    public void releaseLock() {
        this.lock.releaseLock(this.lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            logger.error((Object)"\u6267\u884c\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("TaskID", this.taskid);
            updateMap.put("Status", -1);
            updateMap.put("Complete", 100);
            updateMap.put("Description", "\u6267\u884c\u4efb\u52a1\u5931\u8d25");
            try {
                TaskProgressFacadeFactory.getLocalInstance(this.ctx).updateProgress(updateMap);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private void execute() throws BOSException, EASBizException {
        this.doing(this.inParam);
    }

    protected abstract Object doing(Object var1) throws BOSException, EASBizException;
}

