/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormEntryInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.view.AbstractBgRollImpl;
import com.kingdee.eas.ma.view.BgRollHelper;
import com.kingdee.eas.ma.view.BgRollRuleInfo;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgFixedRollImpl
extends AbstractBgRollImpl {
    private Set<String> historyPeriodNumberSet = new HashSet<String>();
    private Set<String> currPeriodNumberSet = new HashSet<String>();
    private Set<String> laterHistoryPeriodNumberSet = new HashSet<String>();
    private Set<String> yearPeriodNumberSet = new HashSet<String>();

    public BgFixedRollImpl() {
    }

    public BgFixedRollImpl(IBgDimensionManager dimensionManager, BgFormInfo bgFormInfo) {
        this(dimensionManager, null, bgFormInfo);
    }

    public BgFixedRollImpl(BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        this(BgRollHelper.loadFormEntry(bgFormInfo), bgFormInfo);
    }

    public BgFixedRollImpl(Set<String> displayAllPeriodNum, BgFormInfo bgFormInfo) {
        this(null, displayAllPeriodNum, bgFormInfo);
    }

    public BgFixedRollImpl(IBgDimensionManager dimensionManager, Set<String> displayAllPeriodNum, BgFormInfo bgFormInfo) {
        HashSet<String> allPeriodNumSet = new HashSet<String>();
        if (displayAllPeriodNum == null) {
            if (dimensionManager == null) {
                return;
            }
            List allListDimension = dimensionManager.getDimension();
            for (int i = 0; i < allListDimension.size(); ++i) {
                BgDimensionInfo bgDimensionInfo = (BgDimensionInfo)allListDimension.get(i);
                if (!bgDimensionInfo.getType().equalsIgnoreCase("BGPERIOD")) continue;
                for (Object o : bgDimensionInfo.getMember()) {
                    allPeriodNumSet.add(((BgDimensionMember)o).getNumber());
                }
                break;
            }
        } else {
            allPeriodNumSet.addAll(displayAllPeriodNum);
        }
        this.setHasRoll(BgViewHelper.checkHasRoll(bgFormInfo));
        this.setOrgIds(bgFormInfo.getOrgUnit().getId().toString());
        this.setBgFormId(bgFormInfo.getId().toString());
        this.setFormState(bgFormInfo.getState());
        this.partitionPeriod(allPeriodNumSet, bgFormInfo);
    }

    @Override
    public String getPeriodFromRSTmp(BgRollRuleInfo rollRuleInfo) {
        String value = "";
        BgPeriodEnum peroidType = rollRuleInfo.getRollType();
        int fixedLength = rollRuleInfo.getFixedLength();
        value = value + "N!Y|";
        for (int i = 1; i <= fixedLength; ++i) {
            value = value + BgNPeriodHelper.getOffsetBgPeriodNumberForViewTmp((int)peroidType.getValue(), (int)1999, (int)i);
            if (i == fixedLength) continue;
            value = value + "|";
        }
        value = value.replace("1999Y", "N!Y");
        return value;
    }

    @Override
    public void partitionPeriod(Set<String> displayAllPeriodNum, BgFormInfo bgFormInfo) {
        this.getHistoryPeriodNumberSet().clear();
        this.getCurrPeriodNumberSet().clear();
        this.getLaterHistoryPeriodNumberSet().clear();
        BgPeriodInfo bgPeriod = null;
        String bgPeriodNum = null;
        BgPeriodInfo bgRollPeriod = null;
        String bgRollPeriodNum = null;
        String currPeriodNum = null;
        bgPeriod = bgFormInfo.getBgPeriod();
        bgRollPeriod = bgFormInfo.getBgRollPeriod();
        bgPeriodNum = bgPeriod.getNumber();
        bgRollPeriodNum = bgRollPeriod.getNumber();
        int periodType = bgFormInfo.getEntries().get(0).getRollType().getValue();
        if (4 == periodType) {
            currPeriodNum = bgPeriodNum + ".01M";
        } else if (3 == periodType) {
            currPeriodNum = bgPeriodNum + ".01Q";
        } else if (9 == periodType) {
            currPeriodNum = bgPeriodNum + ".01M.01TD";
        } else {
            return;
        }
        if (this.isHasRoll()) {
            this.getYearPeriodNumberSet().add(bgPeriodNum);
            displayAllPeriodNum.remove(bgPeriodNum);
            while (!currPeriodNum.equalsIgnoreCase(bgRollPeriodNum)) {
                this.getHistoryPeriodNumberSet().add(currPeriodNum);
                displayAllPeriodNum.remove(currPeriodNum);
                currPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currPeriodNum, (int)1);
            }
            for (int j = 0; j < bgFormInfo.getEntries().get(0).getRollLength(); ++j) {
                if (!displayAllPeriodNum.contains(currPeriodNum)) continue;
                this.getCurrPeriodNumberSet().add(currPeriodNum);
                displayAllPeriodNum.remove(currPeriodNum);
                currPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currPeriodNum, (int)1);
            }
            this.getLaterHistoryPeriodNumberSet().addAll(displayAllPeriodNum);
        } else {
            this.getYearPeriodNumberSet().add(bgPeriodNum);
            displayAllPeriodNum.remove(bgPeriodNum);
            this.getCurrPeriodNumberSet().addAll(displayAllPeriodNum);
        }
    }

    @Override
    public void diffDisplayPeriod(Map<String, Set> lockActualPeriodNum, Map<String, Set> lockBudgetPeriodNum, Map<String, Set> adjustCoverPeriodNum) {
        this.addToSet(lockActualPeriodNum, this.orgIds, this.getHistoryPeriodNumberSet());
        this.addToSet(adjustCoverPeriodNum, this.orgIds, this.getCurrPeriodNumberSet());
        this.addToSet(lockBudgetPeriodNum, this.orgIds, this.getLaterHistoryPeriodNumberSet());
    }

    @Override
    public void pickAdjustFormula(Map _formulaMap, Map resultMap) {
        Map map = null;
        map = resultMap.get(this.orgIds) != null ? (Map)resultMap.get(this.orgIds) : new HashMap();
        HashSet<String> adjustCoverPeriodNum = new HashSet<String>();
        adjustCoverPeriodNum.addAll(this.getCurrPeriodNumberSet());
        adjustCoverPeriodNum.addAll(this.getYearPeriodNumberSet());
        Map formulaMap = null;
        String formulaStr = null;
        formulaMap = (Map)_formulaMap.get(this.orgIds);
        if (formulaMap == null || formulaMap.size() <= 0) {
            return;
        }
        for (Object oo : formulaMap.keySet()) {
            formulaStr = (String)oo;
            if (!adjustCoverPeriodNum.contains(BgRollHelper.getPeriodNum(formulaStr))) continue;
            map.put(formulaStr, null);
        }
        if (map.size() > 0) {
            resultMap.put(this.orgIds, map);
        }
    }

    @Override
    public Set<String> getLegalPeriodSet() {
        HashSet<String> legalPeriodNumSet = new HashSet<String>();
        legalPeriodNumSet.addAll(this.getYearPeriodNumberSet());
        legalPeriodNumSet.addAll(this.getCurrPeriodNumberSet());
        return legalPeriodNumSet;
    }

    @Override
    public List getNewRollPeriod(BgFormEntryInfo entry, String rollPeriodNum, List curPeriodNum) {
        ArrayList<String> newPeriodNum = new ArrayList<String>();
        newPeriodNum.addAll(curPeriodNum);
        String newLastPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)rollPeriodNum, (int)(entry.getRollStep() + entry.getRollLength() - 1));
        boolean find = false;
        for (int i = 0; i < curPeriodNum.size(); ++i) {
            if (!newLastPeriodNum.equalsIgnoreCase(curPeriodNum.get(i).toString())) continue;
            find = true;
            break;
        }
        if (!find) {
            String lastPeriodNum = (String)curPeriodNum.get(curPeriodNum.size() - 1);
            while (!newLastPeriodNum.equalsIgnoreCase(lastPeriodNum)) {
                lastPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)lastPeriodNum, (int)1);
                newPeriodNum.add(lastPeriodNum);
            }
        }
        return newPeriodNum;
    }

    @Override
    public int getRollMethod() {
        return 2;
    }

    public Set<String> getHistoryPeriodNumberSet() {
        return this.historyPeriodNumberSet;
    }

    public Set<String> getCurrPeriodNumberSet() {
        return this.currPeriodNumberSet;
    }

    public Set<String> getLaterHistoryPeriodNumberSet() {
        return this.laterHistoryPeriodNumberSet;
    }

    public Set<String> getYearPeriodNumberSet() {
        return this.yearPeriodNumberSet;
    }
}

