/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.view.BgBillIntegrateCommonException;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFactory;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.app.AbstractBgBillIntegrateSchemeControllerBean;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgBillIntegrateSchemeControllerBean
extends AbstractBgBillIntegrateSchemeControllerBean {
    private static final long serialVersionUID = 8202430311794894969L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.view.app.BgBillIntegrateSchemeControllerBean");

    @Override
    protected void _setSchemeState(Context ctx, String id, boolean isValid) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        BgBillIntegrateSchemeInfo scheme = BgBillIntegrateSchemeFactory.getLocalInstance(ctx).getBgBillIntegrateSchemeInfo((IObjectPK)new ObjectStringPK(id), this.getSelector());
        if (scheme == null) {
            return;
        }
        BgBillIntegrateCommonHelper.applyMutexService(ctx, id, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            if (isValid) {
                if (scheme.isState()) {
                    throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.HASBEENABLE, new Object[]{scheme.getNumber()});
                }
                pstmt = conn.prepareStatement("select fnumber from t_bg_bgbillintegratescheme where fstate = 1 and fboname = ?");
                pstmt.setString(1, scheme.getBoName());
                res = pstmt.executeQuery();
                if (res.next()) {
                    String number = res.getString("fnumber");
                    throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.HASENABLESCHEME, new Object[]{scheme.getSubSystemAlias(), scheme.getBoAlias(), number});
                }
                SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
            }
            pstmt = conn.prepareStatement("update t_bg_bgbillintegratescheme set  fstate = ? where fid = ?");
            pstmt.setBoolean(1, isValid);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"_setValidState", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                BgBillIntegrateCommonHelper.releaseMutexService(ctx, id);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        BgBillIntegrateCommonHelper.releaseMutexService(ctx, id);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            String hasRefByBgFormSql = "select top 1 fid from T_BG_BgBillIntegrateForm where FSchemeId = ?";
            pstmt = conn.prepareStatement(hasRefByBgFormSql);
            pstmt.setString(1, pk.toString());
            res = pstmt.executeQuery();
            if (res.next()) {
                throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.HASBEREF);
            }
            String hasRefByBgViewDimSql = "select top 1 fid from T_BG_BgBillIntegrateTemplate where FSchemeId = ?";
            pstmt = conn.prepareStatement(hasRefByBgViewDimSql);
            pstmt.setString(1, pk.toString());
            res = pstmt.executeQuery();
            if (res.next()) {
                throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.HASBEREF);
            }
        }
        catch (EASBizException e) {
            try {
                logger.error((Object)"_canDelete", (Throwable)e);
                throw new CanNotDeleteException(e.getMessage());
                catch (BOSException e2) {
                    logger.error((Object)"_canDelete", (Throwable)e2);
                    throw new CanNotDeleteException((Throwable)e2);
                }
                catch (SQLException e3) {
                    logger.error((Object)"_canDelete", (Throwable)e3);
                    throw new CanNotDeleteException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        super._canDelete(ctx, pk, cn);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("state");
        sic.add("boName");
        sic.add("boAlias");
        sic.add("subSystemName");
        sic.add("subSystemAlias");
        return sic;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumDup(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumDup(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkNumDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgBillIntegrateSchemeInfo info = (BgBillIntegrateSchemeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }
}

