/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.IResultReader;
import com.kingdee.eas.ma.view.BgBillIntegrateCommonException;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeCollection;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFactory;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.common.AbstractBgBillIntegrate;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.ma.view.common.BgBillIntegrateData;
import com.kingdee.eas.ma.view.common.BgBillIntegrateDataInfo;
import com.kingdee.eas.ma.view.common.BgBillIntegrateParam;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.IBgBillIntegrateInterface;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgBillIntegrateServerHelper {
    private static Logger logger = Logger.getLogger((String)BgBillIntegrateServerHelper.class.getName());

    public static Map extractData(Context ctx, Map schemeMap, Map bgDataMap, Map orgMap) throws BOSException, EASBizException {
        if (ctx == null || schemeMap == null || bgDataMap == null) {
            return null;
        }
        Map bgPeriodMap = BgBillIntegrateServerHelper.getPeriodMap(ctx, bgDataMap);
        BgBillIntegrateSchemeCollection schemeCol = BgBillIntegrateServerHelper.queryScheme(ctx, schemeMap);
        if (schemeCol == null || schemeCol.isEmpty()) {
            return null;
        }
        ArrayList params = new ArrayList();
        for (int s = 0; s < schemeCol.size(); ++s) {
            ArrayList tempParams = new ArrayList();
            BgBillIntegrateSchemeInfo scheme = schemeCol.get(s);
            AbstractBgBillIntegrate.getInterface(scheme).checkBeforeExtract(ctx, scheme, bgPeriodMap, bgDataMap, orgMap);
            for (int r = 0; r < scheme.getRules().size(); ++r) {
                BgBillIntegrateRuleInfo rule = scheme.getRules().get(r);
                List temp = AbstractBgBillIntegrate.getInterface(scheme).extractData(ctx, scheme, rule, bgPeriodMap, bgDataMap, orgMap);
                if (temp == null || temp.isEmpty()) continue;
                tempParams.addAll(temp);
            }
            AbstractBgBillIntegrate.getInterface(scheme).checkAfterExtract(ctx, scheme, tempParams);
            if (tempParams.isEmpty()) continue;
            params.addAll(tempParams);
        }
        BgBillIntegrateServerHelper.fillOrgId(ctx, params, orgMap);
        BgBillIntegrateServerHelper.fillPeriodNumber(ctx, params);
        BgBillIntegrateServerHelper.fillBgItemInfo(ctx, params);
        return BgBillIntegrateServerHelper.fillToBgData(ctx, params, bgDataMap);
    }

    private static Map fillToBgData(Context ctx, List params, Map bgDataMap) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (ctx == null || params == null || params.isEmpty() || bgDataMap == null) {
            return result;
        }
        for (int i = 0; i < params.size(); ++i) {
            BgBillIntegrateParam param = (BgBillIntegrateParam)params.get(i);
            if (param == null || param.isEmpty()) continue;
            String formula = BgNFSHelper.getFormulaFromParam((String[])new String[]{param.bgItemNumber, param.bgPeriodNumber, param.bgElementNumber, param.currencyNumber});
            Map temBgDataMap = (Map)bgDataMap.get(param.orgId);
            if (temBgDataMap == null || !temBgDataMap.containsKey(formula)) continue;
            Map temMap = BgViewCommonHelper.getSubMap(result, param.orgId, true);
            temMap = BgViewCommonHelper.getSubMap(temMap, formula, true);
            BgBillIntegrateServerHelper.addValue(temMap, param);
        }
        return result;
    }

    private static void addValue(Map valueMap, BgBillIntegrateParam param) {
        if (valueMap != null && param != null && param.value != null) {
            if (!(valueMap.get(param.schemeId) instanceof BgBillIntegrateData)) {
                valueMap.put(param.schemeId, new BgBillIntegrateData());
            }
            BgBillIntegrateData data = (BgBillIntegrateData)valueMap.get(param.schemeId);
            data.add(param);
            data.value = data.value.add(param.value);
        }
    }

    private static void fillBgItemInfo(Context ctx, List params) throws BOSException {
        Set numbers;
        String orgId;
        BgBillIntegrateParam param;
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        HashMap org_numbers = new HashMap();
        boolean isBg063 = BgSHelper.isBgItemIsolate((Context)ctx);
        for (int p = 0; p < params.size(); ++p) {
            param = (BgBillIntegrateParam)params.get(p);
            orgId = BgViewCommonHelper.getOrgId(isBg063, param.orgId);
            if (org_numbers.containsKey(orgId)) {
                numbers = (Set)org_numbers.get(orgId);
            } else {
                numbers = new HashSet();
                org_numbers.put(orgId, numbers);
            }
            BgBillIntegrateCommonHelper.splitBgCombination(numbers, param.bgItemNumber);
        }
        Map org_bgItems = BgBillIntegrateServerHelper.queryBgItems(ctx, org_numbers);
        for (int p = params.size() - 1; p >= 0; --p) {
            param = (BgBillIntegrateParam)params.get(p);
            orgId = BgViewCommonHelper.getOrgId(isBg063, param.orgId);
            Map bgItems = (Map)org_bgItems.get(orgId);
            numbers = BgBillIntegrateCommonHelper.splitBgCombination(null, param.bgItemNumber);
            HashMap<Integer, BgItemInfo> refFields = new HashMap<Integer, BgItemInfo>();
            for (CharSequence number : numbers) {
                if (bgItems != null && bgItems.containsKey(number)) {
                    BgItemInfo bgItem = (BgItemInfo)bgItems.get(number);
                    refFields.put(new Integer(BgBillIntegrateCommonHelper.getBgItemRefField(bgItem)), bgItem);
                    continue;
                }
                refFields.clear();
                break;
            }
            if (!refFields.isEmpty()) {
                CharSequence number;
                Object[] refs = refFields.keySet().toArray();
                Arrays.sort(refs);
                number = new StringBuffer();
                for (int i = 0; i < refs.length; ++i) {
                    if (((StringBuffer)number).length() != 0) {
                        ((StringBuffer)number).append(",");
                    }
                    ((StringBuffer)number).append(((BgItemInfo)refFields.get(refs[i])).getNumber());
                }
                param.bgItemNumber = ((StringBuffer)number).toString();
                continue;
            }
            params.remove(p);
        }
    }

    protected static Map queryBgItems(Context ctx, Map org_numbers) throws BOSException {
        HashMap org_bgItems = new HashMap();
        if (ctx != null && org_numbers != null && !org_numbers.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid, fnumber, freffield from t_bg_bgitem where forgunitid = ? and fnumber in(");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet res = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(sql.toString());
                for (String orgId : org_numbers.keySet()) {
                    HashMap<String, BgItemInfo> bgItems = new HashMap<String, BgItemInfo>();
                    org_bgItems.put(orgId, bgItems);
                    Object[] params = ((Set)org_numbers.get(orgId)).toArray();
                    int loopCount = BgNSQLHelper.getBatchCount((int)params.length);
                    for (int i = 0; i < loopCount; ++i) {
                        pstmt.setString(1, orgId);
                        BgNSQLHelper.setParam4BatchDefCount((PreparedStatement)pstmt, (int)2, (int)i, (Object[])params);
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            BgItemInfo bgItem = new BgItemInfo();
                            bgItem.setId(BOSUuid.read((String)res.getString("fid")));
                            bgItem.setNumber(res.getString("fnumber"));
                            bgItem.setRefField(res.getString("freffield"));
                            bgItems.put(bgItem.getNumber(), bgItem);
                        }
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        }
        return org_bgItems;
    }

    protected static void fillPeriodNumber(Context ctx, List params) throws BOSException, EASBizException {
        block19: {
            BgPeriodInfo bgPeriod;
            BgPeriodCollection periodCol;
            Integer periodType2;
            BgBillIntegrateParam param;
            if (ctx == null || params == null || params.isEmpty()) {
                return;
            }
            HashMap periodMap = new HashMap();
            for (int i = 0; i < params.size(); ++i) {
                Set<Date> dates;
                param = (BgBillIntegrateParam)params.get(i);
                if (!StringUtils.isEmpty((String)param.bgPeriodNumber)) continue;
                periodType2 = new Integer(param.periodType);
                if (periodMap.containsKey(periodType2)) {
                    dates = (Set)periodMap.get(periodType2);
                } else {
                    dates = new HashSet();
                    periodMap.put(periodType2, dates);
                }
                dates.add(param.bizDate);
            }
            if (periodMap.isEmpty()) break block19;
            HashMap<Integer, BgPeriodCollection> periodInfos = new HashMap<Integer, BgPeriodCollection>();
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet res = null;
            Date now = new Date(System.currentTimeMillis());
            int batchCount = 15;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer sql = new StringBuffer();
                sql.append("select fid, fnumber, FBeginDate, FEndDate from T_BG_BgPeriod where FPeriodType = ? AND (");
                for (int i = 0; i < batchCount; ++i) {
                    if (i != 0) {
                        sql.append(" OR ");
                    }
                    sql.append("(FBeginDate <= ? AND FEndDate >= ?)");
                }
                sql.append(")");
                pstmt = conn.prepareStatement(sql.toString());
                for (Integer periodType2 : periodMap.keySet()) {
                    Object[] ds = ((Set)periodMap.get(periodType2)).toArray();
                    periodCol = new BgPeriodCollection();
                    periodInfos.put(periodType2, periodCol);
                    int loopCount = BgNSQLHelper.getBatchCount((int)ds.length, (int)batchCount);
                    for (int i = 0; i < loopCount; ++i) {
                        pstmt.setInt(1, periodType2);
                        for (int j = 0; j < batchCount; ++j) {
                            int index = i * batchCount + j;
                            Date d = null;
                            d = index >= ds.length ? now : new Date(((java.util.Date)ds[index]).getTime());
                            pstmt.setDate(j * 2 + 2, d);
                            pstmt.setDate(j * 2 + 3, d);
                        }
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            bgPeriod = new BgPeriodInfo();
                            bgPeriod.setId(BOSUuid.read((String)res.getString("fid")));
                            bgPeriod.setNumber(res.getString("fnumber"));
                            bgPeriod.setBeginDate((java.util.Date)res.getDate("FBeginDate"));
                            bgPeriod.setEndDate(BgBillIntegrateCommonHelper.setEndDate(res.getDate("FEndDate")));
                            periodCol.add(bgPeriod);
                        }
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
            for (int i = params.size() - 1; i >= 0; --i) {
                param = (BgBillIntegrateParam)params.get(i);
                if (!StringUtils.isEmpty((String)param.bgPeriodNumber)) continue;
                periodType2 = new Integer(param.periodType);
                periodCol = (BgPeriodCollection)periodInfos.get(periodType2);
                if (periodCol != null && !periodCol.isEmpty()) {
                    for (int c = 0; c < periodCol.size(); ++c) {
                        bgPeriod = periodCol.get(c);
                        if (param.bizDate.before(bgPeriod.getBeginDate()) || param.bizDate.after(bgPeriod.getEndDate())) continue;
                        if (8 == periodType2) {
                            if (!StringUtils.isEmpty((String)param.bgPeriodNumber)) {
                                logger.error((Object)("fillPeriod Error(bgPeriodRepeat):" + param.bizDate + "(" + periodType2 + ")"));
                                param.bgPeriodNumber = null;
                                break;
                            }
                            param.bgPeriodNumber = bgPeriod.getNumber();
                            continue;
                        }
                        param.bgPeriodNumber = bgPeriod.getNumber();
                        break;
                    }
                }
                if (param.bgPeriodNumber != null) continue;
                params.remove(i);
            }
        }
    }

    protected static void fillOrgId(Context ctx, List params, Map orgMap) throws BOSException, EASBizException {
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        if (orgMap == null) {
            params.clear();
        }
        for (int i = params.size() - 1; i >= 0; --i) {
            BgBillIntegrateParam param = (BgBillIntegrateParam)params.get(i);
            if (orgMap.containsKey(param.orgNumber)) {
                param.orgId = ((OrgUnitInfo)orgMap.get(param.orgNumber)).getId().toString();
                continue;
            }
            params.remove(i);
        }
    }

    private static Map getPeriodMap(Context ctx, Map bgDataMap) throws BOSException {
        HashMap<Integer, Timestamp[]> result = new HashMap<Integer, Timestamp[]>();
        if (bgDataMap == null || bgDataMap.isEmpty()) {
            return result;
        }
        HashSet<String> periodNumbers = new HashSet<String>();
        for (Map subMap : bgDataMap.values()) {
            if (subMap == null || subMap.isEmpty()) continue;
            Iterator itFormula = subMap.keySet().iterator();
            while (itFormula.hasNext()) {
                String periodNumber = BgNFSHelper.parseFormulaPara((String)((String)itFormula.next()))[1];
                if (StringUtils.isEmpty((String)periodNumber)) continue;
                periodNumbers.add(periodNumber);
            }
        }
        if (periodNumbers.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer("select FPeriodType, MIN(FBeginDate), MAX(FEndDate) FROM T_Bg_BgPeriod WHERE FNumber IN('");
        boolean isFirst = true;
        Iterator it = periodNumbers.iterator();
        while (it.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append("','");
            }
            sql.append(it.next());
        }
        sql.append("') GROUP BY FPeriodType");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                int periodType = rs.getInt(1);
                Timestamp[] times = new Timestamp[]{rs.getTimestamp(2), rs.getTimestamp(3)};
                result.put(new Integer(periodType), times);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    private static BgBillIntegrateSchemeCollection queryScheme(Context ctx, Map schemeMap) throws BOSException {
        if (ctx == null || schemeMap == null || schemeMap.isEmpty()) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(schemeMap.keySet()), CompareType.INCLUDE));
        evi.setSelector(BgBillIntegrateCommonHelper.addSchemeSelectors(null));
        evi.setSorter(BgBillIntegrateCommonHelper.getSchemeSorter());
        return BgBillIntegrateSchemeFactory.getLocalInstance(ctx).getBgBillIntegrateSchemeCollection(evi);
    }

    public static Map updateData(Context ctx, Map schemeMap, Map bgDataMap, Map orgMap) throws BOSException, EASBizException {
        if (ctx == null || schemeMap == null || bgDataMap == null) {
            return null;
        }
        Map bgPeriodMap = BgBillIntegrateServerHelper.getPeriodMap(ctx, bgDataMap);
        BgBillIntegrateSchemeCollection schemeCol = BgBillIntegrateServerHelper.queryScheme(ctx, schemeMap);
        if (schemeCol == null || schemeCol.isEmpty()) {
            return null;
        }
        ArrayList params = new ArrayList();
        for (int s = 0; s < schemeCol.size(); ++s) {
            ArrayList tempParams = new ArrayList();
            BgBillIntegrateSchemeInfo scheme = schemeCol.get(s);
            for (int r = 0; r < scheme.getRules().size(); ++r) {
                BgBillIntegrateRuleInfo rule = scheme.getRules().get(r);
                IBgBillIntegrateInterface bii = AbstractBgBillIntegrate.getInterface(scheme);
                bii.setOperator(1);
                List temp = bii.extractData(ctx, scheme, rule, bgPeriodMap, bgDataMap, orgMap);
                if (temp == null || temp.isEmpty()) continue;
                tempParams.addAll(temp);
            }
            if (tempParams.isEmpty()) continue;
            params.addAll(tempParams);
        }
        BgBillIntegrateServerHelper.fillOrgId(ctx, params, orgMap);
        BgBillIntegrateServerHelper.fillPeriodNumber(ctx, params);
        BgBillIntegrateServerHelper.fillBgItemInfo(ctx, params);
        return BgBillIntegrateServerHelper.fillToBgData(ctx, params, bgDataMap);
    }

    public static void backPlanToBill(Context ctx, List bgFormIds, Map backIdeas) throws BOSException, EASBizException {
        if (ctx == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        Map record = BgBillIntegrateServerHelper.queryBgBillIntegrateRecord(ctx, bgFormIds);
        if (record == null || record.isEmpty()) {
            return;
        }
        BgBillIntegrateServerHelper.fillBackIdea(record, backIdeas);
        record = BgBillIntegrateServerHelper.splitRecord(record);
        for (String boName : record.keySet()) {
            AbstractBgBillIntegrate.getInterface(boName).synPlan(ctx, "OPERATOR_BACK_PLAN", (List)record.get(boName));
        }
    }

    private static void fillBackIdea(Map record, Map backIdeas) {
        if (record == null || record.isEmpty() || backIdeas == null || backIdeas.isEmpty()) {
            return;
        }
        for (BgBillIntegrateDataInfo data : record.values()) {
            Object[] bgFormIds = data.getBgFormIds().keySet().toArray();
            for (int i = 0; i < bgFormIds.length; ++i) {
                Object idea = backIdeas.get(bgFormIds[i]);
                if (idea == null) continue;
                data.getBgFormIds().put(bgFormIds[i], idea);
            }
        }
    }

    public static Map queryBgBillIntegrateRecord(Context ctx, Collection bgFormIds) throws BOSException, EASBizException {
        if (ctx == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select dataEntry.FBgFormId dataEntry_FBgFormId, bgData.FID bgData_FID, bgData.FBgValue bgData_FBgValue, bgData.FBgSchemeId bgData_FBgSchemeId, bgData.FOrgUnitId bgData_FOrgUnitId, bgData.FFormula bgData_FFormula, ").append("record.FID record_FID, record.FBoName record_FBoName, record.FBillId record_FBillId, record.FEntryField record_FEntryField, record.FEntryId record_FEntryId, record.FAmountField record_FAmountField, record.FAmount record_FAmount ").append("From T_Bg_BgBillIntegrateRecord record ").append("Inner join T_Bg_BgData bgData on bgData.FID = record.FBgDataId ").append("Left join T_Bg_BgDataEntry dataEntry on bgData.FID = dataEntry.FBgDataId ").append("Where dataEntry.FBgFormId in(");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
        final HashMap result = new HashMap();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] ps = bgFormIds.toArray();
        int batchCount = BgNSQLHelper.getBatchCount((Object[])ps);
        for (int i = 0; i < batchCount; ++i) {
            Object[] sub = new Object[200];
            BgNSQLHelper.setBatchParams((Object[])ps, (Object[])sub, (int)0, (int)i);
            params.add(sub);
        }
        final HashSet paramIds = new HashSet();
        IResultReader reader = new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String bgDataId = res.getString("bgData_FID");
                BgBillIntegrateDataInfo bgData = null;
                if (!result.containsKey(bgDataId)) {
                    bgData = new BgBillIntegrateDataInfo(res.getBigDecimal("bgData_FBgValue"));
                    bgData.setBudgetValue(res.getBigDecimal("bgData_FBgValue"));
                    bgData.setId(bgDataId);
                    bgData.setBgSchemeId(res.getString("bgData_FBgSchemeId"));
                    bgData.setOrgUnitId(res.getString("bgData_FOrgUnitId"));
                    bgData.setFormula(res.getString("bgData_FFormula"));
                    result.put(bgDataId, bgData);
                } else {
                    bgData = (BgBillIntegrateDataInfo)((Object)result.get(bgDataId));
                }
                bgData.getBgFormIds().put(res.getString("dataEntry_FBgFormId"), null);
                String paramId = res.getString("record_FID");
                if (!paramIds.contains(paramId)) {
                    paramIds.add(paramId);
                    BgBillIntegrateParam param = new BgBillIntegrateParam();
                    param.amountField = res.getString("record_FAmountField");
                    param.value = res.getBigDecimal("record_FAmount");
                    param.billId = res.getString("record_FBillId");
                    param.boName = res.getString("record_FBoName");
                    param.entryField = res.getString("record_FEntryField");
                    param.entryId = res.getString("record_FEntryId");
                    param.mainBgData = bgData;
                    bgData.add(param);
                }
            }
        };
        BgNSQLHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), params, (IResultReader)reader);
        return result;
    }

    public static Map splitRecord(Map record) {
        if (record == null || record.isEmpty()) {
            return null;
        }
        HashMap result = new HashMap();
        for (BgBillIntegrateDataInfo data : record.values()) {
            for (int i = 0; i < data.getParamSize(); ++i) {
                BgBillIntegrateParam param = data.get(i);
                if (!result.containsKey(param.boName)) {
                    result.put(param.boName, new ArrayList());
                }
                ((List)result.get(param.boName)).add(param);
            }
        }
        return result;
    }

    public static String saveAdjustMap(Context ctx, Connection conn, BgFormInfo bgForm, Map adjustMap, boolean isThrowException) throws BOSException, EASBizException {
        if (ctx == null || conn == null || adjustMap == null || adjustMap.isEmpty()) {
            return null;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        HashMap<String, BgAdjustFormDiversityData> newAdjustMap = new HashMap<String, BgAdjustFormDiversityData>();
        for (String formula : adjustMap.keySet()) {
            BgNViewDataInfo vData = (BgNViewDataInfo)((Object)adjustMap.get(formula));
            BgAdjustFormDiversityData aData = new BgAdjustFormDiversityData();
            aData.setAdjustor(userId);
            aData.setAdjustTime((java.util.Date)now);
            aData.setFormula(formula);
            aData.setNewValue(vData.getBudgetValueNoDef());
            aData.setOldValue(vData.getOldValue());
            newAdjustMap.put(formula, aData);
        }
        String[] formulaInfo = BgFacadeHelper.checkFormulaIsEctypeInTmp((Connection)conn, (BOSUuid)bgForm.getOrgUnit().getId(), (BOSUuid)bgForm.getBgScheme().getId(), (BOSUuid)bgForm.getAdjust().getId(), new ArrayList(adjustMap.keySet()));
        if (formulaInfo != null) {
            String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"updatePlanAdjustFail", (Locale)ctx.getLocale()), formulaInfo[0].replaceAll(",\"BgData\",true", ""), formulaInfo[1]);
            if (isThrowException) {
                msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"updatePlanAdjustFailHead", (Locale)ctx.getLocale()), bgForm.getOrgUnit().getName(), bgForm.getNumber()) + msg;
                throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.MESSAGE, new Object[]{msg});
            }
            return msg;
        }
        BgNAdjHelper.createTmpDataOfFormulaForView((Context)ctx, (Connection)conn, (BOSUuid)bgForm.getOrgUnit().getId(), (BOSUuid)bgForm.getBgScheme().getId(), (BOSUuid)bgForm.getBgTemplate().getId(), (BOSUuid)bgForm.getAdjust().getId(), newAdjustMap, null, (BOSUuid)bgForm.getId(), null);
        return null;
    }
}

