/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.view.BgReportActualFacadeFactory;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.app.AbstractBgReportActualFacadeControllerBean;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgReportActualFacadeControllerBean
extends AbstractBgReportActualFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.view.app.BgReportActualFacadeControllerBean");

    @Override
    protected void _saveInitActual(Context ctx, BgFormInfo bgFormInfo, Map bgDataMap) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            return;
        }
        HashSet orgIds = new HashSet();
        if (bgDataMap != null) {
            orgIds.addAll(bgDataMap.keySet());
        }
        Map bgFormMap = BgViewServerHelper.queryBgFormByOrgUnitId(ctx, bgFormInfo, orgIds.toArray());
        BgReportActualFacadeControllerBean.updateBgFormLastUpdate(ctx, bgFormInfo, bgFormMap);
        HashMap updateMap = new HashMap();
        BgReportActualFacadeControllerBean.filterBgDataMap(bgDataMap, updateMap);
        BgReportActualFacadeControllerBean.updateBgData(ctx, bgFormMap, updateMap);
    }

    private static void updateBgFormLastUpdate(Context ctx, BgFormInfo bgFormInfo, Map bgFormMap) throws BOSException {
        if (bgFormInfo == null || bgFormMap == null || bgFormMap.isEmpty()) {
            return;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        for (BgFormInfo b : bgFormMap.values()) {
            b.setLastUpdateUser(user);
        }
    }

    private static void filterBgDataMap(Map bgDataMap, Map updateMap) {
        BOSObjectType type = new BgDataInfo().getBOSType();
        for (String orgId : bgDataMap.keySet()) {
            Map subMap = (Map)bgDataMap.get(orgId);
            if (subMap == null || subMap.isEmpty()) continue;
            for (BgNViewDataInfo data : subMap.values()) {
                if (data.getActualValue() == null) continue;
                BgViewCommonHelper.getSubMap(updateMap, orgId, true).put(data.getFormula(), data);
            }
        }
    }

    private static void updateBgData(Context ctx, Map bgFormMap, Map updateMap) throws BOSException {
        if (updateMap == null || updateMap.isEmpty()) {
            return;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String sql = "Update T_BG_BgData Set FBgActual = ?, FLastupdateUserId = ?, FlastupdateTime = ? where FOrgUnitID = ? and FBgSchemeId = ? and FFormula = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String orgId : updateMap.keySet()) {
            Map subMap = (Map)updateMap.get(orgId);
            BgFormInfo bgForm = (BgFormInfo)bgFormMap.get(orgId);
            if (subMap == null || subMap.isEmpty() || bgForm == null) continue;
            for (BgNViewDataInfo data : subMap.values()) {
                Object[] params = new Object[]{data.getActualValue(), userId, now, data.getOrgUnitId(), data.getBgSchemeId(), data.getFormula()};
                paramsList.add(params);
            }
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            BgNSQLHelper.executeBatch((Connection)conn, (String)sql, paramsList);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected Map _saveActual(Context ctx, BgActualRecordInfo bgActualRecordInfo, Map bgDataMap, Map deleteMap, Map extInfo) throws BOSException, EASBizException {
        Map gatherInfo;
        HashSet orgIdSet = new HashSet();
        orgIdSet.addAll(bgDataMap.keySet());
        orgIdSet.remove(bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString());
        Map actualRecordInfoMap = BgReportActualFacadeFactory.getLocalInstance(ctx).queryBgActualRecordByOrgUnitId(bgActualRecordInfo, orgIdSet.toArray());
        actualRecordInfoMap.put(bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString(), bgActualRecordInfo);
        HashMap addDataMap = new HashMap();
        HashSet delDataSet = new HashSet();
        HashMap updateDataMap = new HashMap();
        HashMap bgPeriodMap = new HashMap();
        this.FilterActualData(ctx, actualRecordInfoMap, bgActualRecordInfo, bgDataMap, addDataMap, delDataSet, updateDataMap, deleteMap, bgPeriodMap);
        if (!addDataMap.isEmpty()) {
            this.batchWriteBgActual(ctx, actualRecordInfoMap, addDataMap, bgPeriodMap);
        }
        if (!updateDataMap.isEmpty()) {
            this.batchUpdateBgActual(ctx, actualRecordInfoMap, updateDataMap);
        }
        if (!delDataSet.isEmpty()) {
            this.batchDelBgActual(ctx, delDataSet);
        }
        if (extInfo.get("GatherInfo") instanceof Map && (gatherInfo = (Map)extInfo.get("GatherInfo")).size() > 0) {
            try {
                Collection collections = actualRecordInfoMap.values();
                for (BgActualRecordInfo info : collections) {
                    Book currentBook = null;
                    currentBook = info.getData() == null ? Book.Manager.getNewBook() : info.getBook();
                    Map currentOrgGahterInfo = (Map)gatherInfo.get(info.getBgForm().getOrgUnit().getId().toString());
                    if (currentOrgGahterInfo == null) continue;
                    currentBook.setUserObject("GATHER_ORGUNIT", currentOrgGahterInfo.get("GATHER_ORGUNIT"));
                    currentBook.setUserObject("GATHER_ORGUNIT_SORT", currentOrgGahterInfo.get("GATHER_ORGUNIT_SORT"));
                    currentBook.setUserObject("GATHER_SCHEME", currentOrgGahterInfo.get("GATHER_SCHEME"));
                    currentBook.setUserObject("GATHER_BGFORM", currentOrgGahterInfo.get("GATHER_BGFORM"));
                    currentBook.setUserObject("IS_GATHER_ADJUST", currentOrgGahterInfo.get("IS_GATHER_ADJUST"));
                    currentBook.setUserObject("GATHER_TYPE_EXT", currentOrgGahterInfo.get("GATHER_TYPE_EXT"));
                    currentBook.setUserObject("GATHER_PERIOD_ID", currentOrgGahterInfo.get("GATHER_PERIOD_ID"));
                    currentBook.setUserObject("GATHER_PERIOD", currentOrgGahterInfo.get("GATHER_PERIOD"));
                    info.setBook(currentBook);
                    info.put("CELL_DATA", currentOrgGahterInfo.get("CELL_DATA"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        CoreBaseCollection col = new CoreBaseCollection();
        for (BgActualRecordInfo info : actualRecordInfoMap.values()) {
            if (info.getCreator() == null) {
                info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (info.getCreateTime() == null) {
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            col.add((CoreBaseInfo)info);
        }
        BgActualRecordFactory.getLocalInstance((Context)ctx).saveBatchData(col);
        return null;
    }

    private void batchDelBgActual(Context ctx, Set delDataSet) throws BOSException {
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNSQLHelper.executeBatch((Connection)conn, (String)"DELETE FROM T_BG_BgActualData WHERE FID = ? ", new ArrayList(delDataSet));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void batchUpdateBgActual(Context ctx, Map actualRecordInfoMap, Map updateDataMap) throws BOSException {
        String orgStr2 = null;
        String formulaStr2 = null;
        Map subMap = null;
        BgNViewDataInfo dataInfo = null;
        BgActualRecordInfo actualRecordInfo = null;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append("update t_bg_bgactualdata set fbizactual = ? where  fbgactualrecordid = ? and forgunitid = ? and fbgschemeid = ? and fformula = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            int count = 0;
            for (String orgStr2 : updateDataMap.keySet()) {
                subMap = (Map)updateDataMap.get(orgStr2);
                if (subMap.isEmpty()) continue;
                actualRecordInfo = (BgActualRecordInfo)actualRecordInfoMap.get(orgStr2);
                for (String formulaStr2 : subMap.keySet()) {
                    dataInfo = (BgNViewDataInfo)((Object)subMap.get(formulaStr2));
                    ps.setBigDecimal(1, dataInfo.getAddActualValue());
                    ps.setString(2, actualRecordInfo.getId().toString());
                    ps.setString(3, actualRecordInfo.getBgForm().getOrgUnit().getId().toString());
                    ps.setString(4, actualRecordInfo.getBgForm().getBgScheme().getId().toString());
                    ps.setString(5, formulaStr2);
                    ps.addBatch();
                    if (++count < 200) continue;
                    ps.executeBatch();
                    count = 0;
                }
            }
            if (count != 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void batchWriteBgActual(Context ctx, Map actualRecordInfoMap, Map addDataMap, Map bgPeriodMap) throws BOSException {
        String orgStr2 = null;
        String formulaStr2 = null;
        Map subMap = null;
        Map subPeriodMap = null;
        BgNViewDataInfo dataInfo = null;
        BgActualRecordInfo actualRecordInfo = null;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append("insert into t_bg_bgactualdata(fid,forgunitid,fbgschemeid,fbgactualrecordid,fbizactual,fformula,fbgperiodid) values(?,?,?,?,?,?,?) ");
            ps = connection.prepareStatement(strBuffer.toString());
            int count = 0;
            for (String orgStr2 : addDataMap.keySet()) {
                subMap = (Map)addDataMap.get(orgStr2);
                if (subMap.isEmpty()) continue;
                actualRecordInfo = (BgActualRecordInfo)actualRecordInfoMap.get(orgStr2);
                subPeriodMap = (Map)bgPeriodMap.get(orgStr2);
                for (String formulaStr2 : subMap.keySet()) {
                    dataInfo = (BgNViewDataInfo)((Object)subMap.get(formulaStr2));
                    ps.setString(1, BOSUuid.create((String)"BgActual").toString());
                    ps.setString(2, actualRecordInfo.getBgForm().getOrgUnit().getId().toString());
                    ps.setString(3, actualRecordInfo.getBgForm().getBgScheme().getId().toString());
                    ps.setString(4, actualRecordInfo.getId().toString());
                    ps.setBigDecimal(5, dataInfo.getAddActualValue());
                    ps.setString(6, formulaStr2);
                    ps.setString(7, (String)subPeriodMap.get(formulaStr2));
                    ps.addBatch();
                    if (++count < 200) continue;
                    ps.executeBatch();
                    count = 0;
                }
            }
            if (count != 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void FilterActualData(Context ctx, Map actualRecordInfoMap, BgActualRecordInfo actualRecordInfo, Map bgDataMap, Map addDataMap, Set delDataSet, Map updateDataMap, Map deleteMap, Map bgPeriodIdMap) throws BOSException, EASBizException {
        BgNViewDataInfo data = null;
        String orgIdStr2 = null;
        String formulaStr = null;
        if (bgDataMap != null && !bgDataMap.isEmpty()) {
            HashMap periodMap = new HashMap();
            BgActualRecordInfo curActualRecordInfo = null;
            Map subMap = null;
            String[] params = null;
            String periodNum = null;
            IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getLocalInstance((Context)ctx);
            for (String orgIdStr2 : actualRecordInfoMap.keySet()) {
                curActualRecordInfo = (BgActualRecordInfo)actualRecordInfoMap.get(orgIdStr2);
                if (bgDataMap.get(orgIdStr2) instanceof Map) {
                    subMap = (Map)bgDataMap.get(orgIdStr2);
                }
                if (!curActualRecordInfo.isIsEditByPeriod() || subMap == null) continue;
                periodMap.put(curActualRecordInfo.getBgPeriod().getNumber(), null);
                Iterator itData = subMap.keySet().iterator();
                while (itData.hasNext()) {
                    formulaStr = (String)itData.next();
                    params = BgNFSHelper.parseFormulaPara(null, (String)formulaStr);
                    periodNum = params[1];
                    if (periodMap.containsKey(periodNum)) continue;
                    itData.remove();
                }
            }
        }
        if (bgDataMap != null) {
            for (String orgIdStr2 : bgDataMap.keySet()) {
                Map subMap = (Map)bgDataMap.get(orgIdStr2);
                if (subMap == null || subMap.isEmpty()) continue;
                Iterator itData = subMap.keySet().iterator();
                while (itData.hasNext()) {
                    formulaStr = (String)itData.next();
                    data = (BgNViewDataInfo)((Object)subMap.get(formulaStr));
                    if (data.getAddActualNoDef() != null && (deleteMap == null || !(deleteMap.get(orgIdStr2) instanceof Map) || !((Map)deleteMap.get(orgIdStr2)).containsKey(formulaStr))) continue;
                    delDataSet.add(data.getId());
                    itData.remove();
                }
            }
        }
        if (!bgDataMap.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("select bgData.forgunitid, bgData.fformula , bgData.fbgperiodid ");
            sql.append("from t_bg_bgdata bgData ").append("left join t_bg_bgscheme bgScheme on bgScheme.fid = bgData.fbgschemeid ").append("where bgData.fdatastate = ? and bgData.forgunitid = ? and bgScheme.forgunitid = ? and bgScheme.FRootId = ? and bgData.fformula in (");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet res = null;
            HashMap<String, String> subBgPeriodMap = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(sql.toString());
                for (String orgIdStr2 : bgDataMap.keySet()) {
                    Object[] params = ((Map)bgDataMap.get(orgIdStr2)).keySet().toArray();
                    if (params.length == 0) continue;
                    int batchCount = (params.length - 1) / 200 + 1;
                    for (int i = 0; i < batchCount; ++i) {
                        subBgPeriodMap = new HashMap<String, String>();
                        pstmt.setInt(1, 9);
                        pstmt.setString(2, orgIdStr2);
                        pstmt.setString(3, orgIdStr2);
                        pstmt.setString(4, actualRecordInfo.getBgForm().getBgScheme().getRootId().toString());
                        BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)5, (int)i, (int)200, (Object[])params);
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            subBgPeriodMap.put(res.getString("fformula"), res.getString("fbgperiodid"));
                        }
                        if (bgDataMap.get(orgIdStr2) instanceof Map) {
                            Map subMap = (Map)bgDataMap.get(orgIdStr2);
                            Iterator itData = subMap.keySet().iterator();
                            while (itData.hasNext()) {
                                formulaStr = (String)itData.next();
                                if (subBgPeriodMap.containsKey(formulaStr)) continue;
                                delDataSet.add(((BgNViewDataInfo)((Object)subMap.get(formulaStr))).getId());
                                itData.remove();
                            }
                        }
                        BgViewCommonHelper.getSubMap(bgPeriodIdMap, orgIdStr2, true).putAll(subBgPeriodMap);
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        }
        if (!bgDataMap.isEmpty()) {
            HashMap<String, String> bgActualRecordIdMap = new HashMap<String, String>();
            for (String orgIdStr2 : actualRecordInfoMap.keySet()) {
                bgActualRecordIdMap.put(orgIdStr2, ((BgActualRecordInfo)actualRecordInfoMap.get(orgIdStr2)).getId().toString());
            }
            Map exitDataMap = this.queryActualData(ctx, bgDataMap, bgActualRecordIdMap);
            Map subMap1 = null;
            Map subMap2 = null;
            Iterator itOrg = bgDataMap.keySet().iterator();
            while (itOrg.hasNext()) {
                orgIdStr2 = (String)itOrg.next();
                if (!(bgDataMap.get(orgIdStr2) instanceof Map)) continue;
                subMap1 = (Map)bgDataMap.get(orgIdStr2);
                if (!(exitDataMap.get(orgIdStr2) instanceof Map)) {
                    BgViewCommonHelper.getSubMap(addDataMap, orgIdStr2, true).putAll(subMap1);
                    itOrg.remove();
                    continue;
                }
                subMap2 = (Map)exitDataMap.get(orgIdStr2);
                Iterator itData = subMap1.keySet().iterator();
                while (itData.hasNext()) {
                    formulaStr = (String)itData.next();
                    data = (BgNViewDataInfo)((Object)subMap1.get(formulaStr));
                    if (subMap2.containsKey(formulaStr)) {
                        BgViewCommonHelper.getSubMap(updateDataMap, orgIdStr2, true).put(data.getFormula(), data);
                    } else {
                        BgViewCommonHelper.getSubMap(addDataMap, orgIdStr2, true).put(data.getFormula(), data);
                    }
                    itData.remove();
                }
            }
        }
    }

    @Override
    public Map _queryBgActualRecordByOrgUnitId(Context ctx, BgActualRecordInfo bgActualRecordInfo, Object[] orgIds) throws BOSException, EASBizException {
        Map bgFormMap = BgFormFacadeFactory.getLocalInstance((Context)ctx).queryBgFormByOrgUnitId(bgActualRecordInfo.getBgForm(), orgIds);
        HashSet<String> bgFormIdSet = new HashSet<String>();
        Iterator iterator = bgFormMap.values().iterator();
        while (iterator.hasNext()) {
            bgFormIdSet.add(((BgFormInfo)iterator.next()).getId().toString());
        }
        HashMap bgActualRecordIdMap = new HashMap();
        this.FilterActualRecordMap(ctx, bgActualRecordIdMap, bgFormIdSet, bgActualRecordInfo.getBgPeriod().getNumber());
        return bgActualRecordIdMap;
    }

    @Override
    protected Map _queryAddActualByRecordId(Context ctx, String bgFormId, Map bgDataMap, String bgPeriodNum) throws BOSException, EASBizException {
        HashMap bgActualRecordIdMap = new HashMap();
        this.FilterActualRecordMap(ctx, bgActualRecordIdMap, bgFormId, bgPeriodNum);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.rootId");
        BgFormInfo formInfo = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        Map budgetMap = BgViewFacadeFactory.getLocalInstance(ctx).queryBgData(bgDataMap, formInfo.getBgScheme().getRootId().toString());
        Map addActualMap = this.queryActualData(ctx, bgDataMap, bgActualRecordIdMap);
        if (budgetMap != null) {
            String orgStr2 = null;
            Map dataMap = null;
            String formulaStr2 = null;
            BgNViewDataInfo data = null;
            for (String orgStr2 : budgetMap.keySet()) {
                if (budgetMap.get(orgStr2) == null) continue;
                dataMap = (Map)budgetMap.get(orgStr2);
                for (String formulaStr2 : dataMap.keySet()) {
                    data = (BgNViewDataInfo)((Object)dataMap.get(formulaStr2));
                    data.setOldValue(null);
                    if (addActualMap.get(orgStr2) != null && ((Map)addActualMap.get(orgStr2)).get(formulaStr2) != null) {
                        data.setAddActualValue(((BgNViewDataInfo)((Object)((Map)addActualMap.get(orgStr2)).get(formulaStr2))).getAddActualNoDef());
                        data.setOldValue(((BgNViewDataInfo)((Object)((Map)addActualMap.get(orgStr2)).get(formulaStr2))).getAddActualNoDef());
                        data.setId(((BgNViewDataInfo)((Object)((Map)addActualMap.get(orgStr2)).get(formulaStr2))).getId());
                        continue;
                    }
                    data.setId(null);
                }
            }
        }
        return budgetMap;
    }

    private Map queryActualData(Context ctx, Map bgDataMap, Map bgActualRecordIdMap) throws BOSException {
        HashMap resMap = new HashMap();
        if (bgDataMap == null || bgDataMap.isEmpty()) {
            return resMap;
        }
        StringBuffer queryActualData = new StringBuffer();
        queryActualData.append("select actualData.FId, actualData.FBgSchemeId, actualData.FOrgUnitId, actualData.FFormula, actualData.FBizActual  from t_bg_bgActualData actualData, t_bg_bgActualRecord actualRecord  where actualData.FBGACTUALRECORDID = actualRecord.FID  and actualRecord.FID = ? and actualData.FFormula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)queryActualData, (int)200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(queryActualData.toString());
            for (String orgId : bgActualRecordIdMap.keySet()) {
                if (!resMap.containsKey(orgId)) {
                    resMap.put(orgId, new HashMap());
                }
                Map subMap = (Map)resMap.get(orgId);
                Object[] params = ((Map)bgDataMap.get(orgId)).keySet().toArray();
                if (params.length == 0) continue;
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, (String)bgActualRecordIdMap.get(orgId));
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)200, (Object[])params);
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        BgNViewDataInfo bgData = new BgNViewDataInfo(res.getBigDecimal("FBizActual"));
                        bgData.setId(res.getString("fid"));
                        bgData.setBgSchemeId(res.getString("fbgschemeid"));
                        bgData.setOrgUnitId(res.getString("forgunitid"));
                        bgData.setFormula(res.getString("fformula"));
                        bgData.setAddActualValue(res.getBigDecimal("fbizactual"));
                        subMap.put(bgData.getFormula(), bgData);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return resMap;
    }

    private void FilterActualRecordMap(Context ctx, Map bgActualRecordIdMap, String bgFormId, String bgPeriodNum) throws BOSException {
        HashSet<String> bgFormIdSet = new HashSet<String>();
        bgFormIdSet.add(bgFormId);
        this.FilterActualRecordMap(ctx, bgActualRecordIdMap, bgFormIdSet, bgPeriodNum);
    }

    private void FilterActualRecordMap(Context ctx, Map bgActualRecordIdMap, Set bgFormIdSet, String bgPeriodNum) throws BOSException {
        if (bgActualRecordIdMap == null || bgFormIdSet == null || bgFormIdSet.isEmpty() || StringUtils.isEmpty((String)bgPeriodNum)) {
            return;
        }
        IBgActualRecord iBgActualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)bgFormIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.number", (Object)bgPeriodNum, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgForm.orgUnit.id");
        sic.add("id");
        entityViewInfo.setSelector(sic);
        CoreBaseCollection col = iBgActualRecord.getCollection(entityViewInfo);
        BgActualRecordInfo actualRecordInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            actualRecordInfo = (BgActualRecordInfo)col.get(i);
            bgActualRecordIdMap.put(actualRecordInfo.getBgForm().getOrgUnit().getId().toString(), actualRecordInfo.getId().toString());
        }
    }
}

