/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateTemplateInfo;
import com.kingdee.eas.ma.view.BgRollMethodEnum;
import com.kingdee.eas.ma.view.BgViewDimensionCollection;
import com.kingdee.eas.ma.view.BgViewDimensionInfo;
import com.kingdee.eas.ma.view.app.AbstractBgViewDimensionControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgViewDimensionControllerBean
extends AbstractBgViewDimensionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.view.app.BgViewDimensionControllerBean");

    @Override
    protected boolean _checkNumberDup(Context ctx, String number, String orgId, String bgTemplateId) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block4: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from t_bg_bgtemplate where fnumber=? and forgunitid = ? ");
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, orgId);
                rs = sm.executeQuery();
                if (!rs.next()) break block4;
                bl = bgTemplateId == null || !bgTemplateId.equals(rs.getString("fid"));
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _addNewView(Context ctx, IObjectValue bgDimensionInfo, IObjectValue bgTemplate) throws BOSException, EASBizException {
        IBgTemplate itemplate = BgTemplateFactory.getLocalInstance((Context)ctx);
        BgTemplateInfo templateInfo = (BgTemplateInfo)bgTemplate;
        templateInfo.setCanModify(BgTemModifyEnum.CANMODIFY);
        templateInfo.setIsAllowChange(BgTemModifyEnum.CANMODIFY);
        IObjectPK templateid = itemplate.save((CoreBaseInfo)templateInfo);
        templateInfo.setId(BOSUuid.read((String)templateid.toString()));
        BgViewDimensionInfo info = (BgViewDimensionInfo)bgDimensionInfo;
        BgViewDimensionCollection old = this.getBgViewDimensionCollection(ctx, "select id, template where template.id = '" + templateid + "'");
        if (old == null || old.isEmpty()) {
            info.setTemplate(templateInfo);
            info.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
            this.changeSchemesRef(info);
            this._addnew(ctx, (IObjectValue)info);
        } else {
            old.get(0).setData(info.getData());
            if (info.getRollType() == null) {
                old.get(0).setInt("rollType", 0);
            } else {
                old.get(0).setRollType(info.getRollType());
            }
            if (info.getRollMethod() == null) {
                old.get(0).setInt("rollMethod", 0);
            } else {
                old.get(0).setRollMethod(info.getRollMethod());
            }
            old.get(0).setRollStep(info.getRollStep());
            old.get(0).setRollLength(info.getRollLength());
            old.get(0).setOverFlow(info.getOverFlow());
            old.get(0).setFixedLength(info.getFixedLength());
            old.get(0).getSchemes().clear();
            old.get(0).getSchemes().addCollection(info.getSchemes());
            this.changeSchemesRef(old.get(0));
            this._update(ctx, (IObjectPK)new ObjectUuidPK(old.get(0).getId()), (IObjectValue)old.get(0));
        }
        return templateid;
    }

    private void changeSchemesRef(BgViewDimensionInfo info) {
        if (info != null && info.getSchemes() != null) {
            for (int i = 0; i < info.getSchemes().size(); ++i) {
                info.getSchemes().get(i).setBgTemplateDimension(info);
            }
        }
    }

    @Override
    protected IObjectValue _getDimensionByTemplate(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        BgViewDimensionInfo bgViewDimensionInfo;
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select dimen.fid, dimen.FData, dimen.FRollMethod, dimen.FRollType, dimen.FRollStep, dimen.FRollLength, dimen.FOverFlow, dimen.FFixedLength, schemes.fid schemes_fid, schemes.fseq schemes_fseq, schemes.flevel schemes_flevel, schemes.FBgFormState schemes_FBgFormState, scheme.fid scheme_id, scheme.fnumber scheme_number, scheme.fname_" + ctx.getLocale() + " scheme_name from T_BG_BgViewDimension dimen left join T_BG_BgBillIntegrateTemplate schemes on schemes.fbgtemplateid = dimen.fid left join T_Bg_BgBillIntegrateScheme scheme on schemes.fschemeid = scheme.fid  where dimen.FTemplateID =? ;");
        connection = this.getConnection(ctx);
        try {
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, bgTemplateId);
            rs = sm.executeQuery();
            BgViewDimensionInfo info = null;
            while (rs.next()) {
                if (info == null) {
                    info = new BgViewDimensionInfo();
                    info.setId(BOSUuid.read((String)rs.getString("fid")));
                    info.setData(rs.getBytes("FData"));
                    info.setRollMethod(BgRollMethodEnum.getEnum(rs.getInt("FRollMethod")));
                    info.setRollType(BgPeriodEnum.getEnum((int)rs.getInt("FRollType")));
                    info.setRollLength(rs.getInt("FRollLength"));
                    info.setOverFlow(rs.getInt("FOverFlow"));
                    info.setRollStep(rs.getInt("FRollStep"));
                    info.setFixedLength(rs.getInt("FFixedLength"));
                }
                if (StringUtils.isEmpty((String)rs.getString("schemes_fid"))) continue;
                BgBillIntegrateTemplateInfo temp = new BgBillIntegrateTemplateInfo();
                info.getSchemes().add(temp);
                temp.setId(BOSUuid.read((String)rs.getString("schemes_fid")));
                temp.setBgTemplateDimension(info);
                temp.setFormState(BgFormStateEnum.getEnum((int)rs.getInt("schemes_FBgFormState")));
                temp.setSeq(rs.getInt("schemes_fseq"));
                temp.setLevel(rs.getInt("schemes_flevel"));
                temp.setScheme(new BgBillIntegrateSchemeInfo());
                temp.getScheme().setId(BOSUuid.read((String)rs.getString("scheme_id")));
                temp.getScheme().setNumber(rs.getString("scheme_number"));
                temp.getScheme().setName(rs.getString("scheme_name"));
            }
            bgViewDimensionInfo = info;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return bgViewDimensionInfo;
    }

    @Override
    protected void _deleteDimension(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        String sql = "delete from T_BG_BgViewDimension  where FTemplateID = ? ;";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, id);
            ps.execute();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        }
    }
}

