/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormPeriodData;
import com.kingdee.eas.ma.budget.BgFormPeriodFilterParam;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeFactory;
import com.kingdee.eas.ma.budget.BgSchemeNodeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.ma.view.BgViewDimensionCollection;
import com.kingdee.eas.ma.view.BgViewDimensionFactory;
import com.kingdee.eas.ma.view.app.AbstractBgViewFacadeControllerBean;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBudgetView;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgViewFacadeControllerBean
extends AbstractBgViewFacadeControllerBean {
    private static final long serialVersionUID = 6494815585958862499L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.view.app.BgViewFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _addNewViewInfo(Context ctx, BgFormInfo bgForm, boolean isBatch) throws BOSException, EASBizException {
        if (bgForm == null || bgForm.getBgTemplate() == null || bgForm.getBgScheme() == null) {
            return null;
        }
        if (!BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return null;
        }
        String currBgFormId = null;
        String bgTemplateId = bgForm.getBgTemplate().getId().toString();
        String bgSchemeId = bgForm.getBgScheme().getId().toString();
        String currencyId = bgForm.getCurrency().getId().toString();
        String bgPeriodId = bgForm.getBgPeriod().getId().toString();
        String bgFormNumber = null;
        String bgFormName = null;
        Object des = null;
        Map bgForms = new HashMap();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            bgForms = this.getBgFormMap(ctx, conn, bgForm, true);
            if (bgFormNumber == null) {
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)bgForm, (String)bgForm.getOrgUnit().getId().toString(), (String)"sourceType");
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)bgForm, (String)bgForm.getOrgUnit().getId().toString(), (String)"sourceType", (String)"name");
                bgFormNumber = bgForm.getNumber();
                bgFormName = bgForm.getName();
                if (StringUtils.isEmpty((String)bgFormNumber)) {
                    bgFormNumber = "BgForm-" + System.currentTimeMillis();
                }
                if (bgFormNumber.indexOf("(") >= 0 || bgFormNumber.indexOf(")") >= 0) {
                    throw new BgNFormException(BgNFormException.NUMBERERROR);
                }
                if (bgFormNumber.length() > 80) {
                    bgFormNumber = bgFormNumber.substring(0, 80);
                }
                if (bgFormName.length() > 80) {
                    bgFormName = bgFormName.substring(0, 80);
                }
            }
            ArrayList<BgFormInfo> newForms = new ArrayList<BgFormInfo>();
            if (isBatch) {
                for (BgFormInfo b : bgForms.values()) {
                    this.setBgFormInfo(bgForm, currencyId, bgPeriodId, bgFormNumber, bgFormName, b);
                    if (b.getId() == null) {
                        newForms.add(b);
                        b.setId(BOSUuid.create((BOSObjectType)b.getBOSType()));
                    }
                    if (!bgSchemeId.equals(b.getBgScheme().getId().toString())) continue;
                    currBgFormId = String.valueOf(b.getId());
                }
            } else {
                BgFormInfo b = (BgFormInfo)bgForms.get(bgSchemeId);
                this.setBgFormInfo(bgForm, currencyId, bgPeriodId, bgFormNumber, bgFormName, b);
                if (b.getId() == null) {
                    newForms.add(b);
                    b.setId(BOSUuid.create((BOSObjectType)b.getBOSType()));
                }
                currBgFormId = String.valueOf(b.getId());
            }
            String logName = bgForm.getNumber() + " " + bgForm.getName();
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgForm_addNew");
            BgViewServerHelper.batchAddNewView(ctx, conn, newForms, true);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
        return currBgFormId;
    }

    private void setBgFormInfo(BgFormInfo bgForm, String currencyId, String bgPeriodId, String bgFormNumber, String bgFormName, BgFormInfo b) {
        b.setNumber(bgFormNumber);
        b.setName(bgFormName);
        b.setDescription(bgForm.getDescription());
        if (b.getId() == null) {
            b.setBgPeriod(new BgPeriodInfo());
            b.getBgPeriod().setId(BOSUuid.read((String)bgPeriodId));
            b.setCurrency(new CurrencyInfo());
            b.getCurrency().setId(BOSUuid.read((String)currencyId));
        }
    }

    @Override
    protected List _checkNumber(Context ctx, BgFormInfo bgFormInfo, boolean isBatch) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            return null;
        }
        ArrayList<Boolean> orgs = new ArrayList<Boolean>();
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            HashSet<String> orgIds = new HashSet<String>();
            if (!isBatch) {
                orgIds.add(bgFormInfo.getOrgUnit().getId().toString());
            } else {
                Map bgForms = this.getBgFormMap(ctx, conn, bgFormInfo, true);
                if (bgForms != null) {
                    for (BgFormInfo b : bgForms.values()) {
                        if (b.getId() != null) continue;
                        orgIds.add(b.getOrgUnit().getId().toString());
                    }
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select org.fid, org.fnumber, org.fname_").append(ctx.getLocale()).append(" fname from t_bg_bgform bgForm, t_org_costcenter org ");
            sql.append(" where org.fid = bgForm.forgunitid and bgForm.fnumber = ? and bgForm.forgunitid in (");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = orgIds.toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (i = 0; i < batchCount; ++i) {
                pstmt.setString(1, bgFormInfo.getNumber());
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)200, (Object[])params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    FullOrgUnitInfo org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)res.getString("fid")));
                    org.setNumber(res.getString("fnumber"));
                    org.setName(res.getString("fname"));
                    orgMap.put(org.getNumber(), org);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
            if (!orgMap.isEmpty()) {
                orgs.add(orgMap.size() == orgIds.size());
                params = orgMap.keySet().toArray();
                Arrays.sort(params);
                for (i = 0; i < params.length; ++i) {
                    orgs.add((Boolean)orgMap.get(params[i]));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return orgs;
    }

    protected Map getBgFormMap(Context ctx, Connection conn, BgFormInfo bgForm, boolean isContainNoForm) throws BOSException {
        if (bgForm == null) {
            return null;
        }
        HashMap<String, BgFormInfo> bgForms = new HashMap<String, BgFormInfo>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            StringBuffer sql = BgViewServerHelper.getQuerySQL();
            sql.append(" and bgForm.FBgTemplateId = bgTemplate.FID and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId =? ");
            sql.append(" where bgScheme.FRootId = (select FRootID from t_Bg_bgscheme where fid = ? ) ");
            sql.append(" and bgTemplate.FRootID = (select FRootID from t_bg_bgTemplate where fid = ? ) ");
            if (!isContainNoForm) {
                sql.append(" and bgForm.FID is not null ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgForm.getBgPeriod().getId().toString());
            pstmt.setString(2, bgForm.getCurrency().getId().toString());
            pstmt.setString(3, bgForm.getBgScheme().getId().toString());
            pstmt.setString(4, bgForm.getBgTemplate().getId().toString());
            res = pstmt.executeQuery();
            while (res.next()) {
                BgFormInfo b = BgViewServerHelper.buildBgFormInfo(res);
                bgForms.put(b.getBgScheme().getId().toString(), b);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        return bgForms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BgFormInfo _checkBgForm(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgFormInfo.getBgScheme() == null || bgFormInfo.getBgTemplate() == null || bgFormInfo.getBgPeriod() == null || bgFormInfo.getCurrency() == null) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            Map bgFormMap = this.getBgFormMap(ctx, conn, bgFormInfo, false);
            if (bgFormMap != null && !bgFormMap.isEmpty()) {
                if (bgFormMap.get(bgFormInfo.getBgScheme().getId().toString()) != null) {
                    BgFormInfo bgFormInfo2 = (BgFormInfo)bgFormMap.get(bgFormInfo.getBgScheme().getId().toString());
                    return bgFormInfo2;
                }
                Iterator it = bgFormMap.values().iterator();
                if (it.hasNext()) {
                    BgFormInfo bgFormInfo3 = (BgFormInfo)it.next();
                    return bgFormInfo3;
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }

    @Override
    protected Map _getInitBgTemplateDimensionInfo(Context ctx, IBgDimensionManager bgDimensionManager, String bgTemplateId) throws BOSException, EASBizException {
        if (bgDimensionManager == null || bgTemplateId == null) {
            return null;
        }
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        Map bgItemMap = this.queryBgTemplateBgItem(ctx, bgDimensionManager, bgTemplateId);
        resMap.put("BGITEM", bgItemMap);
        return resMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map queryBgTemplateBgItem(Context ctx, IBgDimensionManager bgDimensionManager, String bgTemplateId) throws BOSException {
        HashMap bgItemMap = new HashMap();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            String orgId = this.getBgTemplateOrgId(ctx, conn, bgTemplateId);
            orgId = BgSHelper.getIsolateOrg((Context)ctx, (String)orgId);
            HashMap subItemMap = new HashMap();
            bgItemMap.put(orgId, subItemMap);
            ArrayList allDimen = new ArrayList();
            allDimen.addAll(bgDimensionManager.getColDimension());
            allDimen.addAll(bgDimensionManager.getRowDimension());
            allDimen.addAll(bgDimensionManager.getPageDimension());
            for (int i = 0; i < allDimen.size(); ++i) {
                BgDimensionInfo dimen = (BgDimensionInfo)allDimen.get(i);
                if (!"BGITEM".equalsIgnoreCase(dimen.getType())) continue;
                HashMap groupMap = new HashMap();
                subItemMap.put(dimen.getAttributeNumber(), groupMap);
                if (StringUtils.isEmpty((String)dimen.getValue())) continue;
                for (int m = 0; m < dimen.getMember().size(); ++m) {
                    groupMap.put(((BgDimensionMember)dimen.getMember().get(m)).getNumber(), dimen.getMember().get(m));
                }
            }
            BgViewServerHelper.queryBgItem(ctx, conn, bgItemMap);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgItemMap;
    }

    private String getBgTemplateOrgId(Context ctx, Connection conn, String bgTemplateId) throws BOSException {
        ResultSet res;
        PreparedStatement pstmt;
        block5: {
            String string;
            if (conn == null || bgTemplateId == null) {
                return null;
            }
            pstmt = null;
            res = null;
            try {
                pstmt = conn.prepareStatement("select forgunitid from t_bg_bgtemplate where fid = ?");
                pstmt.setString(1, bgTemplateId);
                res = pstmt.executeQuery();
                if (!res.next()) break block5;
                string = res.getString("forgunitid");
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, (Statement)pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        return null;
    }

    @Override
    protected IObjectPK _updateBgFormInfo(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo != null && bgFormInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(bgFormInfo.getId());
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                Map bgFormMap = this.getBgFormMap(ctx, conn, bgFormInfo, false);
                if (bgFormMap == null || bgFormMap.isEmpty()) {
                    ObjectUuidPK objectUuidPK = pk;
                    return objectUuidPK;
                }
                pstmt = conn.prepareStatement("update t_bg_bgform set FName = ? where fid = ?");
                int index = 0;
                for (BgFormInfo b : bgFormMap.values()) {
                    if (b == null || b.getId() == null) continue;
                    pstmt.setString(1, bgFormInfo.getName());
                    pstmt.setString(2, b.getId().toString());
                    pstmt.addBatch();
                    if (++index <= 200) continue;
                    index = 0;
                    pstmt.executeBatch();
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
            return pk;
        }
        return null;
    }

    @Override
    protected Map _getInitBgViewDimensionInfo(Context ctx, IBgDimensionManager bgDimensionManager, String bgViewId) throws BOSException, EASBizException {
        return this.getInitViewDimensionInfo(ctx, bgDimensionManager, bgViewId, false);
    }

    private Map getInitViewDimensionInfo(Context ctx, IBgDimensionManager bgDimensionManager, String bgViewId, boolean isAdjust) throws BOSException, EASBizException {
        if (bgDimensionManager == null || StringUtils.isEmpty((String)bgViewId)) {
            return null;
        }
        BgFormInfo bgForm = this.queryBgFormInfo(ctx, bgViewId);
        if (bgForm == null) {
            return null;
        }
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        resMap.put("BGPERIOD", BgViewServerHelper.queryBgViewBgPeriod(ctx, bgDimensionManager, bgForm));
        resMap.put("ORGUNIT", this.queryBgViewOrgUnit(ctx, bgDimensionManager, bgForm, isAdjust));
        resMap.put("BGITEM", BgViewServerHelper.queryBgViewBgItem(ctx, bgDimensionManager, bgForm.getOrgUnit().getId().toString(), BgSHelper.isBgItemIsolate((Context)ctx)));
        resMap.put("CURRENCY", this.queryBgViewCurrency(ctx, bgDimensionManager, bgForm));
        return resMap;
    }

    @Override
    protected Map _getInitBgAdjustViewDimensionInfo(Context ctx, IBgDimensionManager bgDimensionManager, String bgViewId) throws BOSException, EASBizException {
        return this.getInitViewDimensionInfo(ctx, bgDimensionManager, bgViewId, true);
    }

    private Map queryBgViewCurrency(Context ctx, IBgDimensionManager bgDimensionManager, BgFormInfo bgFormInfo) throws BOSException {
        HashMap<String, CurrencyInfo> resMap = new HashMap<String, CurrencyInfo>();
        if (bgDimensionManager != null) {
            BgDimensionInfo currency = null;
            for (int i = 0; i < bgDimensionManager.getDimension().size(); ++i) {
                if (!"CURRENCY".equalsIgnoreCase(((BgDimensionInfo)bgDimensionManager.getDimension().get(i)).getType())) continue;
                currency = (BgDimensionInfo)bgDimensionManager.getDimension().get(i);
            }
            HashSet<String> currNums = new HashSet<String>();
            currNums.add(bgFormInfo.getCurrency().getNumber());
            if (currency != null && !currency.getMember().isEmpty()) {
                for (int i = 0; i < currency.getMember().size(); ++i) {
                    currNums.add(((BgDimensionMember)currency.getMember().get(i)).getNumber());
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("precision");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", currNums, CompareType.INCLUDE));
            CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(evi);
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    resMap.put(col.get(i).getNumber(), col.get(i));
                }
            }
        }
        return resMap;
    }

    private Map queryBgViewOrgUnit(Context ctx, IBgDimensionManager bgDimensionManager, BgFormInfo bgForm, boolean isAdjust) throws BOSException, EASBizException {
        if (bgForm == null || bgDimensionManager == null) {
            return null;
        }
        String sql = "select org.fid, org.fnumber, org.fname_" + ctx.getLocale() + " fname, org.flevel, org.flongnumber \nfrom t_bg_bgform bgForm \nleft join t_bg_bgscheme bgScheme on bgScheme.fid = bgForm.fbgschemeid \nleft join t_bg_bgtemplate bgTemplate on bgTemplate.fid = bgForm.fbgtemplateid \nleft join t_org_costcenter org on org.fid = bgForm.forgunitid \nleft join t_bg_bgformentry entries on entries.fbgformid = bgForm.fid \nwhere bgScheme.FRootId = ? and bgTemplate.FRootId = ? and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId = ? ";
        if (isAdjust) {
            sql = sql + "and bgForm.fstate in (2,4,35)";
        }
        sql = bgForm.getEntries().get(0).getRollMethod() != null ? sql + " and entries.frollMethod != ? " : sql + " and entries.frollMethod = ? ";
        IRowSet rs = null;
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgForm.getBgScheme().getRootId().toString(), bgForm.getBgTemplate().getRootId().toString(), bgForm.getBgPeriod().getId().toString(), bgForm.getCurrency().getId().toString(), 0});
            while (rs.next()) {
                CostCenterOrgUnitInfo cost = new CostCenterOrgUnitInfo();
                cost.setId(BOSUuid.read((String)rs.getString("fid")));
                cost.setNumber(rs.getString("fnumber"));
                cost.setName(rs.getString("fname"));
                cost.setLevel(rs.getInt("flevel"));
                cost.setLongNumber(rs.getString("flongnumber"));
                orgMap.put(cost.getId().toString(), cost);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (orgMap != null && !orgMap.isEmpty()) {
            IObjectPK[] orgPKs = new IObjectPK[orgMap.size()];
            int index = 0;
            Iterator it = orgMap.keySet().iterator();
            while (it.hasNext()) {
                orgPKs[index++] = new ObjectStringPK((String)it.next());
            }
            String permNumber = "bg_form03_view";
            if ("addNew".equalsIgnoreCase(bgDimensionManager.getOprtState()) || "edit".equalsIgnoreCase(bgDimensionManager.getOprtState())) {
                permNumber = "bg_form04_update";
            }
            Set orgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPKs, permNumber);
            HashMap<String, Object> tempMap = orgMap;
            orgMap = new HashMap();
            if (orgIds != null && !orgIds.isEmpty()) {
                Iterator it2 = orgIds.iterator();
                while (it2.hasNext()) {
                    String orgId = String.valueOf(it2.next());
                    if (!tempMap.containsKey(orgId)) continue;
                    orgMap.put(orgId, tempMap.get(orgId));
                }
            }
        }
        return orgMap;
    }

    private BgFormInfo queryBgFormInfo(Context ctx, String bgViewId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.rootId");
        evi.getSelector().add("bgScheme.id");
        evi.getSelector().add("bgScheme.rootId");
        evi.getSelector().add("bgPeriod.id");
        evi.getSelector().add("bgPeriod.number");
        evi.getSelector().add("bgPeriod.name");
        evi.getSelector().add("bgPeriod.periodType");
        evi.getSelector().add("bgPeriod.level");
        evi.getSelector().add("bgPeriod.longNumber");
        evi.getSelector().add("currency.id");
        evi.getSelector().add("currency.number");
        evi.getSelector().add("currency.name");
        evi.getSelector().add("state");
        evi.getSelector().add("entries.rollMethod");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgViewId));
        BgFormCollection col = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(evi);
        if (col != null && !col.isEmpty()) {
            return col.get(0);
        }
        return null;
    }

    @Override
    protected Map _queryBgData(Context ctx, Map bgDataMap, String bgSchemeRootId) throws BOSException, EASBizException {
        if (bgDataMap == null || bgDataMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return new HashMap();
        }
        return BgViewServerHelper.queryBgDataInfo(ctx, bgDataMap, bgSchemeRootId);
    }

    @Override
    protected Map _queryWithBgActual(Context ctx, Map bgDataMap, String bgSchemeRootId) throws BOSException {
        if (bgDataMap == null || bgDataMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return new HashMap();
        }
        return BgViewServerHelper.queryBgDataInfo(ctx, bgDataMap, bgSchemeRootId, true, true);
    }

    @Override
    protected Map _queryHistoryBgDataAndActual(Context ctx, Map bgDataMap, String bgFormId) throws BOSException, EASBizException {
        if (bgDataMap == null || bgDataMap.isEmpty() || StringUtils.isEmpty((String)bgFormId)) {
            return new HashMap();
        }
        Map res = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        BgFormInfo bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), this.getHistoryBgDataAndActualSic());
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String bgSchemeRootId = bgFormInfo.getBgScheme().getRootId().toString();
        res = BgViewServerHelper.queryBgDataInfo(ctx, bgDataMap, bgSchemeRootId, true, true);
        Timestamp auditTime = bgFormInfo.getAuditTime();
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        this.replaceBgDataByAuditTime(ctx, (Map)res.get(orgUnitId), auditTime, orgUnitId, bgSchemeId);
        this.replaceBgActualByAuditTime(ctx, (Map)res.get(orgUnitId), auditTime, orgUnitId, bgSchemeId);
        return res;
    }

    private void replaceBgActualByAuditTime(Context ctx, Map bgDataMap, Timestamp auditTime, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT data.FFormula as FFormula , sum(record.FActualAmount) as FActualAmount ").append(" FROM T_BG_BGDATA data , T_BG_BGCTRLRECORD record ").append(" WHERE data.FID = record.FBgDataId AND record.FCreateTime > ? AND data.FOrgUnitId = ? AND data.FBgSchemeId = ? ").append(" AND data.FFormula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)strSql, (int)200).append(")");
        strSql.append(" GROUP BY data.FFormula");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String formula = null;
        BigDecimal actualAmount = null;
        BigDecimal bizActualValue = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(strSql.toString());
            Object[] params = bgDataMap.keySet().toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setTimestamp(1, auditTime);
                pstmt.setString(2, orgUnitId);
                pstmt.setString(3, bgSchemeId);
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)4, (int)i, (int)200, (Object[])params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    formula = rs.getString("FFormula");
                    actualAmount = rs.getBigDecimal("FActualAmount");
                    bizActualValue = ((BgNViewDataInfo)((Object)bgDataMap.get(formula))).getBizActual();
                    ((BgNViewDataInfo)((Object)bgDataMap.get(formula))).setBizActual(bizActualValue.add(actualAmount));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private void replaceBgDataByAuditTime(Context ctx, Map bgDataMap, Timestamp auditTime, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT pastdata.FFormula as FFormula ,sum(pastdata.FPastValue) as FPastValue ").append(" FROM T_BG_BGPASTRECORD pastrecord, T_BG_BGPASTDATA pastdata, T_BG_BGDATA data").append(" WHERE pastrecord.FID = pastdata.FPastRecordID AND pastdata.FBgDataID = data.FID ").append(" AND pastrecord.FCreateTime > ? AND data.FOrgUnitId = ? AND data.FBgSchemeId = ? AND data.FFormula in ( ");
        BgNSQLHelper.addPlaceHolder((StringBuffer)strSql, (int)200).append(")");
        strSql.append(" GROUP BY pastdata.FFormula");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String formula = null;
        BigDecimal pastValue = null;
        BigDecimal budgetValue = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(strSql.toString());
            Object[] params = bgDataMap.keySet().toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setTimestamp(1, auditTime);
                pstmt.setString(2, orgUnitId);
                pstmt.setString(3, bgSchemeId);
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)4, (int)i, (int)200, (Object[])params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    formula = rs.getString("FFormula");
                    pastValue = rs.getBigDecimal("FPastValue");
                    budgetValue = ((BgNViewDataInfo)((Object)bgDataMap.get(formula))).getBudgetValue();
                    ((BgNViewDataInfo)((Object)bgDataMap.get(formula))).setBudgetValue(budgetValue.subtract(pastValue));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private SelectorItemCollection getHistoryBgDataAndActualSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("orgUnit.id");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.id");
        sic.add("auditTime");
        return sic;
    }

    @Override
    protected Map _queryAdjustBgData(Context ctx, Map bgDataMap, String bgSchemeRootId) throws BOSException, EASBizException {
        if (bgDataMap == null || bgDataMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return new HashMap();
        }
        return BgViewServerHelper.queryBgTmpDataInfo(ctx, bgDataMap, bgSchemeRootId);
    }

    @Override
    protected Map _getDataChangeViewDimensionInfo(Context ctx, IBgDimensionManager bgDimensionManager, String bgViewId, String orgUnitId) throws BOSException, EASBizException {
        if (bgDimensionManager == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        resMap.put("BGITEM", BgViewServerHelper.queryBgViewBgItem(ctx, bgDimensionManager, orgUnitId, BgSHelper.isBgItemIsolate((Context)ctx)));
        resMap.put("BGPERIOD", BgViewServerHelper.queryBgViewBgPeriod(ctx, bgDimensionManager, this.queryForm(ctx, bgViewId, orgUnitId)));
        return resMap;
    }

    private BgFormInfo queryForm(Context ctx, String bgViewId, String orgUnitId) throws BOSException, EASBizException {
        SelectorItemCollection formSic = new SelectorItemCollection();
        formSic.add("bgTemplate.rootId");
        formSic.add("bgScheme.rootId");
        formSic.add("bgPeriod.id");
        formSic.add("currency.id");
        SelectorItemCollection periodSic = new SelectorItemCollection();
        periodSic.add("bgPeriod.number");
        periodSic.add("bgPeriod.periodType");
        Map formMap = BgFormFacadeFactory.getLocalInstance((Context)ctx).queryBgFormByOrgUnitId(BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgViewId), formSic), new Object[]{orgUnitId}, periodSic);
        return formMap.get(orgUnitId) == null ? null : (BgFormInfo)formMap.get(orgUnitId);
    }

    @Override
    protected void _saveBudget(Context ctx, BgFormInfo bgFormInfo, Map bgDataMap, Map deleteMap) throws BOSException, EASBizException {
        BgViewServerHelper.saveBudget(ctx, bgFormInfo, bgDataMap, deleteMap, null, true, true, null, null);
    }

    @Override
    protected Map _getDecSchemeCostCenterByBgViewForm(Context ctx, IObjectValue bgViewForm, String currencyOrgID) throws BOSException, EASBizException {
        int i;
        BigDecimal d;
        if (bgViewForm == null || StringUtils.isEmpty((String)currencyOrgID) || !(bgViewForm instanceof BgFormInfo)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longNumber");
        CostCenterOrgUnitInfo selectedOrg = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(currencyOrgID), sic);
        if (selectedOrg == null) {
            return null;
        }
        BgFormInfo info = (BgFormInfo)bgViewForm;
        BgSchemeInfo bgScheme = info.getBgScheme();
        BgPeriodInfo currPeriod = info.getBgPeriod();
        CurrencyInfo currInfo = info.getCurrency();
        String schemeRootId = bgScheme.getRootId().toString();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("rootid");
        view.getSelector().add("orgUnit.id");
        view.getSelector().add("orgUnit.name");
        view.getSelector().add("orgUnit.number");
        view.getSelector().add("orgUnit.longNumber");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("rootid", (Object)schemeRootId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.longNumber", (Object)(selectedOrg.getLongNumber() + "!%"), CompareType.LIKE));
        SorterItemInfo sore = new SorterItemInfo("orgUnit.longNumber");
        sore.setSortType(SortType.DESCEND);
        view.getSorter().add(sore);
        BgSchemeCollection bgSchemeCollection = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeCollection(view);
        if (bgSchemeCollection == null) {
            return null;
        }
        CostCenterOrgUnitCollection costCenters = new CostCenterOrgUnitCollection();
        costCenters.add(selectedOrg);
        Object orgInfo = null;
        HashSet<String> schemeId = new HashSet<String>();
        HashSet<String> childOrg = new HashSet<String>();
        HashSet<String> orgLongNumber = new HashSet<String>();
        for (int index = 0; index < bgSchemeCollection.size(); ++index) {
            schemeId.add(bgSchemeCollection.get(index).getId().toString());
            childOrg.add(bgSchemeCollection.get(index).getOrgUnit().getId().toString());
            orgLongNumber.add(bgSchemeCollection.get(index).getOrgUnit().getLongNumber());
        }
        StringBuffer sql = null;
        CostCenterOrgUnitInfo org = null;
        int count = 200;
        int size = childOrg.size();
        int bacth = 0;
        bacth = size <= count ? 1 : ((d = new BigDecimal(size).divide(new BigDecimal(count), 0)).compareTo(new BigDecimal(i = size / count)) > 0 ? i + 1 : i);
        boolean indexSize = false;
        Object[] objs = childOrg.toArray();
        if (objs.length != 0) {
            IRowSet result = null;
            int number = 0;
            for (int n = 0; n < bacth; ++n) {
                sql = new StringBuffer();
                sql.append("select fid,fname_" + ctx.getLocale() + ",fnumber ,flongnumber from t_org_costcenter where fid in (");
                for (int index = n * count; index < objs.length; ++index) {
                    sql.append("'").append(objs[index].toString()).append("',");
                    if (++number != count) continue;
                    number = 0;
                    break;
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (result.next()) {
                        org = new CostCenterOrgUnitInfo();
                        org.setId(BOSUuid.read((String)result.getString("fid")));
                        org.setName(result.getString("fname_" + ctx.getLocale()));
                        org.setNumber(result.getString("fnumber"));
                        org.setLongNumber(result.getString("flongnumber"));
                        costCenters.add(org);
                    }
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        EntityViewInfo nodeView = new EntityViewInfo();
        nodeView.setSelector(new SelectorItemCollection());
        nodeView.getSelector().add("id");
        nodeView.getSelector().add("bgtemplate.id");
        nodeView.getSelector().add("bgscheme.id");
        nodeView.setFilter(new FilterInfo());
        nodeView.getFilter().getFilterItems().add(new FilterItemInfo("bgscheme.id", schemeId, CompareType.INCLUDE));
        BgSchemeNodeCollection nodeColls = BgSchemeNodeFactory.getLocalInstance((Context)ctx).getBgSchemeNodeCollection(nodeView);
        BgSchemeNodeInfo nodeInfo = null;
        HashSet<BOSUuid> nodeTemId = new HashSet<BOSUuid>();
        for (int index = 0; index < nodeColls.size(); ++index) {
            nodeInfo = nodeColls.get(index);
            nodeTemId.add(nodeInfo.getBgTemplate().getId());
        }
        String bgTemplatRootId = info.getBgTemplate().getRootId().toString();
        EntityViewInfo bgTemView = new EntityViewInfo();
        bgTemView.setSelector(new SelectorItemCollection());
        bgTemView.getSelector().add("id");
        bgTemView.getSelector().add("name");
        bgTemView.getSelector().add("number");
        bgTemView.getSelector().add("formType");
        bgTemView.getSelector().add("rootId");
        bgTemView.getSelector().add("orgUnit.id");
        bgTemView.getSelector().add("orgUnit.name");
        bgTemView.getSelector().add("orgUnit.number");
        bgTemView.getSelector().add("orgUnit.longNumber");
        bgTemView.setFilter(new FilterInfo());
        bgTemView.getFilter().getFilterItems().add(new FilterItemInfo("rootId", (Object)bgTemplatRootId, CompareType.EQUALS));
        bgTemView.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", childOrg, CompareType.INCLUDE));
        bgTemView.getFilter().getFilterItems().add(new FilterItemInfo("id", nodeTemId, CompareType.INCLUDE));
        BgTemplateCollection temps = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateCollection(bgTemView);
        if (temps == null || temps.isEmpty()) {
            return null;
        }
        HashSet<String> temId = new HashSet<String>();
        for (int index = 0; index < temps.size(); ++index) {
            temId.add(temps.get(index).getId().toString());
        }
        EntityViewInfo haveFormOrgView = new EntityViewInfo();
        haveFormOrgView.setSelector(new SelectorItemCollection());
        haveFormOrgView.getSelector().add("id");
        haveFormOrgView.getSelector().add("name");
        haveFormOrgView.getSelector().add("number");
        haveFormOrgView.getSelector().add("state");
        haveFormOrgView.getSelector().add("bgPeriod");
        haveFormOrgView.getSelector().add("bgPeriod.id");
        haveFormOrgView.getSelector().add("currency.id");
        haveFormOrgView.getSelector().add("bgScheme.id");
        haveFormOrgView.getSelector().add("bgTemplate.id");
        haveFormOrgView.getSelector().add("bgTemplate.formType");
        haveFormOrgView.getSelector().add("orgUnit.id");
        haveFormOrgView.getSelector().add("orgUnit.name");
        haveFormOrgView.getSelector().add("orgUnit.number");
        haveFormOrgView.getSelector().add("orgUnit.longNumber");
        haveFormOrgView.getSelector().add("entries.rollMethod");
        haveFormOrgView.setFilter(new FilterInfo());
        haveFormOrgView.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", schemeId, CompareType.INCLUDE));
        haveFormOrgView.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.id", temId, CompareType.INCLUDE));
        haveFormOrgView.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)currPeriod.getId().toString(), CompareType.EQUALS));
        haveFormOrgView.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)currInfo.getId().toString(), CompareType.EQUALS));
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(5);
        stateSet.add(15);
        haveFormOrgView.getFilter().getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.NOTINCLUDE));
        haveFormOrgView.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate in ( 4 , 35 , 6 , 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        BgFormCollection bgFormColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(haveFormOrgView);
        String longNum = null;
        HashSet addOrgLongNumber = new HashSet();
        HashSet<String> temOrgSet = new HashSet<String>();
        temOrgSet.addAll(orgLongNumber);
        Iterator it = orgLongNumber.iterator();
        while (it.hasNext()) {
            longNum = it.next().toString();
            if (longNum.equals(selectedOrg.getLongNumber())) continue;
            this.dealCostCenterOrg(ctx, costCenters, temOrgSet, longNum, selectedOrg.getLongNumber());
        }
        EntityViewInfo viewEntity = new EntityViewInfo();
        viewEntity.setFilter(new FilterInfo());
        viewEntity.getFilter().getFilterItems().add(new FilterItemInfo("template.id", temId, CompareType.INCLUDE));
        viewEntity.getSelector().add("rollMethod");
        viewEntity.getSelector().add("template.id");
        BgViewDimensionCollection bgViewDimensionCol = BgViewDimensionFactory.getLocalInstance(ctx).getBgViewDimensionCollection(viewEntity);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BgScheme", bgSchemeCollection);
        map.put("BgOrgUnit", costCenters);
        map.put("BG_COLLECT", bgFormColl);
        map.put("BGTEMPLATE_INFO", temps);
        map.put("BGVIEWDIMENSION_INFO", (Object)bgViewDimensionCol);
        return map;
    }

    private void dealCostCenterOrg(Context ctx, CostCenterOrgUnitCollection costCenters, Set hadOrgLongNumber, String longNumber, String fatherOrgLongNumber) throws BOSException {
        if (costCenters == null || hadOrgLongNumber == null || StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)fatherOrgLongNumber)) {
            return;
        }
        if (longNumber.equals(fatherOrgLongNumber)) {
            return;
        }
        if (longNumber.split("!").length == 1) {
            return;
        }
        String upOrgLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        if (!hadOrgLongNumber.contains(upOrgLongNumber)) {
            this.queryCostCenterOrgUnit(ctx, costCenters, hadOrgLongNumber, upOrgLongNumber);
        }
        this.dealCostCenterOrg(ctx, costCenters, hadOrgLongNumber, upOrgLongNumber, fatherOrgLongNumber);
    }

    private void queryCostCenterOrgUnit(Context ctx, CostCenterOrgUnitCollection costCenters, Set hadOrgLongNumber, String longNumber) throws BOSException {
        if (costCenters == null || hadOrgLongNumber == null || StringUtils.isEmpty((String)longNumber)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
        CostCenterOrgUnitCollection colls = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(view);
        if (colls == null || colls.isEmpty()) {
            return;
        }
        CostCenterOrgUnitInfo info = null;
        for (int index = 0; index < colls.size(); ++index) {
            info = colls.get(index);
            costCenters.add(info);
            hadOrgLongNumber.add(info.getLongNumber());
        }
    }

    @Override
    protected void _batchAddForm(Context ctx, List formList, BgFormInfo editaData) throws BOSException, EASBizException {
        if (formList == null || formList.isEmpty() || editaData == null) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        Map bgForms = this.getBgFormMap(ctx, conn, editaData, true);
        ArrayList<BgFormInfo> newForms = new ArrayList<BgFormInfo>();
        String bgSchemeId = null;
        BgFormInfo newFormInfo = null;
        BgFormInfo bgFormInfo = null;
        for (int index = 0; index < formList.size(); ++index) {
            newFormInfo = (BgFormInfo)formList.get(index);
            bgSchemeId = newFormInfo.getBgScheme().getId().toString();
            if (!bgForms.containsKey(bgSchemeId)) continue;
            bgFormInfo = (BgFormInfo)bgForms.get(bgSchemeId);
            newForms.add(bgFormInfo);
        }
        if (newForms.isEmpty()) {
            return;
        }
        BgViewServerHelper.batchAddNewView(ctx, conn, formList, true);
    }

    @Override
    protected Map _queryAllFormulaByForm(Context ctx, BgFormInfo bgFormInfo, String orgUnitId, Set itemNum) throws BOSException, EASBizException {
        HashMap<String, BgNViewDataInfo> result = new HashMap<String, BgNViewDataInfo>();
        String formula = null;
        String[] parameter = null;
        String[] items = null;
        boolean isAdjustForm = false;
        BgFormInfo currentForm = (BgFormInfo)BgFormFacadeFactory.getLocalInstance((Context)ctx).queryBgFormByOrgUnitId(bgFormInfo, new Object[]{orgUnitId}).get(orgUnitId);
        Connection conn = this.getConnection(ctx);
        String sql = "SELECT data.FID, data.FBGSCHEMEID, data.FORGUNITID, data.FFORMULA, data.FBGVALUE, data.FDATASTATE FROM T_BG_BGDATAENTRY entry , T_BG_BGDATA data WHERE entry.FBGDATAID = data.FID and entry.FBGFORMID = ?";
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            pst = conn.prepareStatement(sql);
            pst.setString(1, currentForm.getId().toString());
            rst = pst.executeQuery();
            block4: while (rst.next()) {
                formula = rst.getString("fformula");
                parameter = BgNFSHelper.parseFormulaPara((String)formula);
                items = parameter[0].split(",");
                for (int i = 0; i < items.length; ++i) {
                    if (!itemNum.contains(items[i])) continue;
                    BgNViewDataInfo bgData = new BgNViewDataInfo(rst.getBigDecimal("fbgvalue"));
                    bgData.setId(rst.getString("fid"));
                    bgData.setOrgUnitId(rst.getString("forgunitid"));
                    bgData.setFormula(rst.getString("fformula"));
                    bgData.setState(rst.getInt("fdatastate"));
                    result.put(bgData.getFormula(), bgData);
                    continue block4;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)conn);
        return result;
    }

    @Override
    protected Map _splitByPeriod(Context ctx, Map parameter) throws BOSException, EASBizException {
        HashMap res = new HashMap();
        if (parameter.get("BgFormPeriodFilterParam") instanceof BgFormPeriodFilterParam && parameter.get("Orgs") instanceof List && parameter.get("BgFormInfo") instanceof BgFormInfo) {
            BgFormPeriodData data;
            BgFormPeriodFilterParam filterParam = (BgFormPeriodFilterParam)parameter.get("BgFormPeriodFilterParam");
            List orgList = (List)parameter.get("Orgs");
            BgFormInfo bgForm = (BgFormInfo)parameter.get("BgFormInfo");
            Set legalDataState = (Set)parameter.get("LegalDataState");
            boolean isAdjust = (Boolean)parameter.get("IsAdjust");
            Map legalPeriod = null;
            if (parameter.get("LegalPeriod") != null) {
                legalPeriod = (Map)parameter.get("LegalPeriod");
            }
            IBgDimensionManager bgDimensionManager = (IBgDimensionManager)parameter.get("BgDimensionManager");
            Map bgForms = BgFormFacadeFactory.getLocalInstance((Context)ctx).queryBgFormByOrgUnitId(bgForm, orgList.toArray());
            Map sourceFormulaValue = new HashMap();
            HashMap<String, BigDecimal> sourceParam = new HashMap<String, BigDecimal>();
            Map targetFormulaValue = new HashMap();
            HashMap<String, BigDecimal> targetParam = new HashMap<String, BigDecimal>();
            for (Object o : filterParam.getSourceData()) {
                data = (BgFormPeriodData)o;
                sourceParam.put(data.getBgPeriodInfo().getNumber(), data.getRateValue());
            }
            for (Object o : filterParam.getTargetData()) {
                data = (BgFormPeriodData)o;
                targetParam.put(data.getBgPeriodInfo().getNumber(), data.getRateValue());
            }
            Set formulas = BgViewServerHelper.getFormulasForView(ctx, bgDimensionManager, bgForm);
            for (Object o : bgForms.keySet()) {
                sourceFormulaValue.put(o, new HashMap());
                targetFormulaValue.put(o, new HashMap());
                for (Object formula : formulas) {
                    if (sourceParam.keySet().contains(this.getPeriodNum((String)formula))) {
                        ((Map)sourceFormulaValue.get(o)).put(formula, null);
                    }
                    if (!targetParam.keySet().contains(this.getPeriodNum((String)formula))) continue;
                    if (legalPeriod != null && legalPeriod.get(o) != null) {
                        if (!((Set)legalPeriod.get(o)).contains(this.getPeriodNum((String)formula))) continue;
                        ((Map)targetFormulaValue.get(o)).put(formula, null);
                        continue;
                    }
                    ((Map)targetFormulaValue.get(o)).put(formula, null);
                }
            }
            targetFormulaValue = this.filterFormula(ctx, targetFormulaValue, legalDataState, bgForm.getBgScheme().getRootId().toString());
            sourceFormulaValue = BgViewServerHelper.queryLatestBgDataInfo(ctx, sourceFormulaValue, bgForm.getBgScheme().getRootId().toString(), isAdjust);
            for (Object orgId : targetFormulaValue.keySet()) {
                Map formulaValue = (Map)targetFormulaValue.get(orgId);
                for (Object formula : formulaValue.keySet()) {
                    formulaValue.put(formula, this.getSplitNewValue(sourceFormulaValue, sourceParam, targetParam, (String)orgId, (String)formula));
                }
            }
            res.put("targetFormulaValue", targetFormulaValue);
            HashMap bgFormInfos = new HashMap();
            BgFormInfo oldForm = null;
            BgFormInfo newForm = null;
            for (Object orgId : bgForms.keySet()) {
                oldForm = (BgFormInfo)bgForms.get(orgId);
                newForm = new BgFormInfo();
                newForm.setId(oldForm.getId());
                newForm.setBgScheme(new BgSchemeInfo());
                newForm.getBgScheme().setId(oldForm.getBgScheme().getId());
                newForm.setOrgUnit(new FullOrgUnitInfo());
                newForm.getOrgUnit().setId(oldForm.getOrgUnit().getId());
                bgFormInfos.put(orgId, newForm);
            }
            res.put("bgFormInfos", bgFormInfos);
        }
        return res;
    }

    private Map filterFormula(Context ctx, Map formulaMap, Set legalDataState, String bgSchemeRootId) throws BOSException {
        if (formulaMap == null || formulaMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId) || legalDataState == null || legalDataState.isEmpty()) {
            return formulaMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bgData.forgunitid, bgData.fformula, bgData.fdatastate ");
        sql.append("from t_bg_bgdata bgData ").append("left join t_bg_bgscheme bgScheme on bgScheme.fid = bgData.fbgschemeid ").append("where bgData.forgunitid = ? and bgScheme.forgunitid = ? and bgScheme.FRootId = ? ").append(" and bgData.FDataState in(");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)legalDataState.size()).append(") ");
        sql.append(" and bgData.fformula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(") ");
        HashMap resMap = new HashMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String orgId : formulaMap.keySet()) {
                if (!resMap.containsKey(orgId)) {
                    resMap.put(orgId, new HashMap());
                }
                Map subMap = (Map)resMap.get(orgId);
                Object[] params = ((Map)formulaMap.get(orgId)).keySet().toArray();
                if (params == null || params.length <= 0) continue;
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, orgId);
                    pstmt.setString(2, orgId);
                    pstmt.setString(3, bgSchemeRootId);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)4, (int)0, (int)legalDataState.size(), (Object[])legalDataState.toArray());
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)(4 + legalDataState.size()), (int)i, (int)200, (Object[])params);
                    long t = System.currentTimeMillis();
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        subMap.put(res.getString("fformula"), null);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return resMap;
    }

    private BigDecimal getSplitNewValue(Map sourceFormulaValue, Map sourceParam, Map targetParam, String orgId, String fomulaStr) {
        BigDecimal value = BigDecimal.ZERO;
        String[] parameter = BgNFSHelper.parseFormulaPara((String)fomulaStr);
        String[] parameterCopy = (String[])parameter.clone();
        for (Object periodNum : sourceParam.keySet()) {
            parameterCopy[1] = (String)periodNum;
            BigDecimal sourceValue = null;
            sourceValue = ((Map)sourceFormulaValue.get(orgId)).get(BgNFSHelper.getFormulaFromParam((String[])parameterCopy)) == null ? BigDecimal.ZERO : ((BgNViewDataInfo)((Object)((Map)sourceFormulaValue.get(orgId)).get(BgNFSHelper.getFormulaFromParam((String[])parameterCopy)))).getBudgetValue();
            value = value.add(sourceValue.multiply(((BigDecimal)sourceParam.get(periodNum)).divide(BgConstants.HUNDRED)));
        }
        value = value.multiply(((BigDecimal)targetParam.get(BgNFSHelper.parseFormulaPara((String)fomulaStr)[1])).divide(BgConstants.HUNDRED));
        return value;
    }

    private String getPeriodNum(String fomulaStr) {
        String[] parameter = BgNFSHelper.parseFormulaPara((String)fomulaStr);
        return parameter[1];
    }

    @Override
    protected Map _batchQueryAllPeriodMember(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds) throws BOSException, EASBizException {
        Map bgFormMap = BgFormFacadeFactory.getLocalInstance((Context)ctx).queryBgFormByOrgUnitId(bgFormInfo, orgIds, this.getSic());
        bgFormMap.put(bgFormInfo.getOrgUnit().getId().toString(), BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId().toString()), this.getSic()));
        return this.getAllPeriodNum(ctx, bgFormMap);
    }

    @Override
    protected Map _batchQueryAllPeriodMemberForHistory(Context ctx, String bgFormId, Object[] orgIds) throws BOSException, EASBizException {
        Map bgFormMap = this.queryBgFormByOrgUnitIdBeforAuditTime(ctx, bgFormId, orgIds);
        return this.getAllPeriodNum(ctx, bgFormMap);
    }

    private Map queryBgFormByOrgUnitIdBeforAuditTime(Context ctx, String bgFormId, Object[] orgIds) throws EASBizException, BOSException {
        IBgForm ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgTemplate.rootId");
        sic.add("bgScheme.rootId");
        sic.add("bgPeriod.id");
        sic.add("currency.id");
        sic.add("createTime");
        BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootId", (Object)bgFormInfo.getBgTemplate().getRootId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootId", (Object)bgFormInfo.getBgScheme().getRootId().toString(), CompareType.EQUALS));
        HashSet<Object> orgIdSet = new HashSet<Object>();
        for (int i = 0; i < orgIds.length; ++i) {
            orgIdSet.add(orgIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgFormInfo.getCurrency().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)bgFormInfo.getCreateTime(), CompareType.LESS_EQUALS));
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(6);
        stateSet.add(35);
        stateSet.add(4);
        stateSet.add(101);
        filter.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.NOTINCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getSic());
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo createTimeItem = new SorterItemInfo("createTime");
        createTimeItem.setSortType(SortType.DESCEND);
        sorter.add(createTimeItem);
        viewInfo.setSorter(sorter);
        BgFormCollection bgFormCol = ibgForm.getBgFormCollection(viewInfo);
        String orgId = null;
        for (int i = 0; i < bgFormCol.size(); ++i) {
            orgId = bgFormCol.get(i).getOrgUnit().getId().toString();
            if (bgFormMap.containsKey(orgId)) continue;
            bgFormMap.put(orgId, bgFormCol.get(i));
        }
        return bgFormMap;
    }

    private SelectorItemCollection getSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("currency.id");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgRollPeriod.number");
        sic.add("entries.rollMethod");
        sic.add("entries.dimensionData");
        sic.add("entries.rollType");
        sic.add("entries.rollType");
        sic.add("entries.rollStep");
        sic.add("entries.rollLength");
        return sic;
    }

    private Map getAllPeriodNum(Context ctx, Map bgFormMap) throws BgFormException, BOSException, EASBizException {
        HashMap res = new HashMap();
        res.put("PeriodNumSet", new HashMap());
        res.put("BgFormInfo", new HashMap());
        String orgUnitId = null;
        BgFormInfo formInfo = null;
        IBudgetView view = null;
        BgDimensionManagerImpl dimensionManager = null;
        HashSet periodNumSet = null;
        for (Object o : bgFormMap.keySet()) {
            orgUnitId = (String)o;
            formInfo = (BgFormInfo)bgFormMap.get(o);
            view = BudgetViewLoaderImpl.getIntance();
            dimensionManager = new BgDimensionManagerImpl();
            try {
                view.load(dimensionManager, formInfo.getEntries().get(0).getDimensionData());
            }
            catch (Exception e) {
                throw new BgFormException(BgFormException.NODATA, (Throwable)e);
            }
            periodNumSet = new HashSet();
            periodNumSet.addAll(BgViewServerHelper.queryBgViewBgPeriod(ctx, dimensionManager, formInfo).keySet());
            ((Map)res.get("PeriodNumSet")).put(orgUnitId, periodNumSet);
            ((Map)res.get("BgFormInfo")).put(orgUnitId, formInfo);
        }
        return res;
    }
}

