/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgDataStateEnum;
import com.kingdee.eas.ma.budget.BgDataSynStateBizHelper;
import com.kingdee.eas.ma.budget.BgFormEntryInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.app.BgDataHelper;
import com.kingdee.eas.ma.view.BgBillIntegrateFormInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFacadeFactory;
import com.kingdee.eas.ma.view.BgDataEntryInfo;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgViewServerHelper {
    private static final Logger logger = Logger.getLogger((String)BgViewServerHelper.class.getName());

    public static Set getFormulasForView(Context ctx, IBgDimensionManager bgDimensionManager, BgFormInfo formInfo) throws EASBizException, BOSException {
        Map cacheMap = BgViewFacadeFactory.getLocalInstance(ctx).getInitBgViewDimensionInfo(bgDimensionManager, formInfo.getId().toString());
        BgViewCommonHelper.fillDimensionMember(bgDimensionManager, cacheMap, BgSHelper.isBgItemIsolate((Context)ctx), formInfo.getOrgUnit().getId().toString(), formInfo.getBgPeriod(), formInfo.getCurrency(), true);
        ArrayList formulas = new ArrayList();
        List resultFormula = BgViewCommonHelper.buildFormula(bgDimensionManager.getDimension(), 0, formulas);
        Object[] currentFormulaInfo = null;
        HashSet<String> formulaSet = new HashSet<String>();
        String formula = null;
        for (Object o : resultFormula) {
            currentFormulaInfo = (Object[])o;
            formula = BgViewCommonHelper.parseItemFormula((String)currentFormulaInfo[0], (String)currentFormulaInfo[1], (String)currentFormulaInfo[2], (Map)currentFormulaInfo[3]);
            formulaSet.add(formula);
        }
        return formulaSet;
    }

    public static List buildFormula(List<BgDimensionInfo> allDimension, int start, List formulas) {
        if (formulas == null) {
            formulas = new ArrayList();
        }
        if (start == allDimension.size()) {
            return formulas;
        }
        List members = allDimension.get(start).getMember();
        List<Object[]> result = new ArrayList();
        HashMap<Integer, String> _item = null;
        String _element = null;
        String _period = null;
        String _currency = null;
        Object[] curFormula2 = null;
        BgDimensionMember curMemeber2 = null;
        if (start == 0) {
            for (BgDimensionMember curMemeber2 : members) {
                curFormula2 = new Object[4];
                if ("bgitem".equalsIgnoreCase(curMemeber2.getType())) {
                    _item = new HashMap<Integer, String>();
                    _item.put(new Integer(curMemeber2.getAttribute().toUpperCase().replaceAll("F", "")), curMemeber2.getNumber());
                    curFormula2[3] = _item;
                } else if ("bgperiod".equalsIgnoreCase(curMemeber2.getType())) {
                    _period = "BGPERIOD".equals(curMemeber2.getNumber()) ? "" : curMemeber2.getNumber();
                    curFormula2[2] = _period;
                } else if ("bgelement".equalsIgnoreCase(curMemeber2.getType())) {
                    _element = curMemeber2.getNumber();
                    curFormula2[0] = _element;
                } else if ("currency".equalsIgnoreCase(curMemeber2.getType())) {
                    _currency = curMemeber2.getNumber();
                    curFormula2[1] = _currency;
                }
                result.add(curFormula2);
            }
        } else {
            for (Object[] curFormula2 : formulas) {
                for (BgDimensionMember curMemeber2 : members) {
                    Object[] newFormula = new Object[4];
                    if (curFormula2[0] != null) {
                        newFormula[0] = curFormula2[0];
                    }
                    if (curFormula2[1] != null) {
                        newFormula[1] = curFormula2[1];
                    }
                    if (curFormula2[2] != null) {
                        newFormula[2] = curFormula2[2];
                    }
                    if (curFormula2[3] != null) {
                        HashMap newItemMap = new HashMap();
                        newItemMap.putAll((Map)curFormula2[3]);
                        newFormula[3] = newItemMap;
                    }
                    if ("bgitem".equalsIgnoreCase(curMemeber2.getType())) {
                        if (newFormula[3] == null) {
                            newFormula[3] = new HashMap();
                        }
                        ((Map)newFormula[3]).put(new Integer(curMemeber2.getAttribute().toUpperCase().replaceAll("F", "")), curMemeber2.getNumber());
                    } else if ("bgperiod".equalsIgnoreCase(curMemeber2.getType())) {
                        _period = "BGPERIOD".equals(curMemeber2.getNumber()) ? "" : curMemeber2.getNumber();
                        newFormula[2] = _period;
                    } else if ("bgelement".equalsIgnoreCase(curMemeber2.getType())) {
                        _element = curMemeber2.getNumber();
                        newFormula[0] = _element;
                    } else if ("currency".equalsIgnoreCase(curMemeber2.getType())) {
                        _currency = curMemeber2.getNumber();
                        newFormula[1] = _currency;
                    }
                    result.add(newFormula);
                }
            }
        }
        if (start + 1 < allDimension.size()) {
            result = BgViewServerHelper.buildFormula(allDimension, start + 1, result);
        }
        return result;
    }

    public static Set queryExistRelation(Context ctx, String formId, Set dataId, boolean isBgData) throws BOSException, EASBizException {
        HashSet<String> result = new HashSet<String>();
        StringBuffer selSql = new StringBuffer();
        if (isBgData) {
            selSql.append("SELECT FBGDATAID as FID FROM T_BG_BGDATAENTRY WHERE FBGFORMID = '" + formId + "' AND FBGDATAID IN (");
        }
        BgNSQLHelper.addPlaceHolder((StringBuffer)selSql, (int)200).append(")");
        Object[] paraArr = dataId.toArray();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(selSql.toString());
            int batchCount = (dataId.size() - 1) / 200 + 1;
            String fid = null;
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)1, (int)i, (int)200, (Object[])paraArr);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    fid = rst.getString("FID");
                    if (result.contains(fid)) continue;
                    result.add(fid);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    public static Set queryExitFormulaByItem(Context ctx, Set delItemNum, boolean isBgData, String viewId) throws BOSException, EASBizException {
        HashSet<String> resultSet = new HashSet<String>();
        String selSql = null;
        selSql = isBgData ? "SELECT data.FID, data.FFormula FROM T_BG_BGDATAENTRY entry , T_BG_BGDATA data WHERE entry.FBGDATAID = data.FID and entry.FBGFORMID = ?" : "SELECT FID, FFormula FROM T_BG_BGTMPDATA WHERE FBGFORMID = ? ";
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String formula = null;
        String id = null;
        String[] parameter = null;
        String[] items = null;
        Object item = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstm = conn.prepareStatement(selSql.toString());
            pstm.setString(1, viewId);
            rs = pstm.executeQuery();
            block4: while (rs.next()) {
                formula = rs.getString("FFormula");
                id = rs.getString("FID");
                parameter = BgNFSHelper.parseFormulaPara((String)formula);
                items = parameter[0].split(",");
                for (int i = 0; i < items.length; ++i) {
                    if (!delItemNum.contains(items[i])) continue;
                    if (resultSet.contains(id)) continue block4;
                    resultSet.add(id);
                    continue block4;
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return resultSet;
    }

    public static Set queryExitFormulaByItem(Context ctx, List<BgDimensionInfo> allDimensionList, Set addItemNum, String orgUnitId, String bgSchemeId, String tableName) throws BOSException, EASBizException {
        if (addItemNum == null || addItemNum.size() == 0 || allDimensionList == null || allDimensionList.size() == 0) {
            return new HashSet();
        }
        HashSet<String> resultSet = new HashSet<String>();
        HashSet<String> bgPeriodNum = new HashSet<String>();
        HashSet<String> bgCurrencyNum = new HashSet<String>();
        HashSet<String> bgElementNum = new HashSet<String>();
        HashSet<String> bgItemNum = new HashSet<String>();
        List members = null;
        for (BgDimensionInfo dimensionInfo : allDimensionList) {
            if ("BGITEM".equalsIgnoreCase(dimensionInfo.getType())) {
                members = dimensionInfo.getMember();
                for (BgDimensionMember member : members) {
                    bgItemNum.add(member.getNumber());
                }
                continue;
            }
            if ("BGELEMENT".equalsIgnoreCase(dimensionInfo.getType())) {
                members = dimensionInfo.getMember();
                for (BgDimensionMember member : members) {
                    bgElementNum.add(member.getNumber());
                }
                continue;
            }
            if ("BGPERIOD".equalsIgnoreCase(dimensionInfo.getType())) {
                members = dimensionInfo.getMember();
                for (BgDimensionMember member : members) {
                    bgPeriodNum.add(member.getNumber());
                }
                continue;
            }
            if (!"CURRENCY".equalsIgnoreCase(dimensionInfo.getType())) continue;
            members = dimensionInfo.getMember();
            for (BgDimensionMember member : members) {
                bgCurrencyNum.add(member.getNumber());
            }
        }
        if (bgPeriodNum.size() == 0 || bgCurrencyNum.size() == 0 || bgElementNum.size() == 0 || bgItemNum.size() == 0) {
            return new HashSet();
        }
        StringBuffer selSql = new StringBuffer("SELECT FID , FFormula FROM " + tableName + " WHERE FOrgUnitId = ? AND FBgSchemeId = ? ");
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String formula = null;
        String id = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstm = conn.prepareStatement(selSql.toString());
            pstm.setString(1, orgUnitId);
            pstm.setString(2, bgSchemeId);
            rs = pstm.executeQuery();
            String[] parameter = null;
            String[] items = null;
            String item = null;
            String bgPeriod = null;
            String bgElement = null;
            String currency = null;
            boolean isInAddItemNum = false;
            ArrayList<Boolean> isAllItemsContain = new ArrayList<Boolean>();
            while (rs.next()) {
                formula = rs.getString("FFormula");
                id = rs.getString("FID");
                parameter = BgNFSHelper.parseFormulaPara((String)formula);
                items = parameter[0].split(",");
                bgPeriod = parameter[1];
                bgElement = parameter[2];
                currency = parameter[5];
                for (int pos = 0; pos < items.length; ++pos) {
                    item = items[pos];
                    if (bgItemNum.contains(item)) {
                        isAllItemsContain.add(true);
                    }
                    if (!addItemNum.contains(item)) continue;
                    isInAddItemNum = true;
                }
                if (isInAddItemNum && isAllItemsContain.size() == items.length && bgPeriodNum.contains(bgPeriod) && bgElementNum.contains(bgElement) && bgCurrencyNum.contains(currency)) {
                    resultSet.add(id);
                }
                isAllItemsContain.clear();
                isInAddItemNum = false;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return resultSet;
    }

    public static StringBuffer getQuerySQL() {
        StringBuffer sql = new StringBuffer("select bgForm.FID bgForm_FID, bgForm.FNumber bgForm_FNumber, bgForm.FName bgForm_FName, bgForm.FDescription bgForm_FDescription, bgForm.FState bgForm_FState, ");
        sql.append(" bgScheme.FID bgScheme_FID, bgScheme.FOrgUnitId bgScheme_FOrgUnitId, bgTemplate.FID bgTemplate_FID,");
        sql.append(" bgTemplate.FLastUpdateTime bgTemplate_FLastUpdateTime, bgTemplate.FBgTypeId bgTemplate_FBgTypeId, ");
        sql.append(" bgTemplate.FDefaultMeasureUnitID bgTemplate_FDMUID, bgForm.FBgPeriodId bgForm_FBgPeriodId, bgForm.FCurrencyID bgForm_FCurrencyID,");
        sql.append(" bgForm.FCreatorID bgForm_FCreatorID ");
        sql.append(" from t_bg_bgschemenode schemeNode ");
        sql.append(" left join t_bg_bgscheme bgScheme on bgScheme.FID = schemeNode.FBgSchemeID ");
        sql.append(" left join t_bg_bgTemplate bgTemplate on bgTemplate.FID = schemeNode.FBgTemplateID ");
        sql.append(" left join t_bg_bgform bgForm on bgForm.FBgSchemeId = bgScheme.FID and bgForm.FBgTemplateId = bgTemplate.FID ");
        return sql;
    }

    public static BgFormInfo buildBgFormInfo(ResultSet res) throws SQLException {
        BgFormInfo b = new BgFormInfo();
        if (!StringUtils.isEmpty((String)res.getString("bgForm_FID"))) {
            b.setId(BOSUuid.read((String)res.getString("bgForm_FID")));
            b.setNumber(res.getString("bgForm_FNumber"));
            b.setName(res.getString("bgForm_FName"));
            b.setDescription(res.getString("bgForm_FDescription"));
            b.setBgPeriod(new BgPeriodInfo());
            b.getBgPeriod().setId(BOSUuid.read((String)res.getString("bgForm_FBgPeriodId")));
            b.setCurrency(new CurrencyInfo());
            b.getCurrency().setId(BOSUuid.read((String)res.getString("bgForm_FCurrencyID")));
            b.setState(BgFormStateEnum.getEnum((int)res.getInt("bgForm_FState")));
        }
        b.setBgScheme(new BgSchemeInfo());
        b.getBgScheme().setId(BOSUuid.read((String)res.getString("bgScheme_FID")));
        b.setOrgUnit(new FullOrgUnitInfo());
        b.getOrgUnit().setId(BOSUuid.read((String)res.getString("bgScheme_FOrgUnitId")));
        b.setBgTemplate(new BgTemplateInfo());
        b.getBgTemplate().setId(BOSUuid.read((String)res.getString("bgTemplate_FID")));
        b.setTemplateLastUpdateTime(res.getTimestamp("bgTemplate_FLastUpdateTime"));
        if (!StringUtils.isEmpty((String)res.getString("bgTemplate_FBgTypeId"))) {
            b.setBgType(new BgTypeInfo());
            b.getBgType().setId(BOSUuid.read((String)res.getString("bgTemplate_FBgTypeId")));
        }
        b.setMeasureUnit(new MeasureUnitInfo());
        b.getMeasureUnit().setId(BOSUuid.read((String)res.getString("bgTemplate_FDMUID")));
        if (res.getString("bgForm_FCreatorID") != null) {
            b.setCreator(new UserInfo());
            b.getCreator().setId(BOSUuid.read((String)res.getString("bgForm_FCreatorID")));
        }
        return b;
    }

    public static void batchAddNewView(Context ctx, Connection conn, List newForms, boolean isCheckNumber) throws BOSException, EASBizException {
        if (ctx != null && !newForms.isEmpty()) {
            boolean closeConn = false;
            try {
                if (conn == null) {
                    closeConn = true;
                    conn = EJBFactory.getConnection((Context)ctx);
                }
                if (isCheckNumber) {
                    BgViewServerHelper.checkNumber(ctx, conn, newForms);
                }
                BgViewServerHelper.fillRptPeriod(ctx, newForms);
                BgViewServerHelper.fillOrgInfo(ctx, conn, newForms);
                BgViewServerHelper.batchAddNew(ctx, conn, newForms);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (closeConn) {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
    }

    private static void checkNumber(Context ctx, Connection conn, List newForms) throws BOSException, EASBizException {
        int i;
        BgFormInfo b;
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashMap<String, Set> numbers = new HashMap<String, Set>();
        for (int i2 = 0; i2 < newForms.size(); ++i2) {
            b = (BgFormInfo)newForms.get(i2);
            if (!numbers.containsKey(b.getNumber())) {
                numbers.put(b.getNumber(), new HashSet());
            }
            ((Set)numbers.get(b.getNumber())).add(b.getOrgUnit().getId().toString());
        }
        Object[] ns = numbers.keySet().toArray();
        for (i = 0; i < ns.length; ++i) {
            String number = (String)ns[i];
            Set orgIds = (Set)numbers.get(ns[i]);
            if ((orgIds = BgViewServerHelper.checkNumber(ctx, conn, "FNumber", number, "FOrgUnitID", orgIds, false)) == null) {
                numbers.remove(number);
                continue;
            }
            numbers.put(number, orgIds);
        }
        for (i = newForms.size() - 1; i >= 0; --i) {
            Set orgIds;
            b = (BgFormInfo)newForms.get(i);
            if (numbers.get(b.getNumber()) == null || !(orgIds = (Set)numbers.get(b.getNumber())).contains(b.getOrgUnit().getId().toString())) continue;
            newForms.remove(i);
        }
    }

    private static void fillRptPeriod(Context ctx, List newForms) throws BOSException, EASBizException {
        int i;
        BgFormInfo b;
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashSet<String> periodIds = new HashSet<String>();
        for (int i2 = 0; i2 < newForms.size(); ++i2) {
            b = (BgFormInfo)newForms.get(i2);
            periodIds.add(String.valueOf(b.getBgPeriod().getId()));
        }
        HashMap<String, BgPeriodInfo> bgPeriods = new HashMap<String, BgPeriodInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("periodType");
        evi.getSelector().add("year");
        evi.getSelector().add("month");
        evi.getSelector().add("halfYear");
        evi.getSelector().add("quart");
        evi.getSelector().add("beginDate");
        evi.getSelector().add("endDate");
        evi.getSelector().add("week");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
        if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
            for (i = 0; i < bgPeriodCol.size(); ++i) {
                bgPeriods.put(bgPeriodCol.get(i).getId().toString(), bgPeriodCol.get(i));
            }
        }
        for (i = 0; i < newForms.size(); ++i) {
            b = (BgFormInfo)newForms.get(i);
            b.setBgPeriod((BgPeriodInfo)bgPeriods.get(b.getBgPeriod().getId().toString()));
            BgViewCommonHelper.converPeriodToRPT(b);
        }
    }

    private static void fillOrgInfo(Context ctx, Connection conn, List newForms) throws BOSException, EASBizException {
        if (conn == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashMap orgInfo = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < newForms.size(); ++i) {
            ids.add(String.valueOf(((BgFormInfo)newForms.get(i)).getOrgUnit().getId()));
        }
        PreparedStatement pstmt = null;
        try {
            StringBuffer sql = new StringBuffer("Select FID, FControlUnitID, FParentID, FIsCompanyOrgUnit From T_Org_CostCenter Where FID IN(");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            BgViewServerHelper.queryOrgInfo(pstmt, ids, orgInfo);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        for (int i = 0; i < newForms.size(); ++i) {
            BgFormInfo b = (BgFormInfo)newForms.get(i);
            b.setCU(((FullOrgUnitInfo)orgInfo.get(b.getOrgUnit().getId().toString())).getCU());
            b.setCompany(new CompanyOrgUnitInfo());
            b.getCompany().setId(BgViewServerHelper.getCompanyId(b.getOrgUnit().getId().toString(), orgInfo));
        }
    }

    private static BOSUuid getCompanyId(String id, Map orgInfo) {
        if (StringUtils.isEmpty((String)id) || orgInfo == null || !orgInfo.containsKey(id)) {
            return null;
        }
        FullOrgUnitInfo org = (FullOrgUnitInfo)orgInfo.get(id);
        if (org.isIsCompanyOrgUnit()) {
            return org.getId();
        }
        if (org.getParent() == null) {
            return null;
        }
        return BgViewServerHelper.getCompanyId(org.getParent().getId().toString(), orgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryOrgInfo(PreparedStatement pstmt, Set ids, Map orgInfo) throws SQLException {
        if (pstmt == null || ids == null || ids.isEmpty() || orgInfo == null) {
            return;
        }
        ids.removeAll(orgInfo.keySet());
        if (ids.isEmpty()) {
            return;
        }
        Object[] params = ids.toArray();
        int batchCount = (params.length - 1) / 200 + 1;
        HashSet<String> newIds = new HashSet<String>();
        ResultSet res = null;
        try {
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)200, (Object[])params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    FullOrgUnitInfo org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)res.getString("FID")));
                    org.setIsCompanyOrgUnit(res.getBoolean("FIsCompanyOrgUnit"));
                    org.setCU(new CtrlUnitInfo());
                    org.getCU().setId(BOSUuid.read((String)res.getString("FControlUnitID")));
                    if (!StringUtils.isEmpty((String)res.getString("FParentID"))) {
                        org.setParent(new FullOrgUnitInfo());
                        org.getParent().setId(BOSUuid.read((String)res.getString("FParentID")));
                    }
                    if (!org.isIsCompanyOrgUnit() && org.getParent() != null) {
                        newIds.add(org.getParent().getId().toString());
                    }
                    orgInfo.put(org.getId().toString(), org);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        finally {
            SQLUtils.cleanup(res);
        }
        BgViewServerHelper.queryOrgInfo(pstmt, newIds, orgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void batchAddNew(Context ctx, Connection conn, List newForms) throws BOSException, EASBizException {
        if (ctx == null || conn == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        String tempForm = null;
        try {
            tempForm = BgViewServerHelper.createTempFormTable(ctx, conn);
            BgViewServerHelper.insertTempFormTable(ctx, conn, tempForm, newForms);
            BgViewServerHelper.updateTempFormXml(ctx, conn, tempForm);
            BgViewServerHelper.insertIntoBgFormTable(ctx, conn, tempForm);
            BgViewServerHelper.batchExtractData(ctx, newForms);
        }
        finally {
            if (tempForm != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempForm);
            }
        }
    }

    private static void batchExtractData(Context ctx, List newForms) throws BOSException, EASBizException {
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        ArrayList<String> bgFormIds = new ArrayList<String>();
        for (int i = 0; i < newForms.size(); ++i) {
            bgFormIds.add(String.valueOf(((BgFormInfo)newForms.get(i)).getId()));
        }
        BgBillIntegrateSchemeFacadeFactory.getLocalInstance(ctx).batchExtractData(bgFormIds);
    }

    private static String createTempFormTable(Context ctx, Connection conn) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String sql = "Create Table T_BG_BgFormTemp (FID VARCHAR(44) ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName NVARCHAR(80),FNumber NVARCHAR(80),FDescription NVARCHAR(80),FYear INT,FPeriod INT,FStartDate DateTime,FEndDate DateTime,FAuditorID VARCHAR(44),FTemplateID VARCHAR(44),FCompanyID VARCHAR(44),FPeriodType INT,FPublicStatus INT,FPublishedStatus INT,FCommittedStatus INT,FHandleStatus INT,FSourceType INT,FOrgTreeID VARCHAR(44),FCurrencyID VARCHAR(44),FAuditedTime DateTime,FAuditedStatus INT,FCheckedStatus INT,FData BLOB(10485760),FAdjustMapData BLOB(1048576),FDataSource INT,FState INT,FExecuteState INT DEFAULT 0,FBgSchemeID VARCHAR(44),FBgTemplateID VARCHAR(44),FBgPeriodID VARCHAR(44),FOrgUnitID VARCHAR(44),FBgTypeID VARCHAR(44),FMeasureUnitID VARCHAR(44),FVersionNo NUMERIC(21,8) ,FAdjustID VARCHAR(44),FTemplateLastUpdateTime DateTime NOT NULL ,FXNum VARCHAR(100) ,FIsChangeType INT ,FCourseOrgId VARCHAR(44),FCourseUserId VARCHAR(44),FCourseTime DateTime,FCertificateUserId VARCHAR(44),FCertificateTime DateTime,FBackUserId VARCHAR(44),FBackTime DateTime,FStateBeforeAudit INT,FBgItemGroupID VARCHAR(44),FRecord INT ,FBgItemID VARCHAR(44), FEntryID varchar(44), FDimensionData BLOB(10485760), FRollMethod INT, FRollType INT, FRollStep INT, FRollLength INT, FOverFlow INT,FFixedLength INT, FBgRollPeriodID VARCHAR(44))";
        try {
            return pool.createTempTable(sql);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private static void insertTempFormTable(Context ctx, Connection conn, String tempForm, List newForms) throws BOSException, EASBizException {
        if (ctx == null || conn == null || tempForm == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        BOSObjectType bosType = new BgFormEntryInfo().getBOSType();
        int batchCount = 100;
        PreparedStatement pstmt = null;
        Object[] fs = BgViewServerHelper.getInsertFormFields();
        StringBuffer sql = new StringBuffer("INSERT INTO ").append(tempForm).append("(");
        BgViewCommonHelper.convertArray(fs, sql);
        sql.append(", FEntryId) values (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)(fs.length + 1)).append(")");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int index = 0;
            for (int i = 0; i < newForms.size(); ++i) {
                BgFormInfo newForm = (BgFormInfo)newForms.get(i);
                pstmt.setString(1, newForm.getId().toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, now);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, now);
                pstmt.setString(6, newForm.getCU().getId().toString());
                pstmt.setString(7, newForm.getName());
                pstmt.setString(8, newForm.getNumber());
                pstmt.setString(9, newForm.getDescription());
                pstmt.setInt(10, newForm.getYear());
                pstmt.setInt(11, newForm.getPeriod());
                pstmt.setDate(12, new Date(newForm.getBgPeriod().getBeginDate().getTime()));
                pstmt.setDate(13, new Date(newForm.getBgPeriod().getEndDate().getTime()));
                pstmt.setString(14, newForm.getCompany().getId().toString());
                if (newForm.getPeriodType() != null) {
                    pstmt.setInt(15, newForm.getPeriodType().getValue());
                } else {
                    pstmt.setInt(15, newForm.getBgPeriod().getPeriodType().getValue());
                }
                pstmt.setInt(16, 66);
                pstmt.setString(17, newForm.getCurrency().getId().toString());
                pstmt.setInt(18, 1);
                pstmt.setInt(19, 1);
                pstmt.setNull(20, 2004);
                pstmt.setInt(21, 0);
                pstmt.setInt(22, 1);
                pstmt.setInt(23, 0);
                pstmt.setString(24, newForm.getBgScheme().getId().toString());
                pstmt.setString(25, newForm.getBgTemplate().getId().toString());
                pstmt.setString(26, newForm.getBgPeriod().getId().toString());
                pstmt.setString(27, newForm.getOrgUnit().getId().toString());
                if (newForm.getBgType() == null) {
                    pstmt.setNull(28, 12);
                } else {
                    pstmt.setString(28, newForm.getBgType().getId().toString());
                }
                pstmt.setString(29, newForm.getMeasureUnit().getId().toString());
                pstmt.setBigDecimal(30, BgNConstants.ONE);
                pstmt.setString(31, newForm.getId().toString());
                if (newForm.getTemplateLastUpdateTime() == null) {
                    pstmt.setTimestamp(32, now);
                } else {
                    pstmt.setTimestamp(32, newForm.getTemplateLastUpdateTime());
                }
                pstmt.setString(33, "");
                pstmt.setBoolean(34, false);
                pstmt.setInt(35, 1);
                pstmt.setInt(36, 0);
                pstmt.setString(37, null);
                pstmt.setString(38, BOSUuid.create((BOSObjectType)bosType).toString());
                pstmt.addBatch();
                if (++index <= 100) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private static void insertIntoBgFormTable(Context ctx, Connection conn, String tempForm) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)tempForm)) {
            return;
        }
        Object[] fs = BgViewServerHelper.getInsertFormFields();
        StringBuffer sql = new StringBuffer("Insert into T_BG_BgForm (");
        BgViewCommonHelper.convertArray(fs, sql);
        sql.append(") select ");
        BgViewCommonHelper.convertArray(fs, sql);
        sql.append(" from ").append(tempForm);
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
            SQLUtils.execute((Connection)conn, (String)("Insert into T_Bg_BgFormEntry (FID, FBgFormID, FDimensionData, FRollMethod, FRollType, FRollStep, FRollLength, FOverFlow, FFixedLength) Select FEntryId, FID, FDimensionData, FRollMethod, FRollType, FRollStep, FRollLength, FOverFlow, FFixedLength From " + tempForm));
            SQLUtils.execute((Connection)conn, (String)("Insert into T_BG_BgMeasureUnit(FID, FBgFormID, FBgElementID, FBgMeasureUnitID) select newbosid('BDC0C39C'), bgForm.FID, tempM.FBgElementID, tempM.FMeasureUnitID from " + tempForm + " bgForm, T_BG_BgTemMeasureUnit tempM where bgForm.FBgTemplateId = tempM.FBgTemplateId"));
            SQLUtils.execute((Connection)conn, (String)("Insert into T_BG_BgBillIntegrateForm(FID, FEntryId, FBgFormState, FSchemeID, FLevel) Select newbosid('" + new BgBillIntegrateFormInfo().getBOSType() + "'), tempForm.FEntryID, schemes.FBgFormState, schemes.FSchemeID, schemes.FLevel from " + tempForm + " tempForm, T_Bg_BgViewDimension viewDimen, T_Bg_BgBillIntegrateTemplate schemes where tempForm.FBgTemplateId = viewDimen.FTemplateId and viewDimen.FID = schemes.FBgTemplateId"));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void updateTempFormXml(Context ctx, Connection conn, String tempForm) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)tempForm)) {
            return;
        }
        try {
            SQLUtils.execute((Connection)conn, (String)("update " + tempForm + " set (FDimensionData, FRollMethod, FRollType, FRollStep, FRollLength, FOverFlow, FFixedLength) = (select templateD.FData, templateD.FRollMethod, templateD.FRollType, templateD.FRollStep, templateD.FRollLength, templateD.FOverFlow, templateD.FFixedLength from  t_bg_bgviewDimension templateD where templateD.FTemplateId = " + tempForm + ".FBgTemplateId )"));
            SQLUtils.execute((Connection)conn, (String)("update " + tempForm + " set FBgRollPeriodId = FBgPeriodId where FRollMethod = 1 or FRollMethod = 2 "));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static Map copyHistory(Connection conn, List updateStateList) throws SQLException {
        if (conn == null || updateStateList == null || updateStateList.isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Set bgFormCol = BgViewServerHelper.getTableColumns(conn, "T_Bg_BgForm");
        bgFormCol.remove("FID");
        bgFormCol.remove("FSTATE");
        Set entryCol = BgViewServerHelper.getTableColumns(conn, "T_Bg_BgFormEntry");
        entryCol.remove("FID");
        entryCol.remove("FBGFORMID");
        String bgFormSql = "INSERT INTO T_Bg_BgForm(FID, FState, " + BgViewServerHelper.convertString(bgFormCol) + ") Select ?, " + 15 + ", " + BgViewServerHelper.convertString(bgFormCol) + " FROM T_Bg_BgForm WHERE FID = ?";
        String entrySql = "INSERT INTO T_Bg_BgFormEntry(FID, FBgFormId, " + BgViewServerHelper.convertString(entryCol) + ") Select ?, ?, " + BgViewServerHelper.convertString(entryCol) + " From T_Bg_BgFormEntry WHERE FBgFormId = ?";
        BOSObjectType formType = new BgFormInfo().getBOSType();
        BOSObjectType entryType = new BgFormEntryInfo().getBOSType();
        ArrayList<Object[]> copyForm = new ArrayList<Object[]>();
        ArrayList<Object[]> copyEntry = new ArrayList<Object[]>();
        Iterator it = updateStateList.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            String bgFormId = BOSUuid.create((BOSObjectType)formType).toString();
            String entryId = BOSUuid.create((BOSObjectType)entryType).toString();
            result.put(id, bgFormId);
            Object[] ps = new Object[]{bgFormId, id};
            copyForm.add(ps);
            ps = new Object[]{entryId, bgFormId, id};
            copyEntry.add(ps);
        }
        BgNSQLHelper.executeBatch((Connection)conn, (String)bgFormSql, copyForm);
        BgNSQLHelper.executeBatch((Connection)conn, (String)entrySql, copyEntry);
        return result;
    }

    public static String convertString(Collection col) {
        if (col == null || col.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(it.next());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getTableColumns(Connection conn, String tableName) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement("SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME= ?");
            pstmt.setString(1, tableName.toUpperCase());
            res = pstmt.executeQuery();
            while (res.next()) {
                result.add(res.getString(1).toUpperCase());
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(res, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        return result;
    }

    public static Set checkNumber(Context ctx, Connection conn, String oneField, String oneValue, String batchField, Set batchValues, boolean isException) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)oneValue) || StringUtils.isEmpty((String)oneValue) || StringUtils.isEmpty((String)batchField) || batchValues == null || batchValues.isEmpty()) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        boolean closeConn = false;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            if (conn == null) {
                closeConn = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select ").append(isException ? " top 1" : "").append(batchField).append(" from t_bg_bgform where ").append(oneField).append(" = ? and ").append(batchField).append(" in(");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = batchValues.toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, oneValue);
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)200, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!isException) {
                        res.add(rst.getString(1));
                        continue;
                    }
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"existNumber", (Locale)ctx.getLocale())});
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                if (closeConn) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        if (closeConn) {
            SQLUtils.cleanup((Connection)conn);
        }
        return res;
    }

    private static String[] getInsertFormFields() {
        return new String[]{"FID", "FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FName", "FNumber", "FDescription", "FYear", "FPeriod", "FStartDate", "FEndDate", "FCompanyID", "FPeriodType", "FSourceType", "FCurrencyID", "FAuditedStatus", "FCheckedStatus", "FData", "FDataSource", "FState", "FExecuteState", "FBgSchemeID", "FBgTemplateID", "FBgPeriodID", "FOrgUnitID", "FBgTypeID", "FMeasureUnitID", "FVersionNo", "FAdjustID", "FTemplateLastUpdateTime", "FXNum", "FIsChangeType", "FStateBeforeAudit", "FRecord", "FBgRollPeriodId"};
    }

    public static Map queryBgDataInfo(Context ctx, String bgViewId) {
        if (StringUtils.isEmpty((String)bgViewId)) {
            return null;
        }
        HashMap resMap = new HashMap();
        return resMap;
    }

    public static Map queryBgTmpDataInfo(Context ctx, Map<?, ?> formulaMap, String bgSchemeRootId) throws BOSException {
        if (formulaMap == null || formulaMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bgData.forgunitid, bgData.FFormula, bgData.FBgValue, bgData.FBizActual, bgData.FAdjustorID, bgData.FAdjustTime, bgData.FAdjustReason ").append(" from t_bg_bgtmpdata bgData ").append(" left join t_bg_bgscheme bgScheme on bgScheme.fid = bgData.fbgschemeid ").append(" where bgData.forgunitid = ? and bgScheme.FRootId = ? and bgData.fformula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        HashMap resMap = new HashMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        String formula = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String orgId : formulaMap.keySet()) {
                Map subMap = null;
                Object[] params = ((Map)formulaMap.get(orgId)).keySet().toArray();
                if (params == null || params.length <= 0) continue;
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, orgId);
                    pstmt.setString(2, bgSchemeRootId);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)3, (int)i, (int)200, (Object[])params);
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        if (!resMap.containsKey(orgId)) {
                            resMap.put(orgId, new HashMap());
                        }
                        subMap = (Map)resMap.get(orgId);
                        formula = res.getString("FFormula");
                        BgAdjustFormDiversityData bgDiversityData = new BgAdjustFormDiversityData();
                        bgDiversityData.setOldValue(res.getBigDecimal("FBizActual"));
                        bgDiversityData.setNewValue(res.getBigDecimal("FBgValue"));
                        bgDiversityData.setAdjustor(res.getString("FAdjustorID"));
                        bgDiversityData.setAdjustTime((java.util.Date)res.getTimestamp("FAdjustTime"));
                        bgDiversityData.setAdjustReson(res.getString("FAdjustReason"));
                        bgDiversityData.setFormula(formula);
                        subMap.put(formula, bgDiversityData);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return resMap;
    }

    public static Map queryBgDataInfo(Context ctx, Map formulaMap, String bgSchemeRootId, boolean actual, boolean budget) throws BOSException {
        if (formulaMap == null || formulaMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return new HashMap();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bgData.fid, bgData.fbgschemeid, bgData.forgunitid, bgData.fformula, bgData.fdatastate ");
        if (budget) {
            sql.append(", bgData.fbgvalue ");
        }
        if (actual) {
            sql.append(", bgData.fbgactual ");
            sql.append(",  bgData.fbizactual ");
        }
        sql.append("from t_bg_bgdata bgData ").append("left join t_bg_bgscheme bgScheme on bgScheme.fid = bgData.fbgschemeid ").append("where bgData.forgunitid = ? and bgScheme.forgunitid = ? and bgScheme.FRootId = ? and bgData.fformula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        HashMap resMap = new HashMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String orgId : formulaMap.keySet()) {
                if (!resMap.containsKey(orgId)) {
                    resMap.put(orgId, new HashMap());
                }
                Map subMap = (Map)resMap.get(orgId);
                Object[] params = ((Map)formulaMap.get(orgId)).keySet().toArray();
                if (params.length == 0) continue;
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, orgId);
                    pstmt.setString(2, orgId);
                    pstmt.setString(3, bgSchemeRootId);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)4, (int)i, (int)200, (Object[])params);
                    long t = System.currentTimeMillis();
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        BgNViewDataInfo bgData = new BgNViewDataInfo(res.getBigDecimal("fbgvalue"));
                        bgData.setId(res.getString("fid"));
                        bgData.setBgSchemeId(res.getString("fbgschemeid"));
                        bgData.setOrgUnitId(res.getString("forgunitid"));
                        bgData.setFormula(res.getString("fformula"));
                        if (budget) {
                            bgData.setBudgetValue(res.getBigDecimal("fbgvalue"));
                        }
                        if (actual) {
                            bgData.setActualValue(res.getBigDecimal("fbgactual"));
                            bgData.setBizActual(res.getBigDecimal("fbizactual"));
                        }
                        bgData.setState(res.getInt("fdatastate"));
                        subMap.put(bgData.getFormula(), bgData);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return resMap;
    }

    public static Map queryLatestBgDataInfo(Context ctx, Map formulaMap, String bgSchemeRootId, boolean isAdjust) throws BOSException {
        if (formulaMap == null || formulaMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return new HashMap();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bgData.fid, bgData.fbgschemeid, bgData.forgunitid, bgData.fformula, bgData.fdatastate ");
        sql.append(", bgData.fbgvalue ");
        sql.append("from t_bg_bgdata bgData ").append("left join t_bg_bgscheme bgScheme on bgScheme.fid = bgData.fbgschemeid ").append("where bgData.forgunitid = ? and bgScheme.forgunitid = ? and bgScheme.FRootId = ? and bgData.fformula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        HashMap resMap = new HashMap();
        BgViewServerHelper.queryBgData(ctx, formulaMap, bgSchemeRootId, sql, resMap, true);
        if (isAdjust) {
            StringBuffer tmpSql = new StringBuffer();
            tmpSql.append("select bgData.fid, bgData.fbgschemeid, bgData.forgunitid, bgData.fformula ");
            tmpSql.append(", bgData.fbgvalue ");
            tmpSql.append("from t_bg_bgtmpdata bgData ").append("left join t_bg_bgscheme bgScheme on bgScheme.fid = bgData.fbgschemeid ").append("where bgData.forgunitid = ? and bgScheme.forgunitid = ? and bgScheme.FRootId = ? and bgData.fformula in (");
            BgNSQLHelper.addPlaceHolder((StringBuffer)tmpSql, (int)200).append(")");
            BgViewServerHelper.queryBgData(ctx, formulaMap, bgSchemeRootId, tmpSql, resMap, false);
        }
        return resMap;
    }

    private static void queryBgData(Context ctx, Map formulaMap, String bgSchemeRootId, StringBuffer sql, Map resMap, boolean hasDataState) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String orgId : formulaMap.keySet()) {
                if (!resMap.containsKey(orgId)) {
                    resMap.put(orgId, new HashMap());
                }
                Map subMap = (Map)resMap.get(orgId);
                Object[] params = ((Map)formulaMap.get(orgId)).keySet().toArray();
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, orgId);
                    pstmt.setString(2, orgId);
                    pstmt.setString(3, bgSchemeRootId);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)4, (int)i, (int)200, (Object[])params);
                    long t = System.currentTimeMillis();
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        if (subMap.containsKey(res.getString("fformula"))) {
                            ((BgNViewDataInfo)((Object)subMap.get(res.getString("fformula")))).setBudgetValue(res.getBigDecimal("fbgvalue"));
                            continue;
                        }
                        BgNViewDataInfo bgData = new BgNViewDataInfo(res.getBigDecimal("fbgvalue"));
                        bgData.setId(res.getString("fid"));
                        bgData.setBgSchemeId(res.getString("fbgschemeid"));
                        bgData.setOrgUnitId(res.getString("forgunitid"));
                        bgData.setFormula(res.getString("fformula"));
                        bgData.setBudgetValue(res.getBigDecimal("fbgvalue"));
                        if (hasDataState) {
                            bgData.setState(res.getInt("fdatastate"));
                        }
                        subMap.put(bgData.getFormula(), bgData);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
    }

    public static Map queryBgDataInfo(Context ctx, Map formulaMap, String bgSchemeRootId) throws BOSException {
        return BgViewServerHelper.queryBgDataInfo(ctx, formulaMap, bgSchemeRootId, false, true);
    }

    public static Map queryBgFormByOrgUnitId(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds) throws BOSException {
        if (bgFormInfo == null || orgIds == null || orgIds.length == 0) {
            return null;
        }
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = BgViewServerHelper.getQuerySQL();
            sql.append(" and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId =?");
            sql.append(" where bgForm.FState <> ? and bgScheme.FRootId = ? ");
            sql.append(" and bgTemplate.FRootID = ? ");
            sql.append(" and bgForm.FOrgUnitId in (");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = (orgIds.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, bgFormInfo.getBgPeriod().getId().toString());
                pstmt.setString(2, bgFormInfo.getCurrency().getId().toString());
                pstmt.setInt(3, 15);
                pstmt.setString(4, bgFormInfo.getBgScheme().getRootId().toString());
                pstmt.setString(5, bgFormInfo.getBgTemplate().getRootId().toString());
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)6, (int)i, (int)200, (Object[])orgIds);
                res = pstmt.executeQuery();
                while (res.next()) {
                    BgFormInfo b = BgViewServerHelper.buildBgFormInfo(res);
                    bgFormMap.put(b.getOrgUnit().getId().toString(), b);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    public static Map queryBgViewBgPeriod(Context ctx, IBgDimensionManager bgDimensionManager, BgFormInfo bgForm) throws BOSException, EASBizException {
        if (bgDimensionManager == null || bgForm == null) {
            return null;
        }
        HashMap<IBgDimensionManager, BgFormInfo> p = new HashMap<IBgDimensionManager, BgFormInfo>();
        p.put(bgDimensionManager, bgForm);
        return BgViewServerHelper.queryBgViewBgPeriod(ctx, p);
    }

    public static Map queryBgViewBgPeriod(Context ctx, Map dim_bgFormMap) throws BOSException, EASBizException {
        int i;
        if (dim_bgFormMap == null || dim_bgFormMap.isEmpty()) {
            return null;
        }
        HashSet<String> numbers = new HashSet<String>();
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        for (IBgDimensionManager bgDimensionManager : dim_bgFormMap.keySet()) {
            BgFormInfo bgForm = (BgFormInfo)dim_bgFormMap.get(bgDimensionManager);
            BgDimensionInfo dimen = null;
            for (i = 0; i < bgDimensionManager.getDimension().size(); ++i) {
                if (!"BGPERIOD".equalsIgnoreCase(((BgDimensionInfo)bgDimensionManager.getDimension().get(i)).getType())) continue;
                dimen = (BgDimensionInfo)bgDimensionManager.getDimension().get(i);
                break;
            }
            if (dimen == null) {
                return null;
            }
            if (StringUtils.isEmpty((String)dimen.getValue()) || dimen.getMember().isEmpty()) {
                bgPeriodMap.put(bgForm.getBgPeriod().getNumber(), bgForm.getBgPeriod());
                continue;
            }
            for (i = 0; i < dimen.getMember().size(); ++i) {
                BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(i);
                numbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)bgForm.getBgPeriod().getNumber(), (String)member.getNumber(), (int)bgForm.getBgPeriod().getPeriodType().getValue()));
            }
        }
        numbers.removeAll(bgPeriodMap.keySet());
        if (numbers.isEmpty()) {
            return bgPeriodMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("periodType");
        evi.getSelector().add("showlevel");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        BgPeriodCollection col = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
        bgPeriodMap.clear();
        if (col != null && !col.isEmpty()) {
            for (i = 0; i < col.size(); ++i) {
                bgPeriodMap.put(col.get(i).getNumber(), col.get(i));
            }
        }
        return bgPeriodMap;
    }

    public static Map queryBgViewBgItem(Context ctx, Map dimen_orgIdMap, boolean isBg063) throws BOSException {
        if (ctx == null || dimen_orgIdMap == null || dimen_orgIdMap.isEmpty()) {
            return null;
        }
        HashMap bgItemMap = new HashMap();
        for (IBgDimensionManager bgDimensionManager : dimen_orgIdMap.keySet()) {
            String orgId = BgViewCommonHelper.getOrgId(isBg063, String.valueOf(dimen_orgIdMap.get(bgDimensionManager)));
            Map subItemMap = BgViewCommonHelper.getSubMap(bgItemMap, orgId, true);
            List allDimen = bgDimensionManager.getDimension();
            for (int i = 0; i < allDimen.size(); ++i) {
                BgDimensionInfo dimen = (BgDimensionInfo)allDimen.get(i);
                if (!"BGITEM".equalsIgnoreCase(dimen.getType())) continue;
                Map groupMap = BgViewCommonHelper.getSubMap(subItemMap, dimen.getAttributeNumber(), true);
                if (StringUtils.isEmpty((String)dimen.getValue())) continue;
                for (int m = 0; m < dimen.getMember().size(); ++m) {
                    groupMap.put(((BgDimensionMember)dimen.getMember().get(m)).getNumber(), dimen.getMember().get(m));
                }
            }
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            BgViewServerHelper.queryBgItem(ctx, conn, bgItemMap);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgItemMap;
    }

    public static Map queryBgViewBgItem(Context ctx, IBgDimensionManager bgDimensionManager, String orgId, boolean isBg063) throws BOSException {
        if (ctx == null || bgDimensionManager == null || StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        HashMap<IBgDimensionManager, String> temMap = new HashMap<IBgDimensionManager, String>();
        temMap.put(bgDimensionManager, orgId);
        return BgViewServerHelper.queryBgViewBgItem(ctx, temMap, isBg063);
    }

    public static void queryBgItem(Context ctx, Connection conn, Map bgItemMap) throws BOSException {
        if (conn == null || bgItemMap == null || bgItemMap.isEmpty()) {
            return;
        }
        PreparedStatement pstGroup = null;
        PreparedStatement pstNumber = null;
        ResultSet res = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid, fnumber, fname_").append(ctx.getLocale()).append(" fname, freffield, flevel, flongnumber from t_bg_bgitem where forgunitid = ?");
            pstGroup = conn.prepareStatement(sql + " and FBgItemGroupID = (select fid from t_bg_bgitemgroup where fnumber = ?)");
            sql.append(" and FNumber in (");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            pstNumber = conn.prepareStatement(sql.toString());
            for (String orgId : bgItemMap.keySet()) {
                Map subItemMap = (Map)bgItemMap.get(orgId);
                if (subItemMap == null || subItemMap.isEmpty()) continue;
                for (String groupNumber : subItemMap.keySet()) {
                    Map groupMap = (Map)subItemMap.get(groupNumber);
                    if (groupMap == null) continue;
                    Object[] params = null;
                    if (!groupMap.isEmpty()) {
                        params = groupMap.keySet().toArray();
                        groupMap.clear();
                        int batchCount = (params.length - 1) / 200 + 1;
                        for (int i = 0; i < batchCount; ++i) {
                            pstNumber.setString(1, orgId);
                            BgNSQLHelper.setParam4Batch((PreparedStatement)pstNumber, (int)2, (int)i, (int)200, (Object[])params);
                            res = pstNumber.executeQuery();
                            while (res.next()) {
                                BgItemInfo info = BgViewServerHelper.buildBgItemInfo(res);
                                groupMap.put(info.getNumber(), info);
                            }
                            SQLUtils.cleanup((ResultSet)res);
                        }
                        continue;
                    }
                    groupMap.clear();
                    pstGroup.setString(1, orgId);
                    pstGroup.setString(2, groupNumber);
                    res = pstGroup.executeQuery();
                    while (res.next()) {
                        BgItemInfo info = BgViewServerHelper.buildBgItemInfo(res);
                        groupMap.put(info.getNumber(), info);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res);
                SQLUtils.cleanup(pstGroup);
                SQLUtils.cleanup(pstNumber);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res);
        SQLUtils.cleanup((Statement)pstGroup);
        SQLUtils.cleanup((Statement)pstNumber);
    }

    private static BgItemInfo buildBgItemInfo(ResultSet res) throws SQLException {
        BgItemInfo info = new BgItemInfo();
        info.setId(BOSUuid.read((String)res.getString("fid")));
        info.setNumber(res.getString("fnumber"));
        info.setName(res.getString("fname"));
        info.setLongNumber(res.getString("flongnumber"));
        info.setLevel(res.getInt("flevel"));
        info.setRefField(res.getString("freffield"));
        return info;
    }

    public static void saveBudget(Context ctx, BgFormInfo bgFormInfo, Map bgDataMap, Map deleteMap, Map bgFormMap, boolean updataBackState, boolean updateForm, BgDataStateEnum dataState, String updateCond) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            return;
        }
        HashSet orgIds = new HashSet();
        if (bgDataMap != null) {
            orgIds.addAll(bgDataMap.keySet());
        }
        if (deleteMap != null) {
            orgIds.addAll(deleteMap.keySet());
        }
        BgViewServerHelper.reQueryBgDataInfo(ctx, bgDataMap, bgFormInfo.getBgScheme().getRootId().toString());
        if (bgFormMap == null) {
            bgFormMap = BgViewServerHelper.queryBgFormByOrgUnitId(ctx, bgFormInfo, orgIds.toArray());
        }
        if (updataBackState) {
            BgViewServerHelper.updateBgFormState(ctx, bgFormMap);
        }
        if (updateForm) {
            BgViewServerHelper.updateBgFormLastUpdate(ctx, bgFormInfo, bgFormMap);
        }
        HashMap addNewMap = new HashMap();
        HashMap updateMap = new HashMap();
        if (deleteMap == null) {
            deleteMap = new HashMap();
        }
        HashMap refMap = new HashMap();
        BgViewServerHelper.filterBgDataMap(bgDataMap, addNewMap, updateMap, deleteMap, refMap);
        BgViewServerHelper.addNewBgData(ctx, bgFormMap, addNewMap);
        BgViewServerHelper.deleteBgData(ctx, bgFormMap, deleteMap);
        BgViewServerHelper.updateBgData(ctx, bgFormMap, updateMap, dataState, updateCond);
        BgViewServerHelper.updateRef(ctx, bgFormMap, refMap, deleteMap);
    }

    private static void filterBgDataMap(Map bgDataMap, Map addNewMap, Map updateMap, Map deleteMap, Map refMap) {
        BOSObjectType type = new BgDataInfo().getBOSType();
        for (String orgId : bgDataMap.keySet()) {
            Map subMap = (Map)bgDataMap.get(orgId);
            if (subMap == null || subMap.isEmpty()) continue;
            for (BgNViewDataInfo data : subMap.values()) {
                if (data.getOldValue() == null && data.getBudgetValue() == null) continue;
                boolean ref = true;
                if (data.getOldValue() == null) {
                    data.setId(BOSUuid.create((BOSObjectType)type).toString());
                    BgViewCommonHelper.getSubMap(addNewMap, orgId, true).put(data.getFormula(), data);
                } else if (data.getBudgetValue() == null) {
                    BgViewCommonHelper.getSubMap(deleteMap, orgId, true).put(data.getFormula(), data);
                    ref = false;
                } else if (data.getBudgetValue().compareTo(data.getOldValue()) == 0) {
                    ref = true;
                } else {
                    BgViewCommonHelper.getSubMap(updateMap, orgId, true).put(data.getFormula(), data);
                }
                if (!ref) continue;
                BgViewCommonHelper.getSubMap(refMap, orgId, true).put(data.getId(), data);
            }
        }
    }

    private static void addNewBgData(Context ctx, Map bgFormMap, Map addNewMap) throws BOSException, EASBizException {
        BgFormInfo bgForm;
        Map subMap;
        if (bgFormMap == null || bgFormMap.isEmpty() || addNewMap == null || addNewMap.isEmpty()) {
            return;
        }
        BgDataHelper helper = new BgDataHelper();
        HashMap formulaCache = new HashMap();
        ArrayList<String> bgTemplateIds = new ArrayList<String>();
        for (String orgId : addNewMap.keySet()) {
            subMap = (Map)addNewMap.get(orgId);
            bgForm = (BgFormInfo)bgFormMap.get(orgId);
            if (subMap == null || subMap.isEmpty() || bgForm == null) continue;
            bgTemplateIds.add(bgForm.getBgTemplate().getId().toString());
        }
        Map totalCtrl = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx).getTemplateCtrlSetting(bgTemplateIds, null);
        Map totalDefCtrl = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx).getDefCtrlSetByTemplateID(bgTemplateIds);
        for (String orgId : addNewMap.keySet()) {
            subMap = (Map)addNewMap.get(orgId);
            bgForm = (BgFormInfo)bgFormMap.get(orgId);
            if (subMap == null || subMap.isEmpty() || bgForm == null) continue;
            String bgTemplateId = bgForm.getBgTemplate().getId().toString();
            HashMap<String, BgNViewDataInfo> bgDataMap = new HashMap<String, BgNViewDataInfo>();
            for (BgNViewDataInfo data : subMap.values()) {
                data.setActualValue(BgNConstants.ZERO);
                if (data.getBudgetValue() == null) {
                    data.setBudgetValue(BgNConstants.ZERO);
                }
                data.setSheetName("Sheet1");
                String[] formulaParams = BgNFSHelper.parseFormulaPara(formulaCache, (String)data.getFormula());
                data.setBgItemNumber(formulaParams[0]);
                data.setBgElementNumber(formulaParams[2]);
                data.setBgPeriodNumber(formulaParams[1]);
                data.setCurrencyNumber(formulaParams[5]);
                String key = formulaParams[0] + "_" + formulaParams[2];
                Map tmpMap = null;
                if (totalCtrl.containsKey(bgTemplateId)) {
                    tmpMap = (Map)((Map)totalCtrl.get(bgTemplateId)).get("ctrlModeMap");
                    if (tmpMap != null && tmpMap.containsKey(key)) {
                        tmpMap = (Map)tmpMap.get(key);
                        tmpMap.put("isFromSuper", Boolean.TRUE);
                        tmpMap.put("isCtrlAllowChange", Boolean.FALSE);
                    } else {
                        tmpMap = null;
                    }
                }
                if (tmpMap == null) {
                    tmpMap = (Map)totalDefCtrl.get(bgTemplateId);
                }
                if (tmpMap == null) {
                    helper.addDefCtrlInfo((BgNDataInfo)data);
                } else {
                    helper.addCtrlInfo(bgForm, (BgNDataInfo)data, tmpMap);
                }
                bgDataMap.put(data.getFormula(), data);
            }
            bgForm.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            helper.getImpl().addNewBgDataValue(ctx, bgForm, bgDataMap);
        }
    }

    private static void deleteBgData(Context ctx, Map bgFormMap, Map deleteMap) throws BOSException, EASBizException {
        new BgDataHelper().getImpl().removeBgDataValue(ctx, bgFormMap, deleteMap);
    }

    private static void updateBgData(Context ctx, Map bgFormMap, Map updateMap, BgDataStateEnum dataState, String updateCond) throws BOSException {
        if (updateMap == null || updateMap.isEmpty()) {
            return;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String sql = "Update T_BG_BgData Set FBgValue = ?, FLastupdateUserId = ?, FlastupdateTime = ?" + (dataState == null ? "" : ", FDataState = " + dataState.getValue()) + " where FOrgUnitID = ? and FBgSchemeId = ? and FFormula = ?" + (StringUtils.isEmpty((String)updateCond) ? "" : " AND " + updateCond);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String orgId : updateMap.keySet()) {
            Map subMap = (Map)updateMap.get(orgId);
            BgFormInfo bgForm = (BgFormInfo)bgFormMap.get(orgId);
            if (subMap == null || subMap.isEmpty() || bgForm == null) continue;
            for (BgNViewDataInfo data : subMap.values()) {
                Object[] params = new Object[]{data.getBudgetValue(), userId, now, data.getOrgUnitId(), data.getBgSchemeId(), data.getFormula()};
                paramsList.add(params);
            }
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            BgNSQLHelper.executeBatch((Connection)conn, (String)sql, paramsList);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static void updateRef(Context ctx, Map bgFormMap, Map refMap, Map deleteMap) throws BOSException {
        if (bgFormMap == null || bgFormMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (refMap != null && !refMap.isEmpty()) {
                Object[] params;
                BgFormInfo bgForm;
                Map subMap;
                BOSObjectType type = new BgDataEntryInfo().getBOSType();
                StringBuffer sql = new StringBuffer();
                sql.append("select dataEntry.FBgDataId from t_bg_bgdataentry dataEntry where dataEntry.FBgFormId = ? and dataEntry.FBgDataId in(");
                BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
                pstmt = conn.prepareStatement(sql.toString());
                for (String orgId : refMap.keySet()) {
                    subMap = (Map)refMap.get(orgId);
                    bgForm = (BgFormInfo)bgFormMap.get(orgId);
                    if (subMap == null || subMap.isEmpty() || bgForm == null) continue;
                    params = subMap.keySet().toArray();
                    int count = (params.length - 1) / 200 + 1;
                    for (int i = 0; i < count; ++i) {
                        pstmt.setString(1, bgForm.getId().toString());
                        BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)200, (Object[])params);
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            subMap.remove(res.getString("FBgDataId"));
                        }
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
                SQLUtils.cleanup(res, (Statement)pstmt);
                sql.delete(0, sql.length());
                sql.append("Insert Into T_BG_BgDataEntry(FID, FBgFormId, FBgDataId) values(?, ?, ?)");
                ArrayList<Object[]> pList = new ArrayList<Object[]>();
                for (String orgId : refMap.keySet()) {
                    subMap = (Map)refMap.get(orgId);
                    bgForm = (BgFormInfo)bgFormMap.get(orgId);
                    if (subMap == null || subMap.isEmpty() || bgForm == null) continue;
                    Iterator itData = subMap.keySet().iterator();
                    while (itData.hasNext()) {
                        params = new Object[]{BOSUuid.create((BOSObjectType)type).toString(), bgForm.getId().toString(), itData.next()};
                        pList.add(params);
                    }
                }
                BgNSQLHelper.executeBatch((Connection)conn, (String)sql.toString(), pList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
    }

    private static void updateBgFormLastUpdate(Context ctx, BgFormInfo bgFormInfo, Map bgFormMap) throws BOSException {
        if (bgFormInfo == null || bgFormMap == null || bgFormMap.isEmpty()) {
            return;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        for (BgFormInfo b : bgFormMap.values()) {
            b.setLastUpdateUser(user);
        }
    }

    private static void updateBgFormState(Context ctx, Map bgFormMap) throws EASBizException, BOSException {
        if (ctx == null || bgFormMap == null || bgFormMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> bgFormIds = new ArrayList<Object[]>();
        HashSet<Object> idSet = new HashSet<Object>();
        for (BgFormInfo bgFormInfo : bgFormMap.values()) {
            if (!BgFormStateEnum.Back.equals((Object)bgFormInfo.getState())) continue;
            Object[] ids = new Object[]{bgFormInfo.getId().toString()};
            bgFormIds.add(ids);
            idSet.add(ids[0]);
        }
        if (bgFormIds.isEmpty()) {
            return;
        }
        DbUtil.executeBatch((Context)ctx, (String)"update t_bg_bgform set fstate = 1 where fid = ?", bgFormIds);
        try {
            BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, idSet, (boolean)false, (String)"OPERATOT_SAVEBUDGET");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void reQueryBgDataInfo(Context ctx, Map bgDataMap, String bgSchemeRootId) throws BOSException {
        if (bgDataMap == null || bgDataMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return;
        }
        HashMap queryMap = new HashMap();
        for (String orgId : bgDataMap.keySet()) {
        }
    }
}

