/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BgRuleField {
    public static final String SPLITER = "|";
    public static final String FILTER_SPLITER = ",";
    public static final String SPLITER_VER_LINE = "\\|";
    private String name = null;
    private String filter = null;

    public String toString() {
        if (StringUtils.isEmpty((String)this.name)) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.filter)) {
            return this.name;
        }
        return this.name + SPLITER + this.filter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Set getFilterSet() {
        if (StringUtils.isEmpty((String)this.filter)) {
            return null;
        }
        String[] filters = this.filter.split(FILTER_SPLITER);
        if (filters == null || filters.length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(filters));
    }

    public static BgRuleField parseField(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        BgRuleField field = new BgRuleField();
        String[] fields = fieldName.split(SPLITER_VER_LINE);
        field.setName(fields[0]);
        if (fields.length >= 2) {
            field.setFilter(fields[1]);
        }
        return field;
    }

    public static boolean isExist(EntityObjectInfo bill, String rule) {
        boolean isExist = false;
        if (bill != null && !StringUtils.isEmpty((String)rule)) {
            isExist = true;
            String[] fields = rule.split("@");
            for (int i = 0; i < fields.length; ++i) {
                String prop;
                if (StringUtils.isEmpty((String)fields[i]) || BgRuleField.getProperty(bill, prop = BgRuleField.parseField(fields[i]).getName(), false) != null) continue;
                return false;
            }
        }
        return isExist;
    }

    public static PropertyInfo getProperty(EntityObjectInfo bill, String fieldName, boolean isLinkProperty) {
        if (bill == null || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        BgRuleField field = BgRuleField.parseField(fieldName);
        if (field == null) {
            return null;
        }
        String[] fields = BgViewCommonHelper.splitField(field.getName());
        if (fields == null || fields.length == 0) {
            return null;
        }
        EntityObjectInfo entity = bill;
        LinkPropertyInfo linkPro = null;
        for (int i = 0; i < fields.length; ++i) {
            PropertyInfo prop = entity.getPropertyByName(fields[i]);
            if (i == fields.length - 1) {
                if (isLinkProperty && !(prop instanceof LinkPropertyInfo)) {
                    return linkPro;
                }
                return prop;
            }
            if (prop instanceof LinkPropertyInfo) {
                linkPro = (LinkPropertyInfo)prop;
                if (linkPro.getRelationship().getSupplierObject() != null && !entity.getFullName().equals(linkPro.getRelationship().getSupplierObject().getFullName())) {
                    entity = linkPro.getRelationship().getSupplierObject();
                    continue;
                }
                entity = linkPro.getRelationship().getClientObject();
                continue;
            }
            return null;
        }
        return null;
    }

    public static EntityObjectInfo getPropertyEntity(EntityObjectInfo bill, String fieldName) {
        PropertyInfo prop;
        if (bill == null || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        BgRuleField field = BgRuleField.parseField(fieldName);
        if (field == null) {
            return null;
        }
        String[] fields = BgViewCommonHelper.splitField(field.getName());
        if (fields == null || fields.length == 0) {
            return null;
        }
        EntityObjectInfo entity = bill;
        LinkPropertyInfo linkPro = null;
        for (int i = 0; i < fields.length && (prop = entity.getPropertyByName(fields[i])) instanceof LinkPropertyInfo; ++i) {
            linkPro = (LinkPropertyInfo)prop;
            entity = linkPro.getRelationship().getSupplierObject() != null && !entity.getFullName().equals(linkPro.getRelationship().getSupplierObject().getFullName()) ? linkPro.getRelationship().getSupplierObject() : linkPro.getRelationship().getClientObject();
        }
        return entity;
    }
}

